/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.jvmpreferences.nativeprefs;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.management.ManagementFactory;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.regex.Pattern;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.gvsig.i18n.Messages;
import org.gvsig.jvmpreferences.nativeprefs.MemoryPreferences;
import org.slf4j.LoggerFactory;

public abstract class BaseMemoryPreferences
implements MemoryPreferences {
    public static final int FACTORY_DEFAULT_MAXIMUM = 512;

    public abstract File getConfigFile();

    public boolean isConfigWritable() {
        return this.getConfigFile().canWrite();
    }

    public int getTotalSystemMemory() {
        MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
        try {
            Object attribute = mBeanServer.getAttribute(new ObjectName("java.lang", "type", "OperatingSystem"), "TotalPhysicalMemorySize");
            System.out.println("Total memory: " + attribute.toString() + " B");
            System.out.println("Total memory: " + Long.parseLong(attribute.toString()) / 0x100000L + " MB");
            return (int)(Long.parseLong(attribute.toString()) / 0x100000L);
        }
        catch (AttributeNotFoundException e) {
            LoggerFactory.getLogger(BaseMemoryPreferences.class).error("Total_system_memory_cant_be_retrived", (Throwable)e);
        }
        catch (InstanceNotFoundException e) {
            LoggerFactory.getLogger(BaseMemoryPreferences.class).error("Total_system_memory_cant_be_retrived", (Throwable)e);
        }
        catch (MalformedObjectNameException e) {
            LoggerFactory.getLogger(BaseMemoryPreferences.class).error("Total_system_memory_cant_be_retrived", (Throwable)e);
        }
        catch (MBeanException e) {
            LoggerFactory.getLogger(BaseMemoryPreferences.class).error("Total_system_memory_cant_be_retrived", (Throwable)e);
        }
        catch (ReflectionException e) {
            LoggerFactory.getLogger(BaseMemoryPreferences.class).error("Total_system_memory_cant_be_retrived", (Throwable)e);
        }
        catch (NullPointerException e) {
            LoggerFactory.getLogger(BaseMemoryPreferences.class).error("Total_system_memory_cant_be_retrived", (Throwable)e);
        }
        return 512;
    }

    public int getSafeMemoryMaximum() {
        int totalMemory = this.getTotalSystemMemory();
        if (totalMemory <= 1024) {
            return (int)(0.6 * (double)totalMemory);
        }
        String arch = System.getProperty("os.arch");
        if ("x86".equals(arch) || "i386".equals(arch)) {
            return 1200;
        }
        return totalMemory - 768;
    }

    /*
     * Exception decompiling
     */
    public int readConfiguredMaximum() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static void copy(File src, File dst) throws IOException {
        int len;
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(src));
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(dst));
        byte[] buf = new byte[10240];
        while ((len = ((InputStream)in).read(buf)) > 0) {
            ((OutputStream)out).write(buf, 0, len);
        }
        ((InputStream)in).close();
        ((OutputStream)out).close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveConguredMaximum(int maximumMemory) {
        File launcherFile = this.getConfigFile();
        if (launcherFile.exists()) {
            SimpleDateFormat format = new SimpleDateFormat("yyyyMMddHHmmssSSS");
            String date = format.format(new Date());
            File backupFile = new File(launcherFile.getAbsolutePath() + "-" + date + ".bak");
            BufferedWriter writer = null;
            BufferedReader reader = null;
            try {
                String line;
                BaseMemoryPreferences.copy(launcherFile, backupFile);
                writer = new BufferedWriter(new FileWriter(launcherFile));
                reader = new BufferedReader(new FileReader(backupFile));
                Pattern pattern = Pattern.compile(this.getMaxMemoryRegexp());
                boolean written = false;
                while ((line = reader.readLine()) != null) {
                    if (!pattern.matcher(line).matches() || written) {
                        writer.write(line);
                        writer.write(this.getNewLineChars());
                        continue;
                    }
                    written = true;
                    writer.write(this.getEncodedMaxMemoryLine(maximumMemory));
                    writer.write(this.getNewLineChars());
                }
            }
            catch (FileNotFoundException e) {
                LoggerFactory.getLogger(this.getClass()).error(Messages.getText((String)"Memory_config_could_not_be_written"), (Throwable)e);
            }
            catch (IOException e) {
                LoggerFactory.getLogger(this.getClass()).error(Messages.getText((String)"Memory_config_could_not_be_written"), (Throwable)e);
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException e) {
                        LoggerFactory.getLogger(this.getClass()).debug(Messages.getText((String)"Error_closing_reader"), (Throwable)e);
                    }
                }
                if (writer != null) {
                    try {
                        writer.close();
                    }
                    catch (IOException e) {
                        LoggerFactory.getLogger(this.getClass()).debug(Messages.getText((String)"Error_closing_writer"), (Throwable)e);
                    }
                }
            }
        }
    }

    protected abstract String getMaxMemoryRegexp();

    protected abstract String getEncodedMaxMemoryLine(int var1);

    protected abstract String getNewLineChars();

    public int getFactoryDefaultMaximum() {
        return 512;
    }
}

