/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.xml2db.swing.impl;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.font.TextAttribute;
import java.util.Map;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataFactory;
import org.gvsig.fmap.dal.PersonalDatabaseServerExplorerFactory;
import org.gvsig.tools.util.LabeledValue;
import org.gvsig.tools.util.LabeledValueImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Xml2dbSwingCommons {
    private static final Logger LOGGER = LoggerFactory.getLogger(Xml2dbSwingCommons.class);

    public static String getHTMLColorTag(Color color, String text) {
        return Xml2dbSwingCommons.getHTMLColorTag(color, false, text);
    }

    public static String getHTMLColorTag(Color color, boolean bold, String text) {
        return Xml2dbSwingCommons.getHTMLColorTag(color, bold, false, text);
    }

    public static String getHTMLColorTag(Color color, boolean bold, boolean strikethrough, String text) {
        String pattern = bold && strikethrough ? "<html><font color='rgb(%s, %s, %s)'><i><s>%s</i></s></font></html>" : (bold ? "<html><font color='rgb(%s, %s, %s)'><i>%s</i></font></html>" : (strikethrough ? "<html><font color='rgb(%s, %s, %s)'><s>%s</s></font></html>" : "<html><font color='rgb(%s, %s, %s)'>%s</font></html>"));
        String tag = String.format(pattern, color.getRed(), color.getGreen(), color.getBlue(), text);
        return tag;
    }

    public static void setColorCompoment(Component c, Color color, boolean bold) {
        Xml2dbSwingCommons.setColorCompoment(c, color, bold, false);
    }

    public static void setColorCompoment(Component c, Color color, boolean bold, boolean strikethrough) {
        if (bold) {
            Font f = c.getFont();
            Map<TextAttribute, ?> attributes = f.getAttributes();
            attributes.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD);
            c.setFont(c.getFont().deriveFont(attributes));
        }
        c.setForeground(color);
    }

    public static ComboBoxModel<LabeledValue<PersonalDatabaseServerExplorerFactory>> getPersonalDatabaseServerExplorersComboModel() {
        DefaultComboBoxModel<LabeledValue<PersonalDatabaseServerExplorerFactory>> model = new DefaultComboBoxModel<LabeledValue<PersonalDatabaseServerExplorerFactory>>();
        for (DataFactory explorerFactory : DALLocator.getDataManager().getServerExplorerRegister()) {
            if (!(explorerFactory instanceof PersonalDatabaseServerExplorerFactory)) continue;
            LabeledValueImpl element = new LabeledValueImpl(explorerFactory.getDescription(), (Object)((PersonalDatabaseServerExplorerFactory)explorerFactory));
            model.addElement((LabeledValue<PersonalDatabaseServerExplorerFactory>)element);
            if (!StringUtils.equalsIgnoreCase((CharSequence)explorerFactory.getName(), (CharSequence)"H2Spatial")) continue;
            model.setSelectedItem(element);
        }
        return model;
    }
}

