/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.tools.algorithm.swing.impl.saveraster;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.gvsig.i18n.Messages;
import org.gvsig.raster.tools.algorithm.swing.impl.util.InputFieldPanel;

public class PrintSelectionPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private InputFieldPanel scale = null;
    private InputFieldPanel width = null;
    private InputFieldPanel height = null;
    private JRadioButton radioPrintSelection = null;
    private JComboBox dpi = null;
    private JLabel labelWidth = null;
    private JLabel labelHeight = null;
    private JLabel resolution = null;
    private int w = 0;
    private int h = 0;

    public PrintSelectionPanel() {
        this.init();
    }

    private void init() {
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createTitledBorder(""));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.insets = new Insets(2, 2, 4, 2);
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.gridwidth = 2;
        gbc.gridx = 0;
        gbc.gridy = 0;
        this.add((Component)this.getRadioPrintSelection(), gbc);
        gbc.gridwidth = 1;
        gbc.gridx = 0;
        gbc.gridy = 1;
        this.add((Component)this.getWidthInput(), gbc);
        gbc.gridx = 1;
        gbc.gridy = 1;
        this.add((Component)new JPanel(), gbc);
        gbc.gridx = 0;
        gbc.gridy = 2;
        this.add((Component)this.getHeightInput(), gbc);
        gbc.gridx = 1;
        gbc.gridy = 2;
        this.add((Component)this.getScale(), gbc);
        gbc.gridx = 0;
        gbc.gridy = 3;
        this.resolution = new JLabel(Messages.getText((String)"resolution") + " (dpi)");
        this.add((Component)this.resolution, gbc);
        gbc.gridx = 1;
        gbc.gridy = 3;
        this.add((Component)this.getComboDPI(), gbc);
        gbc.gridwidth = 2;
        gbc.gridx = 0;
        gbc.gridy = 4;
        this.add((Component)this.getLabelWidth(), gbc);
        gbc.gridx = 0;
        gbc.gridy = 5;
        this.add((Component)this.getLabelHeight(), gbc);
    }

    public JComboBox getComboDPI() {
        if (this.dpi == null) {
            this.dpi = new JComboBox();
            this.dpi.addItem("72");
            this.dpi.addItem("96");
            this.dpi.addItem("160");
            this.dpi.addItem("300");
            this.dpi.addItem("600");
            this.dpi.addItem("2540");
            this.dpi.addItem("4000");
        }
        return this.dpi;
    }

    public InputFieldPanel getScale() {
        if (this.scale == null) {
            this.scale = new InputFieldPanel(Messages.getText((String)"scale") + " 1:", InputFieldPanel.INT);
        }
        return this.scale;
    }

    public InputFieldPanel getWidthInput() {
        if (this.width == null) {
            this.width = new InputFieldPanel(Messages.getText((String)"width_cms"), InputFieldPanel.INT);
        }
        return this.width;
    }

    public InputFieldPanel getHeightInput() {
        if (this.height == null) {
            this.height = new InputFieldPanel(Messages.getText((String)"height_cms"), InputFieldPanel.INT);
        }
        return this.height;
    }

    public JRadioButton getRadioPrintSelection() {
        if (this.radioPrintSelection == null) {
            this.radioPrintSelection = new JRadioButton(Messages.getText((String)"print_selection"));
        }
        return this.radioPrintSelection;
    }

    public void setSizePxResult(int w, int h) {
        this.w = w;
        this.h = h;
        this.labelWidth.setText(Messages.getText((String)"width_result") + ": " + w + " px");
        this.labelHeight.setText(Messages.getText((String)"height_result") + ": " + h + " px");
    }

    public int getWidthPx() {
        return this.w;
    }

    public int getHeightPx() {
        return this.h;
    }

    public JLabel getLabelWidth() {
        if (this.labelWidth == null) {
            this.labelWidth = new JLabel(Messages.getText((String)"width_result") + ": 0 px");
        }
        return this.labelWidth;
    }

    public JLabel getLabelHeight() {
        if (this.labelHeight == null) {
            this.labelHeight = new JLabel(Messages.getText((String)"height_result") + ": 0 px");
        }
        return this.labelHeight;
    }

    public void setEnable(boolean enabled) {
        this.getScale().setEnable(enabled);
        this.getWidthInput().setEnable(enabled);
        this.getHeightInput().setEnable(enabled);
        this.getComboDPI().setEnabled(enabled);
        this.getLabelHeight().setEnabled(enabled);
        this.getLabelWidth().setEnabled(enabled);
        this.resolution.setEnabled(enabled);
    }
}

