/*
 * Decompiled with CFR 0.152.
 */
package org.jzkit.search.provider.z3950;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.beanutils.BeanUtils;
import org.jzkit.search.provider.iface.SearchException;
import org.jzkit.search.provider.iface.SearchServiceFactory;
import org.jzkit.search.provider.iface.Searchable;
import org.jzkit.search.provider.iface.ServiceUserInformation;
import org.jzkit.search.provider.z3950.Z3950Origin;
import org.jzkit.search.provider.z3950.ZAuthenticationMethod;
import org.springframework.context.ApplicationContext;

public class Z3950ServiceFactory
implements SearchServiceFactory {
    private String host;
    private int port;
    private String default_record_syntax;
    private String default_record_schema;
    private String default_element_set_name;
    private int pref_message_size = 0x100000;
    private int exceptional_message_size = 0x100000;
    private String charset_encoding = "UTF-8";
    private boolean use_reference_id = true;
    private ZAuthenticationMethod auth_method;
    private Map record_archetypes = new HashMap();
    private ApplicationContext ctx;

    public Z3950ServiceFactory() {
    }

    public Z3950ServiceFactory(String host, int port) {
        this();
        this.host = host;
        this.port = port;
    }

    public Properties toProps() {
        Properties result = new Properties();
        result.setProperty("ServiceHost", this.host);
        result.setProperty("ServicePort", "" + this.port);
        if (this.charset_encoding != null) {
            result.setProperty("charset", this.charset_encoding);
        }
        return result;
    }

    public Searchable newSearchable(ServiceUserInformation user_info) throws SearchException {
        if (this.ctx == null) {
            throw new SearchException("ApplicationContext not set for this factory. appctx is required");
        }
        Z3950Origin result = new Z3950Origin();
        result.setApplicationContext(this.ctx);
        try {
            BeanUtils.copyProperties((Object)result, (Object)this);
            result.setRecordArchetypes(this.record_archetypes);
        }
        catch (IllegalAccessException iae) {
            throw new SearchException("Problem creating Z3950 Origin", (Object)iae);
        }
        catch (InvocationTargetException ite) {
            throw new SearchException("Problem creating Z3950 Origin", (Object)ite);
        }
        return result;
    }

    public Searchable newSearchable() throws SearchException {
        return this.newSearchable(null);
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getDefaultRecordSyntax() {
        return this.default_record_syntax;
    }

    public String getDefaultRecordSchema() {
        return this.default_record_schema;
    }

    public String getDefaultElementSetName() {
        return this.default_element_set_name;
    }

    public int getPrefMessageSize() {
        return this.pref_message_size;
    }

    public int getExceptionalMessageSize() {
        return this.exceptional_message_size;
    }

    public String getCharsetEncoding() {
        return this.charset_encoding;
    }

    public boolean getUseReferenceId() {
        return this.use_reference_id;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setDefaultRecordSyntax(String default_record_syntax) {
        this.default_record_syntax = default_record_syntax;
    }

    public void setDefaultRecordSchema(String default_record_schema) {
        this.default_record_schema = default_record_schema;
    }

    public void setDefaultElementSetName(String default_element_set_name) {
        this.default_element_set_name = default_element_set_name;
    }

    public void setPrefMessageSize(int pref_message_size) {
        this.pref_message_size = pref_message_size;
    }

    public void setExceptionalMessageSize(int exceptional_message_size) {
        this.exceptional_message_size = exceptional_message_size;
    }

    public void setCharsetEncoding(String charset_encoding) {
        this.charset_encoding = charset_encoding;
    }

    public void setUseReferenceId(boolean use_reference_id) {
        this.use_reference_id = use_reference_id;
    }

    public ZAuthenticationMethod getAuthMethod() {
        return this.auth_method;
    }

    public void setAuthMethod(ZAuthenticationMethod auth_method) {
        this.auth_method = auth_method;
    }

    public Map getRecordArchetypes() {
        return this.record_archetypes;
    }

    public void setRecordArchetypes(Map record_archetypes) {
        this.record_archetypes = record_archetypes;
    }

    public void setApplicationContext(ApplicationContext ctx) {
        this.ctx = ctx;
    }

    public ApplicationContext getApplicationContext() {
        return this.ctx;
    }
}

