/*
 * Decompiled with CFR 0.152.
 */
package org.jzkit.z3950.client;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Logger;
import org.jzkit.a2j.codec.util.OIDRegister;
import org.jzkit.a2j.gen.AsnUseful.EXTERNAL_type;
import org.jzkit.search.util.QueryModel.InvalidQueryException;
import org.jzkit.search.util.QueryModel.PrefixString.PrefixString;
import org.jzkit.search.util.QueryModel.QueryModel;
import org.jzkit.search.util.RecordModel.ExplicitRecordFormatSpecification;
import org.jzkit.z3950.QueryModel.Type1QueryModelBuilder;
import org.jzkit.z3950.QueryModel.Z3950QueryModel;
import org.jzkit.z3950.Z3950Exception;
import org.jzkit.z3950.gen.v3.RecordSyntax_explain.CategoryInfo_type;
import org.jzkit.z3950.gen.v3.RecordSyntax_explain.CategoryList_type;
import org.jzkit.z3950.gen.v3.RecordSyntax_explain.DatabaseInfo_type;
import org.jzkit.z3950.gen.v3.RecordSyntax_explain.Explain_Record_type;
import org.jzkit.z3950.gen.v3.Z39_50_APDU_1995.Close_type;
import org.jzkit.z3950.gen.v3.Z39_50_APDU_1995.DefaultDiagFormat_type;
import org.jzkit.z3950.gen.v3.Z39_50_APDU_1995.DiagRec_type;
import org.jzkit.z3950.gen.v3.Z39_50_APDU_1995.InitializeResponse_type;
import org.jzkit.z3950.gen.v3.Z39_50_APDU_1995.NamePlusRecord_type;
import org.jzkit.z3950.gen.v3.Z39_50_APDU_1995.PDU_type;
import org.jzkit.z3950.gen.v3.Z39_50_APDU_1995.PresentResponse_type;
import org.jzkit.z3950.gen.v3.Z39_50_APDU_1995.ScanResponse_type;
import org.jzkit.z3950.gen.v3.Z39_50_APDU_1995.SearchRequest_type;
import org.jzkit.z3950.gen.v3.Z39_50_APDU_1995.SearchResponse_type;
import org.jzkit.z3950.util.APDUEvent;
import org.jzkit.z3950.util.APDUListener;
import org.jzkit.z3950.util.GenericEventToOriginListenerAdapter;
import org.jzkit.z3950.util.PDUTypeAvailableSemaphore;
import org.jzkit.z3950.util.ReferencedPDUAvaialableSemaphore;
import org.jzkit.z3950.util.TimeoutExceededException;
import org.jzkit.z3950.util.ZEndpoint;
import org.springframework.context.ApplicationContext;

public class SynchronousOriginBean
implements APDUListener {
    protected ZEndpoint assoc = null;
    protected OIDRegister reg = null;
    protected ArrayList db_names = new ArrayList();
    protected String record_syntax = "sutrs";
    public static final int NO_CONNECTION = 1;
    public static final int CONNECTING = 2;
    public static final int CONNECTED = 3;
    public static final String NO_RS_NAME = "default";
    int session_status = 1;
    private HashMap responses = new HashMap();
    private Hashtable dbinfo = new Hashtable();
    private boolean supports_named_result_sets = true;
    protected Logger log = Logger.getLogger((class$org$jzkit$z3950$client$SynchronousOriginBean == null ? (class$org$jzkit$z3950$client$SynchronousOriginBean = SynchronousOriginBean.class$("org.jzkit.z3950.client.SynchronousOriginBean")) : class$org$jzkit$z3950$client$SynchronousOriginBean).getName());
    private ApplicationContext ctx = null;
    static /* synthetic */ Class class$org$jzkit$z3950$client$SynchronousOriginBean;

    public SynchronousOriginBean(OIDRegister reg) {
        this.db_names.add("Default");
        this.reg = reg;
    }

    public int getSessionStatus() {
        return this.session_status;
    }

    public void setSessionStatus(int i) {
        this.session_status = i;
    }

    public void setRecordSyntax(String record_syntax) {
        this.record_syntax = record_syntax;
    }

    public String getRecordSyntax() {
        return this.record_syntax;
    }

    public void clearAllDatabases() {
        this.db_names.clear();
    }

    public void addDatatabse(String dbname) {
        this.db_names.add(dbname);
    }

    public void disconnect() {
        if (null != this.assoc) {
            System.err.println("Closing existing listener");
            try {
                this.assoc.shutdown();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
    }

    public InitializeResponse_type connect(String hostname, int portnum) {
        this.disconnect();
        return this.connect(hostname, portnum, 0, null, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InitializeResponse_type connect(String hostname, int portnum, int auth_type, String principal, String group, String credentials) {
        System.err.println("Connect");
        InitializeResponse_type retval = null;
        try {
            this.disconnect();
            System.out.println("Create listener & encoder");
            this.assoc = new ZEndpoint(this.reg);
            this.assoc.setHost(hostname);
            this.assoc.setPort(portnum);
            this.assoc.setAuthType(auth_type);
            if (principal != null) {
                this.assoc.setServiceUserPrincipal(principal);
            }
            if (group != null) {
                this.assoc.setServiceUserGroup(group);
            }
            if (credentials != null) {
                this.assoc.setServiceUserCredentials(credentials);
            }
            this.assoc.getPDUAnnouncer().addObserver(new GenericEventToOriginListenerAdapter(this));
            PDUTypeAvailableSemaphore s = new PDUTypeAvailableSemaphore(1, this.assoc.getPDUAnnouncer());
            this.assoc.start();
            try {
                s.waitForCondition(20000);
                retval = (InitializeResponse_type)s.the_pdu.o;
            }
            catch (Exception e) {
            }
            finally {
                s.destroy();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return retval;
    }

    public SearchResponse_type sendSearch(QueryModel query, String refid, String setname) throws Z3950Exception, InvalidQueryException {
        return this.sendSearch(query, refid, setname, "F");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SearchResponse_type sendSearch(QueryModel query, String refid, String setname, String elements) throws Z3950Exception, InvalidQueryException {
        System.err.println("Sending search request....");
        SearchResponse_type retval = null;
        if (refid == null) {
            refid = this.assoc.genRefid("Search");
        }
        PDUTypeAvailableSemaphore s = new PDUTypeAvailableSemaphore(3, this.assoc.getPDUAnnouncer());
        try {
            Z3950QueryModel qry = null;
            this.log.fine("Sending Search request, setname=" + setname + " syntax=" + this.record_syntax);
            qry = query instanceof Z3950QueryModel ? (Z3950QueryModel)query : Type1QueryModelBuilder.buildFrom(this.ctx, query, "utf-8");
            this.assoc.sendSearchRequest(this.db_names, qry.toASNType(), refid, 0, 1, 1, true, this.supports_named_result_sets ? setname : NO_RS_NAME, elements, elements, this.reg.oidByName(this.record_syntax));
            s.waitForCondition(20000);
            retval = (SearchResponse_type)s.the_pdu.o;
            if (retval.records != null) {
                if (retval.records.which == 1) {
                    DefaultDiagFormat_type d = (DefaultDiagFormat_type)retval.records.o;
                    if (d.addinfo != null) {
                        throw new Z3950Exception("Diagnostic [" + d.condition + "] Additional Info : " + d.addinfo.o);
                    }
                    throw new Z3950Exception("Diagnostic [" + d.condition + "] no additional info");
                }
                if (retval.records.which == 2) {
                    DiagRec_type d = (DiagRec_type)retval.records.o;
                    if (d.which == 0) {
                        DefaultDiagFormat_type dd = (DefaultDiagFormat_type)d.o;
                        throw new Z3950Exception("Diagnostic [" + dd.condition + "] Additional Info : " + dd.addinfo.o);
                    }
                    throw new Z3950Exception("Externally defined diagnostic record");
                }
                System.err.println("Search has valid piggyback records");
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        catch (TimeoutExceededException tee) {
            tee.printStackTrace();
        }
        finally {
            s.destroy();
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SearchResponse_type sendSearch(PDU_type req) throws Z3950Exception, InvalidQueryException {
        SearchResponse_type retval = null;
        SearchRequest_type search_req = (SearchRequest_type)req.o;
        ReferencedPDUAvaialableSemaphore s = new ReferencedPDUAvaialableSemaphore(new String(search_req.referenceId), this.assoc.getPDUAnnouncer());
        try {
            this.assoc.encodeAndSend(req);
            s.waitForCondition(20000);
            retval = (SearchResponse_type)s.the_pdu.o;
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        catch (TimeoutExceededException tee) {
            tee.printStackTrace();
        }
        finally {
            s.destroy();
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ScanResponse_type sendScan(QueryModel qm) {
        ScanResponse_type retval = null;
        PDUTypeAvailableSemaphore s = new PDUTypeAvailableSemaphore(16, this.assoc.getPDUAnnouncer());
        try {
            Z3950QueryModel qry = null;
            qry = qm instanceof Z3950QueryModel ? (Z3950QueryModel)qm : Type1QueryModelBuilder.buildFrom(this.ctx, qm, "utf-8");
            this.assoc.sendScanRequest("scan", this.db_names, qry.toASNType(), 0L, 10L, 5L);
            s.waitForCondition(20000);
            retval = (ScanResponse_type)s.the_pdu.o;
        }
        catch (TimeoutExceededException tee) {
            tee.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            s.destroy();
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PresentResponse_type sendPresent(long start, long count, String element_set_name, String setname) {
        PresentResponse_type retval = null;
        String refid = this.assoc.genRefid("Present");
        PDUTypeAvailableSemaphore s = new PDUTypeAvailableSemaphore(5, this.assoc.getPDUAnnouncer());
        try {
            this.log.fine("Sending present request for " + count + " records starting at " + start + ", setname=" + setname + " syntax=" + this.record_syntax);
            this.assoc.sendPresentRequest(refid, this.supports_named_result_sets ? setname : NO_RS_NAME, start, count, new ExplicitRecordFormatSpecification(this.record_syntax, null, element_set_name));
            s.waitForCondition(20000);
            retval = (PresentResponse_type)s.the_pdu.o;
        }
        catch (TimeoutExceededException tee) {
            tee.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            s.destroy();
        }
        System.err.println("Done present request");
        return retval;
    }

    public void incomingAPDU(APDUEvent e) {
    }

    public void incomingInitRequest(APDUEvent e) {
        this.log.fine("Incoming InitRequest");
        this.notifyAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incomingInitResponse(APDUEvent e) {
        InitializeResponse_type init_response = (InitializeResponse_type)e.getPDU().o;
        this.responses.put(init_response.referenceId, init_response);
        this.session_status = 3;
        this.log.fine("Incoming init response " + init_response.referenceId);
        if (init_response.result.booleanValue()) {
            if (init_response.options.isSet(14)) {
                this.log.fine("Target supports named result sets");
            } else {
                this.log.fine("Target does not support named result sets");
                this.supports_named_result_sets = false;
            }
        }
        SynchronousOriginBean synchronousOriginBean = this;
        synchronized (synchronousOriginBean) {
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incomingSearchRequest(APDUEvent e) {
        this.log.fine("\nIncoming SearchRequest");
        SynchronousOriginBean synchronousOriginBean = this;
        synchronized (synchronousOriginBean) {
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incomingSearchResponse(APDUEvent e) {
        SearchResponse_type search_response = (SearchResponse_type)e.getPDU().o;
        this.responses.put(search_response.referenceId, search_response);
        this.log.fine("Incoming search response " + search_response.referenceId);
        SynchronousOriginBean synchronousOriginBean = this;
        synchronized (synchronousOriginBean) {
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incomingPresentRequest(APDUEvent e) {
        this.log.fine("Incoming PresentResponse");
        SynchronousOriginBean synchronousOriginBean = this;
        synchronized (synchronousOriginBean) {
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incomingPresentResponse(APDUEvent e) {
        PresentResponse_type present_response = (PresentResponse_type)e.getPDU().o;
        this.responses.put(present_response.referenceId, present_response);
        SynchronousOriginBean synchronousOriginBean = this;
        synchronized (synchronousOriginBean) {
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incomingDeleteResultSetRequest(APDUEvent e) {
        SynchronousOriginBean synchronousOriginBean = this;
        synchronized (synchronousOriginBean) {
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incomingDeleteResultSetResponse(APDUEvent e) {
        this.log.fine("Incoming DeleteResultSetResponse");
        SynchronousOriginBean synchronousOriginBean = this;
        synchronized (synchronousOriginBean) {
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incomingAccessControlRequest(APDUEvent e) {
        SynchronousOriginBean synchronousOriginBean = this;
        synchronized (synchronousOriginBean) {
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incomingAccessControlResponse(APDUEvent e) {
        System.err.println("Incoming AccessControlResponse");
        SynchronousOriginBean synchronousOriginBean = this;
        synchronized (synchronousOriginBean) {
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incomingResourceControlRequest(APDUEvent e) {
        SynchronousOriginBean synchronousOriginBean = this;
        synchronized (synchronousOriginBean) {
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incomingResourceControlResponse(APDUEvent e) {
        System.err.println("Incoming ResourceControlResponse");
        SynchronousOriginBean synchronousOriginBean = this;
        synchronized (synchronousOriginBean) {
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incomingTriggerResourceControlRequest(APDUEvent e) {
        SynchronousOriginBean synchronousOriginBean = this;
        synchronized (synchronousOriginBean) {
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incomingResourceReportRequest(APDUEvent e) {
        System.err.println("Incoming ResourceReportResponse");
        SynchronousOriginBean synchronousOriginBean = this;
        synchronized (synchronousOriginBean) {
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incomingResourceReportResponse(APDUEvent e) {
        SynchronousOriginBean synchronousOriginBean = this;
        synchronized (synchronousOriginBean) {
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incomingScanRequest(APDUEvent e) {
        System.err.println("Incoming ScanResponse");
        SynchronousOriginBean synchronousOriginBean = this;
        synchronized (synchronousOriginBean) {
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incomingScanResponse(APDUEvent e) {
        SynchronousOriginBean synchronousOriginBean = this;
        synchronized (synchronousOriginBean) {
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incomingSortRequest(APDUEvent e) {
        System.err.println("Incoming SortResponse");
        SynchronousOriginBean synchronousOriginBean = this;
        synchronized (synchronousOriginBean) {
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incomingSortResponse(APDUEvent e) {
        SynchronousOriginBean synchronousOriginBean = this;
        synchronized (synchronousOriginBean) {
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incomingSegmentRequest(APDUEvent e) {
        System.err.println("Incoming SegmentResponse");
        SynchronousOriginBean synchronousOriginBean = this;
        synchronized (synchronousOriginBean) {
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incomingExtendedServicesRequest(APDUEvent e) {
        SynchronousOriginBean synchronousOriginBean = this;
        synchronized (synchronousOriginBean) {
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incomingExtendedServicesResponse(APDUEvent e) {
        System.err.println("Incoming ExtendedServicesResponse");
        SynchronousOriginBean synchronousOriginBean = this;
        synchronized (synchronousOriginBean) {
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incomingClose(APDUEvent e) {
        System.err.println("Incoming close event: ");
        Close_type close_apdu = (Close_type)e.getPDU().o;
        System.err.println("closeReason:" + close_apdu.closeReason);
        System.err.println("diagnosticInformation:" + close_apdu.diagnosticInformation);
        SynchronousOriginBean synchronousOriginBean = this;
        synchronized (synchronousOriginBean) {
            this.notifyAll();
        }
    }

    public void doExplain() throws Z3950Exception, InvalidQueryException {
        block5: {
            block6: {
                this.clearAllDatabases();
                this.addDatatabse("IR-Explain-1");
                this.setRecordSyntax("explain");
                SearchResponse_type r = this.sendSearch((QueryModel)new PrefixString("@attrset exp-1 @attr 1=1 categoryList"), "exp", "expset");
                if (!r.searchStatus.booleanValue() || r.resultCount.intValue() != 1) break block5;
                CategoryList_type cl = null;
                if (r.numberOfRecordsReturned.intValue() != 1) break block5;
                if (r.records.which != 0) break block6;
                Vector response_records = (Vector)r.records.o;
                NamePlusRecord_type npr = (NamePlusRecord_type)response_records.get(0);
                System.err.println("Got record from " + npr.name);
                switch (npr.record.which) {
                    case 0: {
                        EXTERNAL_type et = (EXTERNAL_type)npr.record.o;
                        Object o = et.encoding.o;
                        System.err.println("Got retrieval record");
                        if (o instanceof Explain_Record_type) {
                            cl = (CategoryList_type)((Explain_Record_type)o).o;
                            for (int i = 0; i < cl.categories.size(); ++i) {
                                CategoryInfo_type ci = (CategoryInfo_type)cl.categories.get(i);
                                System.err.println("Aviailable category : " + ci.category);
                                if (null == ci.category || !ci.category.equals("DatabaseInfo")) continue;
                                this.explainDatabaseInfo();
                            }
                        }
                        break block5;
                    }
                    default: {
                        System.err.println("Unhandled name plus record option : " + npr.record.which);
                    }
                }
                break block5;
            }
            System.err.println("Might have a diagnostic here...");
        }
    }

    private void explainDatabaseInfo() throws Z3950Exception, InvalidQueryException {
        this.clearAllDatabases();
        this.addDatatabse("IR-Explain-1");
        this.dbinfo.clear();
        this.setRecordSyntax("explain");
        SearchResponse_type r = this.sendSearch((QueryModel)new PrefixString("@attrset exp-1 @attr 1=1 databaseInfo"), "expdbinfo", "dbinfoset");
        if (r.searchStatus.booleanValue() && r.resultCount.intValue() > 0 && r.numberOfRecordsReturned.intValue() > 0 && r.records.which == 0) {
            this.processDatabaseInfoRecords((Vector)r.records.o);
        }
    }

    private void processDatabaseInfoRecords(Vector records) {
        for (int i = 0; i < records.size(); ++i) {
            NamePlusRecord_type npr = (NamePlusRecord_type)records.get(i);
            if (npr.record.which != 0) continue;
            EXTERNAL_type et = (EXTERNAL_type)npr.record.o;
            Object o = et.encoding.o;
            if (!(o instanceof Explain_Record_type)) continue;
            DatabaseInfo_type di = (DatabaseInfo_type)((Explain_Record_type)o).o;
            this.dbinfo.put(di.name, di);
            System.err.println("Aviailable database: " + di.name);
        }
    }

    public Enumeration getDatabases() {
        return this.dbinfo.elements();
    }

    public void setApplicationContext(ApplicationContext ctx) {
        this.ctx = ctx;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

