/*
 * Decompiled with CFR 0.152.
 */
package org.jzkit.z3950.client;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;
import org.jzkit.a2j.codec.util.OIDRegister;
import org.jzkit.a2j.gen.AsnUseful.EXTERNAL_type;
import org.jzkit.search.util.QueryModel.CQLString.CQLString;
import org.jzkit.search.util.QueryModel.InvalidQueryException;
import org.jzkit.search.util.QueryModel.PrefixString.PrefixString;
import org.jzkit.search.util.QueryModel.QueryModel;
import org.jzkit.z3950.RecordModel.GRS1;
import org.jzkit.z3950.Z3950Exception;
import org.jzkit.z3950.client.SynchronousOriginBean;
import org.jzkit.z3950.gen.v3.Z39_50_APDU_1995.DefaultDiagFormat_type;
import org.jzkit.z3950.gen.v3.Z39_50_APDU_1995.DiagRec_type;
import org.jzkit.z3950.gen.v3.Z39_50_APDU_1995.Entry_type;
import org.jzkit.z3950.gen.v3.Z39_50_APDU_1995.InitializeResponse_type;
import org.jzkit.z3950.gen.v3.Z39_50_APDU_1995.NamePlusRecord_type;
import org.jzkit.z3950.gen.v3.Z39_50_APDU_1995.PresentResponse_type;
import org.jzkit.z3950.gen.v3.Z39_50_APDU_1995.Records_type;
import org.jzkit.z3950.gen.v3.Z39_50_APDU_1995.ScanResponse_type;
import org.jzkit.z3950.gen.v3.Z39_50_APDU_1995.SearchResponse_type;
import org.jzkit.z3950.gen.v3.Z39_50_APDU_1995.TermInfo_type;
import org.jzkit.z3950.gen.v3.Z39_50_APDU_1995.Term_type;
import org.jzkit.z3950.util.Z3950Constants;

public class ZClient
extends SynchronousOriginBean {
    public static final char ISO2709_RS = '\u001d';
    public static final char ISO2709_FS = '\u001e';
    public static final char ISO2709_IDFS = '\u001f';
    private static final String PREFIX_QUERY_TYPE = "PREFIX";
    private static final String CCL_QUERY_TYPE = "CCL";
    private int auth_type = 0;
    private String principal = null;
    private String group = null;
    private String credentials = null;
    private String querytype = "PREFIX";
    private String current_result_set_name = null;
    private int result_set_count = 0;
    private String element_set_name = null;

    public static void main(String[] args) {
        ZClient newclient = new ZClient(new OIDRegister("/a2j.properties"));
        if (args.length > 0) {
            newclient.cmdOpen(args[0]);
        }
        newclient.commandShell();
    }

    public ZClient(OIDRegister reg) {
        super(reg);
    }

    public void commandShell() {
        BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
        String command_line = new String();
        String command = new String();
        while (!command.regionMatches(true, 0, "quit", 0, 4)) {
            try {
                System.out.print("ZClient > ");
                command_line = br.readLine();
                StringTokenizer st = new StringTokenizer(command_line, " ", true);
                if (!st.hasMoreTokens()) continue;
                command = st.nextToken();
                if (command.equals("open")) {
                    this.cmdOpen(st.nextToken(""));
                    continue;
                }
                if (command.equals("show")) {
                    this.cmdShow(st.nextToken(""));
                    continue;
                }
                if (command.equals("find")) {
                    this.cmdFind(st.nextToken(""));
                    continue;
                }
                if (command.equals("base")) {
                    this.cmdBase(st.nextToken(""));
                    continue;
                }
                if (command.equals("elements")) {
                    this.cmdElements(st.nextToken(""));
                    continue;
                }
                if (command.equals("format")) {
                    this.cmdFormat(st.nextToken(""));
                    continue;
                }
                if (command.equals("auth")) {
                    this.cmdAuth(st.nextToken(""));
                    continue;
                }
                if (command.equals("querytype")) {
                    this.cmdQueryType(st.nextToken(""));
                    continue;
                }
                if (command.equals("scan")) {
                    this.cmdScan(st.nextToken(""));
                    continue;
                }
                System.out.println("Commands:");
                System.out.println("  open hostname[:portnum]     - Connect to z server on host[:port]");
                System.out.println("  show n[+i]                  - show i records starting at n");
                System.out.println("  find [rpn-string]           - Process the supplied rpn query");
                System.out.println("  base db1 [db2.....]         - Search the specified databases");
                System.out.println("  elements [b|f|custom]       - select the specified element set name");
                System.out.println("  format [ xml|sutrs|grs..]   - Ask the server for the specified kind of records");
                System.out.println("  auth anon                   - use anonymous authentication");
                System.out.println("  auth open idstring          - use open authentication");
                System.out.println("  auth idpass user,group,pass - Use idpass authentication (user,none,pass for no group)");
                System.out.println("  querytype [prefix|ccl]      - Set query parser");
                System.out.println("  scan [rpn-string]");
                System.out.println("");
                System.out.println("  rpn strings are composed as follows: ");
                System.out.println("  rpn-string = @attrset default-attrset expr");
                System.out.println("  expr = [ attr-plus-term | boolean ]");
                System.out.println("  attr-plus-term = attrdef [ attrdef...] { single-term | \"quoted string\" }");
                System.out.println("  attrdef = @attr [attrset] attrtype=attrval ");
                System.out.println("  boolean = { @and | @or | @not } expr expr");
                System.out.println("");
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
            catch (NoSuchElementException nse) {
                System.err.println("Expected parameters for that command");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        System.exit(0);
    }

    public void cmdOpen(String args) {
        try {
            StringTokenizer st = new StringTokenizer(args, ": ");
            String hostname = null;
            int portnum = 210;
            if (st.hasMoreTokens()) {
                hostname = st.nextToken();
            }
            if (st.hasMoreTokens()) {
                portnum = Integer.parseInt(st.nextToken());
            }
            InitializeResponse_type resp = this.connect(hostname, portnum, this.auth_type, this.principal, this.group, this.credentials);
            if (resp.result.booleanValue()) {
                System.out.println("\n  Init Response");
                if (resp.referenceId != null) {
                    System.out.println("Reference ID : " + new String(resp.referenceId));
                }
                System.out.println("  Implementation ID : " + resp.implementationId);
                System.out.println("  Implementation Name : " + resp.implementationName);
                System.out.println("  Implementation Version : " + resp.implementationVersion);
                System.out.print("  Target Services : ");
                for (int i = 0; i < Z3950Constants.z3950_option_names.length; ++i) {
                    if (!resp.options.isSet(i)) continue;
                    System.out.print(Z3950Constants.z3950_option_names[i] + " ");
                }
                System.out.println("");
            } else {
                System.out.println("  Failed to establish association");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void cmdFind(String args) {
        SearchResponse_type resp = null;
        this.current_result_set_name = "RS" + this.result_set_count++;
        Object qm = null;
        try {
            qm = this.querytype.equalsIgnoreCase(CCL_QUERY_TYPE) ? new CQLString(args) : new PrefixString(args);
            if (qm == null) {
                throw new InvalidQueryException("Failed to parse " + this.querytype + " query");
            }
            resp = this.sendSearch((QueryModel)qm, null, this.current_result_set_name, this.element_set_name);
        }
        catch (Z3950Exception se) {
            System.err.println("find: " + this.querytype + ":" + args);
            se.printStackTrace();
        }
        catch (InvalidQueryException iqe) {
            System.err.println("find: " + args);
            iqe.printStackTrace();
        }
        catch (Exception e) {
            System.err.println("find: " + args);
            e.printStackTrace();
        }
        if (resp != null) {
            System.out.println("\n  Search Response");
            if (resp.referenceId != null) {
                System.out.println("  Reference ID : " + new String(resp.referenceId));
            }
            System.out.println("  Search Result : " + resp.searchStatus);
            System.out.println("  Result Count : " + resp.resultCount);
            System.out.println("  Num Records Returned : " + resp.numberOfRecordsReturned);
            System.out.println("  Next RS position : " + resp.nextResultSetPosition);
            if (null != resp.additionalSearchInfo) {
                System.out.println("  search response contains " + resp.additionalSearchInfo.size() + " additionalSearchInfo entries");
            }
            if (null != resp.otherInfo) {
                System.out.println("  search response contains " + resp.otherInfo.size() + " otherInfo entries");
            }
            if (resp.records != null && resp.numberOfRecordsReturned.intValue() > 0) {
                System.out.println("  Search has piggyback records");
                this.displayRecords(resp.records);
            }
            System.out.println("");
        }
    }

    public void cmdScan(String args) {
        ScanResponse_type resp = null;
        try {
            resp = this.querytype.equals(CCL_QUERY_TYPE) ? this.sendScan((QueryModel)new CQLString(args)) : this.sendScan((QueryModel)new PrefixString(args));
            System.out.println("Scan Response");
            System.out.println("-------------");
            if (resp.referenceId != null) {
                System.out.println("  Reference ID : " + new String(resp.referenceId));
            }
            System.out.println("Step size : " + resp.stepSize);
            System.out.println("Scan Status : " + resp.scanStatus);
            System.out.println("Number of entries returned: " + resp.numberOfEntriesReturned);
            System.out.println("Position of term: " + resp.positionOfTerm);
            if (resp.entries != null) {
                Iterator e;
                if (resp.entries.nonsurrogateDiagnostics != null) {
                    System.out.println("Non-surrogate diagnostics");
                    e = ((AbstractList)resp.entries.nonsurrogateDiagnostics).iterator();
                    while (e.hasNext()) {
                        DiagRec_type diag = (DiagRec_type)e.next();
                        switch (diag.which) {
                            case 0: {
                                DefaultDiagFormat_type ddf = (DefaultDiagFormat_type)diag.o;
                                System.out.println("Default diagnostic: " + ddf.condition + " " + ddf.addinfo.o.toString());
                                break;
                            }
                            case 1: {
                                System.out.println("External diagnostic");
                            }
                        }
                    }
                }
                if (resp.entries.entries != null) {
                    e = ((AbstractList)resp.entries.entries).iterator();
                    while (e.hasNext()) {
                        Entry_type et = (Entry_type)e.next();
                        switch (et.which) {
                            case 0: {
                                TermInfo_type ti = (TermInfo_type)et.o;
                                Term_type tt = ti.term;
                                if (tt.o instanceof byte[]) {
                                    System.out.println(new String((byte[])tt.o));
                                    break;
                                }
                                System.out.println(tt.o.toString());
                                break;
                            }
                            case 1: {
                                DiagRec_type diagRec_type = (DiagRec_type)et.o;
                            }
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    public void cmdShow(String args) {
        System.err.println("Present " + args);
        try {
            StringTokenizer st = new StringTokenizer(args, "+ ");
            int from = 1;
            int count = 1;
            String setname = this.current_result_set_name;
            from = Integer.parseInt(st.nextToken());
            if (st.hasMoreTokens()) {
                count = Integer.parseInt(st.nextToken());
            }
            if (st.hasMoreTokens()) {
                setname = st.nextToken();
            }
            PresentResponse_type resp = this.sendPresent(from, count, this.element_set_name, setname);
            System.out.println("\n  Present Response");
            if (resp.referenceId != null) {
                System.out.println("  Reference ID : " + new String(resp.referenceId));
            }
            System.out.println("  Number of records : " + resp.numberOfRecordsReturned);
            System.out.println("  Next RS Position : " + resp.nextResultSetPosition);
            System.out.println("  Present Status : " + resp.presentStatus);
            System.out.println("");
            Records_type r = resp.records;
            this.displayRecords(r);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println("Exception processing show command " + e);
        }
    }

    public void cmdBase(String args) {
        this.db_names.clear();
        try {
            StringTokenizer st = new StringTokenizer(args, " ");
            this.clearAllDatabases();
            while (st.hasMoreTokens()) {
                this.addDatatabse(st.nextToken());
            }
            System.err.println("dbnames:" + this.db_names);
        }
        catch (Exception e) {
            System.err.println("Exception processing base command " + e);
        }
    }

    public void cmdElements(String args) {
        try {
            StringTokenizer st = new StringTokenizer(args, " ");
            if (st.hasMoreTokens()) {
                this.setElementSetName(st.nextToken());
            } else {
                this.setElementSetName(null);
            }
        }
        catch (Exception e) {
            System.err.println("Exception processing base command " + e);
        }
    }

    public void cmdFormat(String args) {
        try {
            StringTokenizer st = new StringTokenizer(args, " ");
            if (st.hasMoreTokens()) {
                String requested_syntax = st.nextToken();
                if (this.reg.oidByName(requested_syntax) != null) {
                    this.setRecordSyntax(requested_syntax);
                } else {
                    System.out.println("Unknown Record Syntax");
                }
            }
        }
        catch (Exception e) {
            System.err.println("Exception processing format command " + e);
        }
    }

    public void cmdAuth(String args) {
        try {
            StringTokenizer st = new StringTokenizer(args, " ,");
            if (st.hasMoreTokens()) {
                String type = st.nextToken();
                if (type.equals("anon")) {
                    System.out.println("Will use anonymous authentication");
                    this.auth_type = 1;
                } else if (type.equals("open")) {
                    System.out.println("Will use open authentication");
                    if (st.hasMoreTokens()) {
                        this.auth_type = 2;
                        this.principal = st.nextToken();
                        System.out.println("Open auth string will be " + this.principal);
                    } else {
                        System.out.println("Asked for open authentication but no open string supplied, No auth will be used");
                    }
                } else if (type.equals("idpass")) {
                    System.out.println("Will use idpass authentication");
                    this.auth_type = 3;
                    if (st.hasMoreTokens()) {
                        this.principal = st.nextToken();
                    }
                    if (st.hasMoreTokens()) {
                        this.group = st.nextToken();
                    }
                    if (st.hasMoreTokens()) {
                        this.credentials = st.nextToken();
                    }
                } else {
                    System.out.println("Unrecognised auth type, no authentication will be used");
                    this.auth_type = 0;
                }
            } else {
                System.out.println("No auth type, no authentication will be used");
            }
        }
        catch (Exception e) {
            System.err.println("Exception processing base command " + e);
        }
    }

    public void cmdQueryType(String args) {
        try {
            StringTokenizer st = new StringTokenizer(args, " ");
            if (st.hasMoreTokens()) {
                String type = st.nextToken();
                System.out.println("Set query type to " + type);
                this.querytype = type.equals(CCL_QUERY_TYPE) ? CCL_QUERY_TYPE : PREFIX_QUERY_TYPE;
            }
        }
        catch (Exception e) {
            System.err.println("Exception processing base command " + e);
        }
    }

    public void dumpOID(int[] oid) {
        System.out.print("{");
        for (int i = 0; i < oid.length; ++i) {
            System.out.print(oid[i] + " ");
        }
        System.out.println("}");
    }

    public void displayRecords(Records_type r) {
        if (r != null) {
            switch (r.which) {
                case 0: {
                    List v = (List)r.o;
                    int num_records = v.size();
                    System.out.println("Response contains " + num_records + " Response Records");
                    Iterator recs = v.iterator();
                    while (recs.hasNext()) {
                        NamePlusRecord_type npr = (NamePlusRecord_type)recs.next();
                        if (null != npr) {
                            System.out.print("[" + npr.name + "] ");
                            block5 : switch (npr.record.which) {
                                case 0: {
                                    EXTERNAL_type et = (EXTERNAL_type)npr.record.o;
                                    if (et.direct_reference.length == 6) {
                                        switch (et.direct_reference[et.direct_reference.length - 1]) {
                                            case 1: {
                                                System.out.print("Unimarc ");
                                                this.DisplayISO2709((byte[])et.encoding.o);
                                                break block5;
                                            }
                                            case 3: {
                                                System.out.print("CCF ");
                                                break block5;
                                            }
                                            case 10: {
                                                System.out.print("USMarc: ");
                                                this.DisplayISO2709((byte[])et.encoding.o);
                                                break block5;
                                            }
                                            case 11: {
                                                System.out.print("UkMarc ");
                                                this.DisplayISO2709((byte[])et.encoding.o);
                                                break block5;
                                            }
                                            case 12: {
                                                System.out.print("Normarc ");
                                                this.DisplayISO2709((byte[])et.encoding.o);
                                                break block5;
                                            }
                                            case 13: {
                                                System.out.print("Librismarc ");
                                                this.DisplayISO2709((byte[])et.encoding.o);
                                                break block5;
                                            }
                                            case 14: {
                                                System.out.print("Danmarc ");
                                                this.DisplayISO2709((byte[])et.encoding.o);
                                                break block5;
                                            }
                                            case 15: {
                                                System.out.print("Finmarc ");
                                                this.DisplayISO2709((byte[])et.encoding.o);
                                                break block5;
                                            }
                                            case 100: {
                                                break block5;
                                            }
                                            case 101: {
                                                System.out.print("SUTRS ");
                                                System.out.println((String)et.encoding.o);
                                                break block5;
                                            }
                                            case 102: {
                                                break block5;
                                            }
                                            case 105: {
                                                System.out.print("GRS1 ");
                                                this.displayGRS((Vector)et.encoding.o);
                                                break block5;
                                            }
                                        }
                                        System.out.print("Unknown.... ");
                                        System.out.println(et.encoding.o.toString());
                                        break;
                                    }
                                    if (et.direct_reference.length == 7 && et.direct_reference[5] == 109) {
                                        switch (et.direct_reference[6]) {
                                            case 3: {
                                                System.out.print("HTML ");
                                                String html_rec = null;
                                                html_rec = et.encoding.o instanceof byte[] ? new String((byte[])et.encoding.o) : et.encoding.o.toString();
                                                System.out.println(html_rec.toString());
                                                break block5;
                                            }
                                            case 9: {
                                                System.out.print("SGML ");
                                                System.out.println(et.encoding.o.toString());
                                                break block5;
                                            }
                                            case 10: {
                                                System.out.print("XML ");
                                                System.out.println(new String((byte[])et.encoding.o));
                                                break block5;
                                            }
                                        }
                                        System.out.println(et.encoding.o.toString());
                                        break;
                                    }
                                    System.out.println("Unknown direct reference OID: " + et.direct_reference);
                                    break;
                                }
                                case 1: {
                                    System.out.println("SurrogateDiagnostic");
                                    break;
                                }
                                case 2: {
                                    System.out.println("StartingFragment");
                                    break;
                                }
                                case 3: {
                                    System.out.println("IntermediateFragment");
                                    break;
                                }
                                case 4: {
                                    System.out.println("FinalFragment");
                                    break;
                                }
                                default: {
                                    System.out.println("Unknown Record type for NamePlusRecord");
                                }
                            }
                            continue;
                        }
                        System.out.println("Error... record ptr is null");
                    }
                    break;
                }
                case 1: {
                    DefaultDiagFormat_type diag = (DefaultDiagFormat_type)r.o;
                    System.out.println("    Non surrogate diagnostics : " + diag.condition);
                    if (diag.addinfo == null) break;
                    System.out.println("Additional Info: " + diag.addinfo.o.toString());
                    break;
                }
                case 2: {
                    System.out.println("    Multiple non surrogate diagnostics");
                    break;
                }
                default: {
                    System.err.println("    Unknown choice for records response : " + r.which);
                }
            }
        }
        System.out.println("");
    }

    private void DisplayISO2709(byte[] octets) {
        String orig = new String(octets);
        int record_length = Integer.parseInt(orig.substring(0, 5));
        char record_status = orig.charAt(5);
        char type_of_record = orig.charAt(6);
        int indicator_length = 2;
        int subfield_code_length = 2;
        char character_coding_scheme = orig.charAt(9);
        int base_address = Integer.parseInt(orig.substring(12, 17));
        int length_field_length = Character.digit(orig.charAt(20), 10);
        int length_entry = Character.digit(orig.charAt(21), 10);
        if (Character.isDigit(orig.charAt(10))) {
            indicator_length = Character.digit(orig.charAt(10), 10);
        }
        if (Character.isDigit(orig.charAt(11))) {
            subfield_code_length = Character.digit(orig.charAt(11), 10);
        }
        int offset = 24;
        while (orig.charAt(offset) != '\u001e') {
            String tag = orig.substring(offset, offset + 3);
            System.out.print(tag + " ");
            int data_length = Integer.parseInt(orig.substring(offset += 3, offset + length_field_length));
            int data_offset = Integer.parseInt(orig.substring(offset += length_field_length, offset + length_entry));
            offset += length_entry;
            String this_tag = orig.substring(base_address + data_offset + 2, base_address + data_offset + data_length);
            StringTokenizer st = new StringTokenizer(this_tag, "\u001d\u001e\u001f", true);
            String subfield = null;
            while (st.hasMoreTokens()) {
                subfield = st.nextToken();
                if (subfield.charAt(0) == '\u001d' || subfield.charAt(0) == '\u001e') continue;
                if (subfield.charAt(0) == '\u001f') {
                    subfield = st.nextToken();
                    System.out.print("$" + subfield.charAt(0) + " " + subfield.substring(1, subfield.length()));
                    continue;
                }
                System.out.print(subfield);
            }
            System.out.println("");
        }
    }

    private void displayGRS(Vector v) {
        GRS1 grs_rec = new GRS1("Repository", "Coll", "", v, null, this.reg);
        System.out.println(grs_rec.toString());
    }

    public void setElementSetName(String element_set_name) {
        this.element_set_name = element_set_name;
    }

    public String getElementSetName() {
        return this.element_set_name;
    }
}

