/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.principalcomponents.swing.impl.main;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import java.util.EventListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.gvsig.fmap.dal.coverage.store.RasterDataStore;
import org.gvsig.i18n.Messages;
import org.gvsig.raster.algorithm.BasicAPISwingPanel;
import org.gvsig.raster.algorithm.RasterBaseAlgorithmLibrary;
import org.gvsig.raster.algorithm.process.DataProcess;
import org.gvsig.raster.algorithm.process.ProcessException;
import org.gvsig.raster.principalcomponents.swing.impl.main.BandTableModel;
import org.gvsig.raster.principalcomponents.swing.impl.main.CheckBoxColumnEditor;
import org.gvsig.raster.principalcomponents.swing.impl.main.CheckBoxColumnRenderer;
import org.gvsig.raster.swing.RasterSwingLocator;
import org.gvsig.raster.swing.RasterSwingManager;
import org.gvsig.raster.swing.newlayer.CreateNewLayerPanel;
import org.gvsig.raster.swing.pagedtable.ModelLoader;
import org.gvsig.raster.swing.pagedtable.PagedTable;
import org.gvsig.raster.swing.pagedtable.TableModel;

public class PrincipalComponentsPanelImpl
extends JPanel
implements BasicAPISwingPanel {
    private static final long serialVersionUID = 1L;
    private String layerName = null;
    private CreateNewLayerPanel newLayerPanel = null;
    private Object inputStore = null;
    private PagedTable table = null;
    private int bandList = 0;

    public PrincipalComponentsPanelImpl(Object inputStore, String layerName, int bandList) {
        this.inputStore = inputStore;
        this.layerName = layerName;
        this.bandList = bandList;
        this.init();
    }

    private void init() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.fill = 2;
        gridBagConstraints1.weightx = 1.0;
        gridBagConstraints1.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 0;
        this.add((Component)this.getLayerPanel(), gridBagConstraints1);
        gridBagConstraints1.gridy = 2;
        this.add((Component)((JComponent)this.getCreateNewLayerPanel()), gridBagConstraints1);
        gridBagConstraints1.fill = 1;
        gridBagConstraints1.gridy = 1;
        gridBagConstraints1.weighty = 1.0;
        this.add((Component)this.getInputsPanel(), gridBagConstraints1);
    }

    private JPanel getLayerPanel() {
        JPanel p = new JPanel();
        p.setBorder(BorderFactory.createTitledBorder(Messages.getText((String)"layer")));
        p.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.fill = 2;
        gridBagConstraints1.weightx = 1.0;
        gridBagConstraints1.insets = new Insets(0, 0, 2, 0);
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 0;
        p.add((Component)new JLabel(this.layerName), gridBagConstraints1);
        return p;
    }

    private JPanel getInputsPanel() {
        JPanel p = new JPanel();
        p.setBorder(BorderFactory.createTitledBorder(Messages.getText((String)"bands")));
        p.setLayout(new BorderLayout());
        GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.fill = 1;
        gridBagConstraints1.weightx = 1.0;
        gridBagConstraints1.weighty = 1.0;
        gridBagConstraints1.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 0;
        p.add((Component)this.getPagedTable().getComponent(), "Center");
        return p;
    }

    public JComponent getComponent() {
        return this;
    }

    public PagedTable getPagedTable() {
        if (this.table == null) {
            RasterSwingManager manager = RasterSwingLocator.getSwingManager();
            String[] columnNames = new String[]{"", Messages.getText((String)"bands")};
            int[] columnSizes = new int[]{30, -1};
            BandTableModel model = new BandTableModel(columnNames);
            ModelLoader loader = manager.createModelLoader((TableModel)model);
            CheckBoxColumnRenderer render = new CheckBoxColumnRenderer(null);
            CheckBoxColumnEditor editor = new CheckBoxColumnEditor();
            loader.setRenderForColumn(0, (TableCellRenderer)render);
            loader.setCellEditorForColumn(0, (TableCellEditor)editor);
            loader.setColumnNames(columnNames);
            loader.setColumnWidths(columnSizes);
            this.table = manager.createPagedTable(loader);
            this.table.showControllerTable(false);
            this.table.showMoveRowsControls(false);
        }
        return this.table;
    }

    public DataProcess getResult() throws ProcessException {
        DataProcess task = RasterBaseAlgorithmLibrary.getManager().createRasterTask("StatsPrincipalComponentsProcess");
        List params = task.getRasterTaskInputParameters("StatsPrincipalComponentsProcess");
        for (int i = 0; i < params.size(); ++i) {
            String paramName = (String)params.get(i);
            Class paramType = task.getParameterTypeByProcess("StatsPrincipalComponentsProcess", paramName);
            if (paramType == RasterDataStore[].class) {
                task.addParam(paramName, (Object)new RasterDataStore[]{(RasterDataStore)this.inputStore});
            }
            if (paramType == String.class) {
                String filename = this.newLayerPanel.getDirectorySelected() + File.separator + this.newLayerPanel.getFileSelected();
                if (!filename.endsWith(".tif")) {
                    filename = filename + ".tif";
                }
                task.addParam(paramName, (Object)filename);
            }
            if (paramType != Boolean[].class) continue;
            boolean[] bands = new boolean[this.getPagedTable().getRowCount()];
            for (int j = 0; j < this.getPagedTable().getRowCount(); ++j) {
                Object obj = this.getPagedTable().getValueAt(j, 0);
                if (!(obj instanceof Boolean)) continue;
                bands[j] = (Boolean)obj;
            }
            task.addParam(paramName, (Object)bands);
        }
        return task;
    }

    public CreateNewLayerPanel getCreateNewLayerPanel() {
        if (this.newLayerPanel == null) {
            this.newLayerPanel = RasterSwingLocator.getSwingManager().createNewLayerPanel();
        }
        return this.newLayerPanel;
    }

    public void initialize() {
        for (int i = 0; i < this.bandList; ++i) {
            this.getPagedTable().addRow(new Object[]{true, "B" + i});
        }
    }

    public int getComponentIDByObject(Object obj) {
        return -1;
    }

    public void addListener(EventListener listener) {
    }
}

