/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.principalcomponents.swing.impl.stats;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import org.cresques.Messages;
import org.gvsig.raster.principalcomponents.algorithm.PCStatsDataStructure;
import org.gvsig.raster.principalcomponents.swing.impl.stats.ReportStatisticsProcessPCA;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.i18n.I18nManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatsPanelImpl
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JButton save = null;
    private JTextPane text = null;
    private String html = null;
    private Logger log = LoggerFactory.getLogger(StatsPanelImpl.class);
    I18nManager i18n = ToolsLocator.getI18nManager();

    public StatsPanelImpl(PCStatsDataStructure pcStatistics, boolean bandStatistics, boolean covar, boolean autovect) {
        ReportStatisticsProcessPCA process = new ReportStatisticsProcessPCA(pcStatistics, bandStatistics, covar, autovect);
        this.html = process.getHtml();
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.text = new JTextPane();
        this.text.setContentType("text/html");
        this.text.setEditable(false);
        this.text.setText(this.html);
        this.text.setCaretPosition(0);
        JScrollPane scrollPane = new JScrollPane(this.text);
        this.save = new JButton(this.i18n.getTranslation("save"));
        this.save.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StatsPanelImpl.this.saveActionPerformed(evt);
            }
        });
        JPanel buttonsPanel = new JPanel();
        buttonsPanel.setLayout(new BoxLayout(buttonsPanel, 2));
        buttonsPanel.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        buttonsPanel.add(Box.createHorizontalGlue());
        buttonsPanel.add(this.save);
        this.add((Component)scrollPane, "Center");
        this.add((Component)buttonsPanel, "South");
        this.setVisible(true);
    }

    private void saveActionPerformed(ActionEvent evt) {
        FileWriter reporte = null;
        PrintWriter escritura = null;
        JFileChooser chooser = new JFileChooser();
        chooser.setFileSelectionMode(2);
        int returnVal = chooser.showSaveDialog(this.getParent());
        if (returnVal == 0 && chooser.getSelectedFile() != null) {
            try {
                File file = chooser.getSelectedFile();
                if (file.isDirectory()) {
                    if (file.canWrite()) {
                        file = new File(file.getAbsolutePath() + File.separator + "Report.html");
                    } else {
                        JOptionPane.showMessageDialog(this.getParent(), Messages.getText((String)"folder_not_writable"));
                    }
                } else if (!file.getAbsolutePath().endsWith("html") && !file.getAbsolutePath().endsWith("htm")) {
                    file = new File(file.getAbsolutePath() + ".html");
                }
                reporte = new FileWriter(file);
            }
            catch (IOException e1) {
                this.log.error("Error writing the statistics", (Throwable)e1);
            }
            escritura = new PrintWriter(reporte);
            escritura.println(this.html);
            escritura.close();
        }
    }
}

