/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.postgresql.dal;

import java.sql.DatabaseMetaData;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.expressionevaluator.ExpressionBuilder;
import org.gvsig.expressionevaluator.Formatter;
import org.gvsig.fmap.dal.SQLBuilder;
import org.gvsig.fmap.dal.feature.spi.SQLBuilderBase;
import org.gvsig.fmap.dal.store.jdbc2.JDBCConnection;
import org.gvsig.fmap.dal.store.jdbc2.JDBCHelper;
import org.gvsig.fmap.dal.store.jdbc2.spi.JDBCSQLBuilderBase;
import org.gvsig.postgresql.dal.PostgreSQLHelper;
import org.gvsig.postgresql.dal.expressionbuilderformatter.PostgreSQLFormatter;

public class PostgreSQLBuilder
extends JDBCSQLBuilderBase {
    protected Formatter formatter = null;
    private Version databaseVersion = null;

    public Version getDatabaseVersion() {
        if (this.databaseVersion == null) {
            JDBCConnection conn = null;
            try {
                conn = this.getHelper().getConnection();
                DatabaseMetaData metadata = conn.getMetaData();
                this.databaseVersion = new Version(metadata.getDatabaseMajorVersion(), metadata.getDatabaseMinorVersion());
            }
            catch (Exception ex) {
                this.databaseVersion = new Version(0, 0);
            }
            finally {
                JDBCConnection.closeQuietly((JDBCConnection)conn);
            }
        }
        return this.databaseVersion;
    }

    public PostgreSQLBuilder(JDBCHelper helper) {
        super(helper);
        this.defaultSchema = "public";
        this.supportSchemas = true;
        this.allowAutomaticValues = true;
        this.geometrySupportType = this.helper.getGeometrySupportType();
        this.hasSpatialFunctions = this.helper.hasSpatialFunctions();
        this.STMT_DELETE_GEOMETRY_COLUMN_FROM_TABLE_schema_table = null;
        this.STMT_DELETE_GEOMETRY_COLUMN_FROM_TABLE_table = null;
        this.STMT_UPDATE_TABLE_STATISTICS_table = "ANALYZE {0}";
    }

    public Formatter formatter() {
        if (this.formatter == null) {
            this.formatter = new PostgreSQLFormatter((SQLBuilder)this);
        }
        return this.formatter;
    }

    public PostgreSQLHelper getHelper() {
        return (PostgreSQLHelper)this.helper;
    }

    protected SQLBuilder.CreateTableBuilder createCreateTableBuilder() {
        return new PostgreSQLCreateTableBuilder();
    }

    public SQLBuilder.CreateIndexBuilder createCreateIndexBuilder() {
        return new PostgreSQLCreateIndexBuilder();
    }

    public SQLBuilder.SelectBuilder createSelectBuilder() {
        return new PostgreSQLSelectBuilderBase();
    }

    protected SQLBuilder.UpdateTableStatisticsBuilder createUpdateTableStatisticsBuilder() {
        return new PostgreSQLUpdateTableStatisticsBuilderBase();
    }

    public int getMaxRecomendedSQLLength() {
        return 10240;
    }

    public String as_clob(String s) {
        int chunkSize = 1024;
        StringBuilder builder = new StringBuilder();
        builder.append("('");
        for (int i = 0; i < s.length(); i += chunkSize) {
            String chunk = s.substring(i, Math.min(s.length(), i + chunkSize));
            if (i > 0) {
                builder.append("'::text || '");
            }
            builder.append(StringUtils.replace((String)chunk, (String)"'", (String)"''"));
        }
        builder.append("'::text)");
        return builder.toString();
    }

    public class PostgreSQLSelectBuilderBase
    extends SQLBuilderBase.SelectBuilderBase {
        public PostgreSQLSelectBuilderBase() {
            super((SQLBuilderBase)PostgreSQLBuilder.this);
        }

        protected boolean isValid(StringBuilder message) {
            if (message == null) {
                message = new StringBuilder();
            }
            if (this.has_offset() && !this.has_order_by()) {
                message.append("Can't use OFFSET without an ORDER BY.");
                return false;
            }
            return true;
        }

        public String toString(Formatter formatter) {
            StringBuilder builder = new StringBuilder();
            if (!this.isValid(builder)) {
                throw new IllegalStateException(builder.toString());
            }
            builder.append("SELECT ");
            if (this.distinct) {
                builder.append("DISTINCT ");
            }
            boolean first = true;
            for (SQLBuilder.SelectColumnBuilder column : this.columns) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append(column.toString(formatter));
            }
            if (this.has_from()) {
                builder.append(" FROM ");
                builder.append(this.from.toString(formatter));
            }
            if (this.has_where()) {
                builder.append(" WHERE ");
                builder.append(this.where.toString(formatter));
            }
            if (this.has_group_by()) {
                builder.append(" GROUP BY ");
                builder.append(((ExpressionBuilder.Value)this.groupColumn.get(0)).toString(formatter));
                for (int i = 1; i < this.groupColumn.size(); ++i) {
                    builder.append(", ");
                    builder.append(((ExpressionBuilder.Value)this.groupColumn.get(i)).toString(formatter));
                }
            }
            if (this.has_order_by()) {
                builder.append(" ORDER BY ");
                first = true;
                for (SQLBuilder.OrderByBuilder item : this.order_by) {
                    if (first) {
                        first = false;
                    } else {
                        builder.append(", ");
                    }
                    builder.append(item.toString(formatter));
                }
            }
            if (this.has_limit() && this.has_offset()) {
                builder.append(" OFFSET ");
                builder.append(this.offset);
                builder.append(" FETCH NEXT ");
                builder.append(this.limit);
                builder.append(" ROWS ONLY");
            } else if (this.has_limit()) {
                builder.append(" LIMIT ");
                builder.append(this.limit);
            } else if (this.has_offset()) {
                builder.append(" LIMIT ALL OFFSET ");
                builder.append(this.offset);
            }
            return builder.toString();
        }
    }

    protected class PostgreSQLCreateTableBuilder
    extends SQLBuilderBase.CreateTableBuilderBase {
        protected PostgreSQLCreateTableBuilder() {
            super((SQLBuilderBase)PostgreSQLBuilder.this);
        }

        public List<String> toStrings(Formatter formatter) {
            ArrayList<String> sqls = new ArrayList<String>();
            StringBuilder builder = new StringBuilder();
            builder.append("CREATE TABLE ");
            builder.append(this.table.toString(formatter));
            builder.append(" (");
            boolean first = true;
            for (SQLBuilder.ColumnDescriptor column : this.columns) {
                if (column.isGeometry()) continue;
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append(PostgreSQLBuilder.this.as_identifier(column.getName()));
                builder.append(" ");
                if (column.isAutomatic()) {
                    builder.append(" SERIAL");
                } else {
                    builder.append(PostgreSQLBuilder.this.sqltype(column.getType(), column.getSize(), column.getPrecision(), column.getScale(), column.getGeometryType(), column.getGeometrySubtype()));
                    if (column.getDefaultValue() == null) {
                        if (column.allowNulls()) {
                            builder.append(" DEFAULT NULL");
                        }
                    } else {
                        builder.append(" DEFAULT '");
                        builder.append(column.getDefaultValue().toString());
                        builder.append("'");
                    }
                    if (column.allowNulls()) {
                        builder.append(" NULL");
                    } else {
                        builder.append(" NOT NULL");
                    }
                }
                if (!column.isPrimaryKey()) continue;
                builder.append(" PRIMARY KEY");
            }
            builder.append(" )");
            sqls.add(builder.toString());
            String AddGeometryColumn = "SELECT AddGeometryColumn({0} , {1} , {2}, {3,number,#######} , {4} , {5}, {6})";
            for (SQLBuilder.ColumnDescriptor column : this.columns) {
                if (!column.isGeometry()) continue;
                String sql = MessageFormat.format(AddGeometryColumn, PostgreSQLBuilder.this.as_string(this.table.has_schema() ? this.table.getSchema() : "public"), PostgreSQLBuilder.this.as_string(this.table.getName()), PostgreSQLBuilder.this.as_string(column.getName()), column.getGeometrySRSId(), PostgreSQLBuilder.this.as_string(PostgreSQLBuilder.this.sqlgeometrytype(column.getGeometryType(), column.getGeometrySubtype())), PostgreSQLBuilder.this.as_string(PostgreSQLBuilder.this.sqlgeometrydimension(column.getGeometryType(), column.getGeometrySubtype())), PostgreSQLBuilder.this.as_string(column.allowNulls()));
                sqls.add(sql);
            }
            return sqls;
        }
    }

    protected class PostgreSQLCreateIndexBuilder
    extends SQLBuilderBase.CreateIndexBuilderBase {
        protected PostgreSQLCreateIndexBuilder() {
            super((SQLBuilderBase)PostgreSQLBuilder.this);
        }

        public List<String> toStrings(Formatter formatter) {
            Version version;
            StringBuilder builder = new StringBuilder();
            builder.append("CREATE ");
            builder.append("INDEX ");
            if (this.ifNotExist && (version = PostgreSQLBuilder.this.getDatabaseVersion()).getMajor() >= 9 && version.getMinor() >= 5) {
                builder.append("IF NOT EXISTS ");
            }
            builder.append(PostgreSQLBuilder.this.as_identifier(this.indexName));
            builder.append(" ON ");
            builder.append(this.table.toString(formatter));
            if (this.isSpatial) {
                builder.append(" USING GIST ");
            }
            builder.append(" ( ");
            boolean is_first_column = true;
            for (String column : this.columns) {
                if (is_first_column) {
                    is_first_column = false;
                } else {
                    builder.append(", ");
                }
                builder.append(PostgreSQLBuilder.this.as_identifier(column));
            }
            builder.append(" )");
            ArrayList<String> sqls = new ArrayList<String>();
            sqls.add(builder.toString());
            return sqls;
        }
    }

    public class PostgreSQLUpdateTableStatisticsBuilderBase
    extends SQLBuilderBase.UpdateTableStatisticsBuilderBase {
        public PostgreSQLUpdateTableStatisticsBuilderBase() {
            super((SQLBuilderBase)PostgreSQLBuilder.this);
        }

        public List<String> toStrings() {
            ArrayList<String> sqls = new ArrayList<String>();
            if (!StringUtils.isBlank((CharSequence)PostgreSQLBuilder.this.STMT_UPDATE_TABLE_STATISTICS_table)) {
                String sql;
                String name = PostgreSQLBuilder.this.as_identifier(this.table.getName());
                if (this.table.has_schema()) {
                    name = PostgreSQLBuilder.this.as_identifier(this.table.getSchema()) + "." + name;
                }
                if (!StringUtils.isEmpty((CharSequence)(sql = MessageFormat.format(PostgreSQLBuilder.this.STMT_UPDATE_TABLE_STATISTICS_table, name)))) {
                    sqls.add(sql);
                }
            }
            return sqls;
        }
    }

    public static class Version {
        private final int major;
        private final int minor;

        public Version(int major, int minor) {
            this.major = major;
            this.minor = minor;
        }

        public int getMajor() {
            return this.major;
        }

        public int getMinor() {
            return this.minor;
        }
    }
}

