/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.postgresql.dal.operations;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.cresques.cts.IProjection;
import org.gvsig.expressionevaluator.ExpressionBuilder;
import org.gvsig.expressionevaluator.GeometryExpressionBuilder;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.EditableFeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.EditableFeatureType;
import org.gvsig.fmap.dal.store.jdbc2.JDBCConnection;
import org.gvsig.fmap.dal.store.jdbc2.JDBCHelper;
import org.gvsig.fmap.dal.store.jdbc2.JDBCUtils;
import org.gvsig.fmap.dal.store.jdbc2.OperationsFactory;
import org.gvsig.fmap.dal.store.jdbc2.spi.JDBCSQLBuilderBase;
import org.gvsig.fmap.dal.store.jdbc2.spi.SRSSolver;
import org.gvsig.fmap.dal.store.jdbc2.spi.operations.FetchFeatureTypeOperation;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.geom.type.GeometryType;
import org.gvsig.postgresql.dal.PostgreSQLBuilder;

public class PostgreSQLFetchFeatureTypeOperation
extends FetchFeatureTypeOperation {
    private static Map<String, GeometryType> databaseGeometryTypes = null;

    public PostgreSQLFetchFeatureTypeOperation(JDBCHelper helper) {
        super(helper);
    }

    private GeometryType getGT(GeometryManager manager, int type, int subtype) {
        try {
            return manager.getGeometryType(type, subtype);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public PostgreSQLFetchFeatureTypeOperation(JDBCHelper helper, EditableFeatureType featureType, OperationsFactory.TableReference table, List<String> primaryKeys, String defaultGeometryColumn, IProjection crs, int geometryType, int geometrySubtype) {
        super(helper, featureType, table, primaryKeys, defaultGeometryColumn, crs, geometryType, geometrySubtype);
    }

    public void fetch(JDBCConnection conn) throws DataException {
        super.fetch(conn);
    }

    protected int getDataTypeFromMetadata(ResultSetMetaData rsMetadata, int colIndex) throws SQLException {
        return super.getDataTypeFromMetadata(rsMetadata, colIndex);
    }

    public String getSQLToRetrievePrimaryKeysFromInformationSchema() throws SQLException {
        PostgreSQLBuilder sqlbuilder = (PostgreSQLBuilder)this.createSQLBuilder();
        GeometryExpressionBuilder expbuilder = sqlbuilder.expression();
        String column_COLUMN_NAME = "column_name";
        String column_CONSTRAINT_TYPE = "constraint_type";
        if (sqlbuilder.getDatabaseVersion().getMajor() < 10) {
            column_COLUMN_NAME = "COLUMN_NAME";
            column_CONSTRAINT_TYPE = "CONSTRAINT_TYPE";
        }
        sqlbuilder.select().column().name(column_COLUMN_NAME);
        sqlbuilder.select().column().name(column_CONSTRAINT_TYPE);
        sqlbuilder.select().from().custom("INFORMATION_SCHEMA.table_constraints t_cons inner join INFORMATION_SCHEMA.key_column_usage c on c.constraint_catalog = t_cons.constraint_catalog and c.table_schema = t_cons.table_schema and c.table_name = t_cons.table_name and c.constraint_name = t_cons.constraint_name ");
        sqlbuilder.select().where().set((ExpressionBuilder.Value)expbuilder.like((ExpressionBuilder.Value)expbuilder.custom((Object)"c.TABLE_NAME"), (ExpressionBuilder.Value)expbuilder.constant((Object)this.table.getTable())));
        if (this.table.hasSchema()) {
            sqlbuilder.select().where().and((ExpressionBuilder.Value)expbuilder.like((ExpressionBuilder.Value)expbuilder.custom((Object)"c.TABLE_SCHEMA"), (ExpressionBuilder.Value)expbuilder.constant((Object)this.table.getSchema())));
        }
        sqlbuilder.select().where().and((ExpressionBuilder.Value)expbuilder.eq((ExpressionBuilder.Value)expbuilder.column(column_CONSTRAINT_TYPE), (ExpressionBuilder.Value)expbuilder.constant((Object)"PRIMARY KEY")));
        return sqlbuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fetchGeometryTypeAndSRS(EditableFeatureAttributeDescriptor attr, ResultSetMetaData rsMetadata, int colIndex) {
        if (attr.getType() != 66) {
            return;
        }
        try {
            JDBCSQLBuilderBase sqlbuilder = this.createSQLBuilder();
            GeometryExpressionBuilder expbuilder = sqlbuilder.expression();
            sqlbuilder.select().column().name("f_table_catalog");
            sqlbuilder.select().column().name("f_table_schema");
            sqlbuilder.select().column().name("f_table_name");
            sqlbuilder.select().column().name("f_geometry_column");
            sqlbuilder.select().column().name("coord_dimension");
            sqlbuilder.select().column().name("srid");
            sqlbuilder.select().column().name("type");
            sqlbuilder.select().where().set((ExpressionBuilder.Value)expbuilder.eq((ExpressionBuilder.Value)expbuilder.column("f_table_name"), (ExpressionBuilder.Value)expbuilder.constant((Object)this.getTable().getTable())));
            sqlbuilder.select().where().and((ExpressionBuilder.Value)expbuilder.eq((ExpressionBuilder.Value)expbuilder.column("f_geometry_column"), (ExpressionBuilder.Value)expbuilder.constant((Object)attr.getName())));
            sqlbuilder.select().from().table().name("geometry_columns");
            Statement st = null;
            ResultSet rs = null;
            Integer srsid = null;
            String geometryTypeName = null;
            try {
                st = this.getConnection().createStatement();
                rs = JDBCUtils.executeQuery((Statement)st, (String)sqlbuilder.toString());
                if (rs.next()) {
                    srsid = rs.getInt("srid");
                    geometryTypeName = rs.getString("type");
                }
            }
            catch (Throwable throwable) {
                JDBCUtils.closeQuietly(rs);
                JDBCUtils.closeQuietly((Statement)st);
                throw throwable;
            }
            JDBCUtils.closeQuietly((ResultSet)rs);
            JDBCUtils.closeQuietly((Statement)st);
            if (!StringUtils.isEmpty(geometryTypeName)) {
                GeometryType gt = this.getGeometryTypeFromDatabaseTypeName(geometryTypeName);
                attr.setGeometryType(gt);
            }
            if (srsid != null) {
                SRSSolver srssolver = this.helper.getSRSSolver();
                attr.setSRS(srssolver.getProjection(this.getConnection(), (Object)srsid));
            }
        }
        catch (Exception ex) {
            LOGGER.debug("Can't get geometry type and srs from column '" + attr.getName() + "'.", (Throwable)ex);
        }
    }

    private GeometryType getGeometryTypeFromDatabaseTypeName(String typeName) {
        if (databaseGeometryTypes == null) {
            GeometryManager manager = GeometryLocator.getGeometryManager();
            databaseGeometryTypes = new HashMap<String, GeometryType>();
            databaseGeometryTypes.put("POINT", this.getGT(manager, 1, 0));
            databaseGeometryTypes.put("POINTZ", this.getGT(manager, 1, 1));
            databaseGeometryTypes.put("POINTM", this.getGT(manager, 1, 2));
            databaseGeometryTypes.put("POINTZM", this.getGT(manager, 1, 3));
            databaseGeometryTypes.put("LINESTRING", this.getGT(manager, 18, 0));
            databaseGeometryTypes.put("LINESTRINGZ", this.getGT(manager, 18, 1));
            databaseGeometryTypes.put("LINESTRINGM", this.getGT(manager, 18, 2));
            databaseGeometryTypes.put("LINESTRINGZM", this.getGT(manager, 18, 3));
            databaseGeometryTypes.put("POLYGON", this.getGT(manager, 19, 0));
            databaseGeometryTypes.put("POLYGONZ", this.getGT(manager, 19, 1));
            databaseGeometryTypes.put("POLYGONM", this.getGT(manager, 19, 2));
            databaseGeometryTypes.put("POLYGONZM", this.getGT(manager, 19, 3));
            databaseGeometryTypes.put("MULTIPOINT", this.getGT(manager, 7, 0));
            databaseGeometryTypes.put("MULTIPOINTZ", this.getGT(manager, 7, 1));
            databaseGeometryTypes.put("MULTIPOINTM", this.getGT(manager, 7, 2));
            databaseGeometryTypes.put("MULTIPOINTZM", this.getGT(manager, 7, 3));
            databaseGeometryTypes.put("MULTILINESTRING", this.getGT(manager, 21, 0));
            databaseGeometryTypes.put("MULTILINESTRINGZ", this.getGT(manager, 21, 1));
            databaseGeometryTypes.put("MULTILINESTRINGM", this.getGT(manager, 21, 2));
            databaseGeometryTypes.put("MULTILINESTRINGZM", this.getGT(manager, 21, 3));
            databaseGeometryTypes.put("MULTIPOLYGON", this.getGT(manager, 22, 0));
            databaseGeometryTypes.put("MULTIPOLYGONZ", this.getGT(manager, 22, 1));
            databaseGeometryTypes.put("MULTIPOLYGONM", this.getGT(manager, 22, 2));
            databaseGeometryTypes.put("MULTIPOLYGONZM", this.getGT(manager, 22, 3));
            databaseGeometryTypes.put("GEOMETRY", this.getGT(manager, 0, 0));
            databaseGeometryTypes.put("GEOMETRYZ", this.getGT(manager, 0, 1));
            databaseGeometryTypes.put("GEOMETRYM", this.getGT(manager, 0, 2));
            databaseGeometryTypes.put("GEOMETRYZM", this.getGT(manager, 0, 3));
        }
        return databaseGeometryTypes.get(typeName);
    }
}

