/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.report.lib.impl;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.expressionevaluator.SymbolTable;
import org.gvsig.fmap.dal.feature.FeatureQuery;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.report.lib.api.Report;
import org.gvsig.report.lib.api.ReportBuilder;
import org.gvsig.report.lib.api.ReportConfig;
import org.gvsig.report.lib.api.ReportDataSet;
import org.gvsig.report.lib.api.ReportManager;
import org.gvsig.report.lib.api.ReportServer;
import org.gvsig.report.lib.api.ReportServerConfig;
import org.gvsig.report.lib.api.ReportServices;
import org.gvsig.report.lib.api.ReportViewCapture;
import org.gvsig.report.lib.api.commands.CommandFactory;
import org.gvsig.report.lib.impl.DefaultReport;
import org.gvsig.report.lib.impl.DefaultReportConfig;
import org.gvsig.report.lib.impl.DefaultReportDataSet;
import org.gvsig.report.lib.impl.DefaultReportServer;
import org.gvsig.report.lib.impl.DefaultReportServerConfig;
import org.gvsig.report.lib.impl.DefaultReportViewCapture;
import org.gvsig.report.lib.impl.ReportSymbolTable;
import org.gvsig.report.lib.impl.commands.CaptureViewFactory;
import org.gvsig.report.lib.impl.commands.GetDatasetFactory;
import org.gvsig.report.lib.impl.commands.GetImageFactory;
import org.gvsig.report.lib.impl.commands.HelpFactory;
import org.gvsig.report.lib.impl.commands.ListDatasetsFactory;
import org.gvsig.report.lib.impl.commands.ListViewsFactory;
import org.gvsig.report.lib.impl.reportbuilder.DefaultReportBuilder;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.bookmarksandhistory.Bookmarks;
import org.gvsig.tools.bookmarksandhistory.History;
import org.json.JSONObject;

public class DefaultReportManager
implements ReportManager {
    private ReportServer defaultServer = null;
    private final Map<String, CommandFactory> commandFactories = new LinkedHashMap<String, CommandFactory>();
    private Bookmarks<ReportBuilder> userDefinedReportBookmarks;
    private History<ReportBuilder> userDefinedReportHistory;

    public DefaultReportManager() {
        this.registerCommandFactory((CommandFactory)new CaptureViewFactory());
        this.registerCommandFactory((CommandFactory)new GetDatasetFactory());
        this.registerCommandFactory((CommandFactory)new HelpFactory());
        this.registerCommandFactory((CommandFactory)new ListDatasetsFactory());
        this.registerCommandFactory((CommandFactory)new ListViewsFactory());
        this.registerCommandFactory((CommandFactory)new GetImageFactory());
        this.userDefinedReportBookmarks = ToolsLocator.getBookmarksAndHistoryManager().getBookmarksGroup("ReportManager");
        this.userDefinedReportHistory = ToolsLocator.getBookmarksAndHistoryManager().getHistoryGroup("ReportManager");
    }

    public Collection<CommandFactory> getCommandFactories() {
        return this.commandFactories.values();
    }

    public void registerCommandFactory(CommandFactory factory) {
        this.commandFactories.put(factory.getName(), factory);
    }

    public ReportServer getDefaultServer() {
        return this.defaultServer;
    }

    public void setDefaultServer(ReportServer server) {
        this.defaultServer = server;
    }

    public ReportServer createServer(ReportServerConfig config) {
        DefaultReportServer server = new DefaultReportServer(this, config);
        if (this.defaultServer == null) {
            this.defaultServer = server;
        }
        return server;
    }

    public ReportDataSet createDataSet(ReportServices services, String name, FeatureStore store) {
        return new DefaultReportDataSet(services, name, store);
    }

    public ReportServerConfig createServerConfig(ReportServices services) {
        DefaultReportServerConfig config = new DefaultReportServerConfig(this, services);
        return config;
    }

    public ReportServerConfig createServerConfig(ReportServices services, String jsonConfig) {
        DefaultReportServerConfig config = new DefaultReportServerConfig(this, services);
        if (!StringUtils.isEmpty((CharSequence)jsonConfig)) {
            config.fromJSON(new JSONObject(jsonConfig));
        }
        return config;
    }

    public ReportViewCapture createViewCapture(ReportServerConfig config) {
        return new DefaultReportViewCapture(config);
    }

    public SymbolTable createReportSymbolTable() {
        return new ReportSymbolTable();
    }

    public ReportBuilder createReportBuilder() {
        DefaultReportBuilder r = new DefaultReportBuilder();
        return r;
    }

    public Bookmarks<ReportBuilder> getUserDefinedReportBookmarks() {
        return this.userDefinedReportBookmarks;
    }

    public History<ReportBuilder> getUserDefinedReportHistory() {
        return this.userDefinedReportHistory;
    }

    public void setUserDefinedReportHistory(History<ReportBuilder> history) {
        this.userDefinedReportHistory = history;
    }

    public void setUserDefinedReportBookmarks(Bookmarks<ReportBuilder> userDefinedReportBookmarks) {
        this.userDefinedReportBookmarks = userDefinedReportBookmarks;
    }

    public ReportDataSet createDataSet(FeatureStore store) {
        return new DefaultReportDataSet(this.defaultServer.getServices(), store.getName(), store);
    }

    public ReportDataSet createDataSet(FeatureStore store, FeatureQuery query) {
        return new DefaultReportDataSet(this.defaultServer.getServices(), store.getName(), store, query);
    }

    public Report createReport(ReportConfig config) {
        DefaultReport r = new DefaultReport(config);
        return r;
    }

    public ReportConfig createReportConfig() {
        DefaultReportConfig r = new DefaultReportConfig();
        return r;
    }
}

