/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.report.lib.impl;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.util.JRLoader;
import net.sf.jasperreports.repo.InputStreamResource;
import net.sf.jasperreports.repo.ObjectResource;
import net.sf.jasperreports.repo.Resource;
import net.sf.jasperreports.repo.StreamRepositoryService;
import org.gvsig.report.lib.impl.commands.GetImage;
import org.gvsig.tools.resourcesstorage.ResourcesStorage;

public class ResourcesRepositoryService
implements StreamRepositoryService {
    private final ResourcesStorage resources;
    private final GetImage fetchFromField;

    public ResourcesRepositoryService(ResourcesStorage resources) {
        this.resources = resources;
        this.fetchFromField = new GetImage();
    }

    public InputStream getInputStream(String uri) {
        try {
            InputStream is;
            ResourcesStorage.Resource resource = this.resources.getResource(uri);
            if (resource != null) {
                is = resource.asInputStream();
            } else {
                URL url = new URL(uri);
                if (this.fetchFromField.canUse(url)) {
                    byte[] image = this.fetchFromField.fetch(url);
                    is = new ByteArrayInputStream(image);
                } else {
                    is = url.openStream();
                }
            }
            return is;
        }
        catch (Exception ex) {
            throw new JRRuntimeException((Throwable)ex);
        }
    }

    public OutputStream getOutputStream(String uri) {
        return null;
    }

    public Resource getResource(String uri) {
        try {
            InputStreamResource r;
            ResourcesStorage.Resource resource = this.resources.getResource(uri);
            if (resource != null) {
                GVResourceToJRInputStreamResourceAdapter r2 = new GVResourceToJRInputStreamResourceAdapter(resource);
                return r2;
            }
            URL url = new URL(uri);
            if (this.fetchFromField.canUse(url)) {
                byte[] image = this.fetchFromField.fetch(url);
                r = new ByteArrayToJRInputStreamResourceAdapter(image);
            } else {
                r = new URLToJRInputStreamResourceAdapter(url);
            }
            return r;
        }
        catch (Exception ex) {
            throw new JRRuntimeException((Throwable)ex);
        }
    }

    public void saveResource(String uri, Resource resource) {
    }

    public <K extends Resource> K getResource(String uri, Class<K> resourceType) {
        try {
            InputStream is;
            ObjectResource r = (ObjectResource)resourceType.newInstance();
            r.setName(uri);
            ResourcesStorage.Resource resource = this.resources.getResource(uri);
            if (resource != null && (is = resource.asInputStream()) != null) {
                Object v = JRLoader.loadObject((InputStream)is);
                r.setValue(v);
                return (K)r;
            }
            URL url = new URL(uri);
            if (this.fetchFromField.canUse(url)) {
                byte[] image = this.fetchFromField.fetch(url);
                ByteArrayInputStream is2 = new ByteArrayInputStream(image);
                r.setValue((Object)is2);
            } else {
                r.setValue((Object)url.openStream());
            }
            return (K)r;
        }
        catch (Throwable th) {
            return null;
        }
    }

    private class ByteArrayToJRInputStreamResourceAdapter
    extends InputStreamResource {
        private final byte[] data;

        public ByteArrayToJRInputStreamResourceAdapter(byte[] data) {
            this.data = data;
        }

        public InputStream getValue() {
            ByteArrayInputStream is = new ByteArrayInputStream(this.data);
            return is;
        }
    }

    private class URLToJRInputStreamResourceAdapter
    extends InputStreamResource {
        private final URL url;

        public URLToJRInputStreamResourceAdapter(URL url) {
            this.url = url;
        }

        public InputStream getValue() {
            try {
                return this.url.openStream();
            }
            catch (IOException ex) {
                return null;
            }
        }
    }

    private class GVResourceToJRInputStreamResourceAdapter
    extends InputStreamResource {
        private final ResourcesStorage.Resource resource;

        public GVResourceToJRInputStreamResourceAdapter(ResourcesStorage.Resource resource) {
            this.resource = resource;
        }

        public InputStream getValue() {
            try {
                return this.resource.asInputStream();
            }
            catch (IOException ex) {
                return null;
            }
        }
    }
}

