/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.report.lib.impl.commands;

import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.commons.lang3.mutable.MutableInt;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.report.lib.api.ReportDataSet;
import org.gvsig.report.lib.api.ReportServer;
import org.gvsig.report.lib.api.commands.AbstractCommand;
import org.gvsig.report.lib.api.commands.CommandFactory;
import org.gvsig.tools.exception.BaseException;
import org.gvsig.tools.visitor.VisitCanceledException;
import org.gvsig.tools.visitor.Visitor;
import org.json.JSONArray;
import org.json.JSONObject;

public class GetDataset
extends AbstractCommand {
    public GetDataset(CommandFactory factory, ReportServer server) {
        super(factory, server);
    }

    public Object call(int argc, String[] args) {
        final MutableBoolean withGeom = new MutableBoolean(false);
        final MutableInt limit = new MutableInt(-1);
        String filter = null;
        boolean ascending = true;
        String orderFields = null;
        int n = 1;
        String datasetName = args[n++];
        block12: while (n < args.length) {
            String option;
            switch (option = args[n++].toLowerCase()) {
                case "withgeom": {
                    withGeom.setTrue();
                    continue block12;
                }
                case "limit": {
                    limit.setValue(NumberUtils.toInt((String)args[n++], (int)-1));
                    continue block12;
                }
                case "filter": {
                    filter = args[n++];
                    continue block12;
                }
                case "order": {
                    orderFields = args[n++];
                    ascending = BooleanUtils.toBoolean((String)args[n++].toLowerCase(), (String)"asc", (String)"desc");
                    continue block12;
                }
            }
            throw new IllegalArgumentException("Option '" + option + "' not supported.");
        }
        ReportDataSet dataset = this.getConfig().getDataset(datasetName);
        if (dataset == null) {
            throw new IllegalArgumentException("Dataset '" + datasetName + "' not exists.");
        }
        final MutableInt count = new MutableInt(0);
        final JSONArray json = new JSONArray();
        dataset.accept(new Visitor(){

            public void visit(Object o) throws VisitCanceledException, BaseException {
                Feature f = (Feature)o;
                JSONObject fjson = new JSONObject();
                FeatureType ft = f.getType();
                for (FeatureAttributeDescriptor desc : ft) {
                    if (desc.isComputed()) continue;
                    if (desc.getType() == 66) {
                        if (withGeom.isTrue()) {
                            fjson.put(desc.getName(), (Object)f.getGeometry(desc.getIndex()).convertToWKT());
                        }
                    } else {
                        switch (desc.getType()) {
                            case 1: {
                                fjson.put(desc.getName(), f.getBoolean(desc.getIndex()));
                                break;
                            }
                            case 2: {
                                fjson.put(desc.getName(), (int)f.getByte(desc.getIndex()));
                                break;
                            }
                            case 4: {
                                fjson.put(desc.getName(), f.getInt(desc.getIndex()));
                                break;
                            }
                            case 5: {
                                fjson.put(desc.getName(), f.getLong(desc.getIndex()));
                                break;
                            }
                            case 7: {
                                fjson.put(desc.getName(), f.getDouble(desc.getIndex()));
                                break;
                            }
                            case 6: {
                                fjson.put(desc.getName(), f.getFloat(desc.getIndex()));
                                break;
                            }
                            case 9: {
                                fjson.put(desc.getName(), (Object)f.getDate(desc.getIndex()));
                                break;
                            }
                            default: {
                                fjson.put(desc.getName(), f.get(desc.getIndex()));
                            }
                        }
                    }
                    if (desc.getAvailableValues() == null) continue;
                    fjson.put(desc.getName() + "@label", (Object)f.getLabelOfValue(desc.getName()));
                }
                json.put((Object)fjson);
                count.increment();
                if (limit.intValue() > 0 && count.intValue() >= limit.intValue()) {
                    throw new VisitCanceledException();
                }
            }
        }, filter, orderFields, ascending);
        return json.toString();
    }
}

