/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.impl.buffer.cache;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import org.gvsig.fmap.dal.coverage.RasterLocator;
import org.gvsig.fmap.dal.coverage.dataset.Buffer;
import org.gvsig.fmap.dal.coverage.datastruct.Extent;
import org.gvsig.fmap.dal.coverage.exception.ProcessInterruptedException;
import org.gvsig.fmap.dal.coverage.exception.QueryException;
import org.gvsig.fmap.dal.coverage.exception.RasterDriverException;
import org.gvsig.fmap.dal.coverage.store.RasterQuery;
import org.gvsig.raster.impl.buffer.SpiRasterQuery;
import org.gvsig.raster.impl.buffer.cache.ICacheDataSource;
import org.gvsig.raster.impl.buffer.cache.PageBandBuffer;
import org.gvsig.raster.impl.provider.AbstractRasterProvider;
import org.gvsig.raster.impl.provider.RasterProvider;
import org.gvsig.raster.impl.store.DefaultRasterStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheDataFromDriverServer
implements ICacheDataSource {
    private Logger log = LoggerFactory.getLogger(CacheDataFromDriverServer.class);
    private AbstractRasterProvider provider = null;
    private Extent pageExtent = null;

    public CacheDataFromDriverServer(RasterProvider provider, int numPag, Extent extent) {
        if (provider instanceof AbstractRasterProvider) {
            this.provider = (AbstractRasterProvider)provider;
        }
        this.pageExtent = extent;
    }

    @Override
    public void loadPage(PageBandBuffer pageBuffer) throws ProcessInterruptedException {
        try {
            DefaultRasterStore store = new DefaultRasterStore();
            store.setProvider(this.provider);
            RasterQuery q = RasterLocator.getManager().createQuery();
            q.setAreaOfInterest(this.pageExtent, pageBuffer.getWidth(), pageBuffer.getHeight());
            q.setAllDrawableBands();
            q.setBufferForProviders((Buffer)pageBuffer);
            this.provider.getDataSet((SpiRasterQuery)q);
        }
        catch (RasterDriverException e) {
            this.log.debug("Error loading the PageBandBuffer", (Throwable)e);
        }
        catch (QueryException e) {
            this.log.debug("Error loading the PageBandBuffer", (Throwable)e);
        }
    }

    @Override
    public void savePage(PageBandBuffer pageBuffer) throws IOException {
    }

    @Override
    public void delete() {
    }

    @Override
    public String getPath() {
        if (this.provider != null) {
            URI uriOfFirstProvider = this.provider.getURIOfFirstProvider();
            if ("FILE".equalsIgnoreCase(uriOfFirstProvider.getScheme())) {
                return new File(uriOfFirstProvider).getAbsolutePath();
            }
            return uriOfFirstProvider.getPath();
        }
        return null;
    }
}

