/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.impl.buffer.cache;

import org.gvsig.fmap.dal.coverage.dataset.Buffer;
import org.gvsig.fmap.dal.coverage.store.DataServerWriter;

public class WriterBufferCompleteServer
implements DataServerWriter {
    private Buffer buffer = null;
    private int nband = -1;

    public WriterBufferCompleteServer(Buffer buffer) {
        this.buffer = buffer;
    }

    public int[] readARGBData(int sizeX, int sizeY, int nBand) {
        return null;
    }

    public byte[][] readByteData(int sizeX, int sizeY) {
        int len = this.buffer.getWidth() * this.buffer.getHeight();
        byte[][] b = new byte[this.buffer.getBandCount()][len];
        int init = 0;
        int end = this.buffer.getBandCount();
        if (this.nband >= 0) {
            init = this.nband;
            end = this.nband + 1;
        }
        for (int iBand = init; iBand < end; ++iBand) {
            for (int j = 0; j < this.buffer.getHeight(); ++j) {
                for (int i = 0; i < this.buffer.getWidth(); ++i) {
                    b[iBand][j * this.buffer.getWidth() + i] = this.buffer.getElemByte(j, i, iBand);
                }
            }
        }
        return b;
    }

    public short[][] readShortData(int sizeX, int sizeY) {
        int len = this.buffer.getWidth() * this.buffer.getHeight();
        short[][] b = new short[this.buffer.getBandCount()][len];
        int init = 0;
        int end = this.buffer.getBandCount();
        if (this.nband >= 0) {
            init = this.nband;
            end = this.nband + 1;
        }
        for (int iBand = init; iBand < end; ++iBand) {
            for (int j = 0; j < this.buffer.getHeight(); ++j) {
                for (int i = 0; i < this.buffer.getWidth(); ++i) {
                    b[iBand][j * this.buffer.getWidth() + i] = this.buffer.getElemShort(j, i, iBand);
                }
            }
        }
        return b;
    }

    public int[][] readIntData(int sizeX, int sizeY) {
        int len = this.buffer.getWidth() * this.buffer.getHeight();
        int[][] b = new int[this.buffer.getBandCount()][len];
        int init = 0;
        int end = this.buffer.getBandCount();
        if (this.nband >= 0) {
            init = this.nband;
            end = this.nband + 1;
        }
        for (int iBand = init; iBand < end; ++iBand) {
            for (int j = 0; j < this.buffer.getHeight(); ++j) {
                for (int i = 0; i < this.buffer.getWidth(); ++i) {
                    b[iBand][j * this.buffer.getWidth() + i] = this.buffer.getElemInt(j, i, iBand);
                }
            }
        }
        return b;
    }

    public float[][] readFloatData(int sizeX, int sizeY) {
        int len = this.buffer.getWidth() * this.buffer.getHeight();
        float[][] b = new float[this.buffer.getBandCount()][len];
        int init = 0;
        int end = this.buffer.getBandCount();
        if (this.nband >= 0) {
            init = this.nband;
            end = this.nband + 1;
        }
        for (int iBand = init; iBand < end; ++iBand) {
            for (int j = 0; j < this.buffer.getHeight(); ++j) {
                for (int i = 0; i < this.buffer.getWidth(); ++i) {
                    b[iBand][j * this.buffer.getWidth() + i] = this.buffer.getElemFloat(j, i, iBand);
                }
            }
        }
        return b;
    }

    public double[][] readDoubleData(int sizeX, int sizeY) {
        int len = this.buffer.getWidth() * this.buffer.getHeight();
        double[][] b = new double[this.buffer.getBandCount()][len];
        int init = 0;
        int end = this.buffer.getBandCount();
        if (this.nband >= 0) {
            init = this.nband;
            end = this.nband + 1;
        }
        for (int iBand = init; iBand < end; ++iBand) {
            for (int j = 0; j < this.buffer.getHeight(); ++j) {
                for (int i = 0; i < this.buffer.getWidth(); ++i) {
                    b[iBand][j * this.buffer.getWidth() + i] = this.buffer.getElemDouble(j, i, iBand);
                }
            }
        }
        return b;
    }

    public void setBuffer(Buffer buffer, int nband) {
        this.buffer = buffer;
        this.nband = nband;
    }

    public Buffer getBuffer() {
        return this.buffer;
    }

    public void setBand(int nband) {
        this.nband = nband;
    }

    public int getPercent() {
        return 0;
    }

    public void setAlphaBuffer(Buffer alphaBuffer) {
    }

    public void dispose() {
    }

    public Buffer getSource() {
        return this.buffer;
    }

    public void setPercent(int value) {
    }
}

