/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.impl.datastruct;

import org.gvsig.fmap.dal.coverage.RasterLibrary;
import org.gvsig.fmap.dal.coverage.datastruct.BufferHistogram;
import org.gvsig.fmap.dal.coverage.datastruct.HistogramClass;
import org.gvsig.fmap.dal.coverage.datastruct.NoData;
import org.gvsig.raster.impl.datastruct.HistogramClassImpl;
import org.slf4j.LoggerFactory;

public class BufferHistogramImpl
implements BufferHistogram {
    private HistogramClass[][] histogram = null;
    private long[][] table = null;
    private double[] min = null;
    private double[] max = null;
    private NoData noDataValue = null;
    private int dataType = 32;
    private int nClasses = 0;

    public BufferHistogramImpl(int nBands, int nClasses, double[] min, double[] max) {
        if (nBands != min.length || nBands != max.length) {
            System.out.println("No tiene las mismas bandas");
        }
        this.constructorHistogramImpl(min, max, nClasses);
    }

    private void constructorHistogramImpl(double[] min, double[] max, int nClasses) {
        this.table = new long[min.length][nClasses];
        for (int i = 0; i < this.table.length; ++i) {
            for (int j = 0; j < this.table[0].length; ++j) {
                this.table[i][j] = 0L;
            }
        }
        this.min = (double[])min.clone();
        this.max = (double[])max.clone();
        this.nClasses = this.getNumValues();
    }

    public BufferHistogramImpl(int nBands, double[] min, double[] max, int dataType) {
        int numberClasses;
        this.dataType = dataType;
        this.min = (double[])min.clone();
        this.max = (double[])max.clone();
        if (dataType == 0) {
            int i;
            numberClasses = RasterLibrary.defaultNumberOfColors;
            boolean unsigned = false;
            for (i = 0; i < this.min.length; ++i) {
                if (!(this.min[i] < 0.0)) continue;
                unsigned = true;
            }
            for (i = 0; i < this.min.length; ++i) {
                if (unsigned) {
                    this.min[i] = -128.0;
                    this.max[i] = 127.0;
                    continue;
                }
                this.min[i] = 0.0;
                this.max[i] = 255.0;
            }
        } else {
            numberClasses = RasterLibrary.defaultNumberOfClasses;
        }
        this.constructorHistogramImpl(this.min, this.max, numberClasses);
    }

    public boolean union(BufferHistogram hist) {
        long[][] auxTable = hist.getTable();
        if (auxTable.length != this.table.length) {
            return false;
        }
        if (auxTable.length == 0) {
            return true;
        }
        if (auxTable[0].length != this.table[0].length) {
            return false;
        }
        for (int i = 0; i < this.table.length; ++i) {
            for (int j = 0; j < this.table[i].length; ++j) {
                long[] lArray = this.table[i];
                int n = j;
                lArray[n] = lArray[n] + auxTable[i][j];
            }
        }
        return true;
    }

    public void setTable(long[][] t) {
        this.table = new long[t.length][t[0].length];
        for (int i = 0; i < this.table.length; ++i) {
            for (int j = 0; j < this.table[0].length; ++j) {
                this.table[i][j] = t[i][j];
            }
        }
        this.nClasses = this.getNumValues();
    }

    public double getMin(int band) {
        return this.min[band];
    }

    public double getMax(int band) {
        return this.max[band];
    }

    public double[] getMinims() {
        return this.min;
    }

    public double[] getMaxims() {
        return this.max;
    }

    public boolean isInRangeRGB() {
        if (this.dataType == 0) {
            return true;
        }
        return true;
    }

    public HistogramClass[][] getHistogram() {
        if (this.nClasses == 0) {
            return null;
        }
        this.histogram = new HistogramClass[this.table.length][this.nClasses];
        for (int i = 0; i < this.table.length; ++i) {
            for (int j = 0; j < this.table[i].length; ++j) {
                HistogramClassImpl hc = new HistogramClassImpl(this.min[i] + (double)j * (this.max[i] - this.min[i]) / (double)(this.nClasses - 1), this.min[i] + (double)(j + 1) * (this.max[i] - this.min[i]) / (double)(this.nClasses - 1));
                hc.setValue(this.table[i][j]);
                this.histogram[i][j] = hc;
            }
        }
        return this.histogram;
    }

    public int getNumBands() {
        if (this.table != null) {
            return this.table.length;
        }
        return 0;
    }

    public int getDataType() {
        return this.dataType;
    }

    public int getBandLenght(int band) {
        if (this.table != null) {
            return this.table[band].length;
        }
        return 0;
    }

    public int getNumValues() {
        if (this.table == null) {
            return 0;
        }
        if (this.table.length == 0) {
            return 0;
        }
        return this.table[0].length;
    }

    public void setHistogram(HistogramClass[][] hist) {
        this.histogram = hist;
    }

    public void setHistogramValue(int band, double px, long value) {
        int pos = (int)((double)(this.nClasses - 1) * (px - this.min[band]) / (this.max[band] - this.min[band]));
        if (pos < 0) {
            pos = 0;
        }
        if (pos >= this.nClasses) {
            pos = this.nClasses - 1;
        }
        this.table[band][pos] = value;
    }

    public void setHistogramValueByPos(int band, int pos, long value) {
        if (pos < 0) {
            pos = 0;
        }
        if (pos >= this.nClasses) {
            pos = this.nClasses - 1;
        }
        this.table[band][pos] = value;
    }

    public double getHistogramValue(int band, double px) {
        if (this.histogram == null) {
            this.getHistogram();
        }
        for (int i = 0; i < this.histogram[band].length; ++i) {
            if (!this.histogram[band][i].isIn(px)) continue;
            return this.histogram[band][i].getValue();
        }
        return 0.0;
    }

    public double getHistogramValueByPos(int band, int pos) {
        if (pos < 0) {
            pos = 0;
        }
        if (pos >= this.nClasses) {
            pos = this.nClasses - 1;
        }
        return this.table[band][pos];
    }

    public void incrementPxValue(int band, double px) {
        int pos;
        if (Double.isNaN(px)) {
            return;
        }
        if (this.noDataValue != null && this.noDataValue.isDefined()) {
            switch (this.dataType) {
                case 0: {
                    if ((byte)px != this.noDataValue.getValue().byteValue()) break;
                    return;
                }
                case 2: {
                    if ((short)px != this.noDataValue.getValue().shortValue()) break;
                    return;
                }
                case 3: {
                    if ((int)px != this.noDataValue.getValue().intValue()) break;
                    return;
                }
                case 4: {
                    if ((float)px != this.noDataValue.getValue().floatValue()) break;
                    return;
                }
                case 5: {
                    if (px != this.noDataValue.getValue().doubleValue()) break;
                    return;
                }
            }
        }
        if ((pos = (int)((double)(this.nClasses - 1) * (px - this.min[band]) / (this.max[band] - this.min[band]))) < 0) {
            pos = 0;
        }
        if (pos >= this.nClasses) {
            pos = this.nClasses - 1;
        }
        long[] lArray = this.table[band];
        int n = pos;
        lArray[n] = lArray[n] + 1L;
    }

    public double[][] getBasicStats(boolean[] bands) {
        if (this.histogram == null) {
            return null;
        }
        return this.getBasicStats(0.0, this.histogram[0].length - 1, bands);
    }

    public double[][] getBasicStats(double beginPos2, double endPos2, boolean[] bands) {
        if (this.histogram == null) {
            this.getHistogram();
        }
        int beginPos = (int)(beginPos2 * (double)(this.nClasses - 1) / 100.0);
        int endPos = (int)(endPos2 * (double)(this.nClasses - 1) / 100.0);
        int bandCount = 0;
        for (int iBand = 0; iBand < bands.length; ++iBand) {
            if (!bands[iBand]) continue;
            ++bandCount;
        }
        double[][] res = new double[5][];
        double[] average = new double[bandCount];
        double[] middle = new double[bandCount];
        double[] nPixelsBand = new double[bandCount];
        int showBandCounter = 0;
        for (int iBand = 0; iBand < this.histogram.length; ++iBand) {
            if (!bands[iBand]) continue;
            for (int i = beginPos; i <= endPos; ++i) {
                int n = showBandCounter;
                nPixelsBand[n] = nPixelsBand[n] + this.histogram[iBand][i].getValue();
                int n2 = showBandCounter;
                average[n2] = average[n2] + this.histogram[iBand][i].getValue() * ((this.histogram[iBand][i].getMax() + this.histogram[iBand][i].getMin()) / 2.0);
            }
            try {
                int n = showBandCounter;
                average[n] = average[n] / nPixelsBand[showBandCounter];
            }
            catch (ArithmeticException exc) {
                average[showBandCounter] = 0.0;
            }
            double stopPos = nPixelsBand[showBandCounter] / 2.0;
            double aux = 0.0;
            int i = beginPos;
            for (i = beginPos; aux <= stopPos && i < this.histogram[iBand].length; ++i) {
                try {
                    aux += this.histogram[iBand][i].getValue();
                    continue;
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    LoggerFactory.getLogger((String)this.getClass().getName()).debug("Acceso a un valor de histogram (Banda: " + iBand + " Posici\u00f3n: " + i + ") fuera de l\u00edmites. (NBandas: " + this.histogram.length + " Valores:" + this.histogram[iBand].length + ")", (Throwable)e);
                }
            }
            middle[showBandCounter] = (this.histogram[iBand][i - 1].getMax() + this.histogram[iBand][i - 1].getMin()) / 2.0;
            ++showBandCounter;
        }
        res[0] = this.min;
        res[1] = this.max;
        res[2] = average;
        res[3] = middle;
        res[4] = nPixelsBand;
        return res;
    }

    public long[][] getTable() {
        return this.table;
    }

    public void addTable(long[][] table) {
        int i;
        if (this.table == null) {
            this.table = table;
            return;
        }
        long[][] newTable = new long[this.table.length + ((long[][])table).length][];
        for (i = 0; i < this.table.length; ++i) {
            newTable[i] = this.table[i];
        }
        for (i = this.table.length; i < this.table.length + ((long[][])table).length; ++i) {
            newTable[i] = table[i];
        }
        table = newTable;
    }

    public static double[][] convertToNormalizeHistogram(long[][] tableToConvert) {
        long[] nValues = new long[tableToConvert.length];
        for (int i = 0; i < tableToConvert.length; ++i) {
            for (int j = 0; j < tableToConvert[i].length; ++j) {
                int n = i;
                nValues[n] = nValues[n] + tableToConvert[i][j];
            }
        }
        double[][] res = new double[tableToConvert.length][tableToConvert[0].length];
        for (int i = 0; i < tableToConvert.length; ++i) {
            for (int j = 0; j < tableToConvert[i].length; ++j) {
                res[i][j] = (double)tableToConvert[i][j] / (double)nValues[i];
            }
        }
        return res;
    }

    public static double[][] convertTableToNormalizeAccumulate(long[][] tableToConvert) {
        double[][] res = BufferHistogramImpl.convertToNormalizeHistogram(tableToConvert);
        for (int i = 0; i < tableToConvert.length; ++i) {
            for (int j = 0; j < tableToConvert[i].length; ++j) {
                if (j <= 0) continue;
                double[] dArray = res[i];
                int n = j;
                dArray[n] = dArray[n] + res[i][j - 1];
            }
        }
        return res;
    }

    public long[][] getNegativeTable() {
        long[][] tableNeg = new long[this.table.length][this.table[0].length];
        for (int i = 0; i < tableNeg.length; ++i) {
            for (int j = 0; j < tableNeg[i].length; ++j) {
                tableNeg[i][this.table[i].length - j - 1] = this.table[i][j];
            }
        }
        return tableNeg;
    }

    public static BufferHistogram convertHistogramToRGB(BufferHistogram histogram) {
        int j;
        int i;
        if (histogram == null) {
            return null;
        }
        if (histogram.getDataType() != 0) {
            return histogram;
        }
        double min = histogram.getMin(0);
        double max = histogram.getMax(0);
        long[][] table2 = histogram.getTable();
        long[][] newTable = new long[table2.length][table2[0].length];
        for (i = 0; i < table2.length; ++i) {
            for (j = 0; j < table2[i].length; ++j) {
                newTable[i][j] = 0L;
            }
        }
        for (i = 0; i < table2.length; ++i) {
            for (j = 0; j < table2[i].length; ++j) {
                double val = (double)j * (max - min) / 255.0 + min;
                int pos = (int)val & 0xFF;
                if (pos < 0) {
                    pos = 0;
                }
                if (pos >= newTable[i].length) {
                    pos = newTable[i].length - 1;
                }
                long[] lArray = newTable[i];
                int n = pos;
                lArray[n] = lArray[n] + table2[i][j];
            }
        }
        double[] mins = new double[histogram.getNumBands()];
        double[] maxs = new double[histogram.getNumBands()];
        for (int i2 = 0; i2 < mins.length; ++i2) {
            mins[i2] = 0.0;
            maxs[i2] = 255.0;
        }
        BufferHistogramImpl histogramNew = new BufferHistogramImpl(histogram.getNumBands(), mins, maxs, 0);
        histogramNew.setTable(newTable);
        return histogramNew;
    }

    public void setNoDataValue(NoData noDataValue) {
        this.noDataValue = noDataValue;
    }
}

