/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.impl.datastruct;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import org.gvsig.fmap.dal.coverage.datastruct.DatasetBand;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DynStruct;
import org.gvsig.tools.persistence.PersistenceManager;
import org.gvsig.tools.persistence.PersistentState;
import org.gvsig.tools.persistence.exception.PersistenceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatasetBandImpl
implements DatasetBand {
    public static final String PERSISTENT_NAME = "DatasetBand_Persistent";
    public static final String PERSISTENT_DESCRIPTION = "DatasetBand Persistent";
    private final Logger logger = LoggerFactory.getLogger(DatasetBandImpl.class);
    private String fileName = "";
    private List<String> additionalName = new ArrayList<String>();
    private int position = -1;
    private int dataType = 0;
    private int[] rasterBufBandToDrawList = null;
    private int nBandsInThisProvider = 0;

    public DatasetBandImpl() {
    }

    public DatasetBandImpl(String fileName, int position, int dataType, int nBands) {
        this.setFileName(fileName);
        this.setPosition(position);
        this.setDataType(dataType);
        this.nBandsInThisProvider = nBands;
    }

    public DatasetBandImpl(URI uri, int position, int dataType, int nBands) {
        this.setFileName(new File(uri).getAbsolutePath());
        this.setPosition(position);
        this.setDataType(dataType);
        this.nBandsInThisProvider = nBands;
    }

    public Object clone() {
        DatasetBandImpl result = new DatasetBandImpl(this.fileName, this.position, this.dataType, this.nBandsInThisProvider);
        if (this.rasterBufBandToDrawList != null) {
            int[] drawBands = new int[this.rasterBufBandToDrawList.length];
            for (int i = 0; i < this.rasterBufBandToDrawList.length; ++i) {
                drawBands[i] = this.rasterBufBandToDrawList[i];
            }
            result.rasterBufBandToDrawList = drawBands;
        }
        return result;
    }

    public void clearDrawableBands() {
        this.rasterBufBandToDrawList = null;
    }

    public int[] getBufferBandListToDraw() {
        return this.rasterBufBandToDrawList;
    }

    public int[] getLocalBufferBandListToDraw() {
        return this.rasterBufBandToDrawList;
    }

    public boolean isDrawing() {
        return this.rasterBufBandToDrawList != null;
    }

    public void addPositionToDrawInBuffer(int rasterBufBandToDraw) {
        if (this.rasterBufBandToDrawList == null) {
            this.rasterBufBandToDrawList = new int[1];
            this.rasterBufBandToDrawList[0] = rasterBufBandToDraw;
        } else {
            int[] auxList = new int[this.rasterBufBandToDrawList.length + 1];
            for (int i = 0; i < this.rasterBufBandToDrawList.length; ++i) {
                auxList[i] = this.rasterBufBandToDrawList[i];
            }
            auxList[this.rasterBufBandToDrawList.length] = rasterBufBandToDraw;
            this.rasterBufBandToDrawList = auxList;
        }
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public int getPosition() {
        return this.position;
    }

    public void setPosition(int position) {
        this.position = position;
    }

    public int getDataType() {
        return this.dataType;
    }

    public void setDataType(int dataType) {
        this.dataType = dataType;
    }

    public void setAdditionalName(String fileName) {
        this.additionalName.add(fileName);
    }

    public String[] getAdditionalName() {
        return (String[])this.additionalName.toArray();
    }

    public void loadFromState(PersistentState state) throws PersistenceException {
        List aux = state.getList("additionalName");
        this.additionalName = new ArrayList<String>();
        this.additionalName.addAll(aux);
        try {
            URI uri = state.getURI("fileName");
            if (uri != null) {
                this.fileName = uri.toString();
                if (uri.getScheme() != null && "FILE".equalsIgnoreCase(uri.getScheme())) {
                    File file = new File(uri);
                    this.fileName = file.isFile() && file.exists() ? file.getAbsolutePath() : uri.getPath();
                }
            }
        }
        catch (ClassCastException e) {
            this.fileName = state.getString("fileName");
        }
        this.position = state.getInt("position");
        this.dataType = state.getInt("dataType");
        this.nBandsInThisProvider = state.getInt("nBandsInThisProvider");
        this.rasterBufBandToDrawList = state.getIntArray("rasterBufBandToDrawList");
    }

    public void saveToState(PersistentState state) throws PersistenceException {
        try {
            File file = new File(this.fileName);
            if (file.exists()) {
                state.set("fileName", file.toURI());
            } else {
                state.set("fileName", new URI(this.fileName));
            }
        }
        catch (URISyntaxException e) {
            this.logger.debug("Error saving the URI " + this.fileName);
        }
        state.set("position", this.position);
        state.set("dataType", this.dataType);
        state.set("nBandsInThisProvider", this.nBandsInThisProvider);
        state.set("additionalName", this.additionalName);
        state.set("rasterBufBandToDrawList", this.rasterBufBandToDrawList);
    }

    public static void registerPersistence() {
        PersistenceManager manager = ToolsLocator.getPersistenceManager();
        DynStruct definition = manager.getDefinition(PERSISTENT_NAME);
        if (definition == null) {
            definition = manager.addDefinition(DatasetBandImpl.class, PERSISTENT_NAME, PERSISTENT_DESCRIPTION, null, null);
            definition.addDynFieldURI("fileName").setMandatory(false);
            definition.addDynFieldInt("position").setMandatory(false);
            definition.addDynFieldList("additionalName").setClassOfItems(String.class).setMandatory(false);
            definition.addDynFieldList("rasterBufBandToDrawList").setClassOfItems(Integer.TYPE).setMandatory(false);
            definition.addDynFieldInt("dataType").setMandatory(false);
            definition.addDynFieldInt("nBandsInThisProvider").setMandatory(false);
        }
    }
}

