/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.impl.datastruct;

import org.gvsig.fmap.dal.coverage.datastruct.Stretch;
import org.gvsig.fmap.dal.coverage.store.props.Statistics;

public class DefaultStretch
implements Stretch {
    public double[] stretchIn = null;
    public int[] stretchOut = null;
    public double tailTrimMin = 0.0;
    public double tailTrimMax = 0.0;
    public double tailTrimValueMin = 0.0;
    public double tailTrimValueMax = 0.0;
    public double[] scale = null;
    public double[] offset = null;
    public double maxValue = 0.0;
    public double minValue = 0.0;
    public int functionType = 0;
    public double valueFunction = 0.0;

    public void applyTrimToStretchs() {
        if (this.stretchIn != null && this.stretchIn.length >= 2) {
            this.minValue = this.stretchIn[0] = this.tailTrimValueMin;
            double d = this.tailTrimValueMax;
            this.stretchIn[this.stretchIn.length - 1] = d;
            this.maxValue = d;
        }
    }

    public boolean hasTailTrim() {
        return this.tailTrimMin != 0.0 || this.tailTrimMax != 0.0;
    }

    public void calcLinearScaleAndOffset() {
        if (this.stretchIn != null && this.stretchOut != null) {
            this.scale = new double[this.stretchIn.length - 1];
            this.offset = new double[this.stretchIn.length - 1];
            for (int i = 0; i < this.scale.length; ++i) {
                double rgbRange = this.stretchOut[i + 1] - this.stretchOut[i];
                this.scale[i] = this.stretchIn[i + 1] - this.stretchIn[i] == 0.0 ? 0.0 : rgbRange / (this.stretchIn[i + 1] - this.stretchIn[i]);
                this.offset[i] = this.stretchOut[i];
            }
        }
    }

    public void setMaxMin(Statistics stats, int band, boolean rgb) {
        try {
            if (rgb) {
                if (stats.getMinByteUnsigned() != null) {
                    this.minValue = stats.getMinByteUnsigned()[band];
                }
                if (stats.getMaxByteUnsigned() != null) {
                    this.maxValue = stats.getMaxByteUnsigned()[band];
                }
            } else {
                if (stats.getMin() != null) {
                    this.minValue = stats.getMin()[band];
                }
                if (stats.getMax() != null) {
                    this.maxValue = stats.getMax()[band];
                }
            }
            if (this.stretchIn == null) {
                this.stretchIn = new double[]{this.minValue, this.maxValue};
            } else {
                this.stretchIn[0] = this.minValue;
                this.stretchIn[this.stretchIn.length - 1] = this.maxValue;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
    }

    public void applyRemoveEndsToStretchs(Statistics stats, boolean rgb, int band) {
        if (this.stretchIn == null) {
            return;
        }
        try {
            if (rgb) {
                if (stats.getSecondMinByteUnsigned() != null) {
                    this.stretchIn[0] = this.minValue = stats.getSecondMinByteUnsigned()[band];
                }
                if (stats.getSecondMaxByteUnsigned() != null) {
                    this.stretchIn[this.stretchIn.length - 1] = this.maxValue = stats.getSecondMaxByteUnsigned()[band];
                }
            } else {
                if (stats.getSecondMin() != null) {
                    this.stretchIn[0] = this.minValue = stats.getSecondMin()[band];
                }
                if (stats.getMax() != null) {
                    this.stretchIn[this.stretchIn.length - 1] = this.maxValue = stats.getSecondMax()[band];
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
    }

    public double[] getOffset() {
        return this.offset;
    }

    public double getMaxValue() {
        return this.maxValue;
    }

    public double getMinValue() {
        return this.minValue;
    }

    public int getFunctionType() {
        return this.functionType;
    }

    public double[] getStretchIn() {
        return this.stretchIn;
    }

    public int[] getStretchOut() {
        return this.stretchOut;
    }

    public double getValueFunction() {
        return this.valueFunction;
    }
}

