/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.impl.datastruct.serializer;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import org.gvsig.fmap.dal.coverage.datastruct.BufferHistogram;
import org.gvsig.fmap.dal.coverage.datastruct.HistogramClass;
import org.gvsig.fmap.dal.coverage.exception.ParsingException;
import org.gvsig.raster.impl.datastruct.BufferHistogramImpl;
import org.gvsig.raster.impl.store.rmf.ClassSerializer;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.extensionpoint.ExtensionPoint;
import org.gvsig.tools.extensionpoint.ExtensionPointManager;
import org.kxml2.io.KXmlParser;
import org.xmlpull.v1.XmlPullParserException;

public class HistogramRmfSerializer
extends ClassSerializer {
    public static final String MAIN_TAG = "Histogram";
    public static final String MIN = "Min";
    public static final String MAX = "Max";
    public static final String BAND = "Band";
    public static final String VALUES = "Values";
    public static final String BAND_COUNT = "BandCount";
    public static final String DATA_TYPE = "DataType";
    private BufferHistogram histogram = null;

    public static void register() {
        ExtensionPointManager extensionPoints = ToolsLocator.getExtensionPointManager();
        ExtensionPoint point = extensionPoints.get("Serializer");
        point.append(MAIN_TAG, "", HistogramRmfSerializer.class);
    }

    public HistogramRmfSerializer(BufferHistogram hist) {
        this.histogram = hist;
    }

    public HistogramRmfSerializer() {
    }

    private long[] parseLongList(String list) throws XmlPullParserException, IOException {
        String[] sValues = list.split(" ");
        long[] dValues = new long[sValues.length];
        for (int i = 0; i < sValues.length; ++i) {
            dValues[i] = Long.parseLong(sValues[i]);
        }
        return dValues;
    }

    private long[] parserHistogramListValues(KXmlParser parser) throws XmlPullParserException, IOException {
        long[] valueList = null;
        boolean end = false;
        boolean tagOk = false;
        int tag = parser.next();
        while (!end) {
            switch (tag) {
                case 2: {
                    if (parser.getName() == null || parser.getName().compareTo(VALUES) != 0) break;
                    tagOk = true;
                    break;
                }
                case 3: {
                    if (parser.getName().compareTo(BAND) != 0) break;
                    end = true;
                    break;
                }
                case 4: {
                    if (!tagOk) break;
                    valueList = this.parseLongList(parser.getText());
                    tagOk = false;
                }
            }
            if (end) continue;
            tag = parser.next();
        }
        return valueList;
    }

    @Override
    public void read(String xml) throws ParsingException {
        double min = 0.0;
        double max = 0.0;
        int numBands = 0;
        int dataType = 0;
        Object values = null;
        KXmlParser parser = new KXmlParser();
        StringReader reader = new StringReader(xml);
        try {
            parser.setInput((Reader)reader);
        }
        catch (XmlPullParserException e) {
            throw new ParsingException(xml);
        }
        try {
            int tag = parser.nextTag();
            if (parser.getEventType() != 1) {
                parser.require(2, null, MAIN_TAG);
                while (tag != 1) {
                    switch (tag) {
                        case 2: {
                            if (parser.getName() == null || parser.getName().compareTo(MAIN_TAG) != 0) break;
                            numBands = (int)Double.parseDouble(this.parserString(parser, BAND_COUNT, null));
                            dataType = Integer.parseInt(this.parserString(parser, DATA_TYPE, null));
                            values = new long[numBands][];
                            for (int iBand = 0; iBand < numBands; ++iBand) {
                                min = Double.parseDouble(this.parserString(parser, MIN, null));
                                max = Double.parseDouble(this.parserString(parser, MAX, null));
                                values[iBand] = this.parserHistogramListValues(parser);
                            }
                            break;
                        }
                        case 3: {
                            break;
                        }
                    }
                    tag = parser.next();
                }
                parser.require(1, null, null);
            }
        }
        catch (XmlPullParserException e) {
            throw new ParsingException(xml);
        }
        catch (IOException e) {
            throw new ParsingException(xml);
        }
        double[] mins = new double[numBands];
        double[] maxs = new double[numBands];
        for (int i = 0; i < numBands; ++i) {
            mins[i] = min;
            maxs[i] = max;
        }
        this.histogram = new BufferHistogramImpl(numBands, mins, maxs, dataType);
        this.histogram.setTable(values);
    }

    @Override
    public String write() {
        StringBuffer b = new StringBuffer();
        HistogramClass[][] c = this.histogram.getHistogram();
        b.append("<Histogram>\n");
        this.putProperty(b, BAND_COUNT, this.histogram.getNumBands(), 1);
        this.putProperty(b, DATA_TYPE, this.histogram.getDataType(), 1);
        for (int iBand = 0; iBand < this.histogram.getNumBands(); ++iBand) {
            b.append("\t<Band>\n");
            this.putProperty(b, MIN, c[iBand][0].getMin(), 2);
            this.putProperty(b, MAX, c[iBand][c[iBand].length - 1].getMin(), 2);
            b.append("\t\t<Values>");
            for (int iValues = 0; iValues < this.histogram.getNumValues(); ++iValues) {
                if (iValues != 0) {
                    b.append(" ");
                }
                b.append((long)this.histogram.getHistogramValueByPos(iBand, iValues));
            }
            b.append("</Values>\n");
            b.append("\t</Band>\n");
        }
        b.append("</Histogram>\n");
        return b.toString();
    }

    @Override
    public Object getResult() {
        return this.histogram;
    }

    @Override
    public String getMainTag() {
        return MAIN_TAG;
    }
}

