/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.impl.grid.filter.band;

import org.gvsig.fmap.dal.coverage.datastruct.Params;
import org.gvsig.fmap.dal.coverage.exception.FilterAddException;
import org.gvsig.fmap.dal.coverage.grid.filter.BaseRasterFilter;
import org.gvsig.raster.impl.store.ParamsImpl;
import org.gvsig.raster.util.DefaultColorConversion;

public class ColorBalanceRGBFilter
extends BaseRasterFilter {
    public static String[] names = new String[]{"colorbalancergb"};
    protected DefaultColorConversion colorConversion = null;
    protected int out = 0;
    protected int red = 0;
    protected int green = 0;
    protected int blue = 0;
    protected boolean luminosity = false;
    protected int redBandNumber = -1;
    protected int greenBandNumber = -1;
    protected int blueBandNumber = -1;

    public ColorBalanceRGBFilter() {
        this.setName(names[0]);
    }

    public void pre() throws FilterAddException {
        super.pre();
        this.redBandNumber = 0;
        this.greenBandNumber = 1;
        this.blueBandNumber = 2;
        if (this.raster.getDataType() != 0) {
            this.exec = false;
            this.raster = this.rasterResult;
            return;
        }
        if (this.params.get("red") != null) {
            this.red = (Integer)this.params.get("red");
        }
        if (this.params.get("green") != null) {
            this.green = (Integer)this.params.get("green");
        }
        if (this.params.get("blue") != null) {
            this.blue = (Integer)this.params.get("blue");
        }
        if (this.params.get("luminosity") != null) {
            this.luminosity = (Boolean)this.params.get("luminosity");
        }
        this.createARGBBufferResult();
        if (this.colorConversion == null) {
            this.colorConversion = new DefaultColorConversion();
        }
    }

    public String getGroup() {
        return "colores";
    }

    public String[] getNames() {
        return names;
    }

    public Params getUIParams(String nameFilter) {
        ParamsImpl params = new ParamsImpl();
        params.setParam("red", new Integer(this.red), 3, new String[]{"0", "100", "0", "5", "25"});
        params.setParam("green", new Integer(this.green), 3, new String[]{"0", "100", "0", "5", "25"});
        params.setParam("blue", new Integer(this.blue), 3, new String[]{"0", "100", "0", "5", "25"});
        params.setParam("luminosity", new Boolean(this.luminosity), 1, null);
        return params;
    }

    public void post() {
    }

    public void process(int x, int y) {
    }

    public int getOutRasterDataType() {
        return 0;
    }

    public boolean isVisible() {
        return true;
    }

    public int getInRasterDataType() {
        return 0;
    }
}

