/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.impl.grid.filter.enhancement;

import java.util.ArrayList;
import java.util.List;
import org.gvsig.fmap.dal.coverage.RasterLibrary;
import org.gvsig.fmap.dal.coverage.datastruct.Params;
import org.gvsig.fmap.dal.coverage.exception.FileNotOpenException;
import org.gvsig.fmap.dal.coverage.exception.FilterTypeException;
import org.gvsig.fmap.dal.coverage.exception.ProcessInterruptedException;
import org.gvsig.fmap.dal.coverage.exception.RasterDriverException;
import org.gvsig.fmap.dal.coverage.grid.AbstractRasterFilterManager;
import org.gvsig.fmap.dal.coverage.grid.RasterFilter;
import org.gvsig.fmap.dal.coverage.grid.RasterFilterList;
import org.gvsig.fmap.dal.coverage.store.props.Statistics;
import org.gvsig.raster.impl.grid.filter.RasterFilterListManagerImpl;
import org.gvsig.raster.impl.grid.filter.enhancement.LinearEnhancementFilter;
import org.gvsig.raster.impl.grid.filter.enhancement.LinearEnhancementFloatFilter;
import org.gvsig.raster.impl.grid.filter.statistics.StatisticsListManager;
import org.gvsig.raster.impl.store.ParamImpl;

public class EnhancementListManager
extends AbstractRasterFilterManager {
    private static String ID = "Enhancement";
    private RasterFilterListManagerImpl filterListManager = null;
    private Statistics stats = null;

    public EnhancementListManager(RasterFilterList filterList) {
        super(filterList);
    }

    public String getManagerID() {
        return ID;
    }

    public static void register() {
        AbstractRasterFilterManager.register((String)ID, EnhancementListManager.class);
    }

    public EnhancementListManager(RasterFilterListManagerImpl filterListManager) {
        super(filterListManager.getFilterList());
        this.filterListManager = filterListManager;
        this.stats = (Statistics)this.getFilterList().getEnvParam("SrcStatistics");
    }

    public Class<?> getFilterClassByID(String id) {
        if (id.compareTo("enhanced") == 0) {
            return LinearEnhancementFilter.class;
        }
        return null;
    }

    public void setStatistics(Statistics stats) {
        this.stats = stats;
    }

    public boolean isDataTypeSupported(int dataType) {
        return true;
    }

    public void addEnhancedFilter(boolean removeEnds, Statistics stats, double tailTrim, int[] renderBands) throws FilterTypeException {
        try {
            RasterFilter filter;
            if (tailTrim == 0.0) {
                if (!stats.isCalculated()) {
                    try {
                        stats.calculate(RasterLibrary.statisticsScale);
                    }
                    catch (FileNotOpenException e) {
                        return;
                    }
                    catch (RasterDriverException e) {
                        return;
                    }
                }
            } else {
                StatisticsListManager slm = new StatisticsListManager(this.filterListManager);
                slm.addTailFilter(tailTrim, 0.0, removeEnds, stats);
            }
            if ((filter = EnhancementListManager.createEnhancedFilter(removeEnds, stats, tailTrim, renderBands)) != null) {
                this.getFilterList().add(filter);
            }
        }
        catch (ProcessInterruptedException processInterruptedException) {
            // empty catch block
        }
    }

    public static RasterFilter createEnhancedFilter(boolean removeEnds, Statistics stats, double tailTrim, int[] renderBands) {
        LinearEnhancementFloatFilter filter = new LinearEnhancementFloatFilter();
        if (filter != null) {
            filter.addParam("stats", stats);
            if (removeEnds) {
                filter.addParam("remove", new Boolean(true));
            } else {
                filter.addParam("remove", new Boolean(false));
            }
            filter.addParam("tailTrim", new Double(tailTrim));
            filter.addParam("renderBands", renderBands);
        }
        return filter;
    }

    public List<String> getStringsFromFilterList(List<String> filterList, RasterFilter rf) {
        if (rf instanceof LinearEnhancementFilter) {
            filterList.add("filter.enhanced.active=true");
            filterList.add("filter.enhanced.tailTrim=" + ((LinearEnhancementFilter)rf).getTailTrim().toString());
            filterList.add("filter.enhanced.remove=" + ((LinearEnhancementFilter)rf).getRemoveEnds().toString());
        }
        return filterList;
    }

    public int createFilterListFromStrings(List<String> filters, String fil, int filteri) throws FilterTypeException {
        if (fil.startsWith("filter.enhanced.active") && RasterFilterListManagerImpl.getValue(fil).equals("true") && this.stats != null) {
            filters.remove(filteri);
            double tailTrim = 0.0;
            int[] renderBands = new int[]{0, 0, 0};
            for (int propFilter = 0; propFilter < filters.size(); ++propFilter) {
                String elem = filters.get(propFilter);
                if (elem.startsWith("filter.enhanced.tailTrim")) {
                    try {
                        tailTrim = new Double(RasterFilterListManagerImpl.getValue(elem));
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                if (!elem.startsWith("filter.enhanced.remove")) continue;
                this.addEnhancedFilter(Boolean.valueOf(RasterFilterListManagerImpl.getValue(elem)), this.stats, tailTrim, renderBands);
                filters.remove(propFilter);
                --propFilter;
            }
            filteri = -1;
        }
        return filteri;
    }

    public List<Class<?>> getRasterFilterList() {
        ArrayList filters = new ArrayList();
        filters.add(LinearEnhancementFilter.class);
        return filters;
    }

    public void addFilter(Class<?> classFilter, Params params) throws FilterTypeException {
        if (LinearEnhancementFilter.class.isAssignableFrom(classFilter)) {
            boolean removeEnds = false;
            double tailTrim = 0.0;
            int[] renderBands = new int[]{0, 1, 2};
            for (int i = 0; i < params.getNumParams(); ++i) {
                if (((ParamImpl)params.getParam(i)).getId().equals("RenderBands") && ((ParamImpl)params.getParam(i)).getDefaultValue() instanceof String) {
                    String[] bands = new String((String)((ParamImpl)params.getParam(i)).getDefaultValue()).split(" ");
                    renderBands[0] = new Integer(bands[0]);
                    renderBands[1] = new Integer(bands[1]);
                    renderBands[2] = new Integer(bands[2]);
                    continue;
                }
                if (((ParamImpl)params.getParam(i)).getId().equals("RemoveEnds") && ((ParamImpl)params.getParam(i)).getDefaultValue() instanceof Boolean) {
                    removeEnds = (Boolean)((ParamImpl)params.getParam(i)).getDefaultValue();
                    continue;
                }
                if (!((ParamImpl)params.getParam(i)).getId().equals("TailTrim") || !(((ParamImpl)params.getParam(i)).getDefaultValue() instanceof Double)) continue;
                tailTrim = (Double)((ParamImpl)params.getParam(i)).getDefaultValue() / 100.0;
            }
            this.addEnhancedFilter(removeEnds, (Statistics)this.getFilterList().getEnvParam("SrcStatistics"), tailTrim, renderBands);
        }
    }

    public void addFilter(Params params) throws FilterTypeException {
        this.addFilter(LinearEnhancementFilter.class, params);
    }

    public RasterFilter createFilter(Params params) {
        return null;
    }
}

