/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.impl.grid.filter.enhancement;

import org.gvsig.raster.impl.datastruct.DefaultStretch;
import org.gvsig.raster.impl.grid.filter.enhancement.LinearStretchEnhancementFilter;

public class LinearStretchEnhancementByteFilter
extends LinearStretchEnhancementFilter {
    @Override
    public void process(int col, int line) {
        for (int iBand = 0; iBand < this.renderBands.length; ++iBand) {
            if (this.renderBands[iBand] < 0) continue;
            int p = this.stretchs.rgb ? this.raster.getElemByte(line, col, iBand) & 0xFF : this.raster.getElemByte(line, col, iBand);
            if (iBand < this.scaleOffsetList.length) {
                this.processValue(p, this.scaleOffsetList[iBand], col, line, iBand);
                continue;
            }
            this.rasterResult.setElem(line, col, iBand, (byte)p);
        }
        this.writeAlphaBand(line, col);
    }

    private void processValue(int p, DefaultStretch data, int col, int line, int iBand) {
        if (data.scale != null) {
            if ((double)p > data.maxValue) {
                p = (int)data.maxValue;
            } else if ((double)p < data.minValue) {
                p = (int)data.minValue;
            }
            for (int i = 0; i < data.scale.length; ++i) {
                if (!((double)p > data.stretchIn[i] && (double)p <= data.stretchIn[i + 1]) && (i != 0 || (double)p != data.stretchIn[i])) continue;
                p = (int)(((double)p - data.stretchIn[i]) * data.scale[i] + data.offset[i]);
                break;
            }
            this.rasterResult.setElem(line, col, iBand, (byte)p);
        }
    }

    @Override
    public int getInRasterDataType() {
        return 0;
    }
}

