/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.impl.grid.filter.pansharp;

import java.util.ArrayList;
import java.util.List;
import org.gvsig.fmap.dal.coverage.datastruct.Params;
import org.gvsig.fmap.dal.coverage.exception.FilterTypeException;
import org.gvsig.fmap.dal.coverage.grid.AbstractRasterFilterManager;
import org.gvsig.fmap.dal.coverage.grid.RasterFilter;
import org.gvsig.fmap.dal.coverage.grid.RasterFilterList;
import org.gvsig.fmap.dal.coverage.store.RasterDataStore;
import org.gvsig.raster.impl.grid.filter.RasterFilterListManagerImpl;
import org.gvsig.raster.impl.grid.filter.pansharp.PanSharpeningByteFilter;
import org.gvsig.raster.impl.grid.filter.pansharp.PanSharpeningFilter;
import org.gvsig.raster.impl.store.ParamImpl;

public class PanSharpeningListManager
extends AbstractRasterFilterManager {
    private static String ID = "PanSharpening";

    public PanSharpeningListManager(RasterFilterList filterList) {
        super(filterList);
    }

    public String getManagerID() {
        return ID;
    }

    public static void register() {
        AbstractRasterFilterManager.register((String)ID, PanSharpeningListManager.class);
    }

    public PanSharpeningListManager(RasterFilterListManagerImpl filterListManager) {
        super(filterListManager.getFilterList());
    }

    public boolean isDataTypeSupported(int dataType) {
        return dataType == 0;
    }

    public Class<?> getFilterClassByID(String id) {
        if (id.compareTo("pansharp") == 0) {
            return PanSharpeningFilter.class;
        }
        return null;
    }

    public void addFilter(Class<?> classFilter, Params params) throws FilterTypeException {
        if (PanSharpeningFilter.class.isAssignableFrom(classFilter)) {
            String method = "";
            String fileNameOutput = null;
            RasterDataStore dataset = null;
            ArrayList order = null;
            int alpha = 0;
            int coefBrovey = 0;
            int posPancromatica = -1;
            double coef = 0.0;
            for (int i = 0; i < params.getNumParams(); ++i) {
                if (((ParamImpl)params.getParam(i)).getId().equals("dataset")) {
                    dataset = (RasterDataStore)params.getParam(i);
                }
                if (((ParamImpl)params.getParam(i)).getId().equals("posPancromatica")) {
                    posPancromatica = new Integer((String)((ParamImpl)params.getParam(i)).getDefaultValue());
                }
                if (((ParamImpl)params.getParam(i)).getId().equals("order")) {
                    order = (ArrayList)((ParamImpl)params.getParam(i)).getDefaultValue();
                }
                if (((ParamImpl)params.getParam(i)).getId().equals("alpha")) {
                    alpha = new Integer((String)((ParamImpl)params.getParam(i)).getDefaultValue());
                }
                if (((ParamImpl)params.getParam(i)).getId().equals("method")) {
                    method = new String((String)((ParamImpl)params.getParam(i)).getDefaultValue());
                }
                if (((ParamImpl)params.getParam(i)).getId().equals("coef")) {
                    coef = new Double((String)((ParamImpl)params.getParam(i)).getDefaultValue());
                }
                if (((ParamImpl)params.getParam(i)).getId().equals("coefBrovey")) {
                    coefBrovey = new Integer((String)((ParamImpl)params.getParam(i)).getDefaultValue());
                }
                if (!((ParamImpl)params.getParam(i)).getId().equals("fileNameOutput")) continue;
                fileNameOutput = new String((String)((ParamImpl)params.getParam(i)).getDefaultValue());
            }
            this.addPanSharpeningFilter(dataset, posPancromatica, order, alpha, method, coef, coefBrovey, fileNameOutput);
        }
    }

    public void addFilter(Params params) throws FilterTypeException {
        this.addFilter(PanSharpeningFilter.class, params);
    }

    public void addPanSharpeningFilter(RasterDataStore ldatastore, int posPancromatica, ArrayList<?> order, int alpha, String method, double coef, int coefBrovey, String fileNameOutput) throws FilterTypeException {
        PanSharpeningByteFilter filter = new PanSharpeningByteFilter();
        if (filter != null) {
            filter.addParam("dataset", ldatastore);
            filter.addParam("posPancromatica", new Integer(posPancromatica));
            filter.addParam("order", order);
            filter.addParam("alpha", new Integer(alpha));
            filter.addParam("method", method);
            filter.addParam("coef", new Double(coef));
            filter.addParam("coefBrovey", new Integer(coefBrovey));
            filter.addParam("fileNameOutput", fileNameOutput);
            this.getFilterList().add((RasterFilter)filter);
        }
    }

    public List<Class<?>> getRasterFilterList() {
        ArrayList filters = new ArrayList();
        filters.add(PanSharpeningFilter.class);
        return filters;
    }

    public RasterFilter createFilter(Params params) {
        return null;
    }
}

