/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.impl.grid.filter.segmentation;

import org.gvsig.fmap.dal.coverage.datastruct.Params;
import org.gvsig.fmap.dal.coverage.exception.FilterAddException;
import org.gvsig.fmap.dal.coverage.grid.filter.BaseRasterFilter;
import org.gvsig.raster.impl.datastruct.Kernel;
import org.gvsig.raster.impl.store.ParamsImpl;

public class FirstDerivativeFilter
extends BaseRasterFilter {
    public static String[] names = new String[]{"sobel", "roberts", "prewitt", "freichen"};
    public static final int TYPE_SOBEL = 0;
    public static final int TYPE_ROBERTS = 1;
    public static final int TYPE_PREWITT = 2;
    public static final int TYPE_FREICHEN = 3;
    protected int umbral = 0;
    protected boolean compare = false;
    protected Kernel operatorH;
    protected Kernel operatorV;
    private int operator = 0;
    static final double[][] sobelH = new double[][]{{-1.0, 0.0, 1.0}, {-2.0, 0.0, 2.0}, {-1.0, 0.0, 1.0}};
    static final double[][] sobelV = new double[][]{{-1.0, -2.0, -1.0}, {0.0, 0.0, 0.0}, {1.0, 2.0, 1.0}};
    static final Kernel sobelHKernel = new Kernel(sobelH);
    static final Kernel sobelVKernel = new Kernel(sobelV);
    static final double[][] robertsH = new double[][]{{0.0, 0.0, -1.0}, {0.0, 1.0, 0.0}, {0.0, 0.0, 0.0}};
    static final double[][] robertsV = new double[][]{{-1.0, 0.0, 0.0}, {0.0, 1.0, 0.0}, {0.0, 0.0, 0.0}};
    static final Kernel robertsHKernel = new Kernel(robertsH);
    static final Kernel robertsVKernel = new Kernel(robertsV);
    static final double[][] prewittH = new double[][]{{1.0, 0.0, -1.0}, {1.0, 0.0, -1.0}, {1.0, 0.0, -1.0}};
    static final double[][] prewittV = new double[][]{{-1.0, -1.0, -1.0}, {0.0, 0.0, 0.0}, {1.0, 1.0, 1.0}};
    static final Kernel prewittHKernel = new Kernel(prewittH);
    static final Kernel prewittVKernel = new Kernel(prewittV);
    static final double[][] freiChenH = new double[][]{{-1.0, -1.4, -1.0}, {0.0, 0.0, 0.0}, {1.0, 1.4, 1.0}};
    static final double[][] freiChenV = new double[][]{{-1.0, 0.0, 1.0}, {-1.4, 0.0, 1.4}, {-1.0, 0.0, 1.0}};
    static final Kernel freiChenHKernel = new Kernel(freiChenH);
    static final Kernel freiChenVKernel = new Kernel(freiChenV);
    protected int nBandsToProcess = 0;
    protected boolean hasTransparency = false;

    public FirstDerivativeFilter() {
        this.setName(names[0]);
    }

    public void pre() throws FilterAddException {
        super.pre();
        if (this.transparency != null && this.transparency.existAlphaBand()) {
            this.nBandsToProcess = this.raster.getBandCount() - 1;
            this.hasTransparency = true;
        } else {
            this.nBandsToProcess = this.raster.getBandCount();
        }
        this.umbral = this.params.get("umbral") != null ? (Integer)this.params.get("umbral") : 0;
        this.compare = this.params.get("compare") != null ? (Boolean)this.params.get("compare") : false;
        this.operator = 0;
        for (int i = 0; i < names.length; ++i) {
            if (!names[i].equals(this.getName())) continue;
            this.operator = i;
            break;
        }
        switch (this.operator) {
            case 0: {
                this.operatorH = sobelHKernel;
                this.operatorV = sobelVKernel;
                break;
            }
            case 1: {
                this.operatorH = robertsHKernel;
                this.operatorV = robertsVKernel;
                break;
            }
            case 2: {
                this.operatorH = prewittHKernel;
                this.operatorV = prewittVKernel;
                break;
            }
            case 3: {
                this.operatorH = freiChenHKernel;
                this.operatorV = freiChenVKernel;
            }
        }
        this.createBufferResult(0, this.raster.getBandCount());
    }

    public int getUmbral() {
        return this.umbral;
    }

    public String getGroup() {
        return "deteccion_bordes";
    }

    public void post() {
        this.raster = null;
    }

    public String[] getNames() {
        return names;
    }

    public Params getUIParams(String nameFilter) {
        ParamsImpl params = new ParamsImpl();
        params.setParam("Umbral", new Integer(this.umbral), 3, new String[]{"0", "255", "0", "1", "25"});
        params.setParam("Compare", new Boolean(this.compare), 1, null);
        params.setParam("FilterName", this.getName(), -1, null);
        return params;
    }

    public int getInRasterDataType() {
        return 0;
    }

    public int getOutRasterDataType() {
        return 0;
    }

    public void process(int x, int y) {
    }
}

