/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.impl.grid.render;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.geom.Dimension2D;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import org.cresques.cts.ICoordTrans;
import org.cresques.cts.IProjection;
import org.gvsig.fmap.dal.coverage.RasterLocator;
import org.gvsig.fmap.dal.coverage.RasterManager;
import org.gvsig.fmap.dal.coverage.dataset.Buffer;
import org.gvsig.fmap.dal.coverage.datastruct.Extent;
import org.gvsig.fmap.dal.coverage.datastruct.Params;
import org.gvsig.fmap.dal.coverage.datastruct.ViewPortData;
import org.gvsig.fmap.dal.coverage.exception.FilterManagerException;
import org.gvsig.fmap.dal.coverage.exception.FilterTypeException;
import org.gvsig.fmap.dal.coverage.exception.ProcessInterruptedException;
import org.gvsig.fmap.dal.coverage.exception.QueryException;
import org.gvsig.fmap.dal.coverage.exception.ROIException;
import org.gvsig.fmap.dal.coverage.exception.WarpException;
import org.gvsig.fmap.dal.coverage.filter.FilterLoader;
import org.gvsig.fmap.dal.coverage.grid.FilterListChangeEvent;
import org.gvsig.fmap.dal.coverage.grid.FilterListChangeListener;
import org.gvsig.fmap.dal.coverage.grid.RasterFilter;
import org.gvsig.fmap.dal.coverage.grid.RasterFilterList;
import org.gvsig.fmap.dal.coverage.grid.RasterFilterListManager;
import org.gvsig.fmap.dal.coverage.grid.render.Render;
import org.gvsig.fmap.dal.coverage.grid.render.VisualPropertyEvent;
import org.gvsig.fmap.dal.coverage.grid.render.VisualPropertyListener;
import org.gvsig.fmap.dal.coverage.store.RasterDataStore;
import org.gvsig.fmap.dal.coverage.store.RasterQuery;
import org.gvsig.fmap.dal.coverage.store.props.ColorInterpretation;
import org.gvsig.fmap.dal.coverage.store.props.ColorTable;
import org.gvsig.fmap.dal.coverage.store.props.Statistics;
import org.gvsig.fmap.dal.coverage.store.props.Transparency;
import org.gvsig.fmap.dal.coverage.util.PropertyEvent;
import org.gvsig.fmap.dal.coverage.util.PropertyListener;
import org.gvsig.fmap.dal.coverage.util.RasterUtils;
import org.gvsig.raster.cache.tile.Tile;
import org.gvsig.raster.cache.tile.exception.TileGettingException;
import org.gvsig.raster.cache.tile.provider.TileListener;
import org.gvsig.raster.impl.datastruct.DefaultViewPortData;
import org.gvsig.raster.impl.datastruct.ExtentImpl;
import org.gvsig.raster.impl.grid.filter.band.ColorTableFilter;
import org.gvsig.raster.impl.grid.render.ImageDrawerImpl;
import org.gvsig.raster.impl.grid.render.RasterRenderReprojection;
import org.gvsig.raster.impl.store.properties.DataStoreColorInterpretation;
import org.gvsig.raster.util.persistence.PersistencyFilterParams;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DynStruct;
import org.gvsig.tools.persistence.PersistenceManager;
import org.gvsig.tools.persistence.Persistent;
import org.gvsig.tools.persistence.PersistentState;
import org.gvsig.tools.persistence.exception.PersistenceException;
import org.gvsig.tools.task.TaskStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultRender
implements Render,
PropertyListener,
FilterListChangeListener,
Persistent,
TileListener {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultRender.class);
    private RasterDataStore dataStore = null;
    ColorInterpretation renderColorInterpretation = null;
    private ImageDrawerImpl drawer = null;
    private Transparency renderingTransparency = null;
    private int lastAlphaBand = -1;
    private RasterFilterList filterList = null;
    private double widthImage;
    private double heightImage;
    private Point2D ulPxRequest;
    private Point2D lrPxRequest;
    private ArrayList<VisualPropertyListener> visualPropertyListener = new ArrayList();
    private RasterUtils util = RasterLocator.getManager().getRasterUtils();
    private boolean isDrawing = false;
    private Graphics2D lastGraphics = null;
    private ViewPortData lastViewPortData = null;
    private ICoordTrans lastCoordTrans = null;
    private Dimension2D viewDimension = null;
    private boolean reprojectionOnTheFly = false;
    private RasterManager rManager = null;
    private List<PersistencyFilterParams> listFilterParameters = null;

    public DefaultRender() {
    }

    public DefaultRender(RasterDataStore ds) {
        this.dataStore = ds;
        this.init();
    }

    private RasterManager getRasterManager() {
        if (this.rManager == null) {
            this.rManager = RasterLocator.getManager();
        }
        return this.rManager;
    }

    public RasterDataStore getDataStore() {
        return this.dataStore;
    }

    public void setDataStore(RasterDataStore dataStore) {
        this.dataStore = dataStore;
        this.init();
    }

    private void init() {
        if (this.dataStore == null || this.dataStore.getDataType() == null) {
            return;
        }
        this.drawer = new ImageDrawerImpl();
        this.getRenderColorInterpretation();
    }

    public void addVisualPropertyListener(VisualPropertyListener listener) {
        this.visualPropertyListener.add(listener);
    }

    private void callVisualPropertyChanged(Object obj) {
        if (this.visualPropertyListener != null) {
            for (int i = 0; i < this.visualPropertyListener.size(); ++i) {
                VisualPropertyEvent ev = new VisualPropertyEvent(obj);
                this.visualPropertyListener.get(i).visualPropertyValueChanged(ev);
            }
        }
    }

    public void run() {
        try {
            this.draw(this.lastGraphics, this.lastViewPortData, this.lastCoordTrans, null);
        }
        catch (QueryException e) {
            LoggerFactory.getLogger(this.getClass()).debug("Error in a query", (Throwable)e);
        }
        catch (ProcessInterruptedException processInterruptedException) {
            // empty catch block
        }
    }

    public void setGraphicInfo(Graphics2D g, ViewPortData vp) {
        this.lastGraphics = g;
        this.lastViewPortData = vp;
    }

    public void drawThread(Graphics2D g, ViewPortData vp) {
        if (this.util.isOutside(vp.getExtent(), this.dataStore.getExtent())) {
            return;
        }
        this.setReading(true);
        this.setGraphicInfo(g, vp);
        new Thread((Runnable)((Object)this)).start();
        while (this.isReading()) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {
                break;
            }
        }
    }

    public synchronized Buffer getLastRenderBuffer() throws QueryException, ProcessInterruptedException {
        return this.draw(null, this.lastViewPortData, this.lastCoordTrans, null);
    }

    public synchronized void drawTiledService(Graphics2D g, ViewPortData vp, Dimension2D viewDimension, ICoordTrans coordTrans, TaskStatus taskStatus) throws QueryException, ProcessInterruptedException {
        Extent areaOfInterest;
        RasterQuery query;
        this.lastGraphics = g;
        this.lastViewPortData = vp;
        this.lastCoordTrans = coordTrans;
        this.viewDimension = viewDimension;
        int[] renderBands = this.getRenderColorInterpretation().buildRenderBands();
        Extent extent = this.dataStore.getExtent();
        if (coordTrans != null) {
            extent = extent.convert(coordTrans);
        }
        if (this.util.isOutside(vp.getExtent(), extent)) {
            this.endReading();
            return;
        }
        if (this.dataStore != null) {
            this.lastAlphaBand = this.getRenderingTransparency().getAlphaBandNumber();
            query = this.getRasterManager().createQuery();
            query.setTaskStatus(taskStatus);
            query.setTime(vp.getTime());
            query.setSupersamplingOption(false);
            if (this.dataStore.getColorInterpretation().isRGB()) {
                renderBands[3] = 3;
            }
            query.setDrawableBands(renderBands);
            if (this.dataStore.getDataType()[0] == 0) {
                if (this.lastAlphaBand != -1) {
                    query.forceARGBRequest();
                } else if (renderBands.length == 3 || renderBands.length == 4 && renderBands[3] == -1) {
                    query.forceRGBRequest();
                } else {
                    query.forceARGBRequest();
                }
            } else {
                query.forceRGBRequest();
            }
            areaOfInterest = vp.getExtent();
            if (coordTrans != null) {
                areaOfInterest = vp.getExtent().convert(coordTrans.getInverted());
            }
        } else {
            return;
        }
        query.setAreaOfInterest(areaOfInterest, (int)Math.round(vp.getWidth()), (int)Math.round(vp.getHeight()), (TileListener)this);
        this.dataStore.query(query);
        query.setSupersamplingOption(true);
    }

    public synchronized void tileReady(Tile loadedTile) throws TileGettingException {
        Buffer buf;
        boolean crash = false;
        Boolean tiling = (Boolean)loadedTile.getDownloaderParams("Tiling");
        double[] step = (double[])loadedTile.getDownloaderParams("Step");
        AffineTransform transf = (AffineTransform)loadedTile.getDownloaderParams("AffineTransform");
        Extent tileExtent = this.getRasterManager().getDataStructFactory().createExtent(loadedTile.getUl().getX(), loadedTile.getUl().getY(), loadedTile.getLr().getX(), loadedTile.getLr().getY());
        Buffer buffer = buf = loadedTile.getData() != null && loadedTile.getData().length > 0 ? (Buffer)loadedTile.getData()[0] : null;
        if (!loadedTile.dataIsLoaded()) {
            if (loadedTile.getCrashARGB() == null) {
                return;
            }
            crash = true;
            buf = (Buffer)loadedTile.getCrashARGB();
        } else {
            ColorTable tileColorTable;
            if (buf == null) {
                return;
            }
            ColorTable colorTable = tileColorTable = loadedTile.getData() != null && loadedTile.getData().length > 2 ? (ColorTable)loadedTile.getData()[2] : null;
            if ((tiling == null || tiling.booleanValue()) && this.filterList != null) {
                this.addTileColorTable(tileColorTable);
            }
        }
        buf.setDataExtent(tileExtent.toRectangle2D());
        if (this.lastCoordTrans != null) {
            Extent projectedExtent = tileExtent.convert(this.lastCoordTrans);
            try {
                buf = buf.project(this.lastCoordTrans.getInverted(), projectedExtent, loadedTile.getWidthPx(), loadedTile.getHeightPx());
                tileExtent = projectedExtent;
            }
            catch (WarpException e) {
                LOG.error(String.format("Can not project [level: %1s row: %2s column: %3s] tile buffer to %4s", loadedTile.getLevel(), loadedTile.getRow(), loadedTile.getCol(), this.lastCoordTrans.getPDest().getAbrev()));
                return;
            }
        }
        Transparency transparencyProcessed = null;
        if (tiling == null || tiling.booleanValue()) {
            try {
                FilterLoader filterLoader = this.bufferPreprocessing(buf);
                transparencyProcessed = filterLoader.getTransparency();
                buf = filterLoader.getBufferResult();
            }
            catch (ProcessInterruptedException e3) {
                return;
            }
        }
        if (tiling == null || tiling.booleanValue()) {
            Image geoImage;
            double w = this.lastViewPortData.getWidth();
            double h = this.lastViewPortData.getHeight();
            if (this.viewDimension != null) {
                w = this.viewDimension.getWidth();
                h = this.viewDimension.getHeight();
            }
            double viewScaleW = this.lastViewPortData.getExtent().width() / w;
            double tileScaleW = tileExtent.width() / (double)buf.getWidth();
            double scaleW = viewScaleW / tileScaleW;
            double viewScaleH = this.lastViewPortData.getExtent().height() / h;
            double tileScaleH = tileExtent.height() / (double)buf.getHeight();
            double scaleH = viewScaleH / tileScaleH;
            ImageDrawerImpl d = new ImageDrawerImpl();
            d.setBuffer(buf);
            d.setSupersamplingOn(null);
            d.setOutputSize(buf.getWidth(), buf.getHeight());
            d.setLastTransparency(transparencyProcessed);
            try {
                geoImage = d.drawBufferOverImageObject();
            }
            catch (ProcessInterruptedException e2) {
                return;
            }
            d.dispose();
            AffineTransform at = new AffineTransform();
            at.scale(1.0 / scaleW, 1.0 / scaleH);
            try {
                Point2D.Double pt = new Point2D.Double(tileExtent.getULX(), tileExtent.getULY());
                ((DefaultViewPortData)this.lastViewPortData).mat.transform(pt, pt);
                at.inverseTransform(pt, pt);
                this.lastGraphics.transform(at);
                this.lastGraphics.drawImage(geoImage, (int)Math.round(((Point2D)pt).getX()), (int)Math.round(((Point2D)pt).getY()), null);
                this.lastGraphics.transform(at.createInverse());
                geoImage.flush();
            }
            catch (NoninvertibleTransformException e1) {
                e1.printStackTrace();
            }
        } else {
            try {
                this.drawBufferOnImage(this.lastGraphics, this.lastViewPortData, buf, step, transf, tileExtent);
            }
            catch (QueryException e1) {
                LoggerFactory.getLogger(this.getClass()).debug("Error loading data", (Throwable)e1);
            }
            catch (ProcessInterruptedException processInterruptedException) {
                // empty catch block
            }
        }
        if (!crash && buf != null) {
            buf.dispose();
        }
    }

    public synchronized Buffer draw(Graphics2D g, ViewPortData vp, ICoordTrans coordTrans, TaskStatus taskStatus) throws QueryException, ProcessInterruptedException {
        this.lastGraphics = g;
        this.lastViewPortData = vp;
        this.lastCoordTrans = coordTrans;
        Extent extent = this.dataStore.getExtent();
        if (coordTrans != null) {
            extent = extent.convert(coordTrans);
        }
        if (this.util.isOutside(vp.getExtent(), extent)) {
            this.endReading();
            return null;
        }
        Extent adjustedRotedRequest = null;
        try {
            adjustedRotedRequest = this.request(vp, coordTrans, this.dataStore);
        }
        catch (NoninvertibleTransformException e) {
            throw new ProcessInterruptedException("Problems adjusting extent to render");
        }
        if (this.widthImage <= 0.0 || this.heightImage <= 0.0) {
            this.endReading();
            return null;
        }
        if (this.dataStore == null) {
            return null;
        }
        Buffer buf = null;
        double[] step = null;
        int[] renderBands = this.getRenderColorInterpretation().buildRenderBands();
        if (coordTrans != null) {
            RasterRenderReprojection renderReprojection = new RasterRenderReprojection();
            try {
                buf = renderReprojection.warp(this.dataStore, coordTrans, adjustedRotedRequest, (int)Math.round(this.widthImage), (int)Math.round(this.heightImage), vp.getTime(), renderBands, taskStatus);
            }
            catch (WarpException e) {
                throw new ProcessInterruptedException((Throwable)e);
            }
        } else {
            this.lastAlphaBand = this.getRenderingTransparency().getAlphaBandNumber();
            RasterQuery query = this.getRasterManager().createQuery();
            query.setTaskStatus(taskStatus);
            query.setTime(vp.getTime());
            query.setAreaOfInterest(adjustedRotedRequest, (int)Math.round(this.widthImage), (int)Math.round(this.heightImage));
            query.setDrawableBands(renderBands);
            if (this.dataStore.getDataType()[0] == 0) {
                if (this.lastAlphaBand != -1) {
                    query.forceARGBRequest();
                } else if (renderBands.length == 3 || renderBands.length == 4 && renderBands[3] == -1) {
                    query.forceRGBRequest();
                }
            } else if (renderBands.length == 4 && renderBands[3] != -1) {
                query.forceARGBRequest();
            } else {
                query.forceRGBRequest();
            }
            buf = this.dataStore.query(query);
            step = query.getStep();
        }
        if (this.drawer == null) {
            this.init();
        }
        return this.drawBufferOnImage(this.lastGraphics, this.lastViewPortData, buf, step, this.dataStore.getAffineTransform(), adjustedRotedRequest);
    }

    private synchronized Buffer drawBufferOnImage(Graphics2D g, ViewPortData vp, Buffer buf, double[] step, AffineTransform transf, Extent adjustedRotedRequest) throws QueryException, ProcessInterruptedException {
        FilterLoader filterLoader = this.bufferPreprocessing(buf);
        Transparency transparencyProcessed = filterLoader.getTransparency();
        buf = filterLoader.getBufferResult();
        if (g == null) {
            return buf;
        }
        this.drawer.setBuffer(buf);
        this.drawer.setSupersamplingOn(step);
        this.drawer.setOutputSize((int)Math.round(this.widthImage), (int)Math.round(this.heightImage));
        this.drawer.setLastTransparency(transparencyProcessed);
        Image geoImage = this.drawer.drawBufferOverImageObject();
        this.drawer.dispose();
        if (transf.getScaleX() > 0.0 && transf.getScaleY() < 0.0 && transf.getShearX() == 0.0 && transf.getShearY() == 0.0) {
            Point2D.Double lastGraphicOffset = new Point2D.Double(adjustedRotedRequest.getULX(), adjustedRotedRequest.getULY());
            ((DefaultViewPortData)vp).mat.transform(lastGraphicOffset, lastGraphicOffset);
            g.drawImage(geoImage, (int)Math.round(((Point2D)lastGraphicOffset).getX()), (int)Math.round(((Point2D)lastGraphicOffset).getY()), null);
            return buf;
        }
        double sX = Math.abs(this.ulPxRequest.getX() - this.lrPxRequest.getX()) / this.widthImage;
        double sY = Math.abs(this.ulPxRequest.getY() - this.lrPxRequest.getY()) / this.heightImage;
        AffineTransform scale = new AffineTransform(sX, 0.0, 0.0, sY, 0.0, 0.0);
        try {
            AffineTransform at = (AffineTransform)scale.clone();
            at.preConcatenate(transf);
            at.preConcatenate(vp.getMat());
            g.transform(at);
            Point2D.Double pt = null;
            pt = transf.getScaleX() < 0.0 && transf.getScaleY() < 0.0 ? new Point2D.Double(adjustedRotedRequest.maxX(), adjustedRotedRequest.maxY()) : (transf.getScaleX() > 0.0 && transf.getScaleY() > 0.0 ? new Point2D.Double(adjustedRotedRequest.minX(), adjustedRotedRequest.minY()) : (transf.getScaleX() < 0.0 && transf.getScaleY() > 0.0 ? new Point2D.Double(adjustedRotedRequest.maxX(), adjustedRotedRequest.minY()) : new Point2D.Double(adjustedRotedRequest.getULX(), adjustedRotedRequest.getULY())));
            vp.getMat().transform(pt, pt);
            at.inverseTransform(pt, pt);
            g.drawImage(geoImage, (int)Math.round(pt.getX()), (int)Math.round(pt.getY()), null);
            g.transform(at.createInverse());
            geoImage.flush();
        }
        catch (NoninvertibleTransformException e) {
            LoggerFactory.getLogger(this.getClass()).debug("Transformation error", (Throwable)e);
        }
        return buf;
    }

    private FilterLoader bufferPreprocessing(Buffer buf) throws ProcessInterruptedException {
        if (this.getRenderingTransparency().getNoData().isNoDataTransparent() || this.getRenderingTransparency().existAlphaBand()) {
            this.getRenderingTransparency().setDataBuffer(buf);
        } else {
            this.getRenderingTransparency().setDataBuffer(null);
        }
        this.getRenderingTransparency().activeTransparency();
        List roi = null;
        try {
            roi = this.dataStore.getRois(this.lastViewPortData != null ? this.lastViewPortData.getProjection() : null);
        }
        catch (ROIException rOIException) {
            // empty catch block
        }
        FilterLoader filterLoader = RasterLocator.getManager().createFilterLoader(this.filterList);
        filterLoader.addSrcBandCount(this.dataStore.getBandCount());
        filterLoader.addSrcDataType(this.dataStore.getDataType()[0]);
        filterLoader.addSrcStatistics(this.dataStore.getStatistics());
        filterLoader.addSrcROI(roi);
        filterLoader.addSrcHistogram(this.dataStore.getHistogramComputer());
        filterLoader.addTransparency(this.getRenderingTransparency());
        filterLoader.applyFilters(buf);
        return filterLoader;
    }

    private void addTileColorTable(ColorTable tileColorTable) {
        if (tileColorTable == null) {
            return;
        }
        if (this.filterList.getFilterClassByID("ColorTable") == null) {
            try {
                RasterFilterListManager colorTableManager = this.filterList.getManagerByID("ColorTable");
                Params params = this.filterList.createEmptyFilterParams();
                params.setParam("colorTable", (Object)tileColorTable);
                colorTableManager.addFilter(params);
            }
            catch (FilterManagerException e) {
                e.printStackTrace();
            }
            catch (FilterTypeException e) {
                e.printStackTrace();
            }
        }
    }

    public void endReading() {
        this.isDrawing = false;
    }

    public boolean isReading() {
        return this.isDrawing;
    }

    public void setReading(boolean reading) {
        this.isDrawing = reading;
    }

    private Extent request(ViewPortData vp, ICoordTrans coordTrans, RasterDataStore ldatastore) throws NoninvertibleTransformException {
        if (ldatastore.isRotated()) {
            Point2D ul = new Point2D.Double(vp.getExtent().minX(), vp.getExtent().maxY());
            Point2D ur = new Point2D.Double(vp.getExtent().maxX(), vp.getExtent().maxY());
            Point2D ll = new Point2D.Double(vp.getExtent().minX(), vp.getExtent().minY());
            Point2D lr = new Point2D.Double(vp.getExtent().maxX(), vp.getExtent().minY());
            ul = ldatastore.worldToRaster(ul);
            ur = ldatastore.worldToRaster(ur);
            ll = ldatastore.worldToRaster(ll);
            lr = ldatastore.worldToRaster(lr);
            double pxMaxX = Math.max(Math.max(ul.getX(), ur.getX()), Math.max(ll.getX(), lr.getX()));
            double pxMaxY = Math.max(Math.max(ul.getY(), ur.getY()), Math.max(ll.getY(), lr.getY()));
            double pxMinX = Math.min(Math.min(ul.getX(), ur.getX()), Math.min(ll.getX(), lr.getX()));
            double pxMinY = Math.min(Math.min(ul.getY(), ur.getY()), Math.min(ll.getY(), lr.getY()));
            pxMinX = Math.max(pxMinX, 0.0);
            pxMinY = Math.max(pxMinY, 0.0);
            pxMaxX = Math.min(pxMaxX, ldatastore.getWidth());
            pxMaxY = Math.min(pxMaxY, ldatastore.getHeight());
            this.ulPxRequest = new Point2D.Double(pxMinX, pxMinY);
            this.lrPxRequest = new Point2D.Double(pxMaxX, pxMaxY);
            this.widthImage = Math.abs(this.lrPxRequest.getX() - this.ulPxRequest.getX()) * vp.getWidth() / Math.abs(pxMaxX - pxMinX);
            this.heightImage = Math.abs(this.lrPxRequest.getY() - this.ulPxRequest.getY()) * vp.getHeight() / Math.abs(pxMaxY - pxMinY);
            Point2D ulWC = ldatastore.rasterToWorld(this.ulPxRequest);
            Point2D lrWC = ldatastore.rasterToWorld(this.lrPxRequest);
            return new ExtentImpl(ulWC, lrWC);
        }
        AffineTransform at = ldatastore.getAffineTransform();
        Extent adjustedRotedExtent = null;
        if (coordTrans != null) {
            Extent reprojectedExtent = ldatastore.getExtent().convert(coordTrans);
            double cellSizeX = (reprojectedExtent.getMax().getX() - reprojectedExtent.getMin().getX()) / ldatastore.getWidth();
            double cellSizeY = (reprojectedExtent.getMax().getY() - reprojectedExtent.getMin().getY()) / ldatastore.getHeight();
            Extent intersection = vp.getExtent().intersection(reprojectedExtent);
            at = new AffineTransform(cellSizeX, at.getShearY(), at.getShearX(), -cellSizeY, intersection.getMin().getX(), intersection.getMax().getY());
            double width = intersection.width() / cellSizeX;
            double height = intersection.height() / cellSizeY;
            adjustedRotedExtent = this.util.calculateAdjustedView(intersection, at, width, height);
        } else {
            adjustedRotedExtent = this.util.calculateAdjustedView(vp.getExtent(), at, ldatastore.getWidth(), ldatastore.getHeight());
        }
        this.widthImage = (int)Math.round(Math.abs(adjustedRotedExtent.width() * vp.getMat().getScaleX()));
        this.heightImage = (int)Math.round(Math.abs(adjustedRotedExtent.height() * vp.getMat().getScaleY()));
        Point2D ul = new Point2D.Double(adjustedRotedExtent.getMin().getX(), adjustedRotedExtent.getMax().getY());
        Point2D lr = new Point2D.Double(adjustedRotedExtent.getMax().getX(), adjustedRotedExtent.getMin().getY());
        Point2D worldUL = new Point2D.Double();
        Point2D worldLR = new Point2D.Double();
        if (coordTrans != null) {
            ul = at.inverseTransform(ul, worldUL);
            lr = at.inverseTransform(lr, worldLR);
        } else {
            worldUL = ldatastore.worldToRaster(ul);
            worldLR = ldatastore.worldToRaster(lr);
        }
        this.ulPxRequest = new Point2D.Double(worldUL.getX(), worldUL.getY());
        this.lrPxRequest = new Point2D.Double(worldLR.getX(), worldLR.getY());
        return adjustedRotedExtent;
    }

    public boolean isRenderingAsGray() {
        int[] renderBands = this.getRenderColorInterpretation().buildRenderBands();
        return renderBands != null && (renderBands.length == 3 || renderBands.length == 4) && renderBands[0] >= 0 && renderBands[0] == renderBands[1] && renderBands[1] == renderBands[2];
    }

    public void setRenderColorInterpretation(ColorInterpretation ci) {
        this.renderColorInterpretation = ci;
    }

    public ColorInterpretation getRenderColorInterpretation() {
        if (this.renderColorInterpretation == null) {
            this.renderColorInterpretation = this.dataStore.getColorInterpretation();
            if (this.renderColorInterpretation == null || !this.renderColorInterpretation.hasInterpretation()) {
                switch (this.dataStore.getBandCount()) {
                    case 1: 
                    case 2: {
                        this.renderColorInterpretation = DataStoreColorInterpretation.createGrayInterpretation();
                        break;
                    }
                    case 3: {
                        this.renderColorInterpretation = DataStoreColorInterpretation.createRGBInterpretation();
                        break;
                    }
                    case 4: {
                        this.renderColorInterpretation = DataStoreColorInterpretation.createRGBAInterpretation();
                    }
                    default: {
                        this.renderColorInterpretation = DataStoreColorInterpretation.createRGBInterpretation();
                        break;
                    }
                }
            } else {
                this.renderColorInterpretation = this.dataStore.getColorInterpretation().cloneColorInterpretation();
            }
        }
        return this.renderColorInterpretation;
    }

    public int[] formatArrayRenderBand(int[] b) {
        int cont = 0;
        for (int i = 0; i < b.length; ++i) {
            if (b[i] < 0) continue;
            ++cont;
        }
        if (cont <= 0) {
            return null;
        }
        int[] out = new int[cont];
        int pos = 0;
        for (int i = 0; i < cont; ++i) {
            while (b[pos] == -1) {
                ++pos;
            }
            out[i] = b[pos];
            ++pos;
        }
        return out;
    }

    public Transparency getRenderingTransparency() {
        if (this.renderingTransparency == null) {
            this.renderingTransparency = this.dataStore.getTransparency().cloneTransparency();
            this.renderingTransparency.addPropertyListener((PropertyListener)this);
        }
        this.renderingTransparency.setColorInterpretation(this.getRenderColorInterpretation());
        return this.renderingTransparency;
    }

    public int getLastAlphaBandNumber() {
        return this.lastAlphaBand;
    }

    public void setLastTransparency(Transparency lastTransparency) {
        this.renderingTransparency = lastTransparency;
        if (this.renderingTransparency != null) {
            this.renderingTransparency.addPropertyListener((PropertyListener)this);
        }
    }

    public RasterFilterList getFilterList() {
        return this.filterList;
    }

    public void setFilterList(RasterFilterList filterList) {
        this.filterList = filterList;
        this.filterList.addFilterListListener((FilterListChangeListener)this);
    }

    public boolean existColorTable() {
        if (this.filterList != null) {
            return this.filterList.getFilterByBaseClass(ColorTableFilter.class) != null;
        }
        return false;
    }

    public ColorTable getColorTable() {
        if (this.existColorTable()) {
            RasterFilter f = this.filterList.getFilterByBaseClass(ColorTableFilter.class);
            return ((ColorTableFilter)f).getColorTable();
        }
        return null;
    }

    public void setDataSource(RasterDataStore ds) {
        this.dataStore = ds;
    }

    public void actionValueChanged(PropertyEvent e) {
        this.callVisualPropertyChanged(new VisualPropertyEvent(e.getSource()));
    }

    public void filterListChanged(FilterListChangeEvent e) {
        this.callVisualPropertyChanged(new VisualPropertyEvent(e.getSource()));
    }

    public void dispose() {
        if (this.renderingTransparency != null) {
            this.renderingTransparency.dispose();
        }
        if (this.getFilterList() != null) {
            this.getFilterList().dispose();
        }
        try {
            this.finalize();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    protected void finalize() throws Throwable {
        this.dataStore = null;
        this.drawer = null;
        this.renderingTransparency = null;
        this.filterList = null;
        this.ulPxRequest = null;
        this.lrPxRequest = null;
        this.lastGraphics = null;
        this.lastViewPortData = null;
        this.viewDimension = null;
        if (this.visualPropertyListener != null) {
            this.visualPropertyListener.clear();
            this.visualPropertyListener = null;
        }
        super.finalize();
    }

    public static void registerPersistence() {
        PersistenceManager manager = ToolsLocator.getPersistenceManager();
        DynStruct definition = manager.getDefinition("DefaultRender_Persistent");
        if (definition == null) {
            definition = manager.addDefinition(DefaultRender.class, "DefaultRender_Persistent", "RasterRendering Persistent definition", null, null);
            definition.addDynFieldObject("lastTransparency").setClassOfValue(Transparency.class).setMandatory(false);
            definition.addDynFieldObject("filterList").setClassOfValue(RasterFilterList.class).setMandatory(false);
            definition.addDynFieldList("paramlist").setClassOfItems(PersistencyFilterParams.class).setMandatory(false);
        }
    }

    public void loadFromState(PersistentState state) throws PersistenceException {
        this.renderingTransparency = (Transparency)state.get("lastTransparency");
        this.renderColorInterpretation = this.renderingTransparency.getColorInterpretation();
        this.filterList = (RasterFilterList)state.get("filterList");
        this.listFilterParameters = state.getList("paramlist");
    }

    public void saveToState(PersistentState state) throws PersistenceException {
        state.set("lastTransparency", (Object)this.getRenderingTransparency());
        state.set("filterList", (Persistent)this.getFilterList());
        state.set("paramlist", this.buildPersistencyFilterParamFromFilters());
    }

    private List<PersistencyFilterParams> buildPersistencyFilterParamFromFilters() throws PersistenceException {
        ArrayList<PersistencyFilterParams> filters = new ArrayList<PersistencyFilterParams>();
        for (int i = 0; i < this.getFilterList().lenght(); ++i) {
            RasterFilter f = this.getFilterList().get(i);
            Params uipar = f.getUIParams(f.getName());
            PersistencyFilterParams param = new PersistencyFilterParams();
            param.setFilterParam(uipar);
            param.setFilterName(f.getName());
            try {
                RasterFilterListManager manager = this.getFilterList().getManagerByFilterClass(f.getClass());
                param.setManagerExtensionName(manager.getManagerID());
            }
            catch (FilterManagerException e) {
                throw new PersistenceException("Error getting filter manager ID", (Throwable)e);
            }
            filters.add(param);
        }
        return filters;
    }

    public void buildFiltersFromPersistencyFilterParam(Statistics stats) throws PersistenceException {
        this.filterList.addEnvParam("SrcStatistics", (Object)stats);
        this.setFilterList(this.filterList);
        ArrayList<Throwable> exc = new ArrayList<Throwable>();
        for (int i = 0; i < this.listFilterParameters.size(); ++i) {
            try {
                PersistencyFilterParams pfp = this.listFilterParameters.get(i);
                if (pfp == null || pfp.getFilterClass() == null || pfp.getFilterParams() == null) continue;
                RasterFilterListManager filterManager = this.filterList.getManagerByFilterClass(pfp.getFilterClass());
                filterManager.setFilterList(this.filterList);
                if (filterManager == null) continue;
                filterManager.addFilter(pfp.getFilterClass(), pfp.getFilterParams());
                continue;
            }
            catch (FilterTypeException e) {
                exc.add(e);
                continue;
            }
            catch (FilterManagerException e) {
                exc.add(e);
            }
        }
        if (exc.size() != 0) {
            throw new PersistenceException("error_adding_filters", (Throwable)exc.get(0));
        }
    }

    public Buffer draw(Graphics2D g, ViewPortData vp, TaskStatus taskStatus) throws QueryException, ProcessInterruptedException {
        IProjection vpProjection = vp.getProjection();
        IProjection dsProjection = this.dataStore.getProjection();
        ICoordTrans ct = null;
        if (vpProjection != null && dsProjection != null && !vpProjection.equals(dsProjection)) {
            ct = dsProjection.getCT(vpProjection);
        }
        return this.draw(g, vp, ct, taskStatus);
    }

    public void drawTiledService(Graphics2D g, ViewPortData vp, Dimension2D viewDimension, TaskStatus status) throws QueryException, ProcessInterruptedException {
        this.drawTiledService(g, vp, viewDimension, null, status);
    }
}

