/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.impl.provider;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import org.gvsig.fmap.dal.coverage.datastruct.SerialInfo;
import org.gvsig.fmap.dal.coverage.store.props.TimeSeries;
import org.gvsig.raster.impl.datastruct.DefaultSerialInfo;
import org.gvsig.timesupport.AbsoluteInstant;
import org.gvsig.timesupport.AbsoluteInterval;
import org.gvsig.timesupport.RelativeInstant;
import org.gvsig.timesupport.RelativeInterval;
import org.gvsig.timesupport.Time;

public class DefaultTimeSerials
implements TimeSeries {
    private ArrayList<DefaultSerialInfo> serial = new ArrayList();
    private String description = null;
    private String name = null;

    public void addSerialInfo(SerialInfo ser) {
        this.serial.add((DefaultSerialInfo)ser);
    }

    public void clearSerialInfoList() {
        this.serial.clear();
    }

    public void selectSerial(String name) {
        for (int i = 0; i < this.serial.size(); ++i) {
            if (this.serial.get(i).getSerialName().compareTo(name) != 0) continue;
            this.name = this.serial.get(i).getSerialName();
            this.description = this.serial.get(i).getDescription();
        }
    }

    public void selectSerial(int pos) {
        if (pos >= 0 && pos < this.serial.size()) {
            this.name = this.serial.get(pos).getSerialName();
            this.description = this.serial.get(pos).getDescription();
        }
    }

    public int getNumberOfSerials() {
        return this.serial.size();
    }

    public DefaultSerialInfo getSerial(String name) {
        for (int i = 0; i < this.serial.size(); ++i) {
            if (this.serial.get(i).getSerialName().compareTo(name) != 0) continue;
            return this.serial.get(i);
        }
        return null;
    }

    public DefaultSerialInfo getSerial(int pos) {
        return this.serial.get(pos);
    }

    public void setSerial(ArrayList<DefaultSerialInfo> serial) {
        this.serial = serial;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void removeIntervals() {
        this.serial.clear();
    }

    public void createNewTimeInterval(String dateA, String dateB) throws ParseException {
        DefaultSerialInfo tInfo = new DefaultSerialInfo();
        tInfo.setTimeType(1);
        tInfo.setDataType(1);
        tInfo.addValue(dateA);
        tInfo.addValue(dateB);
        tInfo.setDescription(this.description);
        tInfo.setSerialName(this.name);
        this.serial.add(tInfo);
    }

    public void createNewTimeValue(String value) throws ParseException {
        DefaultSerialInfo tInfo = new DefaultSerialInfo();
        tInfo.setTimeType(0);
        tInfo.setDataType(1);
        tInfo.addValue(value);
        tInfo.setDescription(this.description);
        tInfo.setSerialName(this.name);
        this.serial.add(tInfo);
    }

    public void createNewTimeInterval(double a, double b) throws ParseException {
        DefaultSerialInfo tInfo = new DefaultSerialInfo();
        tInfo.setTimeType(1);
        tInfo.setDataType(0);
        tInfo.addValue(a);
        tInfo.addValue(b);
        tInfo.setDescription(this.description);
        tInfo.setSerialName(this.name);
        this.serial.add(tInfo);
    }

    public void createNewTimeValue(double value) throws ParseException {
        DefaultSerialInfo tInfo = new DefaultSerialInfo();
        tInfo.setTimeType(0);
        tInfo.setDataType(0);
        tInfo.addValue(value);
        tInfo.setDescription(this.description);
        tInfo.setSerialName(this.name);
        this.serial.add(tInfo);
    }

    public void createNewTime(Time time) throws ParseException {
        String dateA;
        AbsoluteInstant t;
        if (time instanceof RelativeInstant) {
            this.createNewTimeValue(((RelativeInstant)time).toMillis());
        }
        if (time instanceof AbsoluteInstant) {
            t = (AbsoluteInstant)time;
            dateA = t.getDays() + "/" + t.getMonths() + "/" + t.getYears() + "-" + t.getHours() + "/" + t.getMinutes() + "/" + t.getSeconds();
            this.createNewTimeValue(dateA);
        }
        if (time instanceof AbsoluteInterval) {
            t = ((AbsoluteInterval)time).getStart();
            dateA = t.getDays() + "/" + t.getMonths() + "/" + t.getYears() + "-" + t.getHours() + "/" + t.getMinutes() + "/" + t.getSeconds();
            t = ((AbsoluteInterval)time).getEnd();
            String dateB = t.getDays() + "/" + t.getMonths() + "/" + t.getYears() + "-" + t.getHours() + "/" + t.getMinutes() + "/" + t.getSeconds();
            this.createNewTimeInterval(dateA, dateB);
        }
        if (time instanceof RelativeInterval) {
            t = ((RelativeInterval)time).getStart();
            double dateA2 = t.toMillis();
            t = ((RelativeInterval)time).getEnd();
            double dateB = t.toMillis();
            this.createNewTimeInterval(dateA2, dateB);
        }
    }

    public ArrayList<?> getTimeList() {
        ArrayList<Comparable<Date>> result = new ArrayList<Comparable<Date>>();
        for (int i = 0; i < this.serial.size(); ++i) {
            long r;
            long date2;
            long date1;
            DefaultSerialInfo dsi = this.serial.get(i);
            ArrayList<?> timeList = dsi.getTime();
            if (timeList.get(0).getClass() == Date.class) {
                if (timeList.size() > 1) {
                    date1 = ((Date)timeList.get(0)).getTime();
                    date2 = ((Date)timeList.get(timeList.size() - 1)).getTime();
                    r = date1 + (date2 - date1) / 2L;
                    Date newDate = new Date(r);
                    result.add(newDate);
                } else {
                    result.add((Comparable<Date>)timeList.get(0));
                }
            }
            if (timeList.get(0).getClass() != Double.class) continue;
            if (timeList.size() > 1) {
                date1 = ((Double)timeList.get(0)).longValue();
                date2 = ((Double)timeList.get(this.serial.size() - 1)).longValue();
                r = date1 + (date2 - date1) / 2L;
                result.add(new Double(r));
                continue;
            }
            result.add((Comparable<Date>)timeList.get(0));
        }
        return result;
    }
}

