/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.impl.provider;

import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import org.gvsig.fmap.dal.coverage.dataset.Buffer;
import org.gvsig.fmap.dal.coverage.datastruct.Extent;
import org.gvsig.fmap.dal.coverage.exception.ProcessInterruptedException;
import org.gvsig.raster.cache.tile.Tile;
import org.gvsig.raster.impl.DefaultRasterManager;
import org.gvsig.raster.impl.datastruct.ExtentImpl;

public class MemoryTileMatrixBuffer {
    private Buffer[] bufferList = null;
    private int nRows = 0;
    private int nCols = 0;
    private Extent bbox = null;
    private List<Tile> tileList = null;
    private int dataType = 32;

    public MemoryTileMatrixBuffer(Tile[] tileList) {
        this.tileList = new ArrayList<Tile>();
        this.bufferList = new Buffer[tileList.length];
        for (int i = 0; i < tileList.length; ++i) {
            this.tileList.add(tileList[i]);
            this.bufferList[i] = (Buffer)tileList[i].getData()[0];
            if (this.bufferList[i] == null) continue;
            this.dataType = this.bufferList[i].getDataType();
        }
        int minRow = Integer.MAX_VALUE;
        int maxRow = Integer.MIN_VALUE;
        int minCol = Integer.MAX_VALUE;
        int maxCol = Integer.MIN_VALUE;
        for (int i = 0; i < tileList.length; ++i) {
            if (tileList[i].getRow() > maxRow) {
                maxRow = tileList[i].getRow();
            }
            if (tileList[i].getCol() > maxCol) {
                maxCol = tileList[i].getCol();
            }
            if (tileList[i].getRow() < minRow) {
                minRow = tileList[i].getRow();
            }
            if (tileList[i].getCol() >= minCol) continue;
            minCol = tileList[i].getCol();
        }
        this.nRows = maxRow - minRow + 1;
        this.nCols = maxCol - minCol + 1;
        this.bbox = this.calculateBBox();
    }

    public MemoryTileMatrixBuffer(List<Tile> tileList) {
        this.tileList = tileList;
        this.bufferList = new Buffer[tileList.size()];
        for (int i = 0; i < tileList.size(); ++i) {
            this.bufferList[i] = (Buffer)tileList.get(i).getData()[0];
            if (this.bufferList[i] == null) continue;
            this.dataType = this.bufferList[i].getDataType();
        }
        int minRow = Integer.MAX_VALUE;
        int maxRow = Integer.MIN_VALUE;
        int minCol = Integer.MAX_VALUE;
        int maxCol = Integer.MIN_VALUE;
        for (int i = 0; i < tileList.size(); ++i) {
            if (tileList.get(i).getRow() > maxRow) {
                maxRow = tileList.get(i).getRow();
            }
            if (tileList.get(i).getCol() > maxCol) {
                maxCol = tileList.get(i).getCol();
            }
            if (tileList.get(i).getRow() < minRow) {
                minRow = tileList.get(i).getRow();
            }
            if (tileList.get(i).getCol() >= minCol) continue;
            minCol = tileList.get(i).getCol();
        }
        this.nRows = maxRow - minRow + 1;
        this.nCols = maxCol - minCol + 1;
        this.bbox = this.calculateBBox();
    }

    private Extent calculateBBox() {
        double minX = Double.MAX_VALUE;
        double minY = Double.MAX_VALUE;
        double maxX = 0.0;
        double maxY = 0.0;
        for (int i = 0; i < this.tileList.size(); ++i) {
            Rectangle2D e = this.tileList.get(i).getExtent();
            if (e.getX() < minX) {
                minX = e.getX();
            }
            if (e.getY() - e.getHeight() < minY) {
                minY = e.getY() - e.getHeight();
            }
            if (e.getX() + e.getWidth() > maxX) {
                maxX = e.getX() + e.getWidth();
            }
            if (!(e.getY() > maxY)) continue;
            maxY = e.getY();
        }
        return new ExtentImpl(minX, minY, maxX, maxY);
    }

    public Buffer getWindow(Rectangle2D r, int w, int h, int bandCount) {
        int shiftRow = 0;
        int shiftCol = 0;
        int posRow = 0;
        int posCol = 0;
        Rectangle2D[] rTileShiftList = new Rectangle2D[this.bufferList.length];
        Rectangle2D[] rBufferShiftList = new Rectangle2D[this.bufferList.length];
        int[] colsWidth = new int[this.nCols];
        int[] rowsHeight = new int[this.nRows];
        for (int i = 0; i < this.bufferList.length; ++i) {
            Rectangle2D pxLayer = this.tileList.get(i).getCoordsPx();
            int initPxTileX = (int)Math.max(pxLayer.getMinX(), r.getMinX()) - this.tileList.get(i).getCol() * this.tileList.get(i).getWidthPx();
            int initPxTileY = (int)Math.max(pxLayer.getMinY(), r.getMinY()) - this.tileList.get(i).getRow() * this.tileList.get(i).getHeightPx();
            int widthPxTile = (int)Math.min(pxLayer.getMaxX(), r.getMaxX()) - this.tileList.get(i).getCol() * this.tileList.get(i).getWidthPx() - initPxTileX;
            int heightPxTile = (int)Math.min(pxLayer.getMaxY(), r.getMaxY()) - this.tileList.get(i).getRow() * this.tileList.get(i).getHeightPx() - initPxTileY;
            rTileShiftList[i] = new Rectangle2D.Double(initPxTileX, initPxTileY, widthPxTile, heightPxTile);
            if (i == 0) {
                shiftCol = this.tileList.get(i).getCol();
                shiftRow = this.tileList.get(i).getRow();
            }
            posCol = this.tileList.get(i).getCol() - shiftCol;
            posRow = this.tileList.get(i).getRow() - shiftRow;
            colsWidth[posCol] = posCol == 0 ? widthPxTile : widthPxTile + colsWidth[posCol - 1];
            rowsHeight[posRow] = posRow == 0 ? heightPxTile : heightPxTile + rowsHeight[posRow - 1];
        }
        int initPxBufferX = 0;
        int initPxBufferY = 0;
        int widthPxBuffer = 0;
        int heightPxBuffer = 0;
        for (int i = 0; i < this.bufferList.length; ++i) {
            posCol = this.tileList.get(i).getCol() - shiftCol;
            posRow = this.tileList.get(i).getRow() - shiftRow;
            if (posCol == 0) {
                initPxBufferX = 0;
                widthPxBuffer = colsWidth[0];
            } else {
                initPxBufferX = colsWidth[posCol - 1];
                widthPxBuffer = colsWidth[posCol] - initPxBufferX;
            }
            if (posRow == 0) {
                initPxBufferY = 0;
                heightPxBuffer = rowsHeight[0];
            } else {
                initPxBufferY = rowsHeight[posRow - 1];
                heightPxBuffer = rowsHeight[posRow] - initPxBufferY;
            }
            rBufferShiftList[i] = new Rectangle2D.Double(initPxBufferX, initPxBufferY, widthPxBuffer, heightPxBuffer);
        }
        Buffer buf = DefaultRasterManager.getInstance().createBuffer(this.dataType, w, h, bandCount, true);
        for (int i = 0; i < this.bufferList.length; ++i) {
            this.loadBuffer(buf, this.bufferList[i], rTileShiftList[i], (int)rBufferShiftList[i].getX(), (int)rBufferShiftList[i].getY(), false);
        }
        return buf;
    }

    public Buffer getWindow(Extent requestExtent, int w, int h, int bandCount) {
        if (this.tileList.size() <= 0) {
            return null;
        }
        Buffer sourceWithoutResampling = this.createBufferWithoutResampling(requestExtent, this.tileList.get(0).getExtent(), this.bufferList[0], w, h, bandCount);
        double wcX1 = -1.0;
        double wcY1 = -1.0;
        int initXPxBuf = 0;
        int initYPxBuf = 0;
        for (int i = 0; i < this.bufferList.length; ++i) {
            Rectangle2D rTile = this.getClipPoints(this.tileList.get(i).getExtent(), this.bufferList[i], requestExtent);
            Extent adjustedRequestExtent = this.getAdjustedExtent(this.tileList.get(i).getExtent(), requestExtent);
            if (rTile.getX() == 0.0 && rTile.getWidth() == 0.0 || rTile.getY() == 0.0 && rTile.getHeight() == 0.0) continue;
            wcX1 = Math.abs(adjustedRequestExtent.getMin().getX() - requestExtent.getMin().getX());
            wcY1 = Math.abs(requestExtent.getMax().getY() - adjustedRequestExtent.getMax().getY());
            initXPxBuf = (int)Math.floor(wcX1 * (double)sourceWithoutResampling.getWidth() / requestExtent.width());
            initYPxBuf = (int)Math.floor(wcY1 * (double)sourceWithoutResampling.getHeight() / requestExtent.height());
            this.loadBuffer(sourceWithoutResampling, this.bufferList[i], rTile, initXPxBuf, initYPxBuf, false);
        }
        try {
            Buffer result = null;
            result = sourceWithoutResampling.getAdjustedWindow(w, h, 1);
            if (result != sourceWithoutResampling) {
                sourceWithoutResampling.dispose();
            }
            return result;
        }
        catch (ProcessInterruptedException processInterruptedException) {
            return null;
        }
    }

    private Rectangle2D getClipPoints(Rectangle2D extTile, Buffer b, Extent extentRequest) {
        double widthWCTile = extTile.getWidth();
        double widthPXTile = b.getWidth();
        double heightWCTile = extTile.getHeight();
        double heightPXTile = b.getHeight();
        Extent adjustedRequestExtent = this.getAdjustedExtent(extTile, extentRequest);
        double wcX1 = adjustedRequestExtent.getMin().getX() - extTile.getX();
        double wcX2 = adjustedRequestExtent.getMax().getX() - extTile.getX();
        double wcY1 = extTile.getY() - adjustedRequestExtent.getMax().getY();
        double wcY2 = extTile.getY() - adjustedRequestExtent.getMin().getY();
        int initXPxTile = (int)Math.floor(wcX1 * widthPXTile / widthWCTile);
        int endXPxTile = (int)Math.ceil(wcX2 * widthPXTile / widthWCTile);
        int initYPxTile = (int)Math.floor(wcY1 * heightPXTile / heightWCTile);
        int endYPxTile = (int)Math.ceil(wcY2 * heightPXTile / heightWCTile);
        endXPxTile = (double)endXPxTile >= widthPXTile ? (int)(widthPXTile - 1.0) : endXPxTile;
        endYPxTile = (double)endYPxTile >= heightPXTile ? (int)(heightPXTile - 1.0) : endYPxTile;
        return new Rectangle2D.Double(initXPxTile, initYPxTile, Math.abs(endXPxTile - initXPxTile + 1), Math.abs(endYPxTile - initYPxTile + 1));
    }

    private void loadBuffer(Buffer dstBuf, Buffer tileBuf, Rectangle2D rTile, int initXPxBuf, int initYPxBuf, boolean alpha) {
        int col;
        int row;
        int band;
        int r = initXPxBuf;
        int c = initYPxBuf;
        if (tileBuf.getDataType() == 0) {
            for (band = 0; band < tileBuf.getBandCount(); ++band) {
                r = initYPxBuf;
                for (row = (int)rTile.getMinY(); row < (int)rTile.getMaxY() && r < dstBuf.getHeight(); ++r, ++row) {
                    c = initXPxBuf;
                    for (col = (int)rTile.getMinX(); col < (int)rTile.getMaxX() && c < dstBuf.getWidth(); ++c, ++col) {
                        dstBuf.setElem(r, c, band, tileBuf.getElemByte(row, col, band));
                    }
                }
            }
        }
        if (tileBuf.getDataType() == 2) {
            for (band = 0; band < tileBuf.getBandCount(); ++band) {
                r = initYPxBuf;
                for (row = (int)rTile.getMinY(); row < (int)rTile.getMaxY() && r < dstBuf.getHeight(); ++r, ++row) {
                    c = initXPxBuf;
                    for (col = (int)rTile.getMinX(); col < (int)rTile.getMaxX() && c < dstBuf.getWidth(); ++c, ++col) {
                        dstBuf.setElem(r, c, band, tileBuf.getElemShort(row, col, band));
                    }
                }
            }
        }
        if (tileBuf.getDataType() == 3) {
            for (band = 0; band < tileBuf.getBandCount(); ++band) {
                r = initYPxBuf;
                for (row = (int)rTile.getMinY(); row < (int)rTile.getMaxY() && r < dstBuf.getHeight(); ++r, ++row) {
                    c = initXPxBuf;
                    for (col = (int)rTile.getMinX(); col < (int)rTile.getMaxX() && c < dstBuf.getWidth(); ++c, ++col) {
                        dstBuf.setElem(r, c, band, tileBuf.getElemInt(row, col, band));
                    }
                }
            }
        }
        if (tileBuf.getDataType() == 4) {
            for (band = 0; band < tileBuf.getBandCount(); ++band) {
                r = initYPxBuf;
                for (row = (int)rTile.getMinY(); row < (int)rTile.getMaxY() && r < dstBuf.getHeight(); ++r, ++row) {
                    c = initXPxBuf;
                    for (col = (int)rTile.getMinX(); col < (int)rTile.getMaxX() && c < dstBuf.getWidth(); ++c, ++col) {
                        dstBuf.setElem(r, c, band, tileBuf.getElemFloat(row, col, band));
                    }
                }
            }
        }
        if (tileBuf.getDataType() == 5) {
            for (band = 0; band < tileBuf.getBandCount(); ++band) {
                r = initYPxBuf;
                for (row = (int)rTile.getMinY(); row < (int)rTile.getMaxY() && r < dstBuf.getHeight(); ++r, ++row) {
                    c = initXPxBuf;
                    for (col = (int)rTile.getMinX(); col < (int)rTile.getMaxX() && c < dstBuf.getWidth(); ++c, ++col) {
                        dstBuf.setElem(r, c, band, tileBuf.getElemDouble(row, col, band));
                    }
                }
            }
        }
    }

    private Buffer createBufferWithoutResampling(Extent extOrigin, Rectangle2D extTile, Buffer bufTile, int originWidth, int originHeight, int bandCount) {
        double psOrigin = extOrigin.width() / (double)originWidth;
        double psTile = extTile.getWidth() / (double)bufTile.getWidth();
        double rel = psTile / psOrigin;
        int w = (int)Math.floor((double)originWidth / rel);
        int h = (int)Math.floor((double)originHeight / rel);
        return DefaultRasterManager.getInstance().createBuffer(this.dataType, w, h, bandCount, true);
    }

    private Extent getAdjustedExtent(Rectangle2D tileExtent, Extent extentRequest) {
        double x1 = Math.max(extentRequest.getMin().getX(), tileExtent.getX());
        double y1 = Math.min(extentRequest.getMax().getY(), tileExtent.getY());
        double x2 = Math.min(extentRequest.getMax().getX(), tileExtent.getX() + tileExtent.getWidth());
        double y2 = Math.max(extentRequest.getMin().getY(), tileExtent.getY() - tileExtent.getHeight());
        return new ExtentImpl(x1, y1, x2, y2);
    }

    public class Position {
        int col = 0;
        int row = 0;
    }
}

