/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.impl.provider.tile;

import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.swing.ImageIcon;
import org.gvsig.fmap.dal.coverage.RasterLocator;
import org.gvsig.fmap.dal.coverage.RasterManager;
import org.gvsig.fmap.dal.coverage.dataset.Buffer;
import org.gvsig.fmap.dal.coverage.dataset.BufferParam;
import org.gvsig.fmap.dal.coverage.datastruct.BandList;
import org.gvsig.fmap.dal.coverage.datastruct.Extent;
import org.gvsig.fmap.dal.coverage.datastruct.NoData;
import org.gvsig.fmap.dal.coverage.datastruct.Params;
import org.gvsig.fmap.dal.coverage.exception.BandNotFoundInListException;
import org.gvsig.fmap.dal.coverage.exception.BufferCreationException;
import org.gvsig.fmap.dal.coverage.exception.NotSupportedExtensionException;
import org.gvsig.fmap.dal.coverage.exception.ProcessInterruptedException;
import org.gvsig.fmap.dal.coverage.exception.QueryException;
import org.gvsig.fmap.dal.coverage.exception.RasterDriverException;
import org.gvsig.fmap.dal.coverage.store.DataServerWriter;
import org.gvsig.fmap.dal.coverage.store.RasterDataStore;
import org.gvsig.fmap.dal.coverage.store.RasterQuery;
import org.gvsig.fmap.dal.coverage.store.RasterWriter;
import org.gvsig.fmap.dal.coverage.store.props.ColorInterpretation;
import org.gvsig.fmap.dal.exception.InitializeException;
import org.gvsig.fmap.dal.exception.ProviderNotRegisteredException;
import org.gvsig.raster.cache.tile.Tile;
import org.gvsig.raster.cache.tile.exception.TileGettingException;
import org.gvsig.raster.cache.tile.provider.Downloader;
import org.gvsig.raster.impl.RasterDefaultImplLibrary;
import org.gvsig.raster.impl.datastruct.BandListImpl;
import org.gvsig.raster.impl.datastruct.DatasetBandImpl;
import org.gvsig.raster.impl.provider.AbstractRasterProvider;
import org.gvsig.raster.impl.provider.RasterProvider;
import org.gvsig.raster.impl.store.DefaultRasterStore;
import org.gvsig.raster.util.DefaultProviderServices;
import org.gvsig.tools.locator.LocatorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseTileDownloader
implements Downloader {
    private Logger log = LoggerFactory.getLogger(BaseTileDownloader.class);
    protected int tilePxWidth = 0;
    protected int tilePxHeight = 0;
    protected RasterDataStore store = null;
    protected byte byteNoData = 0;
    protected short shortNoData = Short.MIN_VALUE;
    protected int intNoData = Integer.MIN_VALUE;
    protected float floatNoData = -99999.0f;
    protected double doubleNoData = -99999.0;

    public BaseTileDownloader(RasterDataStore store, int tilePxWidth, int tilePxHeight) {
        this.store = store;
        this.tilePxWidth = tilePxWidth;
        this.tilePxHeight = tilePxHeight;
        if (store.getNoDataValue() != null && store.getNoDataValue().isDefined()) {
            this.setNoDataValue(store.getNoDataValue());
        }
    }

    public Object[] getDownloadingImage(int w, int h) {
        if (RasterDefaultImplLibrary.downloadingImg == null) {
            return null;
        }
        String key = w + "X" + h + "_Downloading";
        return new Object[]{this.getBufferFromImageIcon(w, h, key, RasterDefaultImplLibrary.downloadingImg)};
    }

    public Object[] getCrashImage(int w, int h) {
        if (RasterDefaultImplLibrary.crashImg == null) {
            return null;
        }
        String key = w + "X" + h + "_Crash";
        return new Object[]{this.getBufferFromImageIcon(w, h, key, RasterDefaultImplLibrary.crashImg)};
    }

    private Buffer getBufferFromImageIcon(int w, int h, String key, ImageIcon icon) {
        Buffer buf = RasterDefaultImplLibrary.defaultImages.get(key);
        if (buf == null) {
            int initY;
            try {
                BufferParam par = RasterLocator.getManager().getBufferFactory().createBufferParams(w, h, 4, 0, true);
                buf = RasterLocator.getManager().getBufferFactory().createBuffer(par);
            }
            catch (LocatorException e) {
                this.log.debug("Error creating buffers ", (Throwable)e);
            }
            catch (BufferCreationException e) {
                this.log.debug("Error creating buffers ", (Throwable)e);
            }
            byte[] background = new byte[]{-1, -1, -1, 50};
            for (int i = 0; i < buf.getHeight(); ++i) {
                for (int j = 0; j < buf.getWidth(); ++j) {
                    buf.setElemByte(j, i, background);
                }
            }
            BufferedImage img = new BufferedImage(icon.getIconWidth(), icon.getIconHeight(), 2);
            Graphics2D g = img.createGraphics();
            g.drawImage(icon.getImage(), 0, 0, null);
            int initX = w / 2 - img.getWidth() / 2;
            for (int i = initY = h / 2 - img.getHeight() / 2; i < img.getHeight() + initY; ++i) {
                for (int j = initX; j < img.getWidth() + initX; ++j) {
                    int value = img.getRGB(j - initX, i - initY);
                    buf.setElem(i, j, 0, (byte)((value & 0xFF0000) >> 16));
                    buf.setElem(i, j, 1, (byte)((value & 0xFF00) >> 8));
                    buf.setElem(i, j, 2, (byte)(value & 0xFF));
                    buf.setElem(i, j, 3, (byte)((value & 0xFF000000) >> 24));
                }
            }
            RasterDefaultImplLibrary.defaultImages.put(key, buf);
        }
        return buf;
    }

    public int[] getTileSize() {
        return new int[]{this.tilePxWidth, this.tilePxHeight};
    }

    public void setNoDataValue(NoData noData) {
        switch (this.store.getDataType()[0]) {
            case 0: {
                this.byteNoData = noData.getValue().byteValue();
                break;
            }
            case 2: {
                this.shortNoData = noData.getValue().shortValue();
                break;
            }
            case 3: {
                this.intNoData = noData.getValue().intValue();
                break;
            }
            case 4: {
                this.floatNoData = noData.getValue().floatValue();
                break;
            }
            case 5: {
                this.doubleNoData = noData.getValue().doubleValue();
            }
        }
    }

    public Tile readTileFromDisk(Tile tile) throws TileGettingException {
        if (!tile.getFile().exists()) {
            tile.setCorrupt(true);
            return null;
        }
        BandList bandList = (BandList)tile.getDownloaderParams("BandList");
        try {
            DefaultRasterStore tileStore = new DefaultRasterStore();
            AbstractRasterProvider tileProvider = DefaultProviderServices.loadProvider(tile.getFile());
            tileStore.setProvider(tileProvider);
            this.tilePxWidth = tile.getWidthPx();
            this.tilePxHeight = tile.getHeightPx();
            RasterQuery q = RasterLocator.getManager().createQuery();
            int[] renderBands = bandList.getDrawableBands();
            if (renderBands.length == 4 && renderBands[3] < tileProvider.getBandCount()) {
                q.forceARGBRequest();
            } else {
                q.forceRGBRequest();
            }
            q.setDrawableBands(bandList.getDrawableBands());
            Buffer buf = tileStore.query(q);
            tile.setData(new Object[]{buf, null, tileStore.getColorTable()});
            buf.setDataExtent(tileStore.getExtent().toRectangle2D());
            tileStore.close();
            return tile;
        }
        catch (ProcessInterruptedException e) {
            throw new TileGettingException((Throwable)e);
        }
        catch (ProviderNotRegisteredException e) {
            throw new TileGettingException((Throwable)e);
        }
        catch (InitializeException e) {
            throw new TileGettingException((Throwable)e);
        }
        catch (QueryException e) {
            throw new TileGettingException((Throwable)e);
        }
    }

    private BandList createBandListFromProvider(RasterProvider prov) {
        BandListImpl bandList = new BandListImpl();
        bandList.clear();
        int nBands = prov.getDataType()[0] == 0 ? prov.getBandCount() - 1 : prov.getBandCount();
        int[] drawableBands = new int[nBands];
        for (int i = 0; i < nBands; ++i) {
            try {
                int dataType = prov.getDataType()[i];
                DatasetBandImpl band = new DatasetBandImpl(new File(prov.getURIByBand(i)).getAbsolutePath(), prov.getBandPositionByProvider(i), dataType, nBands);
                bandList.addBand(band);
                drawableBands[i] = i;
                continue;
            }
            catch (BandNotFoundInListException bandNotFoundInListException) {
                // empty catch block
            }
        }
        bandList.setDrawableBands(drawableBands);
        return bandList;
    }

    protected void clearMaskBuffer(Buffer buf, int nBand) {
        if (buf.getDataType() == 0) {
            for (int i = 0; i < buf.getHeight(); ++i) {
                for (int j = 0; j < buf.getWidth(); ++j) {
                    buf.setElem(i, j, nBand, this.byteNoData);
                }
            }
            return;
        }
        if (buf.getDataType() == 2) {
            for (int i = 0; i < buf.getHeight(); ++i) {
                for (int j = 0; j < buf.getWidth(); ++j) {
                    buf.setElem(i, j, nBand, this.shortNoData);
                }
            }
            return;
        }
        if (buf.getDataType() == 3) {
            for (int i = 0; i < buf.getHeight(); ++i) {
                for (int j = 0; j < buf.getWidth(); ++j) {
                    buf.setElem(i, j, nBand, this.intNoData);
                }
            }
            return;
        }
        if (buf.getDataType() == 4) {
            for (int i = 0; i < buf.getHeight(); ++i) {
                for (int j = 0; j < buf.getWidth(); ++j) {
                    buf.setElem(i, j, nBand, this.floatNoData);
                }
            }
            return;
        }
        if (buf.getDataType() == 5) {
            for (int i = 0; i < buf.getHeight(); ++i) {
                for (int j = 0; j < buf.getWidth(); ++j) {
                    buf.setElem(i, j, nBand, this.doubleNoData);
                }
            }
            return;
        }
    }

    protected void saveTile(Buffer bufResult, double pixelSize, String extension, boolean alphaBand, Tile tile, Extent tileExtent, ColorInterpretation colorInterpretation) throws NotSupportedExtensionException, RasterDriverException, ProcessInterruptedException, IOException {
        RasterManager rManager = RasterLocator.getManager();
        DataServerWriter dataWriter = RasterLocator.getManager().createDataServerWriter();
        dataWriter.setBuffer(bufResult, -1);
        Params params = rManager.createWriter("_." + extension).getParams();
        AffineTransform affineTransform = new AffineTransform(pixelSize, 0.0, 0.0, -pixelSize, tileExtent.getULX(), tileExtent.getULY());
        RasterWriter rw = rManager.createWriter(dataWriter, tile.getFile().getAbsolutePath(), bufResult.getBandCount(), affineTransform, bufResult.getWidth(), bufResult.getHeight(), bufResult.getDataType(), params, null);
        if (colorInterpretation != null) {
            String[] values = colorInterpretation.getValues();
            if (alphaBand) {
                int i;
                String[] newValues = values;
                boolean exists = false;
                for (i = 0; i < values.length; ++i) {
                    if (values[i] == null || values[i].compareTo("Alpha") != 0) continue;
                    exists = true;
                }
                if (!exists) {
                    newValues = new String[values.length + 1];
                    for (i = 0; i < values.length; ++i) {
                        newValues[i] = values[i];
                    }
                    newValues[newValues.length - 1] = "Alpha";
                }
                rw.setColorBandsInterpretation(newValues);
            }
        } else if (alphaBand) {
            String[] ci = new String[bufResult.getBandCount()];
            if (bufResult.getBandCount() == 4) {
                ci[0] = "Red";
                ci[1] = "Green";
                ci[2] = "Blue";
                ci[3] = "Alpha";
            } else {
                for (int i = 0; i < bufResult.getBandCount(); ++i) {
                    ci[i] = "Gray";
                }
            }
            rw.setColorBandsInterpretation(ci);
        }
        rw.dataWrite();
        rw.writeClose();
        tile.setCorrupt(false);
    }
}

