/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.impl.store;

import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.cresques.cts.IProjection;
import org.gvsig.compat.net.ICancellable;
import org.gvsig.fmap.crs.CRSFactory;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataManager;
import org.gvsig.fmap.dal.DataParameters;
import org.gvsig.fmap.dal.DataServerExplorer;
import org.gvsig.fmap.dal.DataServerExplorerParameters;
import org.gvsig.fmap.dal.DataStoreParameters;
import org.gvsig.fmap.dal.DataStoreProviderFactory;
import org.gvsig.fmap.dal.coverage.RasterLocator;
import org.gvsig.fmap.dal.coverage.datastruct.BandList;
import org.gvsig.fmap.dal.coverage.datastruct.Extent;
import org.gvsig.fmap.dal.coverage.datastruct.GeoPointList;
import org.gvsig.fmap.dal.coverage.datastruct.NoData;
import org.gvsig.fmap.dal.coverage.exception.BandAccessException;
import org.gvsig.fmap.dal.coverage.exception.CloneException;
import org.gvsig.fmap.dal.coverage.exception.ConnectException;
import org.gvsig.fmap.dal.coverage.exception.FileNotOpenException;
import org.gvsig.fmap.dal.coverage.exception.InfoByPointException;
import org.gvsig.fmap.dal.coverage.exception.InvalidSetViewException;
import org.gvsig.fmap.dal.coverage.exception.InvalidSourceException;
import org.gvsig.fmap.dal.coverage.exception.NotSupportedExtensionException;
import org.gvsig.fmap.dal.coverage.exception.OperationNotSupportedException;
import org.gvsig.fmap.dal.coverage.exception.ROIException;
import org.gvsig.fmap.dal.coverage.exception.RasterDriverException;
import org.gvsig.fmap.dal.coverage.exception.RmfSerializerException;
import org.gvsig.fmap.dal.coverage.exception.TimeException;
import org.gvsig.fmap.dal.coverage.grid.render.Render;
import org.gvsig.fmap.dal.coverage.store.RasterDataServerExplorer;
import org.gvsig.fmap.dal.coverage.store.RasterDataStore;
import org.gvsig.fmap.dal.coverage.store.parameter.MultiDimensionalStoreParameters;
import org.gvsig.fmap.dal.coverage.store.parameter.RasterDataParameters;
import org.gvsig.fmap.dal.coverage.store.parameter.RemoteStoreParameters;
import org.gvsig.fmap.dal.coverage.store.parameter.TileDataParameters;
import org.gvsig.fmap.dal.coverage.store.props.ColorInterpretation;
import org.gvsig.fmap.dal.coverage.store.props.ColorTable;
import org.gvsig.fmap.dal.coverage.store.props.HistogramComputer;
import org.gvsig.fmap.dal.coverage.store.props.Metadata;
import org.gvsig.fmap.dal.coverage.store.props.Statistics;
import org.gvsig.fmap.dal.coverage.store.props.TimeSeries;
import org.gvsig.fmap.dal.coverage.store.props.Transparency;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.exception.InitializeException;
import org.gvsig.fmap.dal.exception.ProviderNotRegisteredException;
import org.gvsig.fmap.dal.raster.spi.CoverageStoreProvider;
import org.gvsig.fmap.dal.spi.DataManagerProviderServices;
import org.gvsig.fmap.dal.spi.DataStoreProviderServices;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.exception.CreateEnvelopeException;
import org.gvsig.fmap.geom.primitive.Envelope;
import org.gvsig.raster.cache.tile.Tile;
import org.gvsig.raster.cache.tile.exception.TileGettingException;
import org.gvsig.raster.impl.DefaultRasterManager;
import org.gvsig.raster.impl.buffer.SpiRasterQuery;
import org.gvsig.raster.impl.datastruct.BandListImpl;
import org.gvsig.raster.impl.grid.render.DefaultRender;
import org.gvsig.raster.impl.grid.roi.VectorialROIsReader;
import org.gvsig.raster.impl.provider.AbstractRasterProvider;
import org.gvsig.raster.impl.provider.RasterProvider;
import org.gvsig.raster.impl.provider.TiledRasterProvider;
import org.gvsig.raster.impl.store.AbstractRasterDataStore;
import org.gvsig.raster.impl.store.AbstractRasterFileDataParameters;
import org.gvsig.raster.impl.store.properties.MultiDataStoreMetadata;
import org.gvsig.raster.roi.ROI;
import org.gvsig.timesupport.Interval;
import org.gvsig.timesupport.Time;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DynObject;
import org.gvsig.tools.dynobject.DynStruct;
import org.gvsig.tools.persistence.PersistenceManager;
import org.gvsig.tools.persistence.Persistent;
import org.gvsig.tools.persistence.PersistentState;
import org.gvsig.tools.persistence.exception.PersistenceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultRasterStore
extends AbstractRasterDataStore {
    public static final String PERSISTENT_NAME = "DefaultRasterStore_Persistent";
    public static final String PERSISTENT_DESCRIPTION = "DefaultRasterStore Persistent";
    private static final Logger logger = LoggerFactory.getLogger(DefaultRasterStore.class);
    private List<ROI> rois = null;

    public void reload() {
        this.provider.reload();
    }

    public void setProvider(RasterProvider provider) {
        this.provider = provider;
        this.parameters = provider.getDataParameters();
        this.initializeBandList();
    }

    public void setParameters(DataStoreParameters p) {
        this.parameters = p;
    }

    public void setProvider(CoverageStoreProvider prov) {
        if (prov instanceof RasterProvider) {
            this.setProvider((RasterProvider)prov);
        }
    }

    public String getName() {
        if (this.provider != null) {
            return this.provider.getName();
        }
        return null;
    }

    public boolean needEnhanced() {
        if (this.provider != null) {
            return this.provider.needEnhanced();
        }
        return false;
    }

    public boolean isTiled() {
        return this.provider.isTiled();
    }

    public boolean isMosaic() {
        return this.provider.isMosaic();
    }

    @Override
    public Tile getTile(SpiRasterQuery q) throws TileGettingException {
        TiledRasterProvider tiledProv = (TiledRasterProvider)((Object)this.provider);
        return tiledProv.getTile(q);
    }

    public long getFileSize() {
        if (this.provider != null) {
            long size = 0L;
            long[] fSize = this.provider.getFileSizeByProvider();
            if (fSize != null && fSize.length > 0) {
                for (int j = 0; j < fSize.length; ++j) {
                    size += fSize[j];
                }
            }
            return size;
        }
        return 0L;
    }

    @Override
    public double getHeight() {
        return this.provider.getHeight();
    }

    @Override
    public double getWidth() {
        return this.provider.getWidth();
    }

    public double getCellSize() {
        try {
            Extent e = this.getExtent();
            double dCellsize = (e.getMax().getX() - e.getMin().getX()) / this.getWidth();
            return dCellsize;
        }
        catch (NullPointerException e) {
            return 1.0;
        }
    }

    @Override
    public int getBandCount() {
        return this.provider.getBandCount();
    }

    public int[] getDataType() {
        return this.provider.getDataType();
    }

    @Override
    public BandList getBands() {
        return this.storeBandList;
    }

    public double getMinX() {
        return this.provider.getExtent().getMin().getX();
    }

    public double getMinY() {
        return this.provider.getExtent().getMin().getY();
    }

    public double getMaxX() {
        return this.provider.getExtent().getMax().getX();
    }

    public double getMaxY() {
        return this.provider.getExtent().getMax().getY();
    }

    @Override
    public NoData getNoDataValue() {
        if (this.provider != null) {
            return this.provider.getNoDataValue();
        }
        return null;
    }

    public void setNoDataValue(NoData value) {
        this.provider.setNoDataValue(value);
    }

    @Override
    public Extent getExtent() {
        return this.provider.getExtent();
    }

    public Extent getExtentForRequest() {
        return this.provider.getExtentWithoutRot();
    }

    public Extent getLastSelectedView() {
        return this.provider.getView();
    }

    @Override
    public ColorTable getColorTable(int i) {
        return this.provider.getColorTable();
    }

    public ColorTable getColorTables() {
        return this.provider.getColorTable();
    }

    public ColorTable getColorTable() {
        if (this.provider != null) {
            return this.provider.getColorTable();
        }
        return null;
    }

    public void setColorTable(ColorTable colorTable) {
        this.provider.setColorTable(colorTable);
    }

    @Override
    public ColorTable getColorTable(String fileName) {
        return this.provider.getColorTable();
    }

    @Override
    public Point2D rasterToWorld(Point2D pt) {
        return this.provider.rasterToWorld(pt);
    }

    @Override
    public Point2D worldToRaster(Point2D pt) {
        return this.provider.worldToRaster(pt);
    }

    public boolean isGeoreferenced() {
        return this.provider.isGeoreferenced();
    }

    public double getPixelSizeX() {
        return this.provider.getPixelSizeX();
    }

    public double getPixelSizeY() {
        return this.provider.getPixelSizeY();
    }

    public Object getData(int x, int y, int band) throws InvalidSetViewException, FileNotOpenException, RasterDriverException {
        return this.provider.getData(x, y, band);
    }

    public String getWktProjection() throws RasterDriverException {
        if (this.provider != null) {
            return this.provider.getWktProjection();
        }
        return null;
    }

    public boolean isInside(Point2D p) {
        if (this.provider != null) {
            return this.provider.isInside(p);
        }
        return false;
    }

    @Override
    public RasterDataStore getDataStore() {
        return this;
    }

    public AffineTransform getAffineTransform(int band) {
        return this.provider.getAffineTransform();
    }

    public void setAffineTransform(AffineTransform transf) {
        this.provider.setAffineTransform(transf);
    }

    public AffineTransform getOwnTransformation() {
        return this.provider.getOwnAffineTransform();
    }

    public boolean isRotated() {
        if (this.provider != null) {
            return this.provider.isRotated();
        }
        return false;
    }

    @Override
    public void setDrawableBands(int[] db) {
        this.getBands().setDrawableBands(db);
    }

    @Override
    public int[] getDrawableBands() {
        return this.getBands().getDrawableBands();
    }

    @Override
    public void clearDrawableBands() {
        this.getBands().clearDrawableBands();
    }

    @Override
    public void addDrawableBand(int posRasterBuf, int imageBand) {
        this.getBands().addDrawableBand(posRasterBuf, imageBand);
    }

    public void deleteLayerFromCache() {
        this.provider.deleteLayerFromCache();
    }

    public boolean isMultiFile() {
        return this.provider.isMultiFile();
    }

    public int getOverviewWidth(int band, int overview) throws BandAccessException, RasterDriverException {
        return this.provider.getOverviewWidth(band, overview);
    }

    public int getOverviewHeight(int band, int overview) throws BandAccessException, RasterDriverException {
        return this.provider.getOverviewHeight(band, overview);
    }

    public int getOverviewCount(int band) throws BandAccessException, RasterDriverException {
        if (band >= this.getBandCount()) {
            throw new BandAccessException("Wrong band");
        }
        return this.provider.getOverviewCount(band);
    }

    public boolean overviewsSupport() {
        if (this.provider != null) {
            return this.provider.isOverviewsSupported();
        }
        return false;
    }

    public void saveGeoreferencingToRmf() throws RmfSerializerException {
        this.provider.saveObjectToRmf(AbstractRasterProvider.class, this.provider);
    }

    @Override
    public void saveSerialInfoToRmf(TimeSeries serialInfo) throws RmfSerializerException {
        this.provider.saveObjectToRmf(TimeSeries.class, serialInfo);
    }

    @Override
    public void saveColorTableToRmf(ColorTable table) throws RmfSerializerException {
        this.provider.saveObjectToRmf(ColorTable.class, table);
    }

    @Override
    public void saveGeoPointListToRmf(GeoPointList pointList) throws RmfSerializerException {
        this.provider.saveObjectToRmf(GeoPointList.class, pointList);
    }

    @Override
    public void saveROIFileListToRmf(List<File> fileList) throws RmfSerializerException {
        this.provider.saveObjectToRmf(List.class, fileList);
    }

    public List<File> getROIFileListFromRmf() {
        try {
            ArrayList<File> fileList = new ArrayList<File>();
            this.provider.loadObjectFromRmf(List.class, fileList);
            return fileList;
        }
        catch (RmfSerializerException rmfSerializerException) {
            return null;
        }
    }

    @Override
    public boolean loadSerialInfoFromRmf(TimeSeries serialInfo) {
        try {
            this.provider.loadObjectFromRmf(TimeSeries.class, serialInfo);
            return true;
        }
        catch (RmfSerializerException rmfSerializerException) {
            return false;
        }
    }

    public Extent getView() {
        if (this.provider != null) {
            return this.provider.getView();
        }
        return null;
    }

    public Extent getExtentWithoutRot() {
        if (this.provider != null) {
            return this.provider.getExtentWithoutRot();
        }
        return null;
    }

    public AffineTransform getOwnAffineTransform() {
        if (this.provider != null) {
            return this.provider.getOwnAffineTransform();
        }
        return null;
    }

    @Override
    public AffineTransform getAffineTransform() {
        if (this.provider != null) {
            return this.provider.getAffineTransform();
        }
        return null;
    }

    public IProjection getProjection() {
        if (this.provider != null) {
            return this.provider.getProjection();
        }
        return null;
    }

    public void setProjection(IProjection proj, boolean persist) throws RmfSerializerException {
        if (this.provider != null) {
            this.provider.setProjection(proj, persist);
        }
    }

    public Statistics getStatistics() {
        if (this.provider != null) {
            return this.provider.getStatistics();
        }
        return null;
    }

    public void setStatistics(Statistics stats) throws RmfSerializerException {
        if (this.provider != null) {
            this.provider.setStatistics(stats);
        }
    }

    public HistogramComputer getHistogramComputer() {
        if (this.provider != null) {
            return this.provider.getHistogramComputer();
        }
        return null;
    }

    public Metadata getMetadata() {
        if (this.provider != null) {
            return this.provider.getMetadata();
        }
        return null;
    }

    public Transparency getTransparency() {
        if (this.provider != null) {
            this.provider.getTransparency().setNoData(this.getNoDataValue());
            return this.provider.getTransparency();
        }
        return null;
    }

    public ColorInterpretation getColorInterpretation() {
        return this.provider.getColorInterpretation();
    }

    public void setColorInterpretation(ColorInterpretation ci) {
        this.provider.setColorInterpretation(ci);
    }

    public boolean isReproyectable() {
        if (this.provider != null) {
            return this.provider.isReproyectable();
        }
        return false;
    }

    public String getMetadataName() {
        if (this.provider != null) {
            return this.provider.getName();
        }
        return null;
    }

    public RasterDataStore cloneDataStore() throws CloneException {
        DefaultRasterStore ds = new DefaultRasterStore();
        ds.parameters = this.getParameters();
        ds.provider = this.provider.cloneProvider();
        int[] bands = new int[]{this.provider.getBandCount()};
        ds.metadata = new MultiDataStoreMetadata(bands);
        ((MultiDataStoreMetadata)ds.metadata).add(this.provider.getMetadata());
        ds.storeBandList = (BandListImpl)this.storeBandList.clone();
        return ds;
    }

    public boolean isOpen() {
        if (this.provider == null) {
            return false;
        }
        return this.provider.isOpen();
    }

    @Override
    public CoverageStoreProvider getProvider() {
        return this.provider;
    }

    public String getInfoByPoint(double x, double y, ICancellable cancellable) throws InfoByPointException {
        return ((RasterProvider)this.getProvider()).getInfoByPoint(x, y, cancellable);
    }

    public String getInfoByPoint(double x, double y, Extent bbox, int w, int h, ICancellable cancellable) throws InfoByPointException {
        return ((RasterProvider)this.getProvider()).getInfoByPoint((int)x, (int)y, bbox, w, h, cancellable);
    }

    public void goTo(int position) throws OperationNotSupportedException {
        if (!this.isTimeSupportedByTheProvider()) {
            throw new OperationNotSupportedException("Not supported for a RasterDataset");
        }
        if (this.getParameters() instanceof MultiDimensionalStoreParameters) {
            ((MultiDimensionalStoreParameters)this.getParameters()).goTo(position);
        }
    }

    public void selectNext() throws OperationNotSupportedException {
        if (!this.isTimeSupportedByTheProvider()) {
            throw new OperationNotSupportedException("Not supported for a RasterDataset");
        }
        if (this.getParameters() instanceof MultiDimensionalStoreParameters) {
            ((MultiDimensionalStoreParameters)this.getParameters()).selectNextInstant();
        }
    }

    public void selectPrev() throws OperationNotSupportedException {
        if (!this.isTimeSupportedByTheProvider()) {
            throw new OperationNotSupportedException("Not supported for a RasterDataset");
        }
        if (this.getParameters() instanceof MultiDimensionalStoreParameters) {
            ((MultiDimensionalStoreParameters)this.getParameters()).selectPrevInstant();
        }
    }

    public void setTime(Time time) throws TimeException, OperationNotSupportedException {
        if (!this.isTimeSupportedByTheProvider()) {
            throw new OperationNotSupportedException("Not supported for a RasterDataset");
        }
    }

    private boolean isTimeSupportedByTheProvider() {
        if (this.provider != null) {
            return this.provider.isTimeSupported();
        }
        return false;
    }

    public boolean isRasterEnclosed() {
        if (this.provider != null) {
            return this.provider.isRasterEnclosed();
        }
        return false;
    }

    public Extent getCoordsInLevel(Point2D viewCenter, int level, int w, int h) {
        try {
            return ((TiledRasterProvider)((Object)this.provider)).getCoordsInLevel(viewCenter, level, w, h);
        }
        catch (ClassCastException e) {
            return null;
        }
    }

    public Extent getCoordsInTheNearestLevel(Extent extent, int w, int h) {
        try {
            return ((TiledRasterProvider)((Object)this.provider)).getCoordsInTheNearestLevel(extent, w, h);
        }
        catch (ClassCastException e) {
            return null;
        }
    }

    public int getZoomLevels() {
        try {
            return ((TiledRasterProvider)((Object)this.provider)).getZoomLevels();
        }
        catch (ClassCastException e) {
            return -1;
        }
    }

    public int getNearestLevel(double pixelSize) {
        try {
            return ((TiledRasterProvider)((Object)this.provider)).getNearestLevel(pixelSize);
        }
        catch (ClassCastException e) {
            return -1;
        }
    }

    public void setTileServer(Class<?> tileServer) throws InitializeException {
        if (this.provider instanceof TiledRasterProvider) {
            ((TiledRasterProvider)((Object)this.provider)).setTileServer(tileServer);
        }
    }

    public RasterDataParameters getInternalParameters() {
        if (this.provider instanceof TiledRasterProvider) {
            AbstractRasterProvider prov = (AbstractRasterProvider)((TiledRasterProvider)((Object)this.provider)).getInternalProvider();
            return prov.getDataParameters();
        }
        return (RasterDataParameters)this.getParameters();
    }

    public RasterDataStore newDataStore() {
        if (this.provider != null) {
            DefaultRasterManager manager = (DefaultRasterManager)RasterLocator.getManager();
            RasterDataStore newDataStore = null;
            try {
                newDataStore = manager.getProviderServices().open(this.parameters);
                if (newDataStore instanceof DefaultRasterStore) {
                    ((DefaultRasterStore)newDataStore).setStatistics(this.getStatistics());
                }
                return newDataStore;
            }
            catch (NotSupportedExtensionException e) {
                return null;
            }
            catch (RasterDriverException e) {
                return null;
            }
            catch (RmfSerializerException e) {
                return newDataStore;
            }
        }
        return null;
    }

    public RasterDataStore newNotTiledDataStore() {
        if (this.provider != null) {
            DefaultRasterManager manager = (DefaultRasterManager)RasterLocator.getManager();
            RasterDataStore newDataStore = null;
            try {
                DataStoreParameters newParams = this.parameters;
                if (this.isTiled()) {
                    newParams = ((TiledRasterProvider)this.getProvider()).getInternalProvider().getDataParameters();
                }
                if ((newDataStore = manager.getProviderServices().open(newParams)) instanceof DefaultRasterStore) {
                    ((DefaultRasterStore)newDataStore).setStatistics(this.getStatistics());
                }
                return newDataStore;
            }
            catch (NotSupportedExtensionException e) {
                return null;
            }
            catch (RasterDriverException e) {
                return null;
            }
            catch (RmfSerializerException e) {
                return newDataStore;
            }
        }
        return null;
    }

    public URI[] getURIByProvider() {
        return this.provider.getURIByProvider();
    }

    public long[] getFileSizeByProvider() {
        return this.provider.getFileSizeByProvider();
    }

    public int getProviderCount() {
        return this.provider.getInternalProviderCount();
    }

    public int[] getBandCountByProvider() {
        return this.provider.getBandCountByProvider();
    }

    public RasterDataParameters[] getDataParametersByProvider() {
        RasterDataParameters[] res = new RasterDataParameters[this.getProviderCount()];
        for (int i = 0; i < res.length; ++i) {
            res[i] = this.provider.getInternalProvider(i).getDataParameters();
        }
        return res;
    }

    public Metadata[] getMetadataByProvider() {
        Metadata[] res = new Metadata[this.getProviderCount()];
        for (int i = 0; i < res.length; ++i) {
            res[i] = this.provider.getInternalProvider(i).getMetadata();
        }
        return res;
    }

    public int[] getOverviewCountByProvider(int band) throws BandAccessException {
        int[] res = new int[this.getProviderCount()];
        for (int i = 0; i < res.length; ++i) {
            try {
                res[i] = this.provider.getInternalProvider(i).getOverviewCount(band);
                continue;
            }
            catch (RasterDriverException e) {
                throw new BandAccessException("", (Throwable)e);
            }
        }
        return res;
    }

    public String[] getOverviewSizeByProvider(int band, int overview) throws BandAccessException {
        String[] res = new String[this.getProviderCount()];
        for (int i = 0; i < res.length; ++i) {
            try {
                res[i] = this.provider.getInternalProvider(i).getOverviewWidth(band, overview) + "x" + this.provider.getInternalProvider(i).getOverviewHeight(band, overview);
                continue;
            }
            catch (RasterDriverException e) {
                throw new BandAccessException("", (Throwable)e);
            }
        }
        return res;
    }

    public AffineTransform[] getAffineTransformByProvider() {
        AffineTransform[] res = new AffineTransform[this.getProviderCount()];
        for (int i = 0; i < res.length; ++i) {
            res[i] = this.provider.getInternalProvider(i).getAffineTransform();
        }
        return res;
    }

    public double[] getHeightByProvider() {
        double[] res = new double[this.getProviderCount()];
        for (int i = 0; i < res.length; ++i) {
            res[i] = this.provider.getInternalProvider(i).getHeight();
        }
        return res;
    }

    public double[] getWidthByProvider() {
        double[] res = new double[this.getProviderCount()];
        for (int i = 0; i < res.length; ++i) {
            res[i] = this.provider.getInternalProvider(i).getWidth();
        }
        return res;
    }

    public void addFile(File file) throws InvalidSourceException {
        this.provider.addFile(file);
    }

    public void removeFile(File file) {
        this.provider.removeFile(file);
        this.storeBandList.removeBands(file.getPath());
    }

    public URI getURIByBand(int band) {
        return this.provider.getURIByBand(band);
    }

    public Interval getInterval() {
        return this.provider.getInterval();
    }

    public Collection<?> getTimes() {
        return this.provider.getTimes();
    }

    public Collection<?> getTimes(Interval interval) {
        return this.provider.getTimes(interval);
    }

    public Image getImageLegend() {
        if (this.provider != null) {
            return this.provider.getImageLegend();
        }
        return null;
    }

    public GeoPointList getGeoPointList() {
        return this.provider.getGeoPointList();
    }

    public void setGeoPointList(GeoPointList geoPointList) {
        this.provider.setGeoPointList(geoPointList);
    }

    public Envelope getFullEnvelope() {
        Rectangle2D e = this.getExtent().toRectangle2D();
        try {
            return GeometryLocator.getGeometryManager().createEnvelope(e.getX(), e.getY(), e.getMaxX(), e.getMaxY(), 0);
        }
        catch (CreateEnvelopeException e1) {
            logger.error("Error creating the envelope", (Object)e);
            return null;
        }
    }

    public List<ROI> getRois(String epsg) throws ROIException {
        IProjection proj = CRSFactory.getCRS((String)epsg);
        return this.getRois(proj);
    }

    public List<ROI> getRois(IProjection defaultProjection) throws ROIException {
        if (this.rois == null) {
            try {
                List fileList = this.getDataStore().getROIFileListFromRmf();
                if (fileList != null && fileList.size() > 0 && fileList.get(0) != null) {
                    File f = (File)fileList.get(0);
                    IProjection proj = this.getProjection();
                    if (proj == null) {
                        proj = defaultProjection;
                    }
                    VectorialROIsReader reader = new VectorialROIsReader(f.getPath(), this.getDataStore(), proj, this.getFullEnvelope());
                    this.rois = new ArrayList<ROI>();
                    this.rois = reader.read(this.rois);
                }
            }
            catch (Exception e) {
                throw new ROIException("error_getting_ROIS", (Throwable)e);
            }
        }
        return this.rois;
    }

    public void setRois(List<ROI> rois) {
        this.rois = rois;
    }

    public void setROIsFiles(List<File> file) throws RmfSerializerException {
        this.getDataStore().saveROIFileListToRmf(file);
    }

    public List<File> getROIsFiles() throws RmfSerializerException {
        return this.getDataStore().getROIFileListFromRmf();
    }

    @Override
    public void close() {
        if (this.provider != null) {
            this.provider.close();
        }
        if (this.storeBandList != null) {
            this.storeBandList.clear();
        }
        this.provider = null;
        this.storeBandList = null;
        super.close();
        try {
            this.finalize();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    protected void finalize() throws Throwable {
        this.provider = null;
        this.storeBandList = null;
        this.metadata = null;
        if (this.rois != null) {
            this.rois.clear();
            this.rois = null;
        }
        super.finalize();
    }

    public static void registerPersistence() {
        PersistenceManager manager = ToolsLocator.getPersistenceManager();
        DynStruct definition = manager.getDefinition(PERSISTENT_NAME);
        if (definition == null) {
            definition = manager.addDefinition(DefaultRasterStore.class, PERSISTENT_NAME, PERSISTENT_DESCRIPTION, null, null);
            definition.addDynFieldObject("parameters").setClassOfValue(RasterDataParameters.class).setMandatory(true);
            definition.addDynFieldString("explorername").setMandatory(false);
            definition.addDynFieldObject("bandList").setClassOfValue(BandList.class).setMandatory(false);
            definition.addDynFieldObject("metadata").setClassOfValue(Metadata.class).setMandatory(false);
            definition.addDynFieldObject("render").setClassOfValue(Render.class).setMandatory(false);
        }
    }

    public void loadFromState(PersistentState state) throws PersistenceException {
        this.parameters = (RasterDataParameters)state.get("parameters");
        String explorerName = (String)state.get("explorername");
        if (explorerName != null && this.initializePersistentParameters((RasterDataParameters)this.parameters, explorerName) == null) {
            throw new PersistenceException();
        }
        try {
            DataManagerProviderServices dataManager = (DataManagerProviderServices)DALLocator.getDataManager();
            this.provider = (AbstractRasterProvider)dataManager.createProvider((DataStoreProviderServices)this, this.parameters);
        }
        catch (InitializeException e) {
            throw new PersistenceException((Throwable)e);
        }
        catch (ProviderNotRegisteredException e) {
            throw new PersistenceException((Throwable)e);
        }
        this.storeBandList = (BandListImpl)state.get("bandList");
        if (this.parameters instanceof AbstractRasterFileDataParameters && !this.provider.isMultiFile()) {
            try {
                for (int i = 0; i < this.storeBandList.getBandCount(); ++i) {
                    this.storeBandList.getBand(i).setFileName(new File(this.provider.getURI()).getAbsolutePath());
                }
            }
            catch (Exception e) {
                logger.warn("Couldn't get file for " + this.provider.getURI() + " when creating Band List Store");
            }
        }
        this.metadata = (Metadata)state.get("metadata");
        DefaultRender render = (DefaultRender)state.get("render");
        if (render == null) {
            throw new PersistenceException();
        }
        this.setRender(render);
        render.setDataStore(this);
        render.buildFiltersFromPersistencyFilterParam(this.getStatistics());
        if (this.getRender().getRenderingTransparency() != null) {
            this.getRender().getRenderingTransparency().setNoData(this.getNoDataValue());
        }
    }

    public void saveToState(PersistentState state) throws PersistenceException {
        state.set("parameters", (Persistent)this.provider.getDataParameters());
        RasterDataParameters provParams = this.getInternalDataParameterFromState(this.provider.getDataParameters());
        state.set("explorername", provParams.getDataStoreName());
        state.set("bandList", (Persistent)this.storeBandList);
        state.set("metadata", (Object)this.metadata);
        state.set("render", (Object)this.getRender());
    }

    private RasterDataParameters initializePersistentParameters(RasterDataParameters providerParams, String explorerName) {
        block7: {
            try {
                if (!(this.getInternalDataParameterFromState(providerParams) instanceof RemoteStoreParameters)) {
                    return providerParams;
                }
                DataManager datamanager = DALLocator.getDataManager();
                DataServerExplorerParameters explorerParams = null;
                explorerParams = datamanager.createServerExplorerParameters(explorerName);
                explorerParams.setDynValue("host", (Object)"");
                DataServerExplorer e = datamanager.openServerExplorer(explorerName, explorerParams);
                if (!(e instanceof RasterDataServerExplorer)) break block7;
                this.explorer = (RasterDataServerExplorer)e;
                explorerParams = this.explorer.getParameters();
                explorerParams.setDynValue("host", (Object)providerParams.getURI());
                if (!this.explorer.isHostReachable()) {
                    return null;
                }
                try {
                    this.explorer.connect(null);
                }
                catch (ConnectException exc) {
                    return null;
                }
                RasterDataParameters newParameters = this.getInternalDataParameterFromState(this.explorer.getStoredParameters());
                newParameters.assignFields(this.getInternalDataParameterFromState(providerParams), this.explorer);
                if (providerParams instanceof TileDataParameters) {
                    ((TileDataParameters)providerParams).setDataParameters((DataParameters)newParameters);
                }
                return providerParams;
            }
            catch (Exception e) {
                logger.warn("Error initializing persistent parameters", (Throwable)e);
                return null;
            }
        }
        return null;
    }

    private RasterDataParameters getInternalDataParameterFromState(Object obj) {
        if (obj instanceof TileDataParameters) {
            return (RasterDataParameters)((TileDataParameters)obj).getDataParameters();
        }
        return (RasterDataParameters)obj;
    }

    @Override
    public void useCache(String providerName, DynObject parameters) throws DataException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public DataStoreProviderFactory getProviderFactory() {
        return DALLocator.getDataManager().getStoreProviderFactory(this.parameters.getDataStoreName());
    }
}

