/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.impl.store;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.gvsig.fmap.dal.coverage.datastruct.Param;
import org.gvsig.fmap.dal.coverage.datastruct.Params;
import org.gvsig.fmap.dal.coverage.grid.RegistrableFilterListener;
import org.gvsig.raster.util.persistence.GenericPersistentObject;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DynStruct;
import org.gvsig.tools.extensionpoint.ExtensionPoint;
import org.gvsig.tools.extensionpoint.ExtensionPointManager;
import org.gvsig.tools.persistence.PersistenceManager;
import org.gvsig.tools.persistence.Persistent;
import org.gvsig.tools.persistence.PersistentState;
import org.gvsig.tools.persistence.exception.PersistenceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParamImpl
implements Param {
    private Logger log = LoggerFactory.getLogger(ParamImpl.class);
    private int type = -1;
    private String id = null;
    private Object defaultValue = null;
    private String[] list = null;
    private String managerID = null;

    public void setManagerID(String id) {
        this.managerID = id;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(Object defaultValue) {
        this.defaultValue = defaultValue;
    }

    public String[] getList() {
        return this.list;
    }

    public void setList(String[] list) {
        this.list = list;
    }

    public void loadFromState(PersistentState state) throws PersistenceException {
        this.type = state.getInt("type");
        this.id = state.getString("id");
        if (state.get("defaultValue") == null) {
            this.loadPanel(state);
        } else {
            this.defaultValue = ((GenericPersistentObject)state.get("defaultValue")).getObject();
        }
        List list = state.getList("list");
        if (list != null) {
            this.list = new String[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                this.list[i] = (String)list.get(i);
            }
        }
    }

    private void loadPanel(PersistentState state) throws PersistenceException {
        this.managerID = state.getString("managerID");
        if (this.managerID == null) {
            return;
        }
        Params paramsForUI = (Params)state.get("paramsForUI");
        RegistrableFilterListener panel = (RegistrableFilterListener)this.getPanelObject(this.managerID);
        panel.setParams(paramsForUI);
        this.defaultValue = panel;
    }

    private Object getPanelObject(String filterID) {
        try {
            ExtensionPointManager extensionPoints = ToolsLocator.getExtensionPointManager();
            ExtensionPoint point = extensionPoints.get("PanelRasterFilter");
            Class c = point.get(filterID).getExtension();
            Constructor hazNuevo = c.getConstructor(new Class[0]);
            return hazNuevo.newInstance(new Object[0]);
        }
        catch (IllegalArgumentException e) {
            this.log.debug("Error loading filter class", (Throwable)e);
        }
        catch (InstantiationException e) {
            this.log.debug("Error loading filter class", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            this.log.debug("Error loading filter class", (Throwable)e);
        }
        catch (InvocationTargetException e) {
            this.log.debug("Error loading filter class", (Throwable)e);
        }
        catch (SecurityException e) {
            this.log.debug("Error loading filter class", (Throwable)e);
        }
        catch (NoSuchMethodException e) {
            this.log.debug("Error loading filter class", (Throwable)e);
        }
        return null;
    }

    public void saveToState(PersistentState state) throws PersistenceException {
        state.set("type", this.type);
        state.set("id", this.id);
        if (this.defaultValue instanceof RegistrableFilterListener) {
            this.savePanel(state);
            state.setNull("defaultValue");
        } else {
            state.set("defaultValue", (Persistent)GenericPersistentObject.create(this.defaultValue));
        }
        state.set("list", this.list);
    }

    private void savePanel(PersistentState state) throws PersistenceException {
        Params p = ((RegistrableFilterListener)this.defaultValue).getParams();
        state.set("paramsForUI", (Persistent)p);
        state.set("managerID", this.managerID);
    }

    public static void registerPersistence() {
        PersistenceManager manager = ToolsLocator.getPersistenceManager();
        DynStruct definition = manager.addDefinition(ParamImpl.class, "ParamImpl_Persistence", "ParamImpl Persistence", null, null);
        definition.addDynFieldInt("type").setMandatory(false);
        definition.addDynFieldString("id").setMandatory(false);
        definition.addDynFieldObject("defaultValue").setClassOfValue(GenericPersistentObject.class).setMandatory(false);
        definition.addDynFieldList("list").setClassOfItems(String.class).setMandatory(false);
        definition.addDynFieldObject("paramsForUI").setClassOfValue(Params.class).setMandatory(false);
        definition.addDynFieldString("managerID").setMandatory(false);
    }
}

