/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.impl.store.properties;

import java.util.ArrayList;
import java.util.List;
import org.gvsig.fmap.dal.coverage.dataset.Buffer;
import org.gvsig.fmap.dal.coverage.datastruct.NoData;
import org.gvsig.fmap.dal.coverage.datastruct.TransparencyRange;
import org.gvsig.fmap.dal.coverage.store.props.ColorInterpretation;
import org.gvsig.fmap.dal.coverage.store.props.Transparency;
import org.gvsig.fmap.dal.coverage.util.PropertyEvent;
import org.gvsig.fmap.dal.coverage.util.PropertyListener;
import org.gvsig.raster.impl.store.properties.DataStoreMetadata;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DynStruct;
import org.gvsig.tools.persistence.PersistenceManager;
import org.gvsig.tools.persistence.Persistent;
import org.gvsig.tools.persistence.PersistentState;
import org.gvsig.tools.persistence.exception.PersistenceException;

public class DataStoreTransparency
implements Transparency,
Persistent {
    public static int MAX_OPACITY = 255;
    protected ColorInterpretation colorInterpretation = null;
    protected Buffer originalData = null;
    protected NoData noData = null;
    protected List<TransparencyRange> transparencyRanges = new ArrayList<TransparencyRange>();
    protected int opacity = 255;
    private List<PropertyListener> transparencyPropertyListener = new ArrayList<PropertyListener>();
    private boolean transparencyActive = false;

    public DataStoreTransparency() {
    }

    public DataStoreTransparency(ColorInterpretation colorInterpretation) {
        this.colorInterpretation = colorInterpretation;
    }

    public static void mergeBuffers(Buffer src1, Buffer src2) {
        for (int y = 0; y < src1.getHeight(); ++y) {
            for (int x = 0; x < src1.getWidth(); ++x) {
                src1.setElem(y, x, 0, (byte)((double)((src1.getElemByte(y, x, 0) & 0xFF) * (src2.getElemByte(y, x, 0) & 0xFF)) / 255.0));
            }
        }
    }

    public void addPropertyListener(PropertyListener listener) {
        this.transparencyPropertyListener.add(listener);
    }

    private void callPropertyChanged(Object obj) {
        for (int i = 0; i < this.transparencyPropertyListener.size(); ++i) {
            PropertyEvent ev = new PropertyEvent((Object)this, "transparency", null, null);
            this.transparencyPropertyListener.get(i).actionValueChanged(ev);
        }
    }

    public boolean existAlphaBand() {
        return this.getAlphaBandNumber() >= 0;
    }

    public Buffer getDataBuffer() {
        return this.originalData;
    }

    public void setDataBuffer(Buffer b) {
        this.originalData = b;
    }

    public NoData getNoData() {
        return this.noData;
    }

    public void setNoData(NoData noData) {
        if (this.noData != noData) {
            this.callPropertyChanged(this);
        }
        this.noData = noData;
    }

    public List<TransparencyRange> getTransparencyRange() {
        return this.transparencyRanges;
    }

    public void setTransparencyRange(TransparencyRange range) {
        this.transparencyRanges.add(range);
        this.callPropertyChanged(this);
    }

    public void setTransparencyRangeList(List<TransparencyRange> ranges) {
        this.transparencyRanges = ranges;
        this.callPropertyChanged(this);
    }

    public void clearListOfTransparencyRange() {
        this.transparencyRanges.clear();
        this.callPropertyChanged(this);
    }

    public int getOpacity() {
        return this.opacity;
    }

    public void setOpacity(int opacity) {
        if (opacity != this.opacity) {
            this.callPropertyChanged(this);
        }
        this.opacity = opacity;
    }

    public void setTransparencyByPixelFromMetadata(DataStoreMetadata metadata) {
        if (metadata != null) {
            TransparencyRange[] noData = metadata.parserNodataInMetadata();
            if (noData != null) {
                for (int i = 0; i < noData.length; ++i) {
                    this.getTransparencyRange().add(noData[i]);
                }
            }
            TransparencyRange noDataValue = metadata.parserNodataByBand();
            if (noData == null && noDataValue != null) {
                this.getTransparencyRange().add(noDataValue);
            }
        }
    }

    public int getAlphaBandNumber() {
        return this.colorInterpretation.getAlphaBand();
    }

    public void setTransparencyBand(int alphaBandNumber) {
        this.colorInterpretation.setColorInterpValue(alphaBandNumber, "Alpha");
    }

    protected boolean isNoData(int line, int col) {
        if (this.noData == null) {
            return false;
        }
        if (this.noData.isDefined()) {
            block7: for (int iBand = 0; iBand < this.originalData.getBandCount(); ++iBand) {
                switch (this.originalData.getDataType()) {
                    case 0: {
                        if (this.originalData.getElemByte(line, col, iBand) != this.noData.getValue().byteValue()) continue block7;
                        return true;
                    }
                    case 2: {
                        if (this.originalData.getElemShort(line, col, iBand) != this.noData.getValue().shortValue()) continue block7;
                        return true;
                    }
                    case 3: {
                        if (this.originalData.getElemInt(line, col, iBand) != this.noData.getValue().intValue()) continue block7;
                        return true;
                    }
                    case 4: {
                        float f = this.originalData.getElemFloat(line, col, iBand);
                        if (f != this.noData.getValue().floatValue() && !Float.isNaN(f)) continue block7;
                        return true;
                    }
                    case 5: {
                        double d = this.originalData.getElemDouble(line, col, iBand);
                        if (d != this.noData.getValue().doubleValue() && !Double.isNaN(d)) continue block7;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public void activeTransparency() {
        this.transparencyActive = this.existAlphaBand() || this.getNoData() != null && this.getNoData().isDefined() && this.getNoData().isNoDataTransparent() || this.transparencyRanges.size() > 0 || this.opacity != 255;
    }

    public boolean isTransparencyActive() {
        return this.transparencyActive;
    }

    public void setTransparencyActive(boolean transparencyActive) {
        this.transparencyActive = transparencyActive;
    }

    public int processRGB(int r, int g, int b, int line, int col, Buffer buf) {
        if (this.originalData != null && this.getNoData().isDefined() && this.getNoData().isNoDataTransparent() && this.isNoData(line, col)) {
            return r << 16 | g << 8 | b;
        }
        double a = this.opacity;
        int alphaRange = this.processRange(r, g, b);
        if (alphaRange != 255) {
            a *= (double)alphaRange / 255.0;
        }
        if (this.existAlphaBand() && buf != null) {
            a *= (double)(buf.getElemByte(line, col, this.getAlphaBandNumber()) & 0xFF) / 255.0;
        }
        return (int)a << 24 | r << 16 | g << 8 | b;
    }

    private int processRange(int r, int g, int b) {
        for (int i = 0; i < this.transparencyRanges.size(); ++i) {
            TransparencyRange tr = this.transparencyRanges.get(i);
            if (tr == null) continue;
            if (tr.isAnd()) {
                if (tr.getRed() == null || tr.getGreen() == null || tr.getBlue() == null || r < tr.getRed()[0] || r > tr.getRed()[1] || g < tr.getGreen()[0] || g > tr.getGreen()[1] || b < tr.getBlue()[0] || b > tr.getBlue()[1]) continue;
                return tr.getAlpha();
            }
            if (tr.getRed() != null && r >= tr.getRed()[0] && r <= tr.getRed()[1]) {
                return tr.getAlpha();
            }
            if (tr.getGreen() != null && g >= tr.getGreen()[0] && g <= tr.getGreen()[1]) {
                return tr.getAlpha();
            }
            if (tr.getBlue() == null || b < tr.getBlue()[0] || b > tr.getBlue()[1]) continue;
            return tr.getAlpha();
        }
        return 255;
    }

    public void setColorInterpretation(ColorInterpretation colorInterpretation) {
        this.colorInterpretation = colorInterpretation;
    }

    public Transparency cloneTransparency() {
        DataStoreTransparency t = new DataStoreTransparency(this.colorInterpretation.cloneColorInterpretation());
        t.transparencyRanges = (ArrayList)((ArrayList)this.getTransparencyRange()).clone();
        t.opacity = this.getOpacity();
        t.noData = this.getNoData();
        t.originalData = this.originalData;
        t.transparencyActive = this.transparencyActive;
        t.activeTransparency();
        return t;
    }

    public void loadFromState(PersistentState state) throws PersistenceException {
        List tr;
        this.colorInterpretation = (ColorInterpretation)state.get("colorinterpretation");
        if (state.hasValue("opacity")) {
            this.opacity = state.getInt("opacity");
        }
        if ((tr = state.getList("transparencyRange")) != null) {
            this.transparencyRanges = new ArrayList<TransparencyRange>(tr);
            if (state.hasValue("bandnumber")) {
                int alphaBandNumber = state.getInt("bandnumber");
                this.setTransparencyBand(alphaBandNumber);
            }
        }
        this.transparencyActive = state.getBoolean("transparencyActive");
    }

    public void saveToState(PersistentState state) throws PersistenceException {
        state.set("colorinterpretation", (Persistent)this.colorInterpretation);
        if (this.getOpacity() != 255) {
            state.set("opacity", this.getOpacity());
        }
        state.set("transparencyRange", this.transparencyRanges);
        if (this.getAlphaBandNumber() != -1) {
            state.set("bandnumber", this.getAlphaBandNumber());
        }
        state.set("transparencyActive", this.transparencyActive);
    }

    public static void registerPersistence() {
        PersistenceManager manager = ToolsLocator.getPersistenceManager();
        DynStruct definition = manager.getDefinition("Transparency_Persistent");
        if (definition == null) {
            definition = manager.addDefinition(DataStoreTransparency.class, "Transparency_Persistent", "Transparency Persistent definition (FIXME)", null, null);
            definition.addDynFieldInt("opacity").setMandatory(false);
            definition.addDynFieldInt("bandnumber").setMandatory(false);
            definition.addDynFieldList("transparencyRange").setClassOfItems(TransparencyRange.class).setMandatory(false);
            definition.addDynFieldBoolean("transparencyActive").setMandatory(false);
            definition.addDynFieldObject("colorinterpretation").setClassOfValue(ColorInterpretation.class).setMandatory(false);
        }
    }

    public void dispose() {
        if (this.originalData != null) {
            this.originalData.dispose();
        }
        this.originalData = null;
    }

    public ColorInterpretation getColorInterpretation() {
        return this.colorInterpretation;
    }

    protected void finalize() throws Throwable {
        this.noData = null;
        if (this.transparencyPropertyListener != null) {
            this.transparencyPropertyListener.clear();
            this.transparencyPropertyListener = null;
        }
        if (this.transparencyRanges != null) {
            this.transparencyRanges.clear();
            this.transparencyRanges = null;
        }
        super.finalize();
    }
}

