/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.impl.store.properties;

import java.util.List;
import org.gvsig.fmap.dal.coverage.RasterLibrary;
import org.gvsig.fmap.dal.coverage.dataset.Buffer;
import org.gvsig.fmap.dal.coverage.datastruct.BufferHistogram;
import org.gvsig.fmap.dal.coverage.exception.FileNotOpenException;
import org.gvsig.fmap.dal.coverage.exception.HistogramException;
import org.gvsig.fmap.dal.coverage.exception.InvalidSetViewException;
import org.gvsig.fmap.dal.coverage.exception.ProcessInterruptedException;
import org.gvsig.fmap.dal.coverage.exception.RasterDriverException;
import org.gvsig.fmap.dal.coverage.exception.RmfSerializerException;
import org.gvsig.fmap.dal.coverage.store.props.HistogramComputer;
import org.gvsig.raster.impl.datastruct.BufferHistogramImpl;
import org.gvsig.raster.impl.process.RasterTask;
import org.gvsig.raster.impl.process.RasterTaskQueue;
import org.gvsig.raster.impl.provider.RasterProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleProviderHistogramComputer
implements HistogramComputer {
    private static final Logger logger = LoggerFactory.getLogger(SimpleProviderHistogramComputer.class);
    protected BufferHistogramImpl histogram = null;
    private RasterProvider provider = null;
    private int percent = 0;
    private boolean refresh = false;
    private double scale = 1.0;

    public SimpleProviderHistogramComputer(RasterProvider provider) {
        this.provider = provider;
    }

    public void setScaleHistogram(double scale) {
        this.scale = scale;
    }

    public double getMinimum() {
        return this.provider.getStatistics().getMinimun();
    }

    public double getMaximum() {
        return this.provider.getStatistics().getMaximun();
    }

    public BufferHistogram getBufferHistogram() throws HistogramException, ProcessInterruptedException {
        RasterTask task = RasterTaskQueue.get(Thread.currentThread().getId() + "");
        if (this.provider != null) {
            if (this.histogram == null || this.refresh) {
                try {
                    this.provider.getStatistics().calculate(1.0);
                }
                catch (FileNotOpenException e) {
                    throw new HistogramException("");
                }
                catch (RasterDriverException e) {
                    throw new HistogramException("");
                }
                try {
                    this.histogram = (BufferHistogramImpl)this.provider.loadObjectFromRmf(BufferHistogram.class, this.histogram);
                    if (this.histogram != null) {
                        return this.histogram;
                    }
                }
                catch (RmfSerializerException e) {
                    // empty catch block
                }
                if (task.getEvent() != null) {
                    task.manageEvent(task.getEvent());
                }
                this.histogram = new BufferHistogramImpl(this.provider.getBandCount(), this.provider.getStatistics().getMin(), this.provider.getStatistics().getMax(), this.provider.getDataType()[0]);
                try {
                    this.histogram = (BufferHistogramImpl)this.getHistogramByDataType();
                }
                catch (FileNotOpenException e) {
                    throw new HistogramException("", (Throwable)e);
                }
                catch (RasterDriverException e) {
                    throw new HistogramException("", (Throwable)e);
                }
                catch (Exception e) {
                    logger.info("Error calculando el histograma", (Throwable)e);
                }
                try {
                    this.provider.saveObjectToRmf(BufferHistogram.class, this.histogram);
                }
                catch (RmfSerializerException rmfSerializerException) {
                    // empty catch block
                }
            }
            return this.histogram;
        }
        return null;
    }

    private void loadHistogramFromBuffer(Buffer buf) {
        switch (buf.getDataType()) {
            case 0: {
                for (int iBand = 0; iBand < buf.getBandCount(); ++iBand) {
                    for (int col = 0; col < buf.getWidth(); ++col) {
                        for (int row = 0; row < buf.getHeight(); ++row) {
                            this.histogram.incrementPxValue(iBand, buf.getElemByte(row, col, iBand));
                        }
                    }
                }
                break;
            }
            case 2: {
                for (int iBand = 0; iBand < buf.getBandCount(); ++iBand) {
                    for (int col = 0; col < buf.getWidth(); ++col) {
                        for (int row = 0; row < buf.getHeight(); ++row) {
                            this.histogram.incrementPxValue(iBand, buf.getElemShort(row, col, iBand));
                        }
                    }
                }
                break;
            }
            case 4: {
                for (int iBand = 0; iBand < buf.getBandCount(); ++iBand) {
                    for (int col = 0; col < buf.getWidth(); ++col) {
                        for (int row = 0; row < buf.getHeight(); ++row) {
                            this.histogram.incrementPxValue(iBand, buf.getElemFloat(row, col, iBand));
                        }
                    }
                }
                break;
            }
            case 5: {
                for (int iBand = 0; iBand < buf.getBandCount(); ++iBand) {
                    for (int col = 0; col < buf.getWidth(); ++col) {
                        for (int row = 0; row < buf.getHeight(); ++row) {
                            this.histogram.incrementPxValue(iBand, buf.getElemDouble(row, col, iBand));
                        }
                    }
                }
                break;
            }
            case 3: {
                for (int iBand = 0; iBand < buf.getBandCount(); ++iBand) {
                    for (int col = 0; col < buf.getWidth(); ++col) {
                        for (int row = 0; row < buf.getHeight(); ++row) {
                            this.histogram.incrementPxValue(iBand, buf.getElemInt(row, col, iBand));
                        }
                    }
                }
                break;
            }
        }
    }

    private BufferHistogram getHistogramByDataType() throws InvalidSetViewException, FileNotOpenException, RasterDriverException, ProcessInterruptedException {
        RasterTask task = RasterTaskQueue.get(Thread.currentThread().getId() + "");
        this.percent = 0;
        int type = this.provider.getDataType()[0];
        int h = RasterLibrary.blockHeight;
        if (this.provider.getNoDataValue().isDefined()) {
            this.histogram.setNoDataValue(this.provider.getNoDataValue());
        }
        int block = 0;
        while ((double)block < this.provider.getHeight()) {
            Object buf = null;
            try {
                buf = this.provider.readBlock(block, h, this.scale);
            }
            catch (InvalidSetViewException invalidSetViewException) {
                // empty catch block
            }
            int hB = h;
            if ((double)(block + hB) > this.provider.getHeight()) {
                hB = Math.abs((int)this.provider.getHeight() - block);
            }
            hB = (int)((double)hB * this.scale);
            if (buf instanceof Buffer) {
                this.loadHistogramFromBuffer((Buffer)buf);
            } else {
                switch (type) {
                    case 0: {
                        byte[][][] bBlock = (byte[][][])buf;
                        for (int iBand = 0; iBand < this.provider.getBandCount(); ++iBand) {
                            for (int col = 0; col < bBlock[iBand][0].length; ++col) {
                                for (int row = 0; row < hB; ++row) {
                                    this.histogram.incrementPxValue(iBand, bBlock[iBand][row][col]);
                                }
                            }
                        }
                        break;
                    }
                    case 2: {
                        short[][][] sBlock = (short[][][])buf;
                        for (int iBand = 0; iBand < this.provider.getBandCount(); ++iBand) {
                            for (int col = 0; col < sBlock[iBand][0].length; ++col) {
                                for (int row = 0; row < hB; ++row) {
                                    this.histogram.incrementPxValue(iBand, sBlock[iBand][row][col]);
                                }
                            }
                        }
                        break;
                    }
                    case 3: {
                        int[][][] iBlock = (int[][][])buf;
                        for (int iBand = 0; iBand < this.provider.getBandCount(); ++iBand) {
                            for (int col = 0; col < iBlock[iBand][0].length; ++col) {
                                for (int row = 0; row < hB; ++row) {
                                    this.histogram.incrementPxValue(iBand, iBlock[iBand][row][col]);
                                }
                            }
                        }
                        break;
                    }
                    case 4: {
                        float[][][] fBlock = (float[][][])buf;
                        for (int iBand = 0; iBand < this.provider.getBandCount(); ++iBand) {
                            for (int col = 0; col < fBlock[iBand][0].length; ++col) {
                                for (int row = 0; row < hB; ++row) {
                                    this.histogram.incrementPxValue(iBand, fBlock[iBand][row][col]);
                                }
                            }
                        }
                        break;
                    }
                    case 5: {
                        double[][][] dBlock = (double[][][])buf;
                        for (int iBand = 0; iBand < this.provider.getBandCount(); ++iBand) {
                            for (int col = 0; col < dBlock[iBand][0].length; ++col) {
                                for (int row = 0; row < hB; ++row) {
                                    this.histogram.incrementPxValue(iBand, dBlock[iBand][row][col]);
                                }
                            }
                        }
                        break;
                    }
                }
            }
            if (task.getEvent() != null) {
                task.manageEvent(task.getEvent());
            }
            this.percent = (int)((double)this.percent + (double)(h * 100) / this.provider.getHeight());
            block += h;
        }
        this.percent = 100;
        return this.histogram;
    }

    public void resetPercent() {
        this.percent = 0;
    }

    public int getPercent() {
        return this.percent;
    }

    public void refreshHistogram() {
        this.refresh = true;
    }

    protected void setBufferHistogram(BufferHistogram bh) {
        if (bh instanceof BufferHistogramImpl) {
            this.histogram = (BufferHistogramImpl)bh;
        }
    }

    public static HistogramComputer union(RasterProvider prov, List<RasterProvider> list) throws HistogramException, InterruptedException {
        SimpleProviderHistogramComputer newHistogramComputer = new SimpleProviderHistogramComputer(prov);
        for (int i = 0; i < list.size(); ++i) {
            HistogramComputer hc = list.get(0).getHistogramComputer();
            try {
                BufferHistogram bh = hc.getBufferHistogram();
                if (newHistogramComputer.histogram == null) {
                    newHistogramComputer.setBufferHistogram(bh);
                    continue;
                }
                newHistogramComputer.histogram.union(bh);
                continue;
            }
            catch (ProcessInterruptedException e) {
                throw new InterruptedException();
            }
        }
        return newHistogramComputer;
    }

    public String getLog() {
        return null;
    }

    public boolean isCancelable() {
        return true;
    }

    public boolean isPausable() {
        return false;
    }

    public void setPercent(int value) {
    }
}

