/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.util.persistence;

import org.gvsig.fmap.dal.coverage.store.props.ColorTable;
import org.gvsig.fmap.dal.coverage.store.props.Statistics;
import org.gvsig.raster.util.persistence.GenericPersistentBoolean;
import org.gvsig.raster.util.persistence.GenericPersistentBooleanArray;
import org.gvsig.raster.util.persistence.GenericPersistentColorTable;
import org.gvsig.raster.util.persistence.GenericPersistentDouble;
import org.gvsig.raster.util.persistence.GenericPersistentDoubleArray;
import org.gvsig.raster.util.persistence.GenericPersistentInt;
import org.gvsig.raster.util.persistence.GenericPersistentIntArray;
import org.gvsig.raster.util.persistence.GenericPersistentStatistics;
import org.gvsig.raster.util.persistence.GenericPersistentString;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DynStruct;
import org.gvsig.tools.persistence.PersistenceManager;
import org.gvsig.tools.persistence.Persistent;

public abstract class GenericPersistentObject
implements Persistent {
    protected Object obj = null;

    public static GenericPersistentObject create(Object obj) {
        GenericPersistentObject result = null;
        if (obj instanceof Double) {
            result = new GenericPersistentDouble();
        }
        if (obj instanceof Integer) {
            result = new GenericPersistentInt();
        }
        if (obj instanceof Boolean) {
            result = new GenericPersistentBoolean();
        }
        if (obj instanceof ColorTable) {
            result = new GenericPersistentColorTable();
        }
        if (obj instanceof String) {
            result = new GenericPersistentString();
        }
        if (obj instanceof double[]) {
            result = new GenericPersistentDoubleArray();
        }
        if (obj instanceof int[]) {
            result = new GenericPersistentIntArray();
        }
        if (obj instanceof boolean[]) {
            result = new GenericPersistentBooleanArray();
        }
        if (obj instanceof Statistics) {
            result = new GenericPersistentStatistics();
        }
        if (result != null) {
            result.setObject(obj);
        }
        return result;
    }

    public static void registerPersistence() {
        PersistenceManager manager = ToolsLocator.getPersistenceManager();
        DynStruct definition = manager.addDefinition(GenericPersistentDouble.class, "GenericDouble_Persistence", "Generic Double Persistence", null, null);
        definition.addDynFieldDouble("value").setMandatory(false);
        definition = manager.addDefinition(GenericPersistentBoolean.class, "GenericBoolean_Persistence", "Generic Boolean Persistence", null, null);
        definition.addDynFieldBoolean("value").setMandatory(false);
        definition = manager.addDefinition(GenericPersistentInt.class, "GenericInt_Persistence", "Generic Integer Persistence", null, null);
        definition.addDynFieldInt("value").setMandatory(false);
        definition = manager.addDefinition(GenericPersistentColorTable.class, "GenericPersistentColorTable_Persistence", "Generic Color Table Persistence", null, null);
        definition.addDynFieldObject("value").setClassOfValue(ColorTable.class).setMandatory(false);
        definition = manager.addDefinition(GenericPersistentString.class, "GenericPersistentString_Persistence", "Generic String Persistence", null, null);
        definition.addDynFieldString("value").setClassOfValue(String.class).setMandatory(false);
        definition = manager.addDefinition(GenericPersistentDoubleArray.class, "GenericPersistentDoubleArray_Persistence", "Generic Double Array Persistence", null, null);
        definition.addDynFieldList("value").setClassOfItems(Double.TYPE).setMandatory(false);
        definition = manager.addDefinition(GenericPersistentIntArray.class, "GenericPersistentIntArray_Persistence", "Generic Integer Array Persistence", null, null);
        definition.addDynFieldList("value").setClassOfItems(Integer.TYPE).setMandatory(false);
        definition = manager.addDefinition(GenericPersistentBooleanArray.class, "GenericPersistentBooleanArray_Persistence", "Generic Boolean Array Persistence", null, null);
        definition.addDynFieldList("value").setClassOfItems(Boolean.TYPE).setMandatory(false);
        definition = manager.addDefinition(GenericPersistentStatistics.class, "GenericPersistentStatistics_Persistence", "Generic Statistics Persistence", null, null);
        definition.addDynFieldList("value").setClassOfItems(Statistics.class).setMandatory(false);
    }

    public Object getObject() {
        return this.obj;
    }

    public void setObject(Object obj) {
        this.obj = obj;
    }
}

