/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.geom.jts;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.operation.valid.TopologyValidationError;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.geom.exception.CreateGeometryException;
import org.gvsig.fmap.geom.primitive.Point;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultValidationStatus
implements Geometry.ValidationStatus {
    private static final Logger logger = LoggerFactory.getLogger(DefaultValidationStatus.class);
    private int statusCode = 0;
    private Point problemLocation = null;
    private String message = null;

    public DefaultValidationStatus() {
    }

    public DefaultValidationStatus(int code, String message) {
        this.statusCode = code;
        this.message = message;
    }

    public void setMesage(String message) {
        this.message = message;
    }

    public void setStatusCode(int statusCode) {
        this.statusCode = statusCode;
    }

    public void setValidationError(TopologyValidationError validationError) {
        if (validationError == null) {
            this.statusCode = 0;
            this.message = null;
            this.problemLocation = null;
            return;
        }
        this.message = validationError.getMessage();
        Coordinate coord = validationError.getCoordinate();
        try {
            GeometryManager geomManager = GeometryLocator.getGeometryManager();
            if (Double.isNaN(coord.z)) {
                this.problemLocation = geomManager.createPoint(coord.x, coord.y, 0);
            } else {
                this.problemLocation = geomManager.createPoint(coord.x, coord.y, 1);
                this.problemLocation.setCoordinateAt(2, coord.z);
            }
        }
        catch (CreateGeometryException ex) {
            String coordstr;
            try {
                coordstr = coord.toString();
            }
            catch (Exception ex1) {
                coordstr = "unknow";
            }
            logger.warn("Can't create a point from jts Coordinate (" + coordstr + ").", (Throwable)ex);
            this.problemLocation = null;
        }
        switch (validationError.getErrorType()) {
            case 4: {
                this.statusCode = 10;
                break;
            }
            case 8: {
                this.statusCode = 11;
                break;
            }
            case 2: {
                this.statusCode = 12;
                break;
            }
            case 10: {
                this.statusCode = 13;
                break;
            }
            case 3: {
                this.statusCode = 14;
                break;
            }
            case 7: {
                this.statusCode = 15;
                break;
            }
            case 11: {
                this.statusCode = 17;
                break;
            }
            case 6: {
                this.statusCode = 18;
                break;
            }
            case 5: {
                this.statusCode = 19;
                break;
            }
            case 9: {
                this.statusCode = 20;
                break;
            }
            default: {
                this.statusCode = 2;
            }
        }
    }

    public boolean isValid() {
        return this.statusCode == 0;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public Point getProblemLocation() {
        return this.problemLocation;
    }

    public String getMessage() {
        return this.message;
    }
}

