/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.geom.jts.gml;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.operation.linemerge.LineMerger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.gvsig.fmap.geom.jts.gml.GMLHandler;
import org.gvsig.fmap.geom.jts.gml.GeometryStrategies;
import org.gvsig.fmap.geom.jts.util.JTSUtils;
import org.xml.sax.SAXException;

public class GeometryStrategiesGML3 {
    public static HashMap loadStrategies(HashMap strats) {
        GeometryStrategies.ParseStrategy oneChild = new GeometryStrategies.ParseStrategy(){

            @Override
            public Object parse(GMLHandler.Handler arg, GeometryFactory gf) throws SAXException {
                if (arg.children.size() != 1) {
                    throw new SAXException("Geometry Members may only contain one geometry.");
                }
                return arg.children.get(0);
            }
        };
        GeometryStrategies.ParseStrategy manyChilds = new GeometryStrategies.ParseStrategy(){

            @Override
            public Object parse(GMLHandler.Handler arg, GeometryFactory gf) throws SAXException {
                return arg.children;
            }
        };
        strats.put("pos".toLowerCase(), new GeometryStrategies.ParseStrategy(){

            @Override
            public Object parse(GMLHandler.Handler arg, GeometryFactory gf) throws SAXException {
                String[] ss = StringUtils.split((String)arg.text.toString(), (char)' ');
                Coordinate c = new Coordinate();
                c.x = Double.parseDouble(ss[0]);
                if (ss.length > 1) {
                    c.y = Double.parseDouble(ss[1]);
                }
                if (ss.length > 3) {
                    c.z = Double.parseDouble(ss[2]);
                }
                return c;
            }
        });
        strats.put("posList".toLowerCase(), new GeometryStrategies.ParseStrategy(){

            @Override
            public Object parse(GMLHandler.Handler arg, GeometryFactory gf) throws SAXException {
                if (arg.text == null || "".equals(arg.text)) {
                    throw new SAXException("Cannot create a coordinate sequence without text to parse");
                }
                String coordSeperator = " ";
                int srsDimension = 2;
                if (arg.attrs.getIndex("cs") >= 0) {
                    coordSeperator = arg.attrs.getValue("cs");
                } else if (arg.attrs.getIndex("http://www.opengis.net/gml", "cs") >= 0) {
                    coordSeperator = arg.attrs.getValue("http://www.opengis.net/gml", "cs");
                }
                if (arg.attrs.getIndex("srsDimension") >= 0) {
                    srsDimension = Integer.parseInt(arg.attrs.getValue("srsDimension"));
                } else if (arg.attrs.getIndex("http://www.opengis.net/gml", "srsDimension") >= 0) {
                    srsDimension = Integer.parseInt(arg.attrs.getValue("http://www.opengis.net/gml", "srsDimension"));
                }
                String t = arg.text.toString();
                t = t.replaceAll("\\s", " ");
                String[] ss = StringUtils.split((String)t, (String)coordSeperator);
                int len = ss.length / srsDimension;
                CoordinateSequence cs = gf.getCoordinateSequenceFactory().create(len, srsDimension);
                for (int i = 0; i < len; ++i) {
                    cs.setOrdinate(i, 0, Double.parseDouble(ss[i * 2]));
                    if (srsDimension > 1) {
                        cs.setOrdinate(i, 1, Double.parseDouble(ss[i * 2 + 1]));
                    }
                    if (srsDimension <= 2) continue;
                    cs.setOrdinate(i, 2, Double.parseDouble(ss[i * 2 + 2]));
                }
                return cs;
            }
        });
        strats.put("PolygonPatch".toLowerCase(), new GeometryStrategies.ParseStrategy(){

            @Override
            public Object parse(GMLHandler.Handler arg, GeometryFactory gf) throws SAXException {
                LinearRing exterior = (LinearRing)arg.children.get(0);
                ArrayList interior = null;
                int childrensCount = arg.children.size();
                if (childrensCount == 2) {
                    interior = (ArrayList)arg.children.get(1);
                } else if (childrensCount > 2) {
                    interior = new ArrayList();
                    for (int i = 1; i < childrensCount; ++i) {
                        Object child = arg.children.get(i);
                        if (child instanceof List) {
                            interior.add(((List)child).get(0));
                            continue;
                        }
                        interior.add((LinearRing)child);
                    }
                }
                return new ImmutablePair((Object)exterior, interior);
            }
        });
        strats.put("patches".toLowerCase(), new GeometryStrategies.ParseStrategy(){

            @Override
            public Object parse(GMLHandler.Handler arg, GeometryFactory gf) throws SAXException {
                return arg.children;
            }
        });
        strats.put("Surface".toLowerCase(), new GeometryStrategies.ParseStrategy(){

            @Override
            public Object parse(GMLHandler.Handler arg, GeometryFactory gf) throws SAXException {
                List patches = (List)arg.children.get(0);
                LinearRing shell = (LinearRing)((Pair)patches.get(0)).getLeft();
                List holes = (List)((Pair)patches.get(0)).getRight();
                Polygon polygon = holes == null ? gf.createPolygon(shell) : gf.createPolygon(shell, holes.toArray(new LinearRing[holes.size()]));
                int srid = GeometryStrategies.getSrid(arg.attrs, gf.getSRID());
                if (polygon.getSRID() != srid) {
                    polygon.setSRID(srid);
                }
                return polygon;
            }
        });
        strats.put("exterior".toLowerCase(), oneChild);
        strats.put("surfaceMember".toLowerCase(), oneChild);
        strats.put("OrientableSurface".toLowerCase(), oneChild);
        strats.put("baseSurface".toLowerCase(), oneChild);
        strats.put("interior".toLowerCase(), manyChilds);
        strats.put("MultiSurface".toLowerCase(), new GeometryStrategies.ParseStrategy(){

            @Override
            public Object parse(GMLHandler.Handler arg, GeometryFactory gf) throws SAXException {
                List polygons = arg.children;
                MultiPolygon multiPolygon = gf.createMultiPolygon(polygons.toArray(new Polygon[polygons.size()]));
                int srid = GeometryStrategies.getSrid(arg.attrs, gf.getSRID());
                if (multiPolygon.getSRID() != srid) {
                    multiPolygon.setSRID(srid);
                }
                return multiPolygon;
            }
        });
        strats.put("CompositeSurface".toLowerCase(), strats.get("MultiSurface".toLowerCase()));
        strats.put("curveMember".toLowerCase(), oneChild);
        strats.put("MultiCurve".toLowerCase(), new GeometryStrategies.ParseStrategy(){

            @Override
            public Object parse(GMLHandler.Handler arg, GeometryFactory gf) throws SAXException {
                List curves = arg.children;
                MultiLineString multicurve = gf.createMultiLineString(curves.toArray(new LineString[curves.size()]));
                int srid = GeometryStrategies.getSrid(arg.attrs, gf.getSRID());
                if (multicurve.getSRID() != srid) {
                    multicurve.setSRID(srid);
                }
                return multicurve;
            }
        });
        strats.put("segments".toLowerCase(), manyChilds);
        strats.put("LineStringSegment".toLowerCase(), oneChild);
        strats.put("Curve".toLowerCase(), new GeometryStrategies.ParseStrategy(){

            @Override
            public Object parse(GMLHandler.Handler arg, GeometryFactory gf) throws SAXException {
                CoordinateSequence segment;
                LineString curve = null;
                List segments = (List)arg.children.get(0);
                if (CollectionUtils.isNotEmpty((Collection)segments) && (segment = (CoordinateSequence)segments.get(0)) != null) {
                    curve = gf.createLineString(segment);
                }
                return curve;
            }
        });
        strats.put("Ring".toLowerCase(), new GeometryStrategies.ParseStrategy(){

            @Override
            public Object parse(GMLHandler.Handler arg, GeometryFactory gf) throws SAXException {
                LineMerger merger = new LineMerger();
                List segments = arg.children;
                for (LineString segment : segments) {
                    merger.add((Geometry)segment);
                }
                List merged = (List)merger.getMergedLineStrings();
                return JTSUtils.createJTSLinearRing(null, ((LineString)merged.get(0)).getCoordinateSequence());
            }
        });
        strats.put("Solid".toLowerCase(), null);
        return strats;
    }
}

