/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.geom.jts.operation.fromwkb;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.geom.aggregate.MultiCurve;
import org.gvsig.fmap.geom.aggregate.MultiPoint;
import org.gvsig.fmap.geom.aggregate.MultiPrimitive;
import org.gvsig.fmap.geom.aggregate.MultiSurface;
import org.gvsig.fmap.geom.exception.CreateGeometryException;
import org.gvsig.fmap.geom.primitive.Curve;
import org.gvsig.fmap.geom.primitive.OrientablePrimitive;
import org.gvsig.fmap.geom.primitive.Point;
import org.gvsig.fmap.geom.primitive.Primitive;
import org.gvsig.fmap.geom.primitive.Surface;
import org.gvsig.fmap.geom.type.GeometryType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WKBParser2 {
    private static final Logger LOG = LoggerFactory.getLogger(WKBParser2.class);
    private GeometryManager geomManager = GeometryLocator.getGeometryManager();
    private boolean gHaveM;
    private boolean gHaveZ;
    private boolean gHaveS;
    private GeometryType[] pointGeometryTypes = new GeometryType[]{this.loadPointGeometryType(0, "2D"), this.loadPointGeometryType(1, "3D"), this.loadPointGeometryType(2, "2DM"), this.loadPointGeometryType(3, "3DM")};

    private GeometryType loadPointGeometryType(int subtype, String subTypeName) {
        try {
            return this.geomManager.getGeometryType(1, subtype);
        }
        catch (Exception e) {
            LOG.warn("Unable to get a reference to the geometry type Point{}, to be cached", (Object)subTypeName);
            return null;
        }
    }

    public synchronized Geometry parse(byte[] value) throws CreateGeometryException {
        ByteBuffer buf = ByteBuffer.wrap(value);
        return this.parseGeometry(buf);
    }

    protected void parseTypeAndSRID(ByteBuffer data) {
        byte endian = data.get();
        int typeword = data.getInt();
        int realtype = typeword & 0x1FFFFFFF;
        this.gHaveZ = (typeword & Integer.MIN_VALUE) != 0;
        this.gHaveM = (typeword & 0x40000000) != 0;
        this.gHaveS = (typeword & 0x20000000) != 0;
        int srid = -1;
        if (this.gHaveS) {
            srid = data.getInt();
        }
    }

    protected Geometry parseGeometry(ByteBuffer data) throws CreateGeometryException {
        MultiPoint result1;
        byte endian = data.get();
        if (endian == 1) {
            data.order(ByteOrder.LITTLE_ENDIAN);
        }
        int typeword = data.getInt();
        int realtype = typeword & 0x1FFFFFFF;
        boolean haveZ = (typeword & Integer.MIN_VALUE) != 0;
        boolean haveM = (typeword & 0x40000000) != 0;
        boolean haveS = (typeword & 0x20000000) != 0;
        int srid = -1;
        if (haveS) {
            srid = data.getInt();
        }
        switch (realtype) {
            case 1: {
                result1 = this.parsePoint(data, haveZ, haveM);
                break;
            }
            case 2: {
                result1 = this.parseLineString(data, haveZ, haveM);
                break;
            }
            case 3: {
                result1 = this.parsePolygon(data, haveZ, haveM);
                break;
            }
            case 4: {
                result1 = this.parseMultiPoint(data);
                break;
            }
            case 5: {
                result1 = this.parseMultiLineString(data);
                break;
            }
            case 6: {
                result1 = this.parseMultiPolygon(data);
                break;
            }
            case 7: {
                result1 = this.parseCollection(data);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown Geometry Type!");
            }
        }
        return result1;
    }

    private Point parsePoint(ByteBuffer data, boolean haveZ, boolean haveM) throws CreateGeometryException {
        double x = data.getDouble();
        double y = data.getDouble();
        int subtype = this.getSubType(haveZ, haveM);
        Point point = this.pointGeometryTypes[subtype] == null ? (Point)this.geomManager.create(1, subtype) : (Point)this.pointGeometryTypes[subtype].create();
        point.setX(x);
        point.setY(y);
        if (haveZ) {
            point.setCoordinateAt(2, data.getDouble());
            if (haveM) {
                point.setCoordinateAt(3, data.getDouble());
            }
        } else if (haveM) {
            point.setCoordinateAt(2, data.getDouble());
        }
        return point;
    }

    private int getSubType(boolean haveZ, boolean haveM) {
        int subtype = haveZ ? (haveM ? 3 : 1) : (haveM ? 2 : 0);
        return subtype;
    }

    private void parseGeometryArray(ByteBuffer data, Geometry[] container) throws CreateGeometryException {
        for (int i = 0; i < container.length; ++i) {
            container[i] = this.parseGeometry(data);
        }
    }

    private Point[] parsePointArray(ByteBuffer data, boolean haveZ, boolean haveM) throws CreateGeometryException {
        int count = data.getInt();
        Point[] result = new Point[count];
        for (int i = 0; i < count; ++i) {
            result[i] = this.parsePoint(data, haveZ, haveM);
        }
        return result;
    }

    private double[][] parsePointsAsDoubleArray(ByteBuffer data, boolean haveZ, boolean haveM) throws CreateGeometryException {
        int count = data.getInt();
        double[][] points = null;
        int subtype = this.getSubType(haveZ, haveM);
        switch (subtype) {
            case 0: {
                points = new double[count][2];
                break;
            }
            case 1: 
            case 2: {
                points = new double[count][3];
                break;
            }
            case 3: {
                points = new double[count][4];
                break;
            }
        }
        block9: for (int i = 0; i < count; ++i) {
            points[i][0] = data.getDouble();
            points[i][1] = data.getDouble();
            switch (subtype) {
                case 1: 
                case 2: {
                    points[i][2] = data.getDouble();
                    continue block9;
                }
                case 3: {
                    points[i][2] = data.getDouble();
                    points[i][3] = data.getDouble();
                    continue block9;
                }
            }
        }
        return points;
    }

    private MultiPoint parseMultiPoint(ByteBuffer data) throws CreateGeometryException {
        MultiPoint multipoint = (MultiPoint)this.geomManager.create(7, 0);
        int points = data.getInt();
        multipoint.ensureCapacity(points);
        for (int i = 0; i < points; ++i) {
            this.parseTypeAndSRID(data);
            multipoint.addPoint(this.parsePoint(data, this.gHaveZ, this.gHaveM));
        }
        return multipoint;
    }

    private Curve parseLineString(ByteBuffer data, boolean haveZ, boolean haveM) throws CreateGeometryException {
        Point[] points = this.parsePointArray(data, haveZ, haveM);
        Curve curve = (Curve)this.geomManager.create(2, this.getSubType(haveZ, haveM));
        curve.addMoveToVertex(points[0]);
        for (int i = 1; i < points.length; ++i) {
            curve.addVertex(points[i]);
        }
        return curve;
    }

    private void fillLinearRing(ByteBuffer data, OrientablePrimitive orientablePrimitive, boolean haveZ, boolean haveM) throws CreateGeometryException {
        Point[] points = this.parsePointArray(data, haveZ, haveM);
        orientablePrimitive.addMoveToVertex(points[0]);
        int lastPoint = points.length - 1;
        for (int i = 1; i < lastPoint; ++i) {
            orientablePrimitive.addVertex(points[i]);
        }
    }

    private Surface parsePolygon(ByteBuffer data, boolean haveZ, boolean haveM) throws CreateGeometryException {
        int count = data.getInt();
        int subType = this.getSubType(haveZ, haveM);
        Surface surface = (Surface)this.geomManager.create(3, subType);
        for (int i = 0; i < count; ++i) {
            this.fillLinearRing(data, (OrientablePrimitive)surface, haveZ, haveM);
        }
        surface.closePrimitive();
        return surface;
    }

    private MultiCurve parseMultiLineString(ByteBuffer data) throws CreateGeometryException {
        MultiCurve multiCurve = (MultiCurve)this.geomManager.create(8, this.getSubType(this.gHaveZ, this.gHaveM));
        Curve curve = (Curve)this.geomManager.create(2, this.getSubType(this.gHaveZ, this.gHaveM));
        this.fillOrientablePrimitive(data, (OrientablePrimitive)curve);
        multiCurve.addCurve(curve);
        return multiCurve;
    }

    private void fillOrientablePrimitive(ByteBuffer data, OrientablePrimitive orientablePrimitive) throws CreateGeometryException {
        int count = data.getInt();
        for (int i = 0; i < count; ++i) {
            this.parseTypeAndSRID(data);
            Point[] points = this.parsePointArray(data, this.gHaveZ, this.gHaveM);
            orientablePrimitive.addMoveToVertex(points[0]);
            for (int j = 1; j < points.length; ++j) {
                orientablePrimitive.addVertex(points[j]);
            }
        }
    }

    private MultiSurface parseMultiPolygon(ByteBuffer data) throws CreateGeometryException {
        int count = data.getInt();
        int subType = this.getSubType(this.gHaveZ, this.gHaveM);
        MultiSurface multiSurface = (MultiSurface)this.geomManager.create(9, subType);
        for (int i = 0; i < count; ++i) {
            this.parseTypeAndSRID(data);
            int countRings = data.getInt();
            Surface surface = (Surface)this.geomManager.create(3, subType);
            for (int j = 0; j < countRings; ++j) {
                double[][] points = this.parsePointsAsDoubleArray(data, this.gHaveZ, this.gHaveM);
                surface.addVertex(this.geomManager.createPoint(points[0][0], points[0][1], subType));
                int lastPoint = points.length - 1;
                for (int k = 1; k < lastPoint; ++k) {
                    Point point = this.geomManager.createPoint(points[k][0], points[k][1], subType);
                    int l = 2;
                    while (l < points[k].length) {
                        point.setCoordinateAt(l, points[k][l]);
                        ++i;
                    }
                    surface.addVertex(point);
                }
                surface.closePrimitive();
            }
            multiSurface.addSurface(surface);
        }
        return multiSurface;
    }

    private MultiPrimitive parseCollection(ByteBuffer data) throws CreateGeometryException {
        int count = data.getInt();
        Geometry[] geoms = new Geometry[count];
        this.parseGeometryArray(data, geoms);
        MultiPrimitive multiPrimitive = (MultiPrimitive)this.geomManager.create(6, 0);
        for (int i = 0; i < geoms.length; ++i) {
            multiPrimitive.addPrimitive((Primitive)geoms[i]);
        }
        return multiPrimitive;
    }
}

