/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.geom.jts.operation.fromwkt;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.PrecisionModel;
import com.vividsolutions.jts.io.ParseException;
import com.vividsolutions.jts.util.Assert;
import java.io.IOException;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.geom.aggregate.MultiLine;
import org.gvsig.fmap.geom.aggregate.MultiPoint;
import org.gvsig.fmap.geom.aggregate.MultiPolygon;
import org.gvsig.fmap.geom.exception.CreateGeometryException;
import org.gvsig.fmap.geom.jts.mgeom.MCoordinate;
import org.gvsig.fmap.geom.jts.mgeom.MGeometryFactory;
import org.gvsig.fmap.geom.primitive.Curve;
import org.gvsig.fmap.geom.primitive.Line;
import org.gvsig.fmap.geom.primitive.Point;
import org.gvsig.fmap.geom.primitive.Polygon;
import org.gvsig.fmap.geom.primitive.Ring;
import org.gvsig.fmap.geom.primitive.Surface;

public class EWKTParser {
    private static final String EMPTY = "EMPTY";
    private static final String COMMA = ",";
    private static final String L_PAREN = "(";
    private static final String R_PAREN = ")";
    private static final String EQUALS = "=";
    private static final String SEMICOLON = ";";
    private static final String Z = "Z";
    private static final String ZM = "ZM";
    private static final String M = "M";
    private GeometryFactory geometryFactory;
    private PrecisionModel precisionModel;
    private StreamTokenizer tokenizer;
    private int dimension = -1;
    private Boolean hasM = null;
    private GeometryManager manager = GeometryLocator.getGeometryManager();

    public EWKTParser() {
        this(new MGeometryFactory());
    }

    public EWKTParser(GeometryFactory geometryFactory) {
        this.geometryFactory = geometryFactory;
        this.precisionModel = geometryFactory.getPrecisionModel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Geometry read(String wellKnownText) throws ParseException {
        try (StringReader reader = new StringReader(wellKnownText);){
            Geometry geometry = this.read(reader);
            return geometry;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Geometry read(Reader reader) throws ParseException {
        try {
            EWKTParser eWKTParser = this;
            synchronized (eWKTParser) {
                if (this.tokenizer != null) {
                    throw new RuntimeException("EWKT-Reader is already in use.");
                }
                this.tokenizer = new StreamTokenizer(reader);
            }
            this.tokenizer.resetSyntax();
            this.tokenizer.wordChars(97, 122);
            this.tokenizer.wordChars(65, 90);
            this.tokenizer.wordChars(160, 255);
            this.tokenizer.wordChars(48, 57);
            this.tokenizer.wordChars(45, 45);
            this.tokenizer.wordChars(43, 43);
            this.tokenizer.wordChars(46, 46);
            this.tokenizer.whitespaceChars(0, 32);
            this.tokenizer.commentChar(35);
            this.hasM = null;
            this.dimension = -1;
            eWKTParser = this.readGeometryTaggedText();
            return eWKTParser;
        }
        catch (IOException | CreateGeometryException e) {
            throw new ParseException(e.toString());
        }
        finally {
            this.tokenizer = null;
        }
    }

    private MCoordinate[] getCoordinates() throws IOException, ParseException {
        String nextToken = this.getNextEmptyOrOpenerOrDimension();
        if (nextToken.equals(EMPTY)) {
            return new MCoordinate[0];
        }
        if (nextToken.equals(Z)) {
            this.dimension = 3;
            this.setHasM(false);
            nextToken = this.getNextEmptyOrOpener();
            if (nextToken.equals(EMPTY)) {
                return new MCoordinate[0];
            }
        }
        if (nextToken.equals(M)) {
            this.dimension = 3;
            this.setHasM(true);
            nextToken = this.getNextEmptyOrOpener();
            if (nextToken.equals(EMPTY)) {
                return new MCoordinate[0];
            }
        }
        if (nextToken.equals(ZM)) {
            this.dimension = 4;
            this.setHasM(true);
            nextToken = this.getNextEmptyOrOpener();
            if (nextToken.equals(EMPTY)) {
                return new MCoordinate[0];
            }
        }
        ArrayList<Coordinate> coordinates = new ArrayList<Coordinate>();
        coordinates.add(this.getPreciseCoordinate());
        nextToken = this.getNextCloserOrComma();
        while (nextToken.equals(COMMA)) {
            coordinates.add(this.getPreciseCoordinate());
            nextToken = this.getNextCloserOrComma();
        }
        return coordinates.toArray(new MCoordinate[coordinates.size()]);
    }

    private Coordinate getPreciseCoordinate() throws IOException, ParseException {
        MCoordinate coord = new MCoordinate();
        coord.x = this.getNextNumber();
        coord.y = this.getNextNumber();
        Double thirdOrdinateValue = null;
        Double fourthOrdinateValue = null;
        if (this.dimension == 3) {
            thirdOrdinateValue = this.getNextNumber();
        } else if (this.dimension == 4) {
            thirdOrdinateValue = this.getNextNumber();
            fourthOrdinateValue = this.getNextNumber();
        } else if (this.dimension < 0) {
            if (this.isNumberNext()) {
                thirdOrdinateValue = this.getNextNumber();
            }
            if (this.isNumberNext()) {
                fourthOrdinateValue = this.getNextNumber();
            }
            if (fourthOrdinateValue != null) {
                this.dimension = 4;
                this.setHasM(true);
            } else if (thirdOrdinateValue != null) {
                this.dimension = 3;
                this.setHasM(Boolean.TRUE.equals(this.hasM));
            } else {
                this.dimension = 2;
                this.setHasM(false);
            }
        }
        switch (this.dimension) {
            case 2: {
                break;
            }
            case 3: {
                if (this.hasM.booleanValue()) {
                    coord.m = thirdOrdinateValue;
                    break;
                }
                coord.z = thirdOrdinateValue;
                break;
            }
            case 4: {
                if (this.hasM.booleanValue()) {
                    coord.z = thirdOrdinateValue;
                    coord.m = fourthOrdinateValue;
                    break;
                }
                throw new ParseException("Unsupported geometry dimension.");
            }
            default: {
                throw new ParseException("Unsupported geometry dimension.");
            }
        }
        this.precisionModel.makePrecise((Coordinate)coord);
        return coord;
    }

    private boolean isNumberNext() throws IOException {
        int type = this.tokenizer.nextToken();
        this.tokenizer.pushBack();
        return type == -3;
    }

    private double getNextNumber() throws IOException, ParseException {
        int type = this.tokenizer.nextToken();
        switch (type) {
            case -3: {
                try {
                    return Double.parseDouble(this.tokenizer.sval);
                }
                catch (NumberFormatException ex) {
                    throw new ParseException("Invalid number: " + this.tokenizer.sval);
                }
            }
        }
        this.parseError("number");
        return 0.0;
    }

    private String getNextEmptyOrOpener() throws IOException, ParseException {
        String nextWord = this.getNextWord();
        if (nextWord.equals(EMPTY) || nextWord.equals(L_PAREN)) {
            return nextWord;
        }
        this.parseError("EMPTY or (");
        return null;
    }

    private String getNextEmptyOrOpenerOrDimension() throws IOException, ParseException {
        String nextWord = this.getNextWord();
        if (nextWord.equals(EMPTY) || nextWord.equals(L_PAREN) || nextWord.equalsIgnoreCase(Z) || nextWord.equalsIgnoreCase(M) || nextWord.equalsIgnoreCase(ZM)) {
            return nextWord;
        }
        this.parseError("EMPTY or ( or Z or M or ZM or ");
        return null;
    }

    private String getNextCloserOrComma() throws IOException, ParseException {
        String nextWord = this.getNextWord();
        if (nextWord.equals(COMMA) || nextWord.equals(R_PAREN)) {
            return nextWord;
        }
        this.parseError(", or )");
        return null;
    }

    private String getNextCloser() throws IOException, ParseException {
        String nextWord = this.getNextWord();
        if (nextWord.equals(R_PAREN)) {
            return nextWord;
        }
        this.parseError(R_PAREN);
        return null;
    }

    private int getSRID() throws IOException, ParseException {
        if (!this.getNextWord().equals(EQUALS)) {
            this.parseError(EQUALS);
            return 0;
        }
        int srid = Integer.parseInt(this.getNextWord());
        if (!this.getNextWord().equals(SEMICOLON)) {
            this.parseError(SEMICOLON);
            return 0;
        }
        return srid;
    }

    private String getNextWord() throws IOException, ParseException {
        int type = this.tokenizer.nextToken();
        switch (type) {
            case -3: {
                String word = this.tokenizer.sval;
                if (word.equalsIgnoreCase(EMPTY)) {
                    return EMPTY;
                }
                return word;
            }
            case 40: {
                return L_PAREN;
            }
            case 41: {
                return R_PAREN;
            }
            case 44: {
                return COMMA;
            }
            case 61: {
                return EQUALS;
            }
            case 59: {
                return SEMICOLON;
            }
        }
        this.parseError("word");
        return null;
    }

    private void parseError(String expected) throws ParseException {
        if (this.tokenizer.ttype == -2) {
            Assert.shouldNeverReachHere((String)"Unexpected NUMBER token");
        }
        if (this.tokenizer.ttype == 10) {
            Assert.shouldNeverReachHere((String)"Unexpected EOL token");
        }
        String tokenStr = this.tokenString();
        throw new ParseException("Expected " + expected + " but found " + tokenStr);
    }

    private String tokenString() {
        switch (this.tokenizer.ttype) {
            case -2: {
                return "<NUMBER>";
            }
            case 10: {
                return "End-of-Line";
            }
            case -1: {
                return "End-of-Stream";
            }
            case -3: {
                return "'" + this.tokenizer.sval + "'";
            }
        }
        return "'" + (char)this.tokenizer.ttype + "'";
    }

    private Geometry readGeometryTaggedText() throws IOException, ParseException, CreateGeometryException {
        Point geom;
        String type = null;
        int srid = this.geometryFactory.getSRID();
        try {
            String firstWord = this.getNextWord();
            if ("SRID".equals(firstWord)) {
                srid = this.getSRID();
                type = this.getNextWord();
            } else {
                type = firstWord;
            }
        }
        catch (IOException e) {
            return null;
        }
        catch (ParseException e) {
            return null;
        }
        if (type.equals("POINT")) {
            geom = this.readPointText();
        } else if (type.equals("POINTZ")) {
            this.dimension = 3;
            geom = this.readPointText();
        } else if (type.equals("POINTM")) {
            this.setHasM(true);
            geom = this.readPointText();
        } else if (type.equals("POINTZM")) {
            this.setHasM(true);
            this.dimension = 4;
            geom = this.readPointText();
        } else if (type.equalsIgnoreCase("LINESTRING")) {
            geom = this.readLineStringText();
        } else if (type.equalsIgnoreCase("LINESTRINGZ")) {
            this.dimension = 3;
            geom = this.readLineStringText();
        } else if (type.equalsIgnoreCase("LINESTRINGM")) {
            this.setHasM(true);
            this.dimension = 3;
            geom = this.readLineStringText();
        } else if (type.equalsIgnoreCase("LINESTRINGZM")) {
            this.setHasM(true);
            this.dimension = 4;
            geom = this.readLineStringText();
        } else if (type.equalsIgnoreCase("LINEARRING")) {
            geom = this.readLinearRingText();
        } else if (type.equalsIgnoreCase("LINEARRINGZ")) {
            this.dimension = 3;
            geom = this.readLinearRingText();
        } else if (type.equalsIgnoreCase("LINEARRINGM")) {
            this.setHasM(true);
            this.dimension = 3;
            geom = this.readLinearRingText();
        } else if (type.equalsIgnoreCase("LINEARRINGZM")) {
            this.setHasM(true);
            this.dimension = 4;
            geom = this.readLinearRingText();
        } else if (type.equalsIgnoreCase("POLYGON")) {
            geom = this.readPolygonText();
        } else if (type.equalsIgnoreCase("POLYGONZ")) {
            this.dimension = 3;
            geom = this.readPolygonText();
        } else if (type.equalsIgnoreCase("POLYGONM")) {
            this.setHasM(true);
            this.dimension = 3;
            geom = this.readPolygonText();
        } else if (type.equalsIgnoreCase("POLYGONZM")) {
            this.setHasM(true);
            this.dimension = 4;
            geom = this.readPolygonText();
        } else if (type.equalsIgnoreCase("MULTIPOINT")) {
            geom = this.readMultiPointText();
        } else if (type.equalsIgnoreCase("MULTIPOINTZ")) {
            this.dimension = 3;
            geom = this.readMultiPointText();
        } else if (type.equalsIgnoreCase("MULTIPOINTM")) {
            this.setHasM(true);
            this.dimension = 3;
            geom = this.readMultiPointText();
        } else if (type.equalsIgnoreCase("MULTIPOINTZM")) {
            this.setHasM(true);
            this.dimension = 4;
            geom = this.readMultiPointText();
        } else if (type.equalsIgnoreCase("MULTILINESTRING")) {
            geom = this.readMultiLineStringText();
        } else if (type.equalsIgnoreCase("MULTILINESTRINGZ")) {
            this.dimension = 3;
            geom = this.readMultiLineStringText();
        } else if (type.equalsIgnoreCase("MULTILINESTRINGM")) {
            this.setHasM(true);
            this.dimension = 3;
            geom = this.readMultiLineStringText();
        } else if (type.equalsIgnoreCase("MULTILINESTRINGZM")) {
            this.setHasM(true);
            this.dimension = 4;
            geom = this.readMultiLineStringText();
        } else if (type.equalsIgnoreCase("MULTIPOLYGON")) {
            geom = this.readMultiPolygonText();
        } else if (type.equalsIgnoreCase("MULTIPOLYGONZ")) {
            this.dimension = 3;
            geom = this.readMultiPolygonText();
        } else if (type.equalsIgnoreCase("MULTIPOLYGONM")) {
            this.setHasM(true);
            this.dimension = 3;
            geom = this.readMultiPolygonText();
        } else if (type.equalsIgnoreCase("MULTIPOLYGONZM")) {
            this.setHasM(true);
            this.dimension = 4;
            geom = this.readMultiPolygonText();
        } else {
            throw new ParseException("Unknown geometry type: " + type);
        }
        return geom;
    }

    private void setHasM(boolean hasM) throws ParseException {
        if (this.hasM == null) {
            this.hasM = hasM;
        } else if (this.hasM != hasM) {
            throw new ParseException("Inconsistent use of m-values.");
        }
    }

    private Point readPointText() throws IOException, ParseException, CreateGeometryException {
        String nextToken = this.getNextEmptyOrOpenerOrDimension();
        if (nextToken.equals(EMPTY)) {
            return (Point)this.manager.create(1, this.getSubtype());
        }
        if (nextToken.equals(Z)) {
            this.dimension = 3;
            this.setHasM(false);
            nextToken = this.getNextEmptyOrOpener();
            if (nextToken.equals(EMPTY)) {
                return (Point)this.manager.create(1, this.getSubtype());
            }
        } else if (nextToken.equals(M)) {
            this.dimension = 3;
            this.setHasM(true);
            nextToken = this.getNextEmptyOrOpener();
            if (nextToken.equals(EMPTY)) {
                return (Point)this.manager.create(1, this.getSubtype());
            }
        } else if (nextToken.equals(ZM)) {
            this.dimension = 4;
            this.setHasM(true);
            nextToken = this.getNextEmptyOrOpener();
            if (nextToken.equals(EMPTY)) {
                return (Point)this.manager.create(1, this.getSubtype());
            }
        }
        int subtype = this.getSubtype();
        Coordinate coordinates = this.getPreciseCoordinate();
        Point point = (Point)this.manager.create(1, subtype);
        this.fillPoint(subtype, coordinates, point);
        this.getNextCloser();
        return point;
    }

    private void fillPoint(int subtype, Coordinate coordinates, Point point) {
        point.setX(coordinates.x);
        point.setY(coordinates.y);
        if (subtype == 2) {
            point.setCoordinateAt(2, coordinates.getOrdinate(3));
        } else if (subtype == 3) {
            point.setCoordinateAt(2, coordinates.getOrdinate(2));
            point.setCoordinateAt(3, coordinates.getOrdinate(3));
        } else if (subtype == 1) {
            point.setCoordinateAt(2, coordinates.getOrdinate(2));
        }
    }

    private int getSubtype() {
        int subtype;
        switch (this.dimension) {
            case 4: {
                subtype = 3;
                break;
            }
            case 3: {
                if (this.hasM.booleanValue()) {
                    subtype = 2;
                    break;
                }
                subtype = 1;
                break;
            }
            default: {
                subtype = 0;
            }
        }
        return subtype;
    }

    private Line readLineStringText() throws IOException, ParseException, CreateGeometryException {
        MCoordinate[] coords = this.getCoordinates();
        Line line = (Line)this.manager.create(18, this.getSubtype());
        int subtype = this.getSubtype();
        for (int i = 0; i < coords.length; ++i) {
            Point point = (Point)this.manager.create(1, this.getSubtype());
            this.fillPoint(subtype, coords[i], point);
            line.addVertex(point);
        }
        return line;
    }

    private Ring readLinearRingText() throws IOException, ParseException, CreateGeometryException {
        MCoordinate[] coords = this.getCoordinates();
        int subtype = this.getSubtype();
        Ring ring = (Ring)this.manager.create(20, subtype);
        for (int i = 0; i < coords.length; ++i) {
            Point point = (Point)this.manager.create(1, subtype);
            this.fillPoint(subtype, coords[i], point);
            ring.addVertex(point);
        }
        return ring;
    }

    private MultiPoint readMultiPointText() throws IOException, ParseException, CreateGeometryException {
        String nextToken = this.getNextEmptyOrOpenerOrDimension();
        if (nextToken.equals(Z)) {
            this.dimension = 3;
            this.setHasM(false);
            nextToken = this.getNextEmptyOrOpener();
        } else if (nextToken.equals(M)) {
            this.dimension = 3;
            this.setHasM(true);
            nextToken = this.getNextEmptyOrOpener();
        } else if (nextToken.equals(ZM)) {
            this.dimension = 4;
            this.setHasM(true);
            nextToken = this.getNextEmptyOrOpener();
        } else {
            this.setHasM(false);
            this.dimension = 2;
        }
        int subtype = this.getSubtype();
        MultiPoint multiPoint = (MultiPoint)this.manager.create(7, subtype);
        if (nextToken.equals(EMPTY)) {
            return multiPoint;
        }
        int token = this.tokenizer.nextToken();
        this.tokenizer.pushBack();
        if (token == 40) {
            String stoken;
            do {
                Point p = this.readPointText();
                multiPoint.addPoint(p);
            } while (StringUtils.equalsIgnoreCase((CharSequence)(stoken = this.getNextCloserOrComma()), (CharSequence)COMMA));
        } else {
            String stoken;
            do {
                Coordinate coordinates = this.getPreciseCoordinate();
                Point point = (Point)this.manager.create(1, subtype);
                this.fillPoint(subtype, coordinates, point);
                multiPoint.addPoint(point);
            } while (StringUtils.equalsIgnoreCase((CharSequence)(stoken = this.getNextCloserOrComma()), (CharSequence)COMMA));
        }
        return multiPoint;
    }

    private Point[] toPoints(Coordinate[] coordinates) {
        ArrayList<com.vividsolutions.jts.geom.Point> points = new ArrayList<com.vividsolutions.jts.geom.Point>();
        for (int i = 0; i < coordinates.length; ++i) {
            points.add(this.geometryFactory.createPoint(coordinates[i]));
        }
        return points.toArray(new Point[0]);
    }

    private Polygon readPolygonText() throws IOException, ParseException, CreateGeometryException {
        String nextToken = this.getNextEmptyOrOpenerOrDimension();
        if (nextToken.equals(EMPTY)) {
            return (Polygon)this.manager.create(19, this.getSubtype());
        }
        if (nextToken.equals(Z)) {
            this.dimension = 3;
            this.setHasM(false);
            nextToken = this.getNextEmptyOrOpener();
            if (nextToken.equals(EMPTY)) {
                return (Polygon)this.manager.create(19, this.getSubtype());
            }
        }
        if (nextToken.equals(M)) {
            this.dimension = 3;
            this.setHasM(true);
            nextToken = this.getNextEmptyOrOpener();
            if (nextToken.equals(EMPTY)) {
                return (Polygon)this.manager.create(19, this.getSubtype());
            }
        }
        if (nextToken.equals(ZM)) {
            this.dimension = 4;
            this.setHasM(true);
            nextToken = this.getNextEmptyOrOpener();
            if (nextToken.equals(EMPTY)) {
                return (Polygon)this.manager.create(19, this.getSubtype());
            }
        }
        Polygon polygon = (Polygon)this.manager.create(19, this.getSubtype());
        ArrayList holes = new ArrayList();
        Ring shell = this.readLinearRingText();
        for (int i = 0; i < shell.getNumVertices(); ++i) {
            polygon.addVertex(shell.getVertex(i));
        }
        nextToken = this.getNextCloserOrComma();
        while (nextToken.equals(COMMA)) {
            Ring hole = this.readLinearRingText();
            polygon.addInteriorRing(hole);
            nextToken = this.getNextCloserOrComma();
        }
        return polygon;
    }

    private MultiLine readMultiLineStringText() throws IOException, ParseException, CreateGeometryException {
        String nextToken = this.getNextEmptyOrOpenerOrDimension();
        if (nextToken.equals(EMPTY)) {
            return (MultiLine)this.manager.create(21, this.getSubtype());
        }
        if (nextToken.equals(Z)) {
            this.dimension = 3;
            this.setHasM(false);
            nextToken = this.getNextEmptyOrOpener();
            if (nextToken.equals(EMPTY)) {
                return (MultiLine)this.manager.create(21, this.getSubtype());
            }
        }
        if (nextToken.equals(M)) {
            this.dimension = 3;
            this.setHasM(true);
            nextToken = this.getNextEmptyOrOpener();
            if (nextToken.equals(EMPTY)) {
                return (MultiLine)this.manager.create(21, this.getSubtype());
            }
        }
        if (nextToken.equals(ZM)) {
            this.dimension = 4;
            this.setHasM(true);
            nextToken = this.getNextEmptyOrOpener();
            if (nextToken.equals(EMPTY)) {
                return (MultiLine)this.manager.create(21, this.getSubtype());
            }
        }
        MultiLine multiline = (MultiLine)this.manager.create(21, this.getSubtype());
        Line line = this.readLineStringText();
        if (line != null) {
            multiline.addCurve((Curve)line);
        }
        nextToken = this.getNextCloserOrComma();
        while (nextToken.equals(COMMA)) {
            line = this.readLineStringText();
            if (line != null) {
                multiline.addCurve((Curve)line);
            }
            nextToken = this.getNextCloserOrComma();
        }
        return multiline;
    }

    private MultiPolygon readMultiPolygonText() throws IOException, ParseException, CreateGeometryException {
        String nextToken = this.getNextEmptyOrOpenerOrDimension();
        if (nextToken.equals(Z)) {
            this.dimension = 3;
            this.setHasM(false);
            nextToken = this.getNextEmptyOrOpener();
        } else if (nextToken.equals(M)) {
            this.dimension = 3;
            this.setHasM(true);
            nextToken = this.getNextEmptyOrOpener();
        } else if (nextToken.equals(ZM)) {
            this.dimension = 4;
            this.setHasM(true);
            nextToken = this.getNextEmptyOrOpener();
        } else {
            this.setHasM(false);
            this.dimension = 2;
        }
        MultiPolygon multiPolygon = (MultiPolygon)this.manager.create(22, this.getSubtype());
        if (nextToken.equals(EMPTY)) {
            return multiPolygon;
        }
        Polygon polygon = this.readPolygonText();
        multiPolygon.addSurface((Surface)polygon);
        nextToken = this.getNextCloserOrComma();
        while (nextToken.equals(COMMA)) {
            polygon = this.readPolygonText();
            multiPolygon.addSurface((Surface)polygon);
            nextToken = this.getNextCloserOrComma();
        }
        return multiPolygon;
    }
}

