/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.geom.jts.operation.towkb;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.aggregate.MultiCurve;
import org.gvsig.fmap.geom.aggregate.MultiLine;
import org.gvsig.fmap.geom.aggregate.MultiPoint;
import org.gvsig.fmap.geom.aggregate.MultiPolygon;
import org.gvsig.fmap.geom.aggregate.MultiSurface;
import org.gvsig.fmap.geom.primitive.Curve;
import org.gvsig.fmap.geom.primitive.Line;
import org.gvsig.fmap.geom.primitive.Point;
import org.gvsig.fmap.geom.primitive.Polygon;
import org.gvsig.fmap.geom.primitive.Surface;
import org.gvsig.fmap.geom.type.GeometryType;

public class PostGISEWKBEncoder {
    public static final int wkbPoint = 1;
    public static final int wkbLineString = 2;
    public static final int wkbPolygon = 3;
    public static final int wkbMultiPoint = 4;
    public static final int wkbMultiLineString = 5;
    public static final int wkbMultiPolygon = 6;
    public static final int wkbGeometryCollection = 7;
    static ByteBuffer bytebuffer = ByteBuffer.allocate(8).order(ByteOrder.LITTLE_ENDIAN);

    public byte[] encode(Geometry geometry) throws IOException {
        ByteArrayOutputStream stream = geometry.getType() == 1 ? new ByteArrayOutputStream(50) : new ByteArrayOutputStream(512);
        this.writeGeometry(geometry, new DataOutputStream(stream));
        return stream.toByteArray();
    }

    private void writeInt(DataOutputStream dest, int value) throws IOException {
        byte[] bytes = bytebuffer.putInt(0, value).array();
        dest.writeByte(bytes[0]);
        dest.writeByte(bytes[1]);
        dest.writeByte(bytes[2]);
        dest.writeByte(bytes[3]);
    }

    private void writeDouble(DataOutputStream dest, double value) throws IOException {
        byte[] bytes = bytebuffer.putDouble(0, value).array();
        dest.writeByte(bytes[0]);
        dest.writeByte(bytes[1]);
        dest.writeByte(bytes[2]);
        dest.writeByte(bytes[3]);
        dest.writeByte(bytes[4]);
        dest.writeByte(bytes[5]);
        dest.writeByte(bytes[6]);
        dest.writeByte(bytes[7]);
    }

    protected void writeGeometry(Geometry geom, DataOutputStream dest) throws IOException {
        dest.writeByte(1);
        switch (geom.getType()) {
            case 1: {
                this.encodeWKBGeomHead(1, geom.getGeometryType(), dest);
                this.writePoint((Point)geom, dest);
                break;
            }
            case 18: {
                this.encodeWKBGeomHead(2, geom.getGeometryType(), dest);
                this.writeLine((Curve)((Line)geom), dest);
                break;
            }
            case 19: {
                this.encodeWKBGeomHead(3, geom.getGeometryType(), dest);
                this.writePolygon((Polygon)geom, dest);
                break;
            }
            case 7: {
                this.encodeWKBGeomHead(4, geom.getGeometryType(), dest);
                this.writeMultiPoint((MultiPoint)geom, dest);
                break;
            }
            case 8: 
            case 21: {
                this.encodeWKBGeomHead(5, geom.getGeometryType(), dest);
                this.writeMultiLineString((MultiCurve)geom, dest);
                break;
            }
            case 9: 
            case 22: {
                this.encodeWKBGeomHead(6, geom.getGeometryType(), dest);
                this.writeMultiPolygon((MultiSurface)geom, dest);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown Geometry Type: " + geom.getType());
            }
        }
    }

    private void encodeWKBGeomHead(int wkbBaseType, GeometryType geometryType, DataOutputStream dest) throws IOException {
        int typeword = wkbBaseType;
        GeometryType gtype = geometryType;
        if (gtype.hasZ()) {
            typeword |= Integer.MIN_VALUE;
        }
        if (gtype.hasM()) {
            typeword |= 0x40000000;
        }
        this.writeInt(dest, typeword);
    }

    private void writePoint(Point geom, DataOutputStream dest) throws IOException {
        GeometryType gtype = geom.getGeometryType();
        this.writeDouble(dest, geom.getX());
        this.writeDouble(dest, geom.getY());
        if (gtype.hasZ()) {
            this.writeDouble(dest, geom.getCoordinateAt(2));
        }
        if (gtype.hasM()) {
            this.writeDouble(dest, geom.getCoordinateAt(geom.getDimension() - 1));
        }
    }

    private void writePointArray(Point[] geom, DataOutputStream dest) throws IOException {
        this.writeInt(dest, geom.length);
        for (int i = 0; i < geom.length; ++i) {
            this.writePoint(geom[i], dest);
        }
    }

    private void writeMultiPoint(MultiPoint geom, DataOutputStream dest) throws IOException {
        this.writeInt(dest, geom.getPrimitivesNumber());
        for (Point point : geom) {
            this.writeGeometry((Geometry)point, dest);
        }
    }

    private void writeLine(Curve geom, DataOutputStream dest) throws IOException {
        this.writeInt(dest, geom.getNumVertices());
        for (int i = 0; i < geom.getNumVertices(); ++i) {
            this.writePoint(geom.getVertex(i), dest);
        }
    }

    private void writePolygon(Polygon geom, DataOutputStream dest) throws IOException {
        this.writeInt(dest, geom.getNumInteriorRings() + 1);
        this.writeInt(dest, geom.getNumVertices());
        for (int i = 0; i < geom.getNumVertices(); ++i) {
            this.writePoint(geom.getVertex(i), dest);
        }
    }

    private void writeMultiLineString(MultiCurve geom, DataOutputStream dest) throws IOException {
        this.writeInt(dest, geom.getPrimitivesNumber());
        for (Curve line : geom) {
            this.writeGeometry((Geometry)line, dest);
        }
    }

    private void writeMultiPolygon(MultiSurface geom, DataOutputStream dest) throws IOException {
        this.writeInt(dest, geom.getPrimitivesNumber());
        for (Surface pol : geom) {
            this.writeGeometry((Geometry)pol, dest);
        }
    }

    protected int estimateBytes(Geometry geom) {
        int result = 0;
        ++result;
        result += 4;
        switch (geom.getType()) {
            case 1: {
                result += this.estimatePoint((Point)geom);
                break;
            }
            case 2: 
            case 18: {
                result += this.estimateLine((Curve)geom);
                break;
            }
            case 19: {
                result += this.estimatePolygon((Polygon)geom);
                break;
            }
            case 7: {
                result += this.estimateMultiPoint((MultiPoint)geom);
                break;
            }
            case 21: {
                result += this.estimateMultiLineString((MultiLine)geom);
                break;
            }
            case 22: {
                result += this.estimateMultiPolygon((MultiPolygon)geom);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown Geometry Type: " + geom.getType());
            }
        }
        return result;
    }

    private int estimatePoint(Point geom) {
        GeometryType gtype = geom.getGeometryType();
        int result = 16;
        if (gtype.hasZ()) {
            result += 8;
        }
        if (gtype.hasM()) {
            result += 8;
        }
        return result;
    }

    private int estimateGeometryArray(Geometry[] container) {
        int result = 0;
        for (int i = 0; i < container.length; ++i) {
            result += this.estimateBytes(container[i]);
        }
        return result;
    }

    private int estimatePointArray(Point[] geom) {
        int result = 4;
        if (geom.length > 0) {
            result += geom.length * this.estimatePoint(geom[0]);
        }
        return result;
    }

    private int estimateMultiPoint(MultiPoint geom) {
        int result = 4;
        if (geom.getPrimitivesNumber() > 0) {
            result += geom.getPrimitivesNumber() * this.estimateBytes((Geometry)geom.getPointAt(0));
        }
        return result;
    }

    private int estimateLine(Curve geom) {
        int result = 4;
        if (geom.getNumVertices() > 0) {
            result += geom.getNumVertices() * this.estimatePoint(geom.getVertex(0));
        }
        return result;
    }

    private int estimatePolygon(Polygon geom) {
        int result = 4;
        if (geom.getNumVertices() > 0) {
            result += geom.getNumVertices() * this.estimatePoint(geom.getVertex(0));
        }
        return result;
    }

    private int estimateMultiLineString(MultiLine geom) {
        int result = 4;
        for (Curve line : geom) {
            result += this.estimateLine(line);
        }
        return result;
    }

    private int estimateMultiPolygon(MultiPolygon geom) {
        int result = 4;
        for (Polygon pol : geom) {
            result += this.estimatePolygon(pol);
        }
        return result;
    }
}

