/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.geom.jts.persistence;

import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryException;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.geom.exception.CreateGeometryException;
import org.gvsig.fmap.geom.operation.GeometryOperationException;
import org.gvsig.fmap.geom.operation.GeometryOperationNotSupportedException;
import org.gvsig.tools.dynobject.DynStruct;
import org.gvsig.tools.persistence.AbstractSinglePersistenceFactory;
import org.gvsig.tools.persistence.PersistentState;
import org.gvsig.tools.persistence.exception.PersistenceException;

public class GeometryPersistenceFactory
extends AbstractSinglePersistenceFactory {
    private static final String FIELD_STRING = "string";
    private static final String FIELD_SRS = "srs";
    private static final String DYNCLASS_NAME = "Geometry";
    private static final String DYNCLASS_DESCRIPTION = "gvSIG Geometry";
    private static final String OPERATION_FIELD_NAME = "";
    private static final GeometryManager geometryManager = GeometryLocator.getGeometryManager();

    public GeometryPersistenceFactory() {
        super(Geometry.class, DYNCLASS_NAME, DYNCLASS_DESCRIPTION, null, null);
        DynStruct definition = this.getDefinition();
        definition.addDynFieldString(FIELD_STRING).setMandatory(true);
        definition.addDynFieldString(FIELD_SRS).setMandatory(false);
    }

    public Object createFromState(PersistentState state) throws PersistenceException {
        String string = state.getString(FIELD_STRING);
        String srs = state.getString(FIELD_SRS);
        try {
            return geometryManager.createFrom(string, srs);
        }
        catch (CreateGeometryException e) {
            throw new PersistenceException("Error creating the geometry", (Throwable)e);
        }
        catch (GeometryException e) {
            throw new PersistenceException("Error creating the geometry", (Throwable)e);
        }
    }

    public void saveToState(PersistentState state, Object obj) throws PersistenceException {
        try {
            state.set(FIELD_STRING, ((Geometry)obj).convertToWKT());
        }
        catch (GeometryOperationNotSupportedException e) {
            throw new PersistenceException("Error converting the geometry", (Throwable)e);
        }
        catch (GeometryOperationException e) {
            throw new PersistenceException("Error converting the geometry", (Throwable)e);
        }
    }
}

