/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.geom.jts.primitive.curve.arc;

import com.vividsolutions.jts.geom.Coordinate;
import java.awt.geom.PathIterator;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryException;
import org.gvsig.fmap.geom.aggregate.MultiLine;
import org.gvsig.fmap.geom.aggregate.MultiPoint;
import org.gvsig.fmap.geom.aggregate.MultiPolygon;
import org.gvsig.fmap.geom.jts.aggregate.MultiLine3D;
import org.gvsig.fmap.geom.jts.aggregate.MultiPoint3D;
import org.gvsig.fmap.geom.jts.aggregate.MultiPolygon3D;
import org.gvsig.fmap.geom.jts.primitive.curve.arc.AbstractArc;
import org.gvsig.fmap.geom.jts.primitive.curve.line.Line3D;
import org.gvsig.fmap.geom.jts.primitive.point.Point3D;
import org.gvsig.fmap.geom.jts.primitive.point.PointJTS;
import org.gvsig.fmap.geom.jts.primitive.surface.polygon.Polygon3D;
import org.gvsig.fmap.geom.jts.util.ArrayListCoordinateSequence;
import org.gvsig.fmap.geom.jts.util.JTSUtils;
import org.gvsig.fmap.geom.primitive.Point;

public class Arc2DZ
extends AbstractArc {
    private static final long serialVersionUID = -5691008010954470053L;
    private double zValue = Double.NaN;

    public Arc2DZ() {
        super(1);
    }

    public void setPoints(Point center, double radius, double startAngle, double angleExt) {
        center = this.fixPoint(center);
        this.init = new Point3D(center.getX() + radius * Math.cos(startAngle), center.getY() + radius * Math.sin(startAngle), ((Point3D)center).getZ());
        double midAngle = startAngle + angleExt / 2.0;
        this.middle = new Point3D(center.getX() + radius * Math.cos(midAngle), center.getY() + radius * Math.sin(midAngle), ((Point3D)center).getZ());
        this.end = new Point3D(center.getX() + radius * Math.cos(startAngle + angleExt), center.getY() + radius * Math.sin(startAngle + angleExt), ((Point3D)center).getZ());
    }

    public Point getCenterPoint() {
        ((PointJTS)this.init).getJTS();
        Point3D center = new Point3D(this.getProjection(), JTSUtils.getCircumcentre(this.init, this.middle, this.end));
        return center;
    }

    public Geometry cloneGeometry() {
        Arc2DZ arc2D = new Arc2DZ();
        arc2D.setPoints(this.init.cloneGeometry(), this.middle.cloneGeometry(), this.end.cloneGeometry());
        arc2D.setProjection(this.getProjection());
        return arc2D;
    }

    @Override
    protected Point fixPoint(Point point) {
        if (point instanceof Point3D) {
            Point3D point3D = (Point3D)point;
            if (Double.isNaN(this.zValue) && !Double.isNaN(point3D.getZ())) {
                this.zValue = point3D.getZ();
                if (this.init != null) {
                    ((Point3D)this.init).setZ(this.zValue);
                }
                if (this.middle != null) {
                    ((Point3D)this.middle).setZ(this.zValue);
                }
                if (this.end != null) {
                    ((Point3D)this.end).setZ(this.zValue);
                }
                return point3D;
            }
        }
        return new Point3D(point.getX(), point.getY(), Double.isNaN(this.zValue) ? 0.0 : this.zValue);
    }

    @Override
    public com.vividsolutions.jts.geom.Geometry getJTS() {
        PathIterator pi = this.getPathIterator(null);
        ArrayListCoordinateSequence coordinates = new ArrayListCoordinateSequence();
        double[] coords = new double[6];
        while (!pi.isDone()) {
            switch (pi.currentSegment(coords)) {
                case 0: {
                    coordinates.add(new Coordinate(coords[0], coords[1], this.zValue));
                    break;
                }
                case 1: {
                    coordinates.add(new Coordinate(coords[0], coords[1], this.zValue));
                    break;
                }
                case 2: {
                    coordinates.add(new Coordinate(coords[0], coords[1], this.zValue));
                    coordinates.add(new Coordinate(coords[2], coords[3], this.zValue));
                    break;
                }
                case 3: {
                    coordinates.add(new Coordinate(coords[0], coords[1], this.zValue));
                    coordinates.add(new Coordinate(coords[2], coords[3], this.zValue));
                    coordinates.add(new Coordinate(coords[4], coords[5], this.zValue));
                    break;
                }
                case 4: {
                    coordinates.add(coordinates.get(0));
                }
            }
            pi.next();
        }
        return JTSUtils.createJTSLineString(this.getProjection(), coordinates);
    }

    public MultiPoint toPoints() throws GeometryException {
        MultiPoint3D multiPoint = new MultiPoint3D();
        Coordinate[] coordinates = this.getJTS().getCoordinates();
        multiPoint.ensureCapacity(coordinates.length);
        for (int i = 0; i < coordinates.length; ++i) {
            multiPoint.addPoint(new Point3D(this.getProjection(), coordinates[i].x, coordinates[i].y, this.zValue));
        }
        return multiPoint;
    }

    public MultiLine toLines() throws GeometryException {
        MultiLine3D multiLine = new MultiLine3D();
        Line3D line = new Line3D(this.getJTS().getCoordinates());
        multiLine.addPrimitive(line);
        return multiLine;
    }

    public MultiPolygon toPolygons() throws GeometryException {
        MultiPolygon3D multiPolygon = new MultiPolygon3D();
        Polygon3D polygon = new Polygon3D(this.getJTS().getCoordinates());
        multiPolygon.addPrimitive(polygon);
        return multiPolygon;
    }
}

