/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.geom.jts.primitive.curve.line;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.operation.buffer.BufferParameters;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.jts.primitive.curve.line.BaseLine2DM;
import org.gvsig.fmap.geom.jts.util.ArrayListCoordinateSequence;
import org.gvsig.fmap.geom.jts.util.JTSUtils;
import org.gvsig.fmap.geom.jts.util.OpenJUMPUtils;
import org.gvsig.fmap.geom.operation.GeometryOperationException;
import org.gvsig.fmap.geom.operation.GeometryOperationNotSupportedException;
import org.gvsig.fmap.geom.primitive.Line;

public class Line2DM
extends BaseLine2DM
implements Line {
    private static final long serialVersionUID = -2400803975672135247L;

    public Line2DM() {
        super(18);
    }

    public Line2DM(Coordinate[] coordinates) {
        super(18, coordinates);
    }

    public Line2DM(ArrayListCoordinateSequence coordinates) {
        super(18, coordinates);
    }

    public Line cloneGeometry() {
        Line2DM clone = new Line2DM(this.cloneCoordinates().toCoordinateArray());
        clone.setProjection(this.getProjection());
        return clone;
    }

    public Line clone() throws CloneNotSupportedException {
        return this.cloneGeometry();
    }

    public Geometry offset(double distance) throws GeometryOperationNotSupportedException, GeometryOperationException {
        if (this.isClosed()) {
            return JTSUtils.offsetClosedLine(this.getProjection(), this.coordinates, distance);
        }
        return OpenJUMPUtils.offsetCleanOpenLine(this.getProjection(), this.coordinates, distance);
    }

    public Geometry offset(int joinStyle, double distance) throws GeometryOperationNotSupportedException, GeometryOperationException {
        if (this.isClosed(0.0)) {
            return JTSUtils.offsetClosedLine(this.getProjection(), this.coordinates, joinStyle, distance);
        }
        BufferParameters bufParams = JTSUtils.getBufferParameters(joinStyle, 2);
        return OpenJUMPUtils.offsetCleanOpenLine(this.getProjection(), this.coordinates, bufParams, distance);
    }

    @Override
    public boolean equals(Object obj) {
        boolean res = super.equals(obj);
        if (res && obj instanceof Line2DM) {
            Line2DM other = (Line2DM)obj;
            if (this.getNumVertices() != other.getNumVertices()) {
                return false;
            }
            for (int i = 0; i < this.getNumVertices(); ++i) {
                if (((Coordinate)other.coordinates.get(i)).getOrdinate(3) == ((Coordinate)this.coordinates.get(i)).getOrdinate(3)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public Geometry force2DM() throws GeometryOperationNotSupportedException, GeometryOperationException {
        Line c = this.cloneGeometry();
        return c;
    }
}

