/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.geom.jts.primitive.point;

import com.vividsolutions.jts.geom.Coordinate;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import org.cresques.cts.IProjection;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryException;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.aggregate.MultiPoint;
import org.gvsig.fmap.geom.jts.aggregate.MultiPoint2D;
import org.gvsig.fmap.geom.jts.gputils.DefaultGeneralPathX;
import org.gvsig.fmap.geom.jts.gputils.GeneralPathXIterator;
import org.gvsig.fmap.geom.jts.primitive.curve.circumference.Circumference2D;
import org.gvsig.fmap.geom.jts.primitive.point.AbstractPoint;
import org.gvsig.fmap.geom.jts.primitive.point.Point2DM;
import org.gvsig.fmap.geom.jts.primitive.point.Point3D;
import org.gvsig.fmap.geom.jts.primitive.point.Point3DM;
import org.gvsig.fmap.geom.operation.GeometryOperationException;
import org.gvsig.fmap.geom.operation.GeometryOperationNotSupportedException;
import org.gvsig.fmap.geom.primitive.GeneralPathX;
import org.gvsig.fmap.geom.primitive.IGeneralPathX;
import org.gvsig.fmap.geom.primitive.Point;
import org.gvsig.fmap.geom.type.GeometryType;

public class Point2D
extends AbstractPoint {
    private static final long serialVersionUID = -5486980182751169991L;

    public Point2D(IProjection proj, Coordinate coordinates) {
        super(0, coordinates);
        this.setProjection(proj);
    }

    public Point2D() {
        this(null, new Coordinate(0.0, 0.0));
    }

    public Point2D(double x, double y) {
        this(null, new Coordinate(x, y));
    }

    public Point2D(IProjection proj, double x, double y) {
        this(proj, new Coordinate(x, y));
    }

    public Point cloneGeometry() {
        Point2D clone = new Point2D(this.getProjection(), (Coordinate)this.coordinate.clone());
        clone.setProjection(this.getProjection());
        return clone;
    }

    public int getDimension() {
        return 2;
    }

    @Override
    public GeometryType getGeometryType() {
        try {
            return GeometryLocator.getGeometryManager().getGeometryType(1, 0);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public boolean is3D() {
        return false;
    }

    @Override
    public void setJTSCoordinate(Coordinate coordinate) {
        this.coordinate = coordinate;
    }

    public GeneralPathX getGeneralPath() {
        return new DefaultGeneralPathX(new PointIterator(null), false, 0.0);
    }

    public PathIterator getPathIterator(AffineTransform at) {
        PointIterator pi = new PointIterator(at);
        return pi;
    }

    public MultiPoint toPoints() throws GeometryException {
        MultiPoint2D multiPoint = new MultiPoint2D();
        multiPoint.addPoint(this);
        return multiPoint;
    }

    public Geometry offset(double distance) throws GeometryOperationNotSupportedException, GeometryOperationException {
        return new Circumference2D(this.cloneGeometry(), distance);
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("POINT (");
        for (int i = 0; i < this.getDimension() - 1; ++i) {
            builder.append(this.getCoordinateAt(i));
            builder.append(" ");
        }
        builder.append(this.getCoordinateAt(this.getDimension() - 1));
        builder.append(")");
        return builder.toString();
    }

    @Override
    public boolean equals(Object obj) {
        Point other;
        if (obj == null) {
            return false;
        }
        try {
            other = (Point)obj;
        }
        catch (ClassCastException e) {
            return false;
        }
        if (this.getGeometryType().getSubType() != other.getGeometryType().getSubType()) {
            return false;
        }
        if (this.coordinate.x != other.getX()) {
            return false;
        }
        return this.coordinate.y == other.getY();
    }

    public Point force3D() {
        Point3D p = new Point3D(this.getProjection(), this.coordinate.x, this.coordinate.y, 0.0);
        return p;
    }

    public Point force2DM() {
        Point2DM p = new Point2DM(this.getProjection(), this.coordinate.x, this.coordinate.y, 0.0);
        return p;
    }

    public Point force3DM() {
        Point3DM p = new Point3DM(this.getProjection(), this.coordinate.x, this.coordinate.y, 0.0, 0.0);
        return p;
    }

    public class PointIterator
    extends GeneralPathXIterator {
        private final AffineTransform at;
        private boolean done;

        public PointIterator(AffineTransform at) {
            super((IGeneralPathX)new GeneralPathX());
            if (at == null) {
                at = new AffineTransform();
            }
            this.at = at;
            this.done = Point2D.this.isEmpty();
        }

        @Override
        public int getWindingRule() {
            return 0;
        }

        @Override
        public void next() {
            this.done = true;
        }

        @Override
        public boolean isDone() {
            return this.done;
        }

        @Override
        public int currentSegment(double[] coords) {
            coords[0] = Point2D.this.getX();
            coords[1] = Point2D.this.getY();
            this.at.transform(coords, 0, coords, 0, 1);
            return 0;
        }

        @Override
        public int currentSegment(float[] coords) {
            coords[0] = (float)Point2D.this.getX();
            coords[1] = (float)Point2D.this.getY();
            this.at.transform(coords, 0, coords, 0, 1);
            return 0;
        }
    }
}

