/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.geom.jts.spatialindex;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.index.ItemVisitor;
import com.vividsolutions.jts.index.quadtree.Quadtree;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.SerializationException;
import org.apache.commons.lang3.SerializationUtils;
import org.codehaus.plexus.util.IOUtil;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.geom.SpatialIndex;
import org.gvsig.fmap.geom.SpatialIndexFactory;
import org.gvsig.fmap.geom.jts.GeometryJTS;
import org.gvsig.fmap.geom.spi.spatialindex.AbstractSpatialIndex;
import org.gvsig.tools.dynobject.DynObject;
import org.gvsig.tools.visitor.Visitor;

public class SpatialIndexJTSQuadtree
extends AbstractSpatialIndex
implements SpatialIndex {
    private Quadtree index = null;
    private boolean modified = false;

    public SpatialIndexJTSQuadtree(GeometryManager geometryManager, SpatialIndexFactory factory, DynObject parameters) {
        super(geometryManager, factory, parameters);
        this.open();
    }

    public void open() {
        this.index = new Quadtree();
        File f = (File)this.getParameter("file");
        if (f != null && f.exists()) {
            this.load(f);
        }
    }

    public void close() {
        File f = (File)this.getParameter("file");
        if (f != null && this.modified) {
            try {
                this.save(f);
            }
            catch (FileNotFoundException ex) {
                throw new RuntimeException("Can't save spatial index to '" + f.getAbsolutePath() + "'.");
            }
        }
        this.index = null;
    }

    private void load(File fname) {
        FileInputStream is = null;
        BufferedInputStream bis = null;
        ObjectInputStreamWithClassLoader ois = null;
        try {
            is = new FileInputStream(fname);
            bis = new BufferedInputStream(is);
            ois = new ObjectInputStreamWithClassLoader(bis, ((Object)((Object)this)).getClass().getClassLoader());
            Object x = ois.readObject();
            this.index = (Quadtree)x;
            this.modified = false;
        }
        catch (Exception ex) {
            try {
                throw new SerializationException("Can't deseralize quadtree from '" + Objects.toString(fname) + "'.", (Throwable)ex);
            }
            catch (Throwable throwable) {
                IOUtil.close(ois);
                IOUtil.close(bis);
                IOUtil.close((InputStream)is);
                throw throwable;
            }
        }
        IOUtil.close((InputStream)ois);
        IOUtil.close((InputStream)bis);
        IOUtil.close((InputStream)is);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void save(File fname) throws FileNotFoundException {
        FileOutputStream os = null;
        BufferedOutputStream bos = null;
        try {
            os = new FileOutputStream(fname);
            bos = new BufferedOutputStream(os);
            SerializationUtils.serialize((Serializable)this.index, (OutputStream)bos);
            this.modified = false;
        }
        catch (Throwable throwable) {
            IOUtil.close(bos);
            IOUtil.close((OutputStream)os);
            throw throwable;
        }
        IOUtil.close((OutputStream)bos);
        IOUtil.close((OutputStream)os);
    }

    private com.vividsolutions.jts.geom.Geometry asJTS(Geometry geom) {
        return ((GeometryJTS)geom).getJTS();
    }

    public long size() {
        return this.index.size();
    }

    public void query(org.gvsig.fmap.geom.primitive.Envelope envelope, Visitor visitor) {
        if (envelope == null || envelope.isEmpty()) {
            return;
        }
        JTSVisitorWrapper visitor_jts = new JTSVisitorWrapper(visitor);
        Envelope env_jts = this.asJTS(envelope.getGeometry()).getEnvelopeInternal();
        this.index.query(env_jts, (ItemVisitor)visitor_jts);
    }

    public Iterator query(org.gvsig.fmap.geom.primitive.Envelope envelope, long limit) {
        if (limit > 0L && limit != Long.MAX_VALUE) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
        if (envelope == null || envelope.isEmpty()) {
            return Collections.emptyIterator();
        }
        Envelope env_jts = this.asJTS(envelope.getGeometry()).getEnvelopeInternal();
        List result = this.index.query(env_jts);
        return result.iterator();
    }

    public Iterator queryNearest(org.gvsig.fmap.geom.primitive.Envelope envelope, long limit) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Iterator queryAll() {
        List result = this.index.queryAll();
        return result.iterator();
    }

    public void insert(org.gvsig.fmap.geom.primitive.Envelope envelope, Object data) {
        if (envelope == null || envelope.isEmpty()) {
            return;
        }
        Envelope env_jts = this.asJTS(envelope.getGeometry()).getEnvelopeInternal();
        this.index.insert(env_jts, data);
        this.modified = true;
    }

    public boolean remove(org.gvsig.fmap.geom.primitive.Envelope envelope, Object data) {
        if (envelope == null || envelope.isEmpty()) {
            return false;
        }
        Envelope env_jts = this.asJTS(envelope.getGeometry()).getEnvelopeInternal();
        this.modified = true;
        return this.index.remove(env_jts, data);
    }

    public void removeAll() {
        this.index = new Quadtree();
        this.modified = true;
    }

    public void flush() {
        File f = (File)this.getParameter("file");
        if (f != null) {
            try {
                this.save(f);
            }
            catch (FileNotFoundException ex) {
                throw new RuntimeException("Can't save spatial index to '" + f.getAbsolutePath() + "'.");
            }
        }
    }

    private static class ObjectInputStreamWithClassLoader
    extends ObjectInputStream {
        private final ClassLoader classLoader;

        public ObjectInputStreamWithClassLoader(InputStream in, ClassLoader classLoader) throws IOException {
            super(in);
            this.classLoader = classLoader;
        }

        @Override
        protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
            String name = desc.getName();
            try {
                return Class.forName(name, false, this.classLoader);
            }
            catch (ClassNotFoundException ex) {
                try {
                    return Class.forName(name, false, Thread.currentThread().getContextClassLoader());
                }
                catch (ClassNotFoundException cnfe) {
                    return super.resolveClass(desc);
                }
            }
        }
    }

    private class JTSVisitorWrapper
    implements ItemVisitor {
        private Visitor visitor = null;

        public JTSVisitorWrapper(Visitor visitor) {
            this.visitor = visitor;
        }

        public void visitItem(Object arg0) {
            try {
                this.visitor.visit(arg0);
            }
            catch (Exception e) {
                throw new RuntimeException();
            }
        }
    }
}

