/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vectorediting.swing.impl;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.LayoutManager;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.commons.text.WordUtils;
import org.gvsig.expressionevaluator.Expression;
import org.gvsig.expressionevaluator.ExpressionUtils;
import org.gvsig.expressionevaluator.Function;
import org.gvsig.expressionevaluator.SymbolTable;
import org.gvsig.fmap.dal.DataStore;
import org.gvsig.fmap.dal.EditingNotification;
import org.gvsig.fmap.dal.EditingNotificationManager;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.FeatureSelection;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.dal.swing.DALSwingLocator;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.primitive.Point;
import org.gvsig.fmap.geom.type.GeometryType;
import org.gvsig.fmap.mapcontext.MapContext;
import org.gvsig.fmap.mapcontext.layers.CancelationException;
import org.gvsig.fmap.mapcontext.layers.FLayer;
import org.gvsig.fmap.mapcontext.layers.FLayers;
import org.gvsig.fmap.mapcontext.layers.LayerCollectionEvent;
import org.gvsig.fmap.mapcontext.layers.LayerCollectionListener;
import org.gvsig.fmap.mapcontext.layers.LayerEvent;
import org.gvsig.fmap.mapcontext.layers.LayerListener;
import org.gvsig.fmap.mapcontext.layers.LayerPositionEvent;
import org.gvsig.fmap.mapcontext.layers.SpatialCache;
import org.gvsig.fmap.mapcontext.layers.vectorial.FLyrVect;
import org.gvsig.fmap.mapcontext.rendering.legend.IVectorLegend;
import org.gvsig.fmap.mapcontrol.MapControl;
import org.gvsig.fmap.mapcontrol.tools.Behavior.Behavior;
import org.gvsig.fmap.mapcontrol.tools.Behavior.IBehavior;
import org.gvsig.fmap.mapcontrol.tools.CompoundBehavior;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.bookmarksandhistory.Bookmarks;
import org.gvsig.tools.bookmarksandhistory.History;
import org.gvsig.tools.dataTypes.Coercion;
import org.gvsig.tools.dispose.DisposableIterator;
import org.gvsig.tools.exception.BaseException;
import org.gvsig.tools.future.FutureUtils;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.locator.LocatorException;
import org.gvsig.tools.observer.BaseNotification;
import org.gvsig.tools.observer.Observable;
import org.gvsig.tools.observer.ObservableHelper;
import org.gvsig.tools.observer.Observer;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.threadsafedialogs.ThreadSafeDialogsManager;
import org.gvsig.tools.task.SimpleTaskStatus;
import org.gvsig.utils.console.JDockPanel;
import org.gvsig.utils.console.ResponseListener;
import org.gvsig.vectorediting.lib.api.DrawingStatus;
import org.gvsig.vectorediting.lib.api.EditingLocator;
import org.gvsig.vectorediting.lib.api.EditingManager;
import org.gvsig.vectorediting.lib.api.EditingService;
import org.gvsig.vectorediting.lib.api.EditingServiceInfo;
import org.gvsig.vectorediting.lib.api.EditingServiceParameter;
import org.gvsig.vectorediting.lib.api.exceptions.CreateEditingBehaviorException;
import org.gvsig.vectorediting.lib.api.exceptions.EndEditingException;
import org.gvsig.vectorediting.lib.api.exceptions.InvalidEntryException;
import org.gvsig.vectorediting.lib.api.exceptions.ParsePointException;
import org.gvsig.vectorediting.lib.api.exceptions.ParseValueException;
import org.gvsig.vectorediting.lib.api.exceptions.ServiceInformationException;
import org.gvsig.vectorediting.lib.api.exceptions.StartEditingException;
import org.gvsig.vectorediting.lib.api.exceptions.StartServiceException;
import org.gvsig.vectorediting.lib.api.exceptions.StopServiceException;
import org.gvsig.vectorediting.lib.api.exceptions.VectorEditingException;
import org.gvsig.vectorediting.swing.api.EditingContext;
import org.gvsig.vectorediting.swing.api.EditingSwingLocator;
import org.gvsig.vectorediting.swing.api.EditingSwingManager;
import org.gvsig.vectorediting.swing.api.console.EditingConsole;
import org.gvsig.vectorediting.swing.impl.DefaultEditingBehavior;
import org.gvsig.vectorediting.swing.impl.EditingCompoundBehavior;
import org.gvsig.vectorediting.swing.impl.EditingContextSymbolTable;
import org.gvsig.vectorediting.swing.impl.console.DefaultEditingConsole;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultEditingContext
implements EditingContext {
    private static final Logger LOGGER = LoggerFactory.getLogger(EditingManager.class);
    private WeakReference<MapControl> mapControlReference;
    private WeakReference<MapContext> mapContextReference;
    private EditingCompoundBehavior editingCompoundBehavior;
    private Behavior[] lastAdditionalBehaviors;
    private final ObservableHelper observableHelper;
    private EditingConsole console;
    private JDockPanel dockConsole = null;
    private boolean isShowConsole = false;
    private final Stack<EditingService> serviceStack;
    private FLyrVect currentLayer;
    private EditingServiceParameter currentParam;
    private Behavior[] defaultBehaviors;
    private Set<FLyrVect> layersSpatialCacheEnabled = new HashSet<FLyrVect>();
    private int drawMode;
    private Set<FLyrVect> removeFromSnapping;
    private final LayerListener layerListener = new LayerListener(){

        public void activationChanged(final LayerEvent e) {
            FLayer[] activeLayers;
            if (!SwingUtilities.isEventDispatchThread()) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        this.activationChanged(e);
                    }
                });
                return;
            }
            FLayer layer = e.getSource();
            MapContext mapContext = layer.getMapContext();
            if (DefaultEditingContext.this.countActiveAndEditingLayers(mapContext) > 1) {
                DefaultEditingContext.this.hideConsole();
                return;
            }
            if (layer instanceof FLyrVect) {
                SpatialCache spatialCache;
                if (layer.isActive()) {
                    if (layer.isEditing()) {
                        DefaultEditingContext.this.setCurrentLayer((FLyrVect)layer);
                        DefaultEditingContext.this.showConsole();
                        return;
                    }
                    spatialCache = ((FLyrVect)layer).getSpatialCache();
                    if (!spatialCache.isEnabled("active")) {
                        spatialCache.setEnabled("active", true);
                        DefaultEditingContext.this.layersSpatialCacheEnabled.add((FLyrVect)layer);
                        ((FLyrVect)layer).refreshSpatialCache(mapContext.getViewPort().getEnvelope());
                    }
                } else if (!layer.isEditing() && (spatialCache = ((FLyrVect)layer).getSpatialCache()).isEnabled("active") && DefaultEditingContext.this.layersSpatialCacheEnabled.contains((FLyrVect)layer)) {
                    spatialCache.setEnabled("active", false);
                    DefaultEditingContext.this.layersSpatialCacheEnabled.remove((FLyrVect)layer);
                }
            }
            for (FLayer activeLayer : activeLayers = layer.getMapContext().getLayers().getActives()) {
                if (!(activeLayer instanceof FLyrVect) || !activeLayer.isEditing()) continue;
                DefaultEditingContext.this.setCurrentLayer((FLyrVect)activeLayer);
                DefaultEditingContext.this.showConsole();
                return;
            }
            DefaultEditingContext.this.hideConsole();
        }

        public void drawValueChanged(LayerEvent e) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void editionChanged(final LayerEvent e) {
            if (!SwingUtilities.isEventDispatchThread()) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        this.editionChanged(e);
                    }
                });
                return;
            }
            FLayer layer = e.getSource();
            if (layer instanceof FLyrVect) {
                if (layer.isEditing()) {
                    DefaultEditingContext defaultEditingContext = DefaultEditingContext.this;
                    synchronized (defaultEditingContext) {
                        DefaultEditingContext.this.beginEdition((FLyrVect)layer);
                        DefaultEditingContext.this.showConsole();
                    }
                } else {
                    DefaultEditingContext.this.hideConsole();
                }
            }
        }

        public void nameChanged(LayerEvent e) {
        }

        public void visibilityChanged(LayerEvent e) {
        }
    };
    private final PreferenceChangeListener preferenceChangeListener = new PreferenceChangeListener(){

        @Override
        public void preferenceChange(PreferenceChangeEvent evt) {
            String key = evt.getKey();
            if (key.equalsIgnoreCase("apply-snappers")) {
                boolean newValue = Boolean.parseBoolean(evt.getNewValue());
                DefaultEditingContext.this.getMapControl().setRefentEnabled(newValue);
            }
        }
    };
    private static final int WRITE_OPTION_SAVE = 1;
    private static final int WRITE_OPTION_EXPORT = 2;
    private static final EditingContextSymbolTable contextSymbolTable = new EditingContextSymbolTable();
    TasksDispatcher tasksDispatcher = null;

    private int countActiveAndEditingLayers(MapContext mapcontext) {
        FLayer[] activeLayers;
        int count = 0;
        for (FLayer activeLayer : activeLayers = mapcontext.getLayers().getActives()) {
            if (!(activeLayer instanceof FLyrVect) || !activeLayer.isEditing()) continue;
            ++count;
        }
        return count;
    }

    public DefaultEditingContext(MapControl mapControl) {
        this.mapControlReference = new WeakReference<MapControl>(mapControl);
        this.mapContextReference = new WeakReference<MapContext>(mapControl.getMapContext());
        this.observableHelper = new ObservableHelper();
        this.serviceStack = new Stack();
        this.drawMode = 0;
        this.removeFromSnapping = new HashSet<FLyrVect>();
        this.addLayerListeners();
        this.addPreferenceListener();
    }

    private void addPreferenceListener() {
        Preferences prefs = Preferences.userRoot().node("snappers");
        prefs.addPreferenceChangeListener(this.preferenceChangeListener);
    }

    public void activateService(String name) {
        if (this.isProcessing()) {
            return;
        }
        if (this.getMapControl() != null && this.getMapControl().hasTool("VectorEditing")) {
            EditingCompoundBehavior editingCompoundBehavior = this.getEditingCompoundBehavior();
            this.getMapControl().setTool("VectorEditing");
            editingCompoundBehavior.setDrawnBehavior(0, true);
            EditingManager manager = EditingLocator.getManager();
            if (this.currentLayer != null) {
                IVectorLegend legend = null;
                try {
                    legend = (IVectorLegend)this.currentLayer.getLegend();
                }
                catch (Exception e) {
                    LOGGER.trace("Can't retrieve legend from layer.");
                }
                EditingService service = manager.getEditingService(name, this.currentLayer.getFeatureStore(), (MapContext)this.mapContextReference.get(), legend);
                if (service != null) {
                    this.enableSelection(false);
                    try {
                        service.activate();
                        service.start();
                        this.setDrawMode(0);
                    }
                    catch (StartServiceException e) {
                        LOGGER.info(String.format("Can't start the service %1$s", service.getName()), (Throwable)e);
                        I18nManager i18nManager = ToolsLocator.getI18nManager();
                        this.showConsoleMessage("\n" + i18nManager.getTranslation("_Cant_start_tool") + "\n" + e.getLocalizedMessage());
                        this.cleanEditingContext();
                        return;
                    }
                    catch (InvalidEntryException ex) {
                        I18nManager i18nManager = ToolsLocator.getI18nManager();
                        String stateMessage = ex.getStateMessage();
                        if (StringUtils.isBlank((CharSequence)stateMessage)) {
                            this.showConsoleMessage("\n" + i18nManager.getTranslation("invalid_option"));
                        } else {
                            this.showConsoleMessage("\n" + i18nManager.getTranslation("invalid_option") + ": " + (String)StringUtils.defaultIfBlank((CharSequence)ex.getStateMessage(), (CharSequence)""));
                        }
                    }
                    catch (Exception e) {
                        LOGGER.info(String.format("Can't start the service %1$s", service.getName()), (Throwable)e);
                        I18nManager i18nManager = ToolsLocator.getI18nManager();
                        this.showConsoleMessage("\n" + i18nManager.getTranslation("_An_error_has_occurred") + "\n" + e.getLocalizedMessage());
                        this.cleanEditingContext();
                        return;
                    }
                    if (!this.serviceStack.isEmpty()) {
                        if (this.getActiveService().next().getTypes().contains(EditingServiceParameter.TYPE.GEOMETRY)) {
                            service.setShowPreviewSymbol(false);
                        } else {
                            this.serviceStack.pop();
                        }
                    }
                    this.setActiveService(service);
                    this.nextParameter();
                }
            }
        }
    }

    private void addBehaviors(Behavior[] additionalBehavior) throws CreateEditingBehaviorException {
        if (!this.getMapControl().hasTool("VectorEditing")) {
            DefaultEditingBehavior editingBehavior = new DefaultEditingBehavior(this);
            EditingCompoundBehavior editingCompoundBehavior = new EditingCompoundBehavior((IBehavior)editingBehavior);
            this.setCompoundBehavior(editingCompoundBehavior);
            if (additionalBehavior != null) {
                Behavior[] behaviors = new Behavior[additionalBehavior.length + 1];
                behaviors[0] = editingCompoundBehavior;
                System.arraycopy(additionalBehavior, 0, behaviors, 1, additionalBehavior.length);
                this.getMapControl().addBehavior("VectorEditing", behaviors);
                this.lastAdditionalBehaviors = additionalBehavior;
            } else {
                this.getMapControl().addBehavior("VectorEditing", (Behavior)editingCompoundBehavior);
            }
        } else {
            EditingCompoundBehavior editingCompoundBehavior = this.getEditingCompoundBehavior();
            DefaultEditingBehavior editingBehavior = (DefaultEditingBehavior)editingCompoundBehavior.getBehavior(0);
            this.setCompoundBehavior(editingCompoundBehavior);
            this.cleanEditingContext();
        }
    }

    private void addLayerListeners() {
        FLayers layers = ((MapContext)this.mapContextReference.get()).getLayers();
        layers.addLayerListener(this.layerListener);
        layers.addLayerCollectionListener(new LayerCollectionListener(){

            public void addLayer(FLayer layer) {
                if (layer instanceof FLayers) {
                    FLayers layers = (FLayers)layer;
                    for (int i = 0; i < layers.getLayersCount(); ++i) {
                        this.addLayer(layers.getLayer(i));
                    }
                } else if (layer instanceof FLyrVect) {
                    ((FLyrVect)layer).addLayerListener(DefaultEditingContext.this.layerListener);
                }
            }

            public void layerAdded(LayerCollectionEvent e) {
                this.addLayer((FLayer)e.getLayers());
            }

            public void layerAdding(LayerCollectionEvent e) throws CancelationException {
            }

            public void layerMoved(LayerPositionEvent e) {
            }

            public void layerMoving(LayerPositionEvent e) throws CancelationException {
            }

            public void removeLayer(FLayer layer) {
                if (layer instanceof FLayers) {
                    FLayers layers = (FLayers)layer;
                    for (int i = 0; i < layers.getLayersCount(); ++i) {
                        this.addLayer(layers.getLayer(i));
                    }
                } else if (layer instanceof FLyrVect) {
                    ((FLyrVect)layer).removeLayerListener(DefaultEditingContext.this.layerListener);
                }
            }

            public void layerRemoved(LayerCollectionEvent e) {
                this.removeLayer((FLayer)e.getLayers());
            }

            public void layerRemoving(LayerCollectionEvent e) throws CancelationException {
            }

            public void visibilityChanged(LayerCollectionEvent e) throws CancelationException {
            }
        });
    }

    public void addObserver(Observer o) {
        this.observableHelper.addObserver(o);
    }

    private void askQuestion(EditingServiceParameter param) {
        I18nManager i18nManager = ToolsLocator.getI18nManager();
        String translation = i18nManager.getTranslation(param.getDescription());
        String activeServiceName = i18nManager.getTranslation(this.getActiveService().getName());
        String strDefaultValue = param.getConsoleDefaultValue();
        if (StringUtils.isBlank((CharSequence)strDefaultValue)) {
            this.showConsoleMessage("\n" + activeServiceName + "# " + translation + " : ");
        } else {
            this.showConsoleMessage("\n" + activeServiceName + "# " + translation + "<" + strDefaultValue + "> : ");
        }
    }

    public synchronized void beginEdition(FLyrVect layer, Behavior[] additionalBehaviors) {
        try {
            throw new Exception("Deprecated method");
        }
        catch (Exception e) {
            LOGGER.info("Deprecated method", (Throwable)e);
            this.beginEdition(layer);
            try {
                this.addBehaviors(additionalBehaviors);
            }
            catch (CreateEditingBehaviorException e1) {
                LOGGER.info("Problems adding behaviors to editing context", (Throwable)e1);
                this.getMapControl().setTool("pan");
            }
            return;
        }
    }

    public synchronized void beginEdition(FLyrVect layer) {
        this.setCurrentLayer(layer);
        FeatureStore featureStore = layer.getFeatureStore();
        if (!featureStore.isEditing()) {
            EditingNotificationManager editingNotificationManager = DALSwingLocator.getEditingNotificationManager();
            EditingNotification notification = editingNotificationManager.notifyObservers((Object)this, "BEFORE_ENTER_EDITING_STORE", null, (Object)layer, (DataStore)layer.getFeatureStore());
            if (notification.isCanceled() || notification.isAborted()) {
                String msg = String.format("Edit layer %1$s canceled by somme observer.", layer.getName());
                LOGGER.info(msg, (Throwable)new StartEditingException(msg, notification.getAbortCause()));
                return;
            }
            try {
                featureStore.edit();
            }
            catch (Exception e) {
                String msg = String.format("Can't set %1$s in edit mode", featureStore.getName());
                LOGGER.info(msg, (Throwable)new VectorEditingException(e));
                this.cleanEditingContext();
                return;
            }
            editingNotificationManager.notifyObservers((Object)this, "AFTER_ENTER_EDITING_STORE", null, (Object)layer, (DataStore)layer.getFeatureStore());
        }
        featureStore.addObserver((Observer)this.getMapControl());
        this.enableSnapping();
    }

    private void enableSnapping() {
        Set layersToSnap;
        Preferences prefs = Preferences.userRoot().node("snappers");
        this.getMapControl().setRefentEnabled(prefs.getBoolean("apply-snappers", false));
        if (this.currentLayer != null && !(layersToSnap = this.getMapControl().getMapContext().getLayersToSnap()).contains(this.currentLayer)) {
            layersToSnap.add(this.currentLayer);
            this.removeFromSnapping.add(this.currentLayer);
        }
    }

    private void disableSnapping() {
        Set layersToSnap = this.getMapControl().getMapContext().getLayersToSnap();
        if (layersToSnap.contains(this.currentLayer) && this.removeFromSnapping.contains(this.currentLayer)) {
            layersToSnap.remove(this.currentLayer);
            this.removeFromSnapping.remove(this.currentLayer);
        }
    }

    private void changeSelectedTool(String name) {
        if (name.equalsIgnoreCase("default_tool")) {
            name = "selection-simple-select-view";
            this.getMapControl().setTool("pointSelection");
        }
    }

    private void notifyChangeSelectedTool() {
        BaseNotification notification = new BaseNotification("EditingContext.changeSelectedTool", null);
        this.observableHelper.notifyObservers((Observable)this, (Object)notification);
    }

    private void notifyChangeSelectedTool(String actionName) {
        BaseNotification notification = new BaseNotification("EditingContext.changeSelectedTool", (Object[])new String[]{actionName});
        this.observableHelper.notifyObservers((Observable)this, (Object)notification);
    }

    public void notifyDrawingStatus(DrawingStatus status, EditingService service) {
        BaseNotification notification = new BaseNotification("EditingContext.drawingStatus", new Object[]{status, service});
        this.observableHelper.notifyObservers((Observable)this, (Object)notification);
    }

    private void cleanEditingContext() {
        this.serviceStack.clear();
        this.currentParam = null;
        I18nManager i18n = ToolsLocator.getI18nManager();
        this.showConsoleMessage("\n" + i18n.getTranslation("select_new_tool") + "\n");
        this.changeSelectedTool("default_tool");
        this.notifyChangeSelectedTool("selection-simple-select-view");
    }

    public void deleteObserver(Observer o) {
        this.observableHelper.deleteObserver(o);
    }

    public void deleteObservers() {
        this.observableHelper.deleteObservers();
    }

    private void discardChanges(FLyrVect layer) throws EndEditingException {
        FeatureStore featureStore = layer.getFeatureStore();
        try {
            featureStore.cancelEditing();
        }
        catch (Exception e) {
            throw new EndEditingException((Throwable)e);
        }
    }

    private void doAction(FLyrVect layer, int option) {
        ThreadSafeDialogsManager dialogs = ToolsSwingLocator.getThreadSafeDialogsManager();
        I18nManager i18n = ToolsLocator.getI18nManager();
        switch (option) {
            case 3: {
                try {
                    this.saveChanges(layer);
                    break;
                }
                catch (VectorEditingException e) {
                    String msg = String.format("Changes can not be saved in %1$s", layer.getName());
                    LOGGER.info(msg, (Throwable)e);
                    dialogs.messageDialog(WordUtils.wrap((String)(i18n.getTranslation("_There_are_problems_saving_changes") + "\n\n" + BaseException.getMessageStack((Throwable)e, (int)2) + "\n\n" + i18n.getTranslation("_See_error_log_for_more_information")), (int)100, (String)"\n", (boolean)true), null, i18n.getTranslation("_Warning"), 2, "Vectorediting_cant_save_changes");
                    return;
                }
            }
            case 1: {
                try {
                    this.discardChanges(layer);
                    break;
                }
                catch (VectorEditingException e) {
                    String msg = String.format("Changes can not be discared in %1$s", layer.getName());
                    LOGGER.info(msg, (Throwable)e);
                    dialogs.messageDialog(i18n.getTranslation("_There_are_problems_discarding_changes") + "\n" + "\n" + i18n.getTranslation("_See_error_log_for_more_information"), null, i18n.getTranslation("_Warning"), 2, "Vectorediting_cant_discard_changes");
                    return;
                }
            }
            case 2: {
                try {
                    this.exportLayer(layer);
                    break;
                }
                catch (VectorEditingException e) {
                    String msg = String.format("Changes of %1$s can not be exported", layer.getName());
                    LOGGER.info(msg, (Throwable)e);
                    dialogs.messageDialog(i18n.getTranslation("_There_are_problems_exporting_changes") + "\n\n" + i18n.getTranslation("_See_error_log_for_more_information"), null, i18n.getTranslation("_Warning"), 2, "Vectorediting_cant_export_changes");
                    return;
                }
            }
            case 0: {
                return;
            }
        }
        this.cleanEditingContext();
        this.hideConsole();
        this.disableSnapping();
        this.changeSelectedTool("default_tool");
        FeatureStore featureStore = layer.getFeatureStore();
        featureStore.deleteObserver((Observer)this.getMapControl());
    }

    private void enableSelection(boolean enableSelection) {
        this.getEditingCompoundBehavior().setDrawnBehavior(1, enableSelection);
    }

    public void endEdition(FLyrVect layer) {
        if (this.isProcessing()) {
            return;
        }
        if (layer.isEditing()) {
            int option;
            EditingNotificationManager editingNotificationManager = DALSwingLocator.getEditingNotificationManager();
            EditingNotification notification = editingNotificationManager.notifyObservers((Object)this, "BEFORE_EXIT_EDITING_STORE", null, (Object)layer, (DataStore)layer.getFeatureStore());
            if (notification.isCanceled() || notification.isAborted()) {
                String msg = String.format("Stop edit layer %1$s canceled by somme observer.", layer.getName());
                LOGGER.info(msg, (Throwable)new EndEditingException(msg, notification.getAbortCause()));
            }
            this.getMapControl().getCanceldraw().setCanceled(true);
            EditingSwingManager swingManager = EditingSwingLocator.getSwingManager();
            switch (this.useOptionSaveOrExport(layer)) {
                case 2: {
                    option = swingManager.showPanelExportOrDiscard(this.getMapControl(), layer.getName());
                    break;
                }
                default: {
                    option = swingManager.showPanelSaveOrDiscard(this.getMapControl(), layer.getName());
                }
            }
            this.doAction(layer, option);
            editingNotificationManager.notifyObservers((Object)this, "AFTER_EXIT_EDITING_STORE", null, (Object)layer, (DataStore)layer.getFeatureStore());
        }
    }

    private int useOptionSaveOrExport(FLyrVect layer) {
        if (!layer.isWritable()) {
            return 2;
        }
        if (!this.getMapControl().getProjection().equals(layer.getProjection())) {
            if (FutureUtils.use((String)"ALLOW_SAVE_ON_REPROJECTED_LAYER")) {
                return 1;
            }
            return 2;
        }
        return 1;
    }

    private void exportLayer(FLyrVect layer) throws EndEditingException {
        BaseNotification notification = new BaseNotification("EditingContext.exportLayer", 1);
        notification.setValue((Object)layer);
        this.observableHelper.notifyObservers((Observable)this, (Object)notification);
    }

    protected void finishService() {
        this.enqueueTask(() -> this.doFinishService());
        this.refreshMenusAndToolBars();
    }

    /*
     * Exception decompiling
     */
    private void doFinishService() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [6[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public EditingService getActiveService() {
        if (!this.serviceStack.isEmpty()) {
            return this.serviceStack.peek();
        }
        return null;
    }

    public EditingConsole getConsolePanel() {
        if (this.console == null) {
            this.console = new DefaultEditingConsole(new ResponseListener(){

                public void acceptResponse(String response) {
                    DefaultEditingContext.this.textEntered(response);
                }
            });
        }
        return this.console;
    }

    protected FLyrVect getCurrentLayer() {
        return this.currentLayer;
    }

    protected EditingServiceParameter getCurrentParam() {
        return this.currentParam;
    }

    private Component getDockConsole() {
        if (this.dockConsole == null) {
            this.dockConsole = new JDockPanel((JComponent)this.getConsolePanel());
        }
        return this.dockConsole;
    }

    private DefaultEditingBehavior getEditingBehavior() {
        if (this.editingCompoundBehavior != null) {
            return (DefaultEditingBehavior)this.editingCompoundBehavior.getBehavior(0);
        }
        return null;
    }

    private EditingCompoundBehavior getEditingCompoundBehavior() {
        if (this.editingCompoundBehavior != null) {
            return this.editingCompoundBehavior;
        }
        CompoundBehavior compoundBehavior = (CompoundBehavior)this.getMapControl().getMapTool("VectorEditing");
        EditingCompoundBehavior editingCompoundBehavior = compoundBehavior instanceof EditingCompoundBehavior ? (EditingCompoundBehavior)compoundBehavior : (EditingCompoundBehavior)compoundBehavior.getBehavior(0);
        this.setCompoundBehavior(editingCompoundBehavior);
        return editingCompoundBehavior;
    }

    public MapControl getMapControl() {
        return (MapControl)this.mapControlReference.get();
    }

    public void nextParameter() {
        this.enqueueTask(() -> this.doNextParameter());
    }

    private void doNextParameter() {
        EditingService activeService;
        if (this.getMapControl().getCurrentTool() != null && !this.getMapControl().getCurrentTool().equals("VectorEditing")) {
            this.getMapControl().setTool("VectorEditing");
        }
        this.currentParam = (activeService = this.getActiveService()) == null ? null : activeService.next();
        if (this.currentParam == null) {
            this.doFinishService();
        } else {
            this.askQuestion(this.currentParam);
            if (this.currentParam.getTypes().contains(EditingServiceParameter.TYPE.SELECTION)) {
                this.enableSelection(true);
            } else if (this.currentParam.getTypes().contains(EditingServiceParameter.TYPE.MULTILAYER_SELECTION)) {
                this.enableSelection(true);
            } else if (this.currentParam.getTypes().contains(EditingServiceParameter.TYPE.GEOMETRY)) {
                this.refreshMenusAndToolBars();
            }
        }
    }

    protected Stack<EditingService> getServiceStack() {
        return this.serviceStack;
    }

    private synchronized void hideConsole() {
        if (!SwingUtilities.isEventDispatchThread()) {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        DefaultEditingContext.this.hideConsole();
                    }
                });
                return;
            }
            catch (InterruptedException | InvocationTargetException ex) {
                LOGGER.warn("Can't hide editing console.", (Throwable)ex);
                return;
            }
        }
        this.isShowConsole = false;
        this.getDockConsole().setVisible(false);
    }

    public boolean isServiceCompatible(String name) {
        DefaultEditingBehavior editingBehavior = this.getEditingBehavior();
        if (editingBehavior != null) {
            try {
                EditingManager manager = EditingLocator.getManager();
                EditingServiceInfo serviceInfo = manager.getServiceInfo(name);
                GeometryType geoType = null;
                for (EditingService editingService : this.getServiceStack()) {
                    EditingServiceParameter parameter = editingService.next();
                    if (parameter == null || !parameter.getTypes().contains(EditingServiceParameter.TYPE.GEOMETRY)) continue;
                    int geometryType = parameter.getGeometryType();
                    int subType = -1;
                    try {
                        subType = this.getCurrentLayer().getFeatureStore().getDefaultFeatureType().getDefaultGeometryAttribute().getGeomType().getSubType();
                        geoType = GeometryLocator.getGeometryManager().getGeometryType(geometryType, subType);
                    }
                    catch (Exception e) {
                        String msg = String.format("Problems getting default feature type of %1$s or getting geometry type of %2$s %3$s", this.getCurrentLayer().getName(), geometryType, subType);
                        throw new ServiceInformationException(msg, (Throwable)e);
                    }
                    return serviceInfo.isCompatibleWith(geoType) && serviceInfo.createsNewGeometries();
                }
                if (this.getCurrentLayer() != null) {
                    try {
                        geoType = this.getCurrentLayer().getFeatureStore().getDefaultFeatureType().getDefaultGeometryAttribute().getGeomType();
                        if (serviceInfo.isCompatibleWith(geoType)) {
                            return true;
                        }
                    }
                    catch (DataException e) {
                        String msg = String.format("Problems getting default feature type of %1$s", this.getCurrentLayer().getName());
                        throw new ServiceInformationException(msg, (Throwable)e);
                    }
                }
                return false;
            }
            catch (ServiceInformationException e) {
                LOGGER.warn("Problems getting if editing context is compatible with " + name, (Throwable)e);
            }
        }
        return false;
    }

    public SymbolTable getContextSymbolTable() {
        return contextSymbolTable;
    }

    public Point parsePoint(String response) throws ParsePointException {
        response = this.fixResponseUsingBookmarks(response);
        try {
            Object x = ExpressionUtils.evaluate((SymbolTable)contextSymbolTable, (String)response);
            if (x instanceof Point) {
                contextSymbolTable.addPoint((Point)x);
                this.getHistoryForInsertPoints().add((Object)ExpressionUtils.createExpression((String)response));
                return (Point)x;
            }
        }
        catch (Exception ex) {
            LOGGER.debug("Can't evaluate: " + StringEscapeUtils.escapeJava((String)response), (Throwable)ex);
        }
        String s = "ST_MakePoint(" + response + ")";
        try {
            Object x = ExpressionUtils.evaluate((SymbolTable)contextSymbolTable, (String)s);
            if (x instanceof Point) {
                contextSymbolTable.addPoint((Point)x);
                return (Point)x;
            }
        }
        catch (Exception ex) {
            throw new ParsePointException((Throwable)ex);
        }
        throw new ParsePointException(null);
    }

    private Double parseValue(String response) throws ParseValueException {
        response = this.fixResponseUsingBookmarks(response);
        try {
            Object x = ExpressionUtils.evaluate((SymbolTable)contextSymbolTable, (String)response);
            if (x instanceof Double) {
                return (Double)x;
            }
            if (x == null) {
                throw new ParseValueException((Throwable)new NullPointerException());
            }
            Coercion toDouble = ToolsLocator.getDataTypesManager().get(7).getCoercion();
            return (Double)toDouble.coerce(x);
        }
        catch (Exception ex) {
            throw new ParseValueException((Throwable)ex);
        }
    }

    protected String fixResponseUsingBookmarks(String expression) throws LocatorException {
        if (expression != null) {
            expression = expression.trim();
            int firstBlank = StringUtils.indexOf((CharSequence)expression, (CharSequence)" ");
            int firstParenthesis = StringUtils.indexOf((CharSequence)expression, (CharSequence)"(");
            if (firstBlank > 0 && (firstParenthesis < 0 || firstBlank < firstParenthesis)) {
                String name = StringUtils.left((String)expression, (int)firstBlank);
                Function fn = this.getContextSymbolTable().function(name);
                if (fn != null) {
                    expression = name + "(" + expression.substring(firstBlank) + ")";
                }
            }
        }
        return expression;
    }

    protected void refreshMenusAndToolBars() {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(() -> this.refreshMenusAndToolBars());
            return;
        }
        BaseNotification notification = new BaseNotification("EditingContext.refreshTools", null);
        this.observableHelper.notifyObservers((Observable)this, (Object)notification);
    }

    private void saveChanges(FLyrVect layer) throws EndEditingException {
        FeatureStore featureStore = layer.getFeatureStore();
        try {
            featureStore.finishEditing();
        }
        catch (Exception e) {
            throw new EndEditingException((Throwable)e);
        }
    }

    private void setActiveService(EditingService service) {
        this.serviceStack.add(service);
        this.notifyChangeSelectedTool(service.getName());
    }

    private void setCompoundBehavior(EditingCompoundBehavior compoundBehavior) {
        if (this.isProcessing()) {
            return;
        }
        this.editingCompoundBehavior = compoundBehavior;
    }

    private void setCurrentLayer(FLyrVect layer) {
        if (this.isProcessing()) {
            return;
        }
        if (this.currentLayer != layer) {
            this.currentLayer = layer;
            if (!this.serviceStack.isEmpty()) {
                EditingService x = (EditingService)this.serviceStack.firstElement();
                if (x != null && this.isServiceCompatible(x.getName())) {
                    String name = x.getName();
                    this.cleanEditingContext();
                    this.serviceStack.clear();
                    this.activateService(name);
                } else {
                    this.cleanEditingContext();
                }
            }
        }
    }

    public void setMapControl(MapControl mapControl) {
        if (this.isProcessing()) {
            return;
        }
        this.mapControlReference = new WeakReference<MapControl>(mapControl);
        this.mapContextReference = new WeakReference<MapContext>(mapControl.getMapContext());
        if (this.lastAdditionalBehaviors != null) {
            try {
                this.addBehaviors(this.lastAdditionalBehaviors);
            }
            catch (CreateEditingBehaviorException e1) {
                LOGGER.info("Problems adding behaviors to editing context", (Throwable)e1);
                this.getMapControl().setTool("pan");
            }
        }
    }

    private synchronized void showConsole() {
        if (this.isShowConsole) {
            return;
        }
        if (!SwingUtilities.isEventDispatchThread()) {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        DefaultEditingContext.this.showConsole();
                    }
                });
                return;
            }
            catch (InterruptedException | InvocationTargetException ex) {
                LOGGER.warn("Can't show editing console.", (Throwable)ex);
                return;
            }
        }
        this.isShowConsole = true;
        this.getMapControl().remove(this.getDockConsole());
        this.getMapControl().setLayout((LayoutManager)new BorderLayout());
        this.getMapControl().add(this.getDockConsole(), (Object)"South");
        this.getDockConsole().setVisible(true);
    }

    protected void showConsoleMessage(final String text) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    DefaultEditingContext.this.showConsoleMessage(text);
                }
            });
            return;
        }
        this.getConsolePanel().addText(text);
    }

    public void cancelActiveService() {
        this.textEntered(null);
    }

    protected void textEntered(String response) {
        block10: {
            if (this.isProcessing()) {
                return;
            }
            FeatureStore featureStore = this.getCurrentLayer().getFeatureStore();
            if (response == null) {
                EditingService activeService = this.getActiveService();
                if (activeService != null) {
                    try {
                        activeService.stop();
                        this.serviceStack.pop();
                        if (this.serviceStack.isEmpty()) {
                            featureStore.getFeatureSelection().deselectAll();
                            this.changeSelectedTool("default_tool");
                        } else {
                            this.changeSelectedTool(activeService.getName());
                        }
                        this.refreshMenusAndToolBars();
                        activeService = this.getActiveService();
                        if (activeService != null) {
                            this.nextParameter();
                            break block10;
                        }
                        this.cleanEditingContext();
                    }
                    catch (StopServiceException e) {
                        LOGGER.info("Can't stop " + activeService.getName(), (Throwable)e);
                    }
                    catch (DataException e) {
                        LOGGER.info("Can't get selection of " + featureStore.getFullName(), (Throwable)e);
                    }
                }
            } else {
                this.enqueueTask(() -> {
                    try {
                        I18nManager i18nManager = ToolsLocator.getI18nManager();
                        EditingService activeService = this.getActiveService();
                        if (this.getCurrentParam() != null) {
                            try {
                                Object coercedValue = this.coerceInputParameter(this.getCurrentParam(), response);
                                activeService.setValue(coercedValue);
                            }
                            catch (InvalidEntryException ex) {
                                String stateMessage = ex.getStateMessage();
                                if (StringUtils.isBlank((CharSequence)stateMessage)) {
                                    this.showConsoleMessage("\n" + i18nManager.getTranslation("invalid_option"));
                                } else {
                                    this.showConsoleMessage("\n" + i18nManager.getTranslation("invalid_option") + ": " + (String)StringUtils.defaultIfBlank((CharSequence)ex.getStateMessage(), (CharSequence)""));
                                }
                            }
                            catch (Exception ex) {
                                LOGGER.warn("Error processing the entered option " + (activeService == null ? "" : activeService.getName()), (Throwable)ex);
                                this.showConsoleMessage("\n" + i18nManager.getTranslation("_An_error_has_occurred") + "\n" + ex.getLocalizedMessage());
                            }
                        }
                        if ((activeService = this.getActiveService()) != null) {
                            this.doNextParameter();
                        } else {
                            this.cleanEditingContext();
                        }
                    }
                    finally {
                        this.refreshMenusAndToolBars();
                    }
                });
                this.refreshMenusAndToolBars();
            }
        }
    }

    private Object coerceInputParameter(EditingServiceParameter parameter, String input) throws InvalidEntryException {
        if (parameter != null) {
            FeatureStore featureStore = this.getCurrentLayer().getFeatureStore();
            Set types = parameter.getTypes();
            Point point = null;
            Double value = null;
            Point defaultPoint = null;
            Object defaultValue = parameter.getDefaultValue();
            if (types.contains(EditingServiceParameter.TYPE.POSITION) || types.contains(EditingServiceParameter.TYPE.LIST_POSITIONS)) {
                if (defaultValue instanceof Point) {
                    defaultPoint = (Point)defaultValue;
                }
                try {
                    point = StringUtils.isEmpty((CharSequence)input.replace("\n", "")) ? defaultPoint : this.parsePoint(input);
                    if (point != null) {
                        return point;
                    }
                }
                catch (ParsePointException parsePointException) {
                    // empty catch block
                }
            }
            if (types.contains(EditingServiceParameter.TYPE.VALUE)) {
                try {
                    value = this.parseValue(input);
                    if (value != null) {
                        return value;
                    }
                }
                catch (ParseValueException parseValueException) {
                    // empty catch block
                }
            }
            if (types.contains(EditingServiceParameter.TYPE.OPTION)) {
                input = input.replace("\n", "");
                return input;
            }
            if (types.contains(EditingServiceParameter.TYPE.SELECTION) && input.equalsIgnoreCase("\n")) {
                this.enableSelection(false);
                try {
                    FeatureSelection clonedSelection = (FeatureSelection)featureStore.getFeatureSelection().clone();
                    if (!clonedSelection.isEmpty()) {
                        return clonedSelection;
                    }
                }
                catch (Exception e) {
                    LOGGER.warn("Can't access to selection.", (Throwable)e);
                    throw new InvalidEntryException((Throwable)e);
                }
            }
            if (types.contains(EditingServiceParameter.TYPE.MULTILAYER_SELECTION) && input.equalsIgnoreCase("\n")) {
                this.enableSelection(false);
                MapContext mapContext = this.getMapControl().getMapContext();
                ArrayList<Feature> features = new ArrayList<Feature>();
                for (FLayer lyrActive : mapContext.getLayers().getActives()) {
                    if (!(lyrActive instanceof FLyrVect) || ((FLyrVect)lyrActive).getFeatureStore().isFeatureSelectionEmpty()) continue;
                    this.getSelectedFeaturesCopy(features, ((FLyrVect)lyrActive).getFeatureStore().getFeatureSelectionQuietly());
                }
                if (!features.isEmpty()) {
                    return features;
                }
            }
        }
        return null;
    }

    private List<Feature> getSelectedFeaturesCopy(List<Feature> features, FeatureSelection selection) {
        SimpleTaskStatus status = ToolsLocator.getTaskStatusManager().createDefaultSimpleTaskStatus("Loading selection");
        try {
            status.add();
            status.setAutoremove(true);
            status.setRangeOfValues(0L, (long)selection.size());
            if (features == null) {
                features = new ArrayList<Feature>();
            }
            DisposableIterator it = selection.fastIterator();
            while (it.hasNext()) {
                if (status.isCancellationRequested()) {
                    status.cancel();
                    return features;
                }
                Feature feature = (Feature)it.next();
                if (feature.getDefaultGeometry() == null) continue;
                features.add(feature.getCopy());
                status.incrementCurrentValue();
            }
            status.terminate();
            return features;
        }
        catch (DataException ex) {
            status.abort();
            throw new RuntimeException("Can't calculate selected features", ex);
        }
    }

    public void setDefaultBehaviors(Behavior[] defaultBehaviors) {
        if (this.isProcessing()) {
            return;
        }
        this.defaultBehaviors = defaultBehaviors;
        try {
            this.addBehaviors(defaultBehaviors);
        }
        catch (CreateEditingBehaviorException e1) {
            LOGGER.info("Problems adding behaviors to editing context", (Throwable)e1);
            this.getMapControl().setTool("pan");
        }
    }

    public Behavior[] getDefaultBehaviors() {
        return this.defaultBehaviors;
    }

    public void setValue(EditingServiceParameter parameter, Object value) throws InvalidEntryException {
        this.setValue(parameter, value, false);
    }

    public void setValue(EditingServiceParameter parameter, Object value, boolean next) throws InvalidEntryException {
        if (value instanceof CharSequence) {
            value = this.coerceInputParameter(parameter, value.toString());
        } else if (value instanceof Point) {
            contextSymbolTable.addPoint((Point)value);
        }
        Object v = value;
        Runnable task = () -> {
            EditingService activeService = null;
            try {
                activeService = this.getActiveService();
                activeService.setValue(parameter, v);
                if (next) {
                    this.doNextParameter();
                }
            }
            catch (InvalidEntryException ex) {
                I18nManager i18nManager = ToolsLocator.getI18nManager();
                String stateMessage = ex.getStateMessage();
                if (StringUtils.isBlank((CharSequence)stateMessage)) {
                    this.showConsoleMessage("\n" + i18nManager.getTranslation("invalid_option"));
                } else {
                    this.showConsoleMessage("\n" + i18nManager.getTranslation("invalid_option") + ": " + (String)StringUtils.defaultIfBlank((CharSequence)ex.getStateMessage(), (CharSequence)""));
                }
                this.doNextParameter();
            }
            catch (Exception ex) {
                LOGGER.warn("Error processing the value " + (activeService == null ? "" : activeService.getName()), (Throwable)ex);
                I18nManager i18nManager = ToolsLocator.getI18nManager();
                this.showConsoleMessage("\n" + i18nManager.getTranslation("_An_error_has_occurred") + "\n" + ex.getLocalizedMessage());
                this.doNextParameter();
            }
            finally {
                this.refreshMenusAndToolBars();
            }
        };
        this.enqueueTask(task);
        this.refreshMenusAndToolBars();
    }

    private void enqueueTask(Runnable task) {
        if (this.tasksDispatcher == null || !this.tasksDispatcher.isAlive()) {
            this.tasksDispatcher = new TasksDispatcher((JComponent)this.getMapControl());
            this.tasksDispatcher.start();
        }
        this.tasksDispatcher.add(task);
    }

    public GeometryType getGeometryType() {
        if (this.currentLayer == null) {
            return null;
        }
        FeatureStore store = this.currentLayer.getFeatureStore();
        if (store == null) {
            return null;
        }
        FeatureType ftype = store.getDefaultFeatureTypeQuietly();
        if (ftype == null) {
            return null;
        }
        FeatureAttributeDescriptor geomattr = ftype.getDefaultGeometryAttribute();
        if (geomattr == null) {
            return null;
        }
        return geomattr.getGeomType();
    }

    public boolean isProcessing() {
        if (this.tasksDispatcher == null) {
            return false;
        }
        return this.tasksDispatcher.isProcessing();
    }

    public int getDrawMode() {
        return this.drawMode;
    }

    public void setDrawMode(int mode) {
        this.drawMode = mode;
        this.refreshMenusAndToolBars();
    }

    public History<Expression> getHistoryForInsertPoints() {
        History h = ToolsLocator.getBookmarksAndHistoryManager().getHistoryGroup("VectorEditingInsertPoints");
        return h;
    }

    public Bookmarks<Expression> getBookmarksForInsertPoints() {
        Bookmarks g = ToolsLocator.getBookmarksAndHistoryManager().getBookmarksGroup("VectorEditingInsertPoints");
        return g;
    }

    private /* synthetic */ void lambda$doFinishService$1(EditingService lastService) {
        try {
            lastService.stop();
            if (this.serviceStack.isEmpty()) {
                this.cleanEditingContext();
            }
            this.refreshMenusAndToolBars();
        }
        catch (StopServiceException stopServiceException) {
            // empty catch block
        }
    }

    private static class TasksDispatcher
    extends Thread {
        private BlockingQueue<Runnable> tasks = new LinkedBlockingQueue<Runnable>();
        private boolean processing = false;
        private final JComponent component;
        private Cursor lastNoBusyCursor = null;

        public TasksDispatcher(JComponent component) {
            this.component = component;
        }

        public void setMouseBusy(boolean busy) {
            if (busy) {
                if (this.lastNoBusyCursor == null) {
                    this.lastNoBusyCursor = this.component.getCursor();
                }
                this.component.setCursor(Cursor.getPredefinedCursor(3));
            } else {
                this.component.setCursor(this.lastNoBusyCursor);
                this.lastNoBusyCursor = null;
            }
        }

        @Override
        public void run() {
            while (true) {
                try {
                    Runnable task = this.tasks.poll(1L, TimeUnit.MINUTES);
                    if (task == null) {
                        return;
                    }
                    this.processing = true;
                    this.setMouseBusy(true);
                    task.run();
                    continue;
                }
                catch (Throwable t) {
                    LOGGER.warn("Can't proccess task", t);
                    continue;
                }
                finally {
                    if (!this.tasks.isEmpty()) continue;
                    this.processing = false;
                    this.setMouseBusy(false);
                    continue;
                }
                break;
            }
        }

        public void add(Runnable task) {
            try {
                this.tasks.put(task);
            }
            catch (InterruptedException ex) {
                throw new RuntimeException("Can't addd task", ex);
            }
        }

        public boolean isProcessing() {
            if (!this.isAlive()) {
                return false;
            }
            return this.processing;
        }
    }
}

