/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vectorediting.swing.impl.console;

import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.text.JTextComponent;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.utils.console.ResponseListener;
import org.gvsig.utils.console.ResponseListenerSupport;
import org.gvsig.vectorediting.swing.api.console.EditingConsole;
import org.gvsig.vectorediting.swing.impl.console.DefaultEditingConsoleView;
import org.gvsig.vectorediting.swing.impl.console.DefaultEditingNavigationFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultEditingConsole
extends DefaultEditingConsoleView
implements EditingConsole {
    private static final long serialVersionUID = -1068129558465010049L;
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultEditingConsole.class);
    private ResponseListenerSupport responseListenerSupport;
    private int startingCaretPosition = 0;
    private Action enterAction = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            DefaultEditingConsole.this.callResponseListener(DefaultEditingConsole.this.getResponseText() + "\n");
        }
    };
    private Action escAction = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            DefaultEditingConsole.this.callResponseListener(null);
        }
    };
    private Action backSpaceAction = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            int caretPos = DefaultEditingConsole.this.getTextArea().getCaretPosition();
            if (caretPos > DefaultEditingConsole.this.startingCaretPosition) {
                StringBuilder stb = new StringBuilder(DefaultEditingConsole.this.getTextArea().getText());
                stb.deleteCharAt(DefaultEditingConsole.this.getTextArea().getCaretPosition() - 1);
                DefaultEditingConsole.this.getTextArea().setText(stb.toString());
                DefaultEditingConsole.this.getTextArea().setCaretPosition(caretPos - 1);
            }
        }
    };

    public DefaultEditingConsole(ResponseListener listener) {
        this.addAncestorListenerToSetCaretPosition();
        this.responseListenerSupport = new ResponseListenerSupport();
        this.responseListenerSupport.addResponseListener(listener);
        this.getTextArea().setNavigationFilter(new DefaultEditingNavigationFilter(this.startingCaretPosition));
        this.addKeyBindings();
        ToolsSwingLocator.getToolsSwingManager().setDefaultPopupMenu((JTextComponent)this.getTextArea());
    }

    public DefaultEditingConsole(List<ResponseListener> listeners) {
        this.addAncestorListenerToSetCaretPosition();
        this.responseListenerSupport = new ResponseListenerSupport();
        for (ResponseListener responseListener : listeners) {
            this.responseListenerSupport.addResponseListener(responseListener);
        }
        this.getTextArea().setNavigationFilter(new DefaultEditingNavigationFilter(this.startingCaretPosition));
        this.addKeyBindings();
        ToolsSwingLocator.getToolsSwingManager().setDefaultPopupMenu((JTextComponent)this.getTextArea());
    }

    @Override
    public JPopupMenu getComponentPopupMenu() {
        return this.getTextArea().getComponentPopupMenu();
    }

    private void addAncestorListenerToSetCaretPosition() {
        this.addAncestorListener(new AncestorListener(){

            @Override
            public void ancestorRemoved(AncestorEvent event) {
            }

            @Override
            public void ancestorMoved(AncestorEvent event) {
            }

            @Override
            public void ancestorAdded(AncestorEvent event) {
                DefaultEditingConsole.this.getTextArea().requestFocusInWindow();
                DefaultEditingConsole.this.getTextArea().setCaretPosition(DefaultEditingConsole.this.startingCaretPosition);
            }
        });
    }

    private void addKeyBindings() {
        this.getTextArea().getInputMap().put(KeyStroke.getKeyStroke("ENTER"), "enterAction");
        this.getTextArea().getActionMap().put("enterAction", this.enterAction);
        this.getTextArea().getInputMap().put(KeyStroke.getKeyStroke("ESCAPE"), "escAction");
        this.getTextArea().getActionMap().put("escAction", this.escAction);
        this.getTextArea().getInputMap().put(KeyStroke.getKeyStroke("BACK_SPACE"), "backSpaceAction");
        this.getTextArea().getActionMap().put("backSpaceAction", this.backSpaceAction);
        this.getTextArea().getInputMap().put(KeyStroke.getKeyStroke("DELETE"), "none");
    }

    public String getResponseText() {
        return this.getTextArea().getText().substring(this.startingCaretPosition, this.getTextArea().getText().length());
    }

    public void addText(String text) {
        this.getTextArea().setText(this.getTextArea().getText() + text);
        this.getTextArea().setCaretPosition(this.getTextArea().getText().length());
        this.startingCaretPosition = this.getTextArea().getText().length();
        this.getTextArea().setNavigationFilter(new DefaultEditingNavigationFilter(this.startingCaretPosition));
        this.getTextArea().requestFocusInWindow();
    }

    public void addResponseText(String responseText) {
        this.getTextArea().setText(this.getTextArea().getText() + responseText);
        this.getTextArea().setCaretPosition(this.getTextArea().getText().length());
    }

    public void addResponseListener(ResponseListener listener) {
        this.responseListenerSupport.addResponseListener(listener);
    }

    public void removeResponseListener(ResponseListener listener) {
        this.responseListenerSupport.removeResponseListener(listener);
    }

    private void callResponseListener(String response) {
        this.responseListenerSupport.callAcceptResponse(response);
    }

    public void clear() {
        this.getTextArea().setText(null);
    }
}

