/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.jdk.sun.awt.geom;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Vector;
import org.gvsig.jdk.sun.awt.geom.ChainEnd;
import org.gvsig.jdk.sun.awt.geom.Curve;
import org.gvsig.jdk.sun.awt.geom.CurveLink;
import org.gvsig.jdk.sun.awt.geom.Edge;

abstract class AreaOp {
    public static final int CTAG_LEFT = 0;
    public static final int CTAG_RIGHT = 1;
    public static final int ETAG_IGNORE = 0;
    public static final int ETAG_ENTER = 1;
    public static final int ETAG_EXIT = -1;
    public static final int RSTAG_INSIDE = 1;
    public static final int RSTAG_OUTSIDE = -1;
    private static Comparator YXTopComparator = new Comparator(){

        public int compare(Object o1, Object o2) {
            double v2;
            Curve c1 = ((Edge)o1).getCurve();
            Curve c2 = ((Edge)o2).getCurve();
            double v1 = c1.getYTop();
            if (v1 == (v2 = c2.getYTop()) && (v1 = c1.getXTop()) == (v2 = c2.getXTop())) {
                return 0;
            }
            if (v1 < v2) {
                return -1;
            }
            return 1;
        }
    };
    private static CurveLink[] EmptyLinkList = new CurveLink[2];
    private static ChainEnd[] EmptyChainList = new ChainEnd[2];

    AreaOp() {
    }

    public abstract void newRow();

    public abstract int classify(Edge var1);

    public abstract int getState();

    public Vector calculate(Vector left, Vector right) {
        Vector edges = new Vector();
        AreaOp.addEdges(edges, left, 0);
        AreaOp.addEdges(edges, right, 1);
        edges = this.pruneEdges(edges);
        return edges;
    }

    private static void addEdges(Vector edges, Vector curves, int curvetag) {
        Enumeration enum_ = curves.elements();
        while (enum_.hasMoreElements()) {
            Curve c = (Curve)enum_.nextElement();
            if (c.getOrder() <= 0) continue;
            edges.add(new Edge(c, curvetag));
        }
    }

    private Vector pruneEdges(Vector edges) {
        int numedges = edges.size();
        if (numedges < 2) {
            return edges;
        }
        Edge[] edgelist = edges.toArray(new Edge[numedges]);
        Arrays.sort(edgelist, YXTopComparator);
        int left = 0;
        int right = 0;
        int cur = 0;
        int next = 0;
        double[] yrange = new double[2];
        Vector subcurves = new Vector();
        Vector chains = new Vector();
        Vector<CurveLink> links = new Vector<CurveLink>();
        while (left < numedges) {
            Edge e;
            double y = yrange[0];
            for (cur = next = right - 1; cur >= left; --cur) {
                e = edgelist[cur];
                if (!(e.getCurve().getYBot() > y)) continue;
                if (next > cur) {
                    edgelist[next] = e;
                }
                --next;
            }
            left = next + 1;
            if (left >= right) {
                if (right >= numedges) break;
                y = edgelist[right].getCurve().getYTop();
                if (y > yrange[0]) {
                    AreaOp.finalizeSubCurves(subcurves, chains);
                }
                yrange[0] = y;
            }
            while (right < numedges && !((e = edgelist[right]).getCurve().getYTop() > y)) {
                ++right;
            }
            yrange[1] = edgelist[left].getCurve().getYBot();
            if (right < numedges && yrange[1] > (y = edgelist[right].getCurve().getYTop())) {
                yrange[1] = y;
            }
            int nexteq = 1;
            for (cur = left; cur < right; ++cur) {
                e = edgelist[cur];
                e.setEquivalence(0);
                for (next = cur; next > left; --next) {
                    Edge prevedge = edgelist[next - 1];
                    int ordering = e.compareTo(prevedge, yrange);
                    if (yrange[1] <= yrange[0]) {
                        throw new InternalError("backstepping to " + yrange[1] + " from " + yrange[0]);
                    }
                    if (ordering >= 0) {
                        if (ordering != 0) break;
                        int eq = prevedge.getEquivalence();
                        if (eq == 0) {
                            eq = nexteq++;
                            prevedge.setEquivalence(eq);
                        }
                        e.setEquivalence(eq);
                        break;
                    }
                    edgelist[next] = prevedge;
                }
                edgelist[next] = e;
            }
            this.newRow();
            double ystart = yrange[0];
            double yend = yrange[1];
            for (cur = left; cur < right; ++cur) {
                int etag;
                e = edgelist[cur];
                int eq = e.getEquivalence();
                if (eq != 0) {
                    int origstate = this.getState();
                    etag = origstate == 1 ? -1 : 1;
                    Edge activematch = null;
                    Edge longestmatch = e;
                    double furthesty = yend;
                    do {
                        this.classify(e);
                        if (activematch == null && e.isActiveFor(ystart, etag)) {
                            activematch = e;
                        }
                        if (!((y = e.getCurve().getYBot()) > furthesty)) continue;
                        longestmatch = e;
                        furthesty = y;
                    } while (++cur < right && (e = edgelist[cur]).getEquivalence() == eq);
                    --cur;
                    if (this.getState() == origstate) {
                        etag = 0;
                    } else {
                        e = activematch != null ? activematch : longestmatch;
                    }
                } else {
                    etag = this.classify(e);
                }
                if (etag == 0) continue;
                e.record(yend, etag);
                links.add(new CurveLink(e.getCurve(), ystart, yend, etag));
            }
            if (this.getState() != -1) {
                System.out.println("Still inside at end of active edge list!");
                System.out.println("num curves = " + (right - left));
                System.out.println("num links = " + links.size());
                System.out.println("y top = " + yrange[0]);
                if (right < numedges) {
                    System.out.println("y top of next curve = " + edgelist[right].getCurve().getYTop());
                } else {
                    System.out.println("no more curves");
                }
                for (cur = left; cur < right; ++cur) {
                    e = edgelist[cur];
                    System.out.println(e);
                    int eq = e.getEquivalence();
                    if (eq == 0) continue;
                    System.out.println("  was equal to " + eq + "...");
                }
            }
            AreaOp.resolveLinks(subcurves, chains, links);
            links.clear();
            yrange[0] = yend;
        }
        AreaOp.finalizeSubCurves(subcurves, chains);
        Vector<Curve> ret = new Vector<Curve>();
        Enumeration enum_ = subcurves.elements();
        while (enum_.hasMoreElements()) {
            CurveLink link = (CurveLink)enum_.nextElement();
            ret.add(link.getMoveto());
            CurveLink nextlink = link;
            while ((nextlink = nextlink.getNext()) != null) {
                if (link.absorb(nextlink)) continue;
                ret.add(link.getSubCurve());
                link = nextlink;
            }
            ret.add(link.getSubCurve());
        }
        return ret;
    }

    public static void finalizeSubCurves(Vector subcurves, Vector chains) {
        int numchains = chains.size();
        if (numchains == 0) {
            return;
        }
        if ((numchains & 1) != 0) {
            throw new InternalError("Odd number of chains!");
        }
        ChainEnd[] endlist = new ChainEnd[numchains];
        chains.toArray(endlist);
        for (int i = 1; i < numchains; i += 2) {
            ChainEnd open = endlist[i - 1];
            ChainEnd close = endlist[i];
            CurveLink subcurve = open.linkTo(close);
            if (subcurve == null) continue;
            subcurves.add(subcurve);
        }
        chains.clear();
    }

    public static void resolveLinks(Vector subcurves, Vector chains, Vector links) {
        ChainEnd[] endlist;
        CurveLink[] linklist;
        int numlinks = links.size();
        if (numlinks == 0) {
            linklist = EmptyLinkList;
        } else {
            if ((numlinks & 1) != 0) {
                throw new InternalError("Odd number of new curves!");
            }
            linklist = new CurveLink[numlinks + 2];
            links.toArray(linklist);
        }
        int numchains = chains.size();
        if (numchains == 0) {
            endlist = EmptyChainList;
        } else {
            if ((numchains & 1) != 0) {
                throw new InternalError("Odd number of chains!");
            }
            endlist = new ChainEnd[numchains + 2];
            chains.toArray(endlist);
        }
        int curchain = 0;
        int curlink = 0;
        chains.clear();
        ChainEnd chain = endlist[0];
        ChainEnd nextchain = endlist[1];
        CurveLink link = linklist[0];
        CurveLink nextlink = linklist[1];
        while (chain != null || link != null) {
            boolean connectlinks;
            boolean connectchains = link == null;
            boolean bl = connectlinks = chain == null;
            if (!connectchains && !connectlinks) {
                connectchains = !(curchain & true) && chain.getX() == nextchain.getX();
                boolean bl2 = connectlinks = !(curlink & true) && link.getX() == nextlink.getX();
                if (!connectchains && !connectlinks) {
                    double cx = chain.getX();
                    double lx = link.getX();
                    connectchains = nextchain != null && cx < lx && AreaOp.obstructs(nextchain.getX(), lx, curchain);
                    boolean bl3 = connectlinks = nextlink != null && lx < cx && AreaOp.obstructs(nextlink.getX(), cx, curlink);
                }
            }
            if (connectchains) {
                CurveLink subcurve = chain.linkTo(nextchain);
                if (subcurve != null) {
                    subcurves.add(subcurve);
                }
                chain = endlist[curchain += 2];
                nextchain = endlist[curchain + 1];
            }
            if (connectlinks) {
                ChainEnd openend = new ChainEnd(link, null);
                ChainEnd closeend = new ChainEnd(nextlink, openend);
                openend.setOtherEnd(closeend);
                chains.add(openend);
                chains.add(closeend);
                link = linklist[curlink += 2];
                nextlink = linklist[curlink + 1];
            }
            if (connectchains || connectlinks) continue;
            chain.addLink(link);
            chains.add(chain);
            chain = nextchain;
            nextchain = endlist[++curchain + 1];
            link = nextlink;
            nextlink = linklist[++curlink + 1];
        }
        if ((chains.size() & 1) != 0) {
            System.out.println("Odd number of chains!");
        }
    }

    public static boolean obstructs(double v1, double v2, int phase) {
        return (phase & 1) == 0 ? v1 <= v2 : v1 < v2;
    }

    static class EOWindOp
    extends AreaOp {
        private boolean inside;

        EOWindOp() {
        }

        @Override
        public void newRow() {
            this.inside = false;
        }

        @Override
        public int classify(Edge e) {
            boolean newInside;
            this.inside = newInside = !this.inside;
            return newInside ? 1 : -1;
        }

        @Override
        public int getState() {
            return this.inside ? 1 : -1;
        }
    }

    static class NZWindOp
    extends AreaOp {
        private int count;

        NZWindOp() {
        }

        @Override
        public void newRow() {
            this.count = 0;
        }

        @Override
        public int classify(Edge e) {
            int newCount = this.count;
            int type = newCount == 0 ? 1 : 0;
            this.count = newCount += e.getCurve().getDirection();
            return newCount == 0 ? -1 : type;
        }

        @Override
        public int getState() {
            return this.count == 0 ? -1 : 1;
        }
    }

    static class XorOp
    extends CAGOp {
        XorOp() {
        }

        @Override
        public boolean newClassification(boolean inLeft, boolean inRight) {
            return inLeft != inRight;
        }
    }

    static class IntOp
    extends CAGOp {
        IntOp() {
        }

        @Override
        public boolean newClassification(boolean inLeft, boolean inRight) {
            return inLeft && inRight;
        }
    }

    static class SubOp
    extends CAGOp {
        SubOp() {
        }

        @Override
        public boolean newClassification(boolean inLeft, boolean inRight) {
            return inLeft && !inRight;
        }
    }

    static class AddOp
    extends CAGOp {
        AddOp() {
        }

        @Override
        public boolean newClassification(boolean inLeft, boolean inRight) {
            return inLeft || inRight;
        }
    }

    static abstract class CAGOp
    extends AreaOp {
        boolean inLeft;
        boolean inRight;
        boolean inResult;

        CAGOp() {
        }

        @Override
        public void newRow() {
            this.inLeft = false;
            this.inRight = false;
            this.inResult = false;
        }

        @Override
        public int classify(Edge e) {
            if (e.getCurveTag() == 0) {
                this.inLeft = !this.inLeft;
            } else {
                this.inRight = !this.inRight;
            }
            boolean newClass = this.newClassification(this.inLeft, this.inRight);
            if (this.inResult == newClass) {
                return 0;
            }
            this.inResult = newClass;
            return newClass ? 1 : -1;
        }

        @Override
        public int getState() {
            return this.inResult ? 1 : -1;
        }

        public abstract boolean newClassification(boolean var1, boolean var2);
    }
}

