/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.extension;

import org.gvsig.andami.PluginsLocator;
import org.gvsig.andami.actioninfo.ActionInfo;
import org.gvsig.andami.plugins.Extension;
import org.gvsig.app.ApplicationLocator;
import org.gvsig.app.ApplicationManager;
import org.gvsig.app.project.documents.Document;
import org.gvsig.app.project.documents.table.TableDocument;
import org.gvsig.app.project.documents.table.TableManager;
import org.gvsig.app.project.documents.table.gui.FeatureTableDocumentPanel;
import org.gvsig.fmap.dal.feature.FeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.FeatureStore;

public class FieldCalculatorExtension
extends Extension {
    public void initialize() {
    }

    public void execute(String actionCommand) {
        if ("table-expression-field".equalsIgnoreCase(actionCommand)) {
            this.doUpdateTable();
        }
    }

    private void doUpdateTable() {
        ApplicationManager application = ApplicationLocator.getManager();
        TableDocument doc = (TableDocument)application.getActiveDocument(TableManager.TYPENAME);
        if (doc == null) {
            return;
        }
        FeatureTableDocumentPanel tablePanel = (FeatureTableDocumentPanel)((Object)doc.getMainComponent());
        FeatureStore store = tablePanel.getFeatureStore();
        StringBuilder columnNames = new StringBuilder();
        FeatureAttributeDescriptor[] selectedColumns = tablePanel.getSelectedColumnsDescriptors();
        if (selectedColumns != null) {
            for (FeatureAttributeDescriptor selectedColumn : selectedColumns) {
                if (columnNames.length() > 0) {
                    columnNames.append(",");
                }
                columnNames.append(selectedColumn.getName());
            }
        }
        ActionInfo updateTable = PluginsLocator.getActionInfoManager().getAction("tools-updatetable");
        updateTable.execute(new Object[]{"--table=", store, "--useSelection=", !store.isFeatureSelectionEmpty(), "--columnName=", columnNames.toString()});
    }

    public boolean isEnabled() {
        ApplicationManager application = ApplicationLocator.getManager();
        TableDocument doc = (TableDocument)application.getActiveDocument(TableManager.TYPENAME);
        return doc != null;
    }

    public boolean isVisible() {
        ApplicationManager application = ApplicationLocator.getManager();
        Document doc = application.getActiveDocument(TableManager.TYPENAME);
        return doc != null;
    }
}

