/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.extension;

import java.math.BigDecimal;
import org.gvsig.andami.IconThemeHelper;
import org.gvsig.andami.PluginServices;
import org.gvsig.andami.messages.NotificationManager;
import org.gvsig.andami.plugins.Extension;
import org.gvsig.andami.ui.mdiManager.IWindow;
import org.gvsig.app.project.documents.table.gui.FeatureTableDocumentPanel;
import org.gvsig.app.project.documents.table.gui.Statistics;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.FeatureQuery;
import org.gvsig.fmap.dal.feature.FeatureSelection;
import org.gvsig.fmap.dal.feature.FeatureSet;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.tools.dispose.DisposableIterator;

public class TableNumericFieldOperations
extends Extension {
    private FeatureTableDocumentPanel table;

    public void initialize() {
        IconThemeHelper.registerIcon((String)"action", (String)"table-statistics", (Object)((Object)this));
    }

    public void execute(String actionCommand) {
        IWindow v;
        if ("table-statistics".equalsIgnoreCase(actionCommand) && (v = PluginServices.getMDIManager().getActiveWindow()) != null && v.getClass() == FeatureTableDocumentPanel.class) {
            FeatureTableDocumentPanel table = (FeatureTableDocumentPanel)v;
            this.doExecute(table);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doExecute(FeatureTableDocumentPanel table) {
        FeatureSet featureSet = null;
        DisposableIterator iterator = null;
        try {
            BigDecimal average;
            FeatureAttributeDescriptor fad = table.getTablePanel().getTable().getSelectedColumnsAttributeDescriptor()[0];
            long numRows = 0L;
            FeatureStore fs = table.getModel().getStore();
            FeatureSelection selection = fs.getFeatureSelection();
            if (selection.isEmpty()) {
                FeatureQuery fq = fs.createFeatureQuery();
                fq.setAttributeNames(new String[]{fad.getName()});
                featureSet = fs.getFeatureSet();
                numRows = featureSet.getSize();
                iterator = featureSet.fastIterator();
            } else {
                numRows = selection.getSize();
                iterator = selection.fastIterator();
            }
            BigDecimal sum = BigDecimal.ZERO;
            double min = Double.MAX_VALUE;
            double max = -1.7976931348623157E308;
            BigDecimal variance = BigDecimal.ZERO;
            while (iterator.hasNext()) {
                Feature feature = (Feature)iterator.next();
                Number valueNumber = (Number)feature.get(fad.getName());
                if (valueNumber == null) continue;
                double value = valueNumber.doubleValue();
                BigDecimal valueBig = BigDecimal.valueOf(value);
                sum = sum.add(valueBig);
                if (value < min) {
                    min = value;
                }
                if (value > max) {
                    max = value;
                }
                variance = variance.add(valueBig.pow(2));
            }
            double desviation = 0.0;
            if (numRows < 1L) {
                average = BigDecimal.ZERO;
            } else {
                BigDecimal numRowsBig = BigDecimal.valueOf(numRows);
                average = sum.divide(numRowsBig, 5);
                variance = variance.divide(numRowsBig, 5).subtract(average.pow(2));
                desviation = Math.sqrt(variance.doubleValue());
            }
            Statistics st = new Statistics();
            st.setStatistics(average.doubleValue(), max, min, variance.doubleValue(), desviation, numRows, max - min, sum.doubleValue());
            PluginServices.getMDIManager().addWindow((IWindow)st);
        }
        catch (DataException e) {
            NotificationManager.addError((Throwable)e);
        }
        finally {
            if (iterator != null) {
                iterator.dispose();
            }
            if (featureSet != null) {
                featureSet.dispose();
            }
        }
    }

    public boolean isEnabled() {
        return this.doIsEnabled(this.table);
    }

    protected boolean doIsEnabled(FeatureTableDocumentPanel table) {
        int type;
        FeatureAttributeDescriptor[] fads = null;
        try {
            fads = table.getTablePanel().getTable().getSelectedColumnsAttributeDescriptor();
        }
        catch (DataException e) {
            e.printStackTrace();
        }
        return fads.length == 1 && ((type = fads[0].getType()) == 5 || type == 7 || type == 6 || type == 4);
    }

    public boolean isVisible() {
        IWindow v = PluginServices.getMDIManager().getActiveWindow();
        if (v != null && v instanceof FeatureTableDocumentPanel) {
            this.table = (FeatureTableDocumentPanel)v;
            return true;
        }
        return false;
    }
}

