/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.extension;

import java.awt.Dimension;
import java.util.List;
import org.gvsig.andami.IconThemeHelper;
import org.gvsig.andami.PluginServices;
import org.gvsig.andami.messages.NotificationManager;
import org.gvsig.andami.plugins.Extension;
import org.gvsig.andami.ui.mdiManager.IWindow;
import org.gvsig.app.project.Project;
import org.gvsig.app.project.ProjectManager;
import org.gvsig.app.project.documents.gui.AndamiWizard;
import org.gvsig.app.project.documents.gui.ObjectSelectionStep;
import org.gvsig.app.project.documents.table.FieldSelectionModel;
import org.gvsig.app.project.documents.table.TableDocument;
import org.gvsig.app.project.documents.table.TableManager;
import org.gvsig.app.project.documents.table.TableSelectionModel;
import org.gvsig.app.project.documents.table.gui.FeatureTableDocumentPanel;
import org.gvsig.fmap.dal.feature.FeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.utils.swing.objectSelection.ObjectSelectionModel;
import org.gvsig.utils.swing.objectSelection.SelectionException;
import org.gvsig.utils.swing.wizard.Step;
import org.gvsig.utils.swing.wizard.WizardControl;
import org.gvsig.utils.swing.wizard.WizardEvent;
import org.gvsig.utils.swing.wizard.WizardListener;

public class TableOperations
extends Extension {
    private final FeatureStore featureStore = null;

    public void execute(String actionCommand) {
        I18nManager i18n = ToolsLocator.getI18nManager();
        Project project = ProjectManager.getInstance().getCurrentProject();
        List tableDcouments = project.getDocuments(TableManager.TYPENAME);
        TableDocument[] pts = tableDcouments.toArray(new TableDocument[tableDcouments.size()]);
        if ("table-create-link".equals(actionCommand)) {
            try {
                final ObjectSelectionStep sourceTable = new ObjectSelectionStep();
                sourceTable.setModel((ObjectSelectionModel)new TableSelectionModel(pts, PluginServices.getText((Object)((Object)this), (String)"seleccione_tabla_origen")));
                final ObjectSelectionStep targetTable = new ObjectSelectionStep();
                targetTable.setModel((ObjectSelectionModel)new TableSelectionModel(pts, PluginServices.getText((Object)((Object)this), (String)"seleccione_tabla_a_enlazar")));
                final ObjectSelectionStep firstTableField = new ObjectSelectionStep();
                final ObjectSelectionStep secondTableField = new ObjectSelectionStep();
                final AndamiWizard wiz = new AndamiWizard(PluginServices.getText((Object)((Object)this), (String)"back"), PluginServices.getText((Object)((Object)this), (String)"next"), PluginServices.getText((Object)((Object)this), (String)"finish"), PluginServices.getText((Object)((Object)this), (String)"cancel"));
                wiz.getWindowInfo().setTitle(i18n.getTranslation("_Create_link_between_tables"));
                wiz.setSize(new Dimension(450, 200));
                wiz.addStep((Step)sourceTable);
                wiz.addStep((Step)firstTableField);
                wiz.addStep((Step)targetTable);
                wiz.addStep((Step)secondTableField);
                wiz.addWizardListener(new WizardListener(){

                    public void cancel(WizardEvent w) {
                        PluginServices.getMDIManager().closeWindow((IWindow)wiz);
                    }

                    public void finished(WizardEvent w) {
                        PluginServices.getMDIManager().closeWindow((IWindow)wiz);
                        TableDocument sourceProjectTable = (TableDocument)((Object)sourceTable.getSelected());
                        TableDocument targetProjectTable = (TableDocument)((Object)targetTable.getSelected());
                        FeatureStore sds2 = targetProjectTable.getStore();
                        String field1 = (String)firstTableField.getSelected();
                        String field2 = (String)secondTableField.getSelected();
                        sourceProjectTable.addLinkTable(targetProjectTable.getName(), field1, field2);
                    }

                    public void next(WizardEvent w) {
                        WizardControl wiz2 = w.wizard;
                        wiz2.enableBack(true);
                        wiz2.enableNext(((ObjectSelectionStep)wiz2.getCurrentStep()).getSelectedItem() != null);
                        if (w.currentStep == 1) {
                            TableDocument pt = (TableDocument)((Object)sourceTable.getSelected());
                            try {
                                firstTableField.setModel((ObjectSelectionModel)new FieldSelectionModel(pt.getStore(), PluginServices.getText((Object)this, (String)"seleccione_campo_enlace")));
                            }
                            catch (SelectionException e) {
                                NotificationManager.addError((String)"Error obteniendo los campos de la tabla", (Throwable)e);
                            }
                        } else if (w.currentStep == 3) {
                            try {
                                TableDocument pt = (TableDocument)((Object)sourceTable.getSelected());
                                FeatureStore fs = pt.getStore();
                                String fieldName = (String)firstTableField.getSelected();
                                int type = ((FeatureAttributeDescriptor)fs.getDefaultFeatureType().get(fieldName)).getType();
                                secondTableField.setModel((ObjectSelectionModel)new FieldSelectionModel(((TableDocument)((Object)targetTable.getSelected())).getStore(), PluginServices.getText((Object)this, (String)"seleccione_campo_enlace"), type));
                            }
                            catch (Exception e) {
                                NotificationManager.addError((String)"Error obteniendo los campos de la tabla", (Throwable)e);
                            }
                        }
                    }

                    public void back(WizardEvent w) {
                        WizardControl wiz2 = w.wizard;
                        wiz2.enableBack(true);
                        wiz2.enableNext(((ObjectSelectionStep)wiz2.getCurrentStep()).getSelectedItem() != null);
                    }
                });
                project.setModified(true);
                PluginServices.getMDIManager().addWindow((IWindow)wiz);
            }
            catch (SelectionException e) {
                NotificationManager.addError((String)"Error abriendo el asistente", (Throwable)e);
            }
        }
    }

    public boolean isVisible() {
        IWindow v = PluginServices.getMDIManager().getActiveWindow();
        if (v == null) {
            return false;
        }
        return v instanceof FeatureTableDocumentPanel;
    }

    public void initialize() {
        IconThemeHelper.registerIcon((String)"action", (String)"table-create-link", (Object)((Object)this));
    }

    public boolean isEnabled() {
        return true;
    }

    public String sanitizeFieldName(String fieldName) {
        return fieldName.replaceAll("\\W", "_");
    }
}

