/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.serverexplorer.filesystem.swing;

import java.awt.Component;
import java.awt.Window;
import java.util.ArrayList;
import java.util.HashSet;
import javax.swing.JOptionPane;
import org.cresques.cts.IProjection;
import org.gvsig.andami.PluginServices;
import org.gvsig.andami.messages.NotificationManager;
import org.gvsig.app.ApplicationLocator;
import org.gvsig.app.ApplicationManager;
import org.gvsig.app.prepareAction.PrepareContext;
import org.gvsig.app.project.Project;
import org.gvsig.app.project.ProjectManager;
import org.gvsig.app.project.documents.table.TableDocument;
import org.gvsig.app.project.documents.table.TableManager;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataManager;
import org.gvsig.fmap.dal.DataStore;
import org.gvsig.fmap.dal.DataStoreParameters;
import org.gvsig.fmap.dal.exception.ValidateDataParametersException;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.serverexplorer.filesystem.swing.FilesystemExplorerWizardPanel;
import org.gvsig.fmap.dal.swing.DALSwingLocator;
import org.gvsig.fmap.dal.swing.dataStoreParameters.DataStoreParametersPanel;
import org.gvsig.fmap.dal.swing.dataStoreParameters.DataStoreParametersPanelManager;
import org.gvsig.i18n.Messages;
import org.gvsig.tools.dispose.Disposable;
import org.gvsig.tools.dispose.DisposeUtils;
import org.gvsig.tools.dynobject.DynObject;
import org.gvsig.tools.dynobject.exception.DynFieldRequiredValueException;
import org.gvsig.tools.dynobject.exception.DynObjectValidateException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilesystemExplorerTableWizardPanel
extends FilesystemExplorerWizardPanel {
    private static final long serialVersionUID = 8469934188826417698L;
    private static final Logger LOG = LoggerFactory.getLogger(FilesystemExplorerTableWizardPanel.class);
    private PrepareContext prepareDSContext = null;

    public FilesystemExplorerTableWizardPanel() {
        super(true);
    }

    public void execute() {
        this.executeWizard();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object executeWizard() {
        ApplicationManager manager = ApplicationLocator.getManager();
        Project project = manager.getCurrentProject();
        PrepareContext context = this.getPrepareDataStoreContext();
        DataStoreParameters[] parameters = this.getParameters();
        ArrayList<TableDocument> tabledocs = new ArrayList<TableDocument>(parameters.length);
        HashSet<String> not_valid = new HashSet<String>();
        for (DataStoreParameters params : parameters) {
            FeatureStore store = null;
            try {
                params.validate();
            }
            catch (ValidateDataParametersException ecx) {
                StringBuffer buffer = new StringBuffer();
                if (ecx.getCause() instanceof DynObjectValidateException) {
                    DynObjectValidateException exceptions = (DynObjectValidateException)ecx.getCause();
                    for (int i = 0; i < exceptions.size(); ++i) {
                        if (!(exceptions.get(i) instanceof DynFieldRequiredValueException)) continue;
                        DynFieldRequiredValueException exx = (DynFieldRequiredValueException)exceptions.get(i);
                        if (buffer.length() > 0) {
                            buffer.append(", ");
                        }
                        buffer.append(exx.getMessage());
                    }
                }
                String msg = params.getDataStoreName();
                if (buffer.length() > 0) {
                    msg = msg + ": " + buffer.toString();
                }
                LOG.info("Unable to validate params: " + msg);
                not_valid.add(msg);
                continue;
            }
            try {
                DataManager dataManager = DALLocator.getDataManager();
                store = (FeatureStore)dataManager.openStore(params.getDataStoreName(), params);
                manager.pepareOpenDataSource((DataStore)store, context);
                TableDocument table = (TableDocument)ProjectManager.getInstance().createDocument(TableManager.TYPENAME);
                table.setName(store.getName());
                table.setStore(store);
                tabledocs.add(table);
                DisposeUtils.disposeQuietly((Disposable)store);
            }
            catch (Exception e) {
                NotificationManager.addError((Throwable)e);
            }
            finally {
                DisposeUtils.disposeQuietly(store);
            }
        }
        if (not_valid.size() > 0) {
            String not_str = ((Object)not_valid).toString();
            JOptionPane.showMessageDialog((Component)((Object)this), Messages.getText((String)"_These_sources_were_not_loaded") + ": " + not_str, Messages.getText((String)"_Load_error"), 2);
        }
        return tabledocs;
    }

    protected PrepareContext getPrepareDataStoreContext() {
        if (this.prepareDSContext == null) {
            this.prepareDSContext = new PrepareContext(){

                public Window getOwnerWindow() {
                    return null;
                }

                public IProjection getViewProjection() {
                    return null;
                }
            };
        }
        return this.prepareDSContext;
    }

    public String getTabName() {
        return PluginServices.getText((Object)((Object)this), (String)"File");
    }

    protected void showPropertiesDialog(DynObject parameters) {
        DataStoreParametersPanelManager manager = DALSwingLocator.getDataStoreParametersPanelManager();
        DataStoreParametersPanel panel = manager.createDataStoreParametersPanel(parameters);
        panel.setExcludeGeometryOptions(true);
        manager.showPropertiesDialog(parameters, panel);
    }
}

